/*
 * Created on 16/09/2011
 *
 */
package s12.servlet.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import bilbofrmk.util.BLogger;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

import s12.progrExperienciales.dao.S12ProgramasExperiencialesDao;
import s12.progrExperienciales.valueObjects.S12GaleriaXml;
import s12.progrExperienciales.valueObjects.S12ImagenXml;
import s12.progrExperienciales.valueObjects.S12UnidadMultimedia;
import s12.util.S12AppConfig;
import s12.util.S12Utils;


/**
 * The Class S12ProgramasExperiencialesAction.
 *  
 */
public class S12ProgramasExperiencialesAction extends HttpServlet{

  /**
   * Gets the img viajar con.
   *
   * @return the img viajar con
   */
  public static Map getImgViajarCon(){
    Map imgViajarCon = new HashMap();
    imgViajarCon.put("1","ico_pareja.png");
    imgViajarCon.put("2","ico_ninos.png");
    imgViajarCon.put("3","ico_amigos.png");

    return imgViajarCon;
  }

  /**
   * Gets the img intereses.
   *
   * @return the img intereses
   */
  public static Map getImgIntereses(){
    Map imgIntereses = new HashMap();
    imgIntereses.put("1","ico_cultura.png");
    imgIntereses.put("2","ico_gastronomia.png");
    imgIntereses.put("3","ico_bienestar.png");
    imgIntereses.put("4","ico_paisaje.png");
    imgIntereses.put("5","ico_compras.png");
    imgIntereses.put("6","ico_eventos.png");

    return imgIntereses;
  }

  private String urlPEX = Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","URL_CONTENIDO_PEX");
  private String language = "";

  private static final String COMPONENTE = "PROGRAMAS_EXPERIENCIALES";



  /**
   *
   */
  private static final long serialVersionUID = 6714146080326216473L;

  private static final int DIA_1 = 1;
  private static final int DIA_2 = 2;
  private static final int DIA_3 = 3;
  private static final int DIA_4 = 4;

  /**
   * do Get.
   *
   * @param request the request
   * @param response the response
   *
   * @throws ServletException the servlet exception
   */
  protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException{
    this.doPost(request, response);
  }

  /**
   * do Post.
   *
   * @param request the request
   * @param response the response
   *
   * @throws ServletException the servlet exception
   */
  protected void doPost(HttpServletRequest request, HttpServletResponse response)	throws ServletException{


    if (Q70Factoria.getTraza().isTraceActive()) {
      Q70Factoria.getTraza().trace(S12ProgramasExperiencialesAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12ProgramasExperiencialesAction:: Inicio");
    }

    String pageForward = "/programasExperiencialesJSP/buscadorProgExperiencialesResultados.jsp";
  
    //Solucion temporal para no romper el buscador de x65 hasta que se sustituya definitivamente
//    if (request.getParameter("portal") != null) {
//    	pageForward = "/programasExperiencialesJSP/buscadorProgExperiencialesResultados_aa30.jsp";
//    }
    
    this.language = request.getParameter("lang");
    if ( this.language == null ) {
      this.language = "es"; // Castellano por defecto
    }

    //recuperamos los valores de la request
    String capital = "";
    if (request.getParameter("capital")!= null){
      capital = (String)request.getParameter("capital");
    }
    int nDias = 0;
    if (request.getParameter("dias")!= null){
      nDias = Integer.parseInt(request.getParameter("dias"));
    }
    int viajarCon = 0;
    if (request.getParameter("viajarCon")!= null){
      viajarCon = Integer.parseInt(request.getParameter("viajarCon"));
    }
    int interes = 0;
    if(request.getParameter("interes")!=null){
      interes = Integer.parseInt(request.getParameter("interes"));
    }
    String original = "";
    if (request.getParameter("original") != null){
      original = request.getParameter("original");
    }


    //S12ProgramasExperiencialesDao daoProgramas = S12ProgramasExperiencialesFactory.create();
    S12ProgramasExperiencialesDao daoProgramas = new S12ProgramasExperiencialesDao();
    ArrayList arEnlacesCapital = null;
    ArrayList arUnidadesContenido = null;
    ArrayList arMultimediaUnidades = null;
    ArrayList arImagenesDias = null;

    try {

      //para saber cual es la pgina inicial desde la que se inici la bsqueda
      String paginaFrom = "";
      if (request.getParameter("paginaFrom") != null){
        paginaFrom = (String)request.getParameter("paginaFrom");
      }
      request.setAttribute("paginaFrom", paginaFrom);


      //bsqueda para los enlaces de la capital seleccionada
      arEnlacesCapital = daoProgramas.getEnlacesCapital(capital, this.language);
      request.setAttribute("enlacesCapital", arEnlacesCapital);

      //bsqueda para las unidades de contenido, segn los criterios seleccionados
      arUnidadesContenido = daoProgramas.getUnidadesContenido(capital, nDias, viajarCon, interes, original, this.language);
      if (arUnidadesContenido.size() > 0){
        request.setAttribute("unidadesContenido", arUnidadesContenido);

        for(int i=1; i<=nDias; i++){

          //bsqueda para mostrar los multimedia pertenecientes a ese programa Experiencial(segn el da y el lenguaje)
          arMultimediaUnidades = daoProgramas.getMultimedia(arUnidadesContenido, i, nDias, this.language);

          String xmlMultimedia = "";
          //esto es para que no se ejecute en LOCAL(no funciona el JSON)
          if(!S12AppConfig.getInstance().getValue("cssIncluded").equals("OK")){
            xmlMultimedia = this.crearXmlMultimedia(arMultimediaUnidades);
          }

          switch (i){
	      	case S12ProgramasExperiencialesAction.DIA_1:
	      		request.setAttribute("xmlMultimediaDia1", xmlMultimedia);
	      		break;
	      	case S12ProgramasExperiencialesAction.DIA_2:
	      		request.setAttribute("xmlMultimediaDia2", xmlMultimedia);
	      		break;
	      	case S12ProgramasExperiencialesAction.DIA_3:
	      		request.setAttribute("xmlMultimediaDia3", xmlMultimedia);
	      		break;
	      	case S12ProgramasExperiencialesAction.DIA_4:
	      		request.setAttribute("xmlMultimediaDia4", xmlMultimedia);
	      		break;
	      	default:
	      		break;
	      	};
    	}
        
        //bsqueda de imgenes para cada da de programa
        arImagenesDias = daoProgramas.getImagenesDias(capital, nDias);
        request.setAttribute("imagenesDia", arImagenesDias);

      }else{
        if (Q70Factoria.getTraza().isTraceActive()) {
          Q70Factoria.getTraza().trace(S12ProgramasExperiencialesAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12ProgramasExperiencialesAction:: No encuentra unidades de contenido");
        }
        request.setAttribute("noResultados", "true");
        if ("subHomeCapitalesMedida".equals(paginaFrom)){

          pageForward = "/programasExperiencialesJSP/buscadorProgExperienciales.jsp";
        }else if ("buscadorCapitalesMedida".equals(paginaFrom)){
          pageForward = "/programasExperiencialesJSP/buscadorCapitalesMedida.jsp";
        }
      }

    } catch (Exception e) {
      throw new ServletException( "Error en S12ProgramasExperiencialesAction", e );
    }

    this.forwardJSP(request,response,pageForward);
  }


  /**
   * Crear xml multimedia.
   *
   * @param arMultimediaUnidades the ar multimedia unidades
   *
   * @return the string
   */
  public String crearXmlMultimedia(ArrayList arMultimediaUnidades){

    String xmlMultimedia = "";
    S12UnidadMultimedia unidadMultimedia = null;

    S12GaleriaXml galeriaXml = new S12GaleriaXml();
    S12ImagenXml imagenXml;
    for (int i=0; i<arMultimediaUnidades.size(); i++){
      unidadMultimedia = (S12UnidadMultimedia)arMultimediaUnidades.get(i);
      imagenXml = new S12ImagenXml();
      imagenXml.setTitulo(S12Utils.encodeHtmlTag(unidadMultimedia.getDescripcionMultimedia()));
      imagenXml.setUrl(this.urlPEX + this.language + "_prog_exp/media/" + unidadMultimedia.getUrlMultimedia());
      if (unidadMultimedia.getCodigoTipoMultimedia() == 1){
        imagenXml.setTipo("foto");
      }else if (unidadMultimedia.getCodigoTipoMultimedia() == 2){
        imagenXml.setTipo("video");

      }
      imagenXml.setTextAlt(S12Utils.encodeHtmlTag(unidadMultimedia.getDescripcionMultimedia()));
      galeriaXml.getImagen().add(imagenXml);
    }

    xmlMultimedia = galeriaXml.toJSONString();

    BLogger.blog(BLogger.DEBUG,"XMLMultimedia:" + xmlMultimedia);

    return xmlMultimedia;
  }


  /**
   * Forward jsp.
   *
   * @param request the request
   * @param response the response
   * @param page the page
   *
   * @throws ServletException the servlet exception
   */
  public void forwardJSP(HttpServletRequest request, HttpServletResponse response, String page) throws ServletException
  {
    try {
      ServletContext ctx = this.getServletContext();

      RequestDispatcher dispatcher = ctx.getRequestDispatcher( page );
      if (dispatcher == null) {
        throw new ServletException( "No dispatcher found for " + page );
      }
      dispatcher.forward( request, response );

      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12ProgramasExperiencialesAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12ProgramasExperiencialesAction:: Fin");
      }
    }
    catch (Exception e) {
      e.printStackTrace();
      throw new ServletException( "Failed to process request", e );
    }

  }




}
