/**
 * Created on 08-jun-2007
 */
package s12.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * The Class S12LogsServlet.
 *
 *  
 */
public class S12LogsServlet extends HttpServlet {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1L;

	/** The Constant RUTA_LOGS_S41. */
	private static final String RUTA_LOGS_S41 = "/datos/s41/log/";

	/** The Constant RUTA_LOGS_S12. */
	private static final String RUTA_LOGS_S12 = "/datos/s12/log/";

	/** The Constant RUTA_PROPERTIES_S41. */
	private static final String RUTA_PROPERTIES_S41 = "/config/s41/";

	/** The Constant RUTA_PROPERTIES_S12. */
	private static final String RUTA_PROPERTIES_S12 = "/config/s12/";

	/** The Constant SIZE_STRINGBUFFER. */
	private static final int SIZE_STRINGBUFFER = 420;

	/** The Constant SIZE_KB. */
	private static final int SIZE_KB = 1024;

	private static final int PAGINA_NO_ENCONTRADA = 404;

	/**
	 * doGet.
	 *
	 * @param request the request
	 * @param response the response
	 *
	 * @throws ServletException the servlet exception
	 * @throws IOException Signals that an I/O exception has occurred.
	 *
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    this.doPost(request, response);
	}

	/**
	 * doPost.
	 *
	 * @param request the request
	 * @param response the response
	 *
	 * @throws ServletException the servlet exception
	 * @throws IOException Signals that an I/O exception has occurred.
	 *
	 * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    /* Seguridad (m o meno) */
		if ("true".equals(request.getParameter("logViewer"))) {
			if (request.getParameter("file") != null) {
				this.verFichero(request, response);
			} else {
				this.listarFicheros(request, response);
			}
		} else {
			response.sendError(S12LogsServlet.PAGINA_NO_ENCONTRADA);
    }
	}

	/**
	 * Listar ficheros.
	 *
	 * @param request the request
	 * @param response the response
	 *
	 * @throws ServletException the servlet exception
	 */
	private void listarFicheros(HttpServletRequest request, HttpServletResponse response) throws ServletException {
		StringBuffer buff = new StringBuffer(S12LogsServlet.SIZE_STRINGBUFFER);
    buff.append("<html><head><title>Visor de logs</title></head><body>\n");

		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
		NumberFormat nf = NumberFormat.getInstance(new Locale("es", "ES"));
		if (nf instanceof DecimalFormat) {
			((DecimalFormat) nf).setDecimalSeparatorAlwaysShown(true);
		}

		/* Primero s41 */
		File dir = new File(S12LogsServlet.RUTA_LOGS_S41);
		File[] files = dir.listFiles();
		Arrays.sort(files, new FileComparatorByDate());

		buff.append("<table><tr><td colspan=\"3\"><h1>s41</h1></td></tr>\n");
		if (files != null) {
			for (int i = 0; i < files.length; i++) {
				File f = files[i];
				buff.append("\n<tr><td><a href=\"S12LogsServlet?R01HNoPortal=true&logViewer=true&app=s41&type=log&file=");
				buff.append(f.getName());
				buff.append("\">");
				buff.append(f.getName());
				buff.append("</a></td><td>");
				buff.append(sdf.format(new Date(f.lastModified())));
				buff.append("</td>");
				buff.append("<td style='text-align:right;'>");
				buff.append(nf.format(f.length()/S12LogsServlet.SIZE_KB));
				buff.append(" KB</td>");
			}
		} else {
			buff.append("No se han encontrado ficheros en " + S12LogsServlet.RUTA_LOGS_S41);
		}

		/* s41 - properties */
		dir = new File(S12LogsServlet.RUTA_PROPERTIES_S41);
		files = dir.listFiles();
		Arrays.sort(files, new FileComparatorByDate());

		buff.append("<tr><td colspan=\"3\"><h2>Properties</h2></td></tr>\n");
		if (files != null) {
			for (int i = 0; i < files.length; i++) {
	      File f = files[i];
	      buff.append("\n<tr><td><a href=\"S12LogsServlet?R01HNoPortal=true&logViewer=true&app=s41&type=prop&file=");
	      buff.append(f.getName());
	      buff.append("\">");
	      buff.append(f.getName());
	      buff.append("</a></td><td>");
	      buff.append(sdf.format(new Date(f.lastModified())));
	      buff.append("</td>");
	      buff.append("<td style='text-align:right;'>");
	      buff.append(nf.format(f.length()/S12LogsServlet.SIZE_KB));
	      buff.append(" KB</td>");
			}
		} else {
		   buff.append("No se han encontrado ficheros en " + S12LogsServlet.RUTA_PROPERTIES_S41);
		}

		/* Despus s12 */
		dir = new File(S12LogsServlet.RUTA_LOGS_S12);
		files = dir.listFiles();
		Arrays.sort(files, new FileComparatorByDate());

		buff.append("<tr><td colspan=\"3\"><h1>s12</h1></td></tr>\n");
		if (files != null) {
			for (int i = 0; i < files.length; i++) {
	      File f = files[i];
	      buff.append("\n<tr><td><a href=\"S12LogsServlet?R01HNoPortal=true&logViewer=true&app=s12&type=log&file=");
	      buff.append(f.getName());
	      buff.append("\">");
	      buff.append(f.getName());
	      buff.append("</a></td><td>");
	      buff.append(sdf.format(new Date(f.lastModified())));
	      buff.append("</td>");
	      buff.append("<td style='text-align:right;'>");
	      buff.append(nf.format(f.length()/S12LogsServlet.SIZE_KB));
	      buff.append(" KB</td>");
			}
		} else {
			buff.append("No se han encontrado ficheros en " + S12LogsServlet.RUTA_LOGS_S12);
		}

		/* s12 - properties */
		dir = new File(S12LogsServlet.RUTA_PROPERTIES_S12);
		files = dir.listFiles();
		Arrays.sort(files, new FileComparatorByDate());

		buff.append("<tr><td colspan=\"3\"><h2>Properties</h2></td></tr>\n");
		if (files != null) {
			for (int i = 0; i < files.length; i++) {
	      File f = files[i];
	      buff.append("\n<tr><td><a href=\"S12LogsServlet?R01HNoPortal=true&logViewer=true&app=s12&type=prop&file=");
	      buff.append(f.getName());
	      buff.append("\">");
	      buff.append(f.getName());
	      buff.append("</a></td><td>");
	      buff.append(sdf.format(new Date(f.lastModified())));
	      buff.append("</td>");
	      buff.append("<td style='text-align:right;'>");
	      buff.append(nf.format(f.length()/S12LogsServlet.SIZE_KB));
	      buff.append(" KB</td>");
			}
		} else {
			buff.append("No se han encontrado ficheros en " + S12LogsServlet.RUTA_PROPERTIES_S12);
		}

		buff.append("\n</table></body></html>");
		try {
			response.getOutputStream().print(buff.toString());
			response.getOutputStream().flush();
			response.getOutputStream().close();
		} catch (Exception e) {
			throw new ServletException("Error al escribir salida", e);
    }
	}

	/**
	 * Ver fichero.
	 *
	 * @param request the request
	 * @param response the response
	 *
	 * @throws ServletException the servlet exception
	 */
  private void verFichero(HttpServletRequest request, HttpServletResponse response) throws ServletException {
	  String sFile = request.getParameter("file");
	  String sApp = request.getParameter("app");
	  String sType = request.getParameter("type");
	  String sRutaFile = "";

    if ("s41".equals(sApp)) {
    	if ("log".equals(sType)) {
    		sRutaFile = S12LogsServlet.RUTA_LOGS_S41 + sFile;
    	} else if ("prop".equals(sType)) {
    		sRutaFile = S12LogsServlet.RUTA_PROPERTIES_S41 + sFile;
    	} else {
        throw new ServletException("Los parmetros no son correctos");
    	}
    } else if ("s12".equals(sApp)) {
    	if ("log".equals(sType)) {
    		sRutaFile = S12LogsServlet.RUTA_LOGS_S12 + sFile;
    	} else if ("prop".equals(sType)) {
    		sRutaFile = S12LogsServlet.RUTA_PROPERTIES_S12 + sFile;
    	} else {
    		throw new ServletException("Los parmetros no son correctos");
    	}
    } else {
    	throw new ServletException("Los parmetros no son correctos");
    }

    try {
    	File file = new File(sRutaFile);
      FileInputStream fis = new FileInputStream(file);

      byte[] baFile = new byte[fis.available()];
      fis.read(baFile);
      fis.close();

      response.setContentType("text/download");
      response.addHeader("content-disposition", "attachment; filename=" + request.getParameter("file")); // attachment
      response.setContentLength(baFile.length);
      response.getOutputStream().write(baFile);
      response.getOutputStream().flush();
      response.getOutputStream().close();
    } catch (Exception e) {
      throw new ServletException("Error al ver el fichero: " + e.getMessage());
    }
  }
}

/**
 * The Class FileComparatorByDate.
 *
 *  
 */
class FileComparatorByDate implements Comparator {

	/**
	 * Compare.
	 *
	 * @param o1 the o1
	 * @param o2 the o2
	 *
	 * @return the int
	 *
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2) {
		if (((File) o1).lastModified() > ((File) o2).lastModified()) {
			return -1;
		} else if (((File) o1).lastModified() < ((File) o2).lastModified()) {
			return 1;
		} else {
			return 0;
		}
	}
}
