/*
 * Created on 21/02/2011
 *
 */
package s12.operacionespresentacion.newsletter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import s12.operacionespresentacion.S12BaseDisplayAction;
import s12.search.S12NewsletterQuery;
import s12.search.S12PaisesTraduccionesQuery;
import s12.search.S12ProvinciasQuery;
import s12.search.record.S12NewsletterRecord;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class S12NewsletterInitDisplayAction.
 *
 *  
 */
public class S12NewsletterInitDisplayAction extends S12BaseDisplayAction {

	/** The Constant COMPONENTE. */
	private static final String COMPONENTE = "NEWSLETTER";

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		return mapping.findForward("ok");
	}

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12NewsletterInitDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12NewsletterInitDisplayAction:: INICIO");
		}

		Q70OPValidatorForm testForm = (Q70OPValidatorForm) form;
		BTransport backTransport = this.getTransport(0);

		S12ProvinciasQuery provincias = (S12ProvinciasQuery)backTransport.getParameter("provincias");

		provincias.setResultsLocale(this.getLocale(request));
		this.setQueryInContext(provincias,"provinciasJSP");

		S12PaisesTraduccionesQuery paises = (S12PaisesTraduccionesQuery)backTransport.getParameter("paises");

		provincias.setResultsLocale(this.getLocale(request));
		this.setQueryInContext(paises,"paisesJSP");

		S12NewsletterQuery destinatariosQuery = (S12NewsletterQuery)backTransport.getParameter("queryDestinatarios");
		StringBuffer emails = new StringBuffer();
		S12NewsletterRecord destinatariosRecord = null;
		for (int i=0;i<destinatariosQuery.getResults().size();i++){
			destinatariosRecord = (S12NewsletterRecord)destinatariosQuery.getResults().get(i);
			if (emails.length() == 0){
				emails.append(destinatariosRecord.getEmail());
			}else{
				emails.append(";");
				emails.append(destinatariosRecord.getEmail());
			}
		}
		testForm.set("listaEmails", emails.toString());
		testForm.set("accesibility", "on");
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12NewsletterInitDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12NewsletterInitDisplayAction:: FIN");
		}
	}

}
