/*
 * Created on 21/02/2011
 *
 */
package s12.operacionespresentacion.newsletter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import bilbofrmk.trasport.BTransport;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import s12.operacionespresentacion.comun.S12BaseAppInitAction;
import s12.valueObjects.comun.S12Idioma;

/**
 * The Class S12NewsletterInitAction.
 *
 *  
 */
public class S12NewsletterInitAction extends S12BaseAppInitAction {

	/** The Constant COMPONENTE. */
	private static final String COMPONENTE = "NEWSLETTER";

	/** The Constant CONST_INIT_NEWSLETTER. */
	private final static int CONST_INIT_NEWSLETTER = 3;

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.comun.S12BaseAppInitAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		return mapping.findForward("ok");
	}

	/**
	 * Process s12 init op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.comun.S12BaseAppInitAction#processS12InitOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12InitOP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12NewsletterInitAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12NewsletterInitAction::processS12InitOP: INICIO");
		}


		BTransport transport = new BTransport();
		String language = Q70ListenerUtils.getLanguage(request);
		S12Idioma idioma = new S12Idioma();
		idioma.setIdIdioma(language);
		this.setSessionValueObjectInContext(idioma,"idioma");

		String urlFrom=request.getHeader("Referer");
		contextoEjie.set("url",urlFrom);

		transport.setIdBackAction("NewsletterAction");
		transport.setIdSubBackAction(S12NewsletterInitAction.CONST_INIT_NEWSLETTER);
		this.addTransport(transport);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12NewsletterInitAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12NewsletterInitAction::processS12InitOP: FIN ");
		}

	}

}
