/*
 * Created on 21/02/2011
 *
 */
package s12.operacionespresentacion.newsletter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import s12.operacionespresentacion.S12BaseDisplayAction;

/**
 * The Class S12NewsletterDisplayAction.
 *
 *  
 */
public class S12NewsletterDisplayAction extends S12BaseDisplayAction {

	/** The Constant COMPONENTE. */
	private static final String COMPONENTE = "NEWSLETTER";

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		if(!errors.isEmpty() || this.areBussinessErrors()){
			return mapping.findForward("error");
		}
		return mapping.findForward("ok");
	}

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseDisplayAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12NewsletterDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12NewsletterDisplayAction:: INICIO");
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12NewsletterDisplayAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12NewsletterDisplayAction:: FIN");
		}
	}

}
