/*
 * Created on 21/02/2011
 *
 */
package s12.operacionespresentacion.newsletter;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import s12.constantes.S12Constantes;
import s12.operacionespresentacion.S12BaseAction;
//import s12.util.S12ConexionProxy;
import s12.valueObjects.newsletter.S12Newsletter;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
//import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class S12NewsletterAction.
 *
 *  
 */
public class S12NewsletterAction extends S12BaseAction {

	/** The Constant COMPONENTE. */
	private static final String COMPONENTE = "NEWSLETTER";

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		return mapping.findForward("bussiness");
	}

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12NewsletterAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12NewsletterAction::processS41OP: INICIO");
		}

		BTransport transport = new BTransport();
		Q70OPValidatorForm formNewsletter = (Q70OPValidatorForm) form;
		S12Newsletter newsletter=new S12Newsletter();
		//String url = Q70ListenerUtils.getApplicationProperty("newsletter.alta.url");

		HashMap params = new HashMap();
		params.put(S12Constantes.EMAIL, (String)formNewsletter.get(S12Constantes.EMAIL));
		String idioma = (String)formNewsletter.get("idioma");
		if(S12Constantes.IDIOMA_ES.equals(idioma)){
			idioma = "2";
		}else if(S12Constantes.IDIOMA_EU.equals(idioma)){
			idioma = "1";
		}else if(S12Constantes.IDIOMA_EN.equals(idioma)){
			idioma = "3";
		}else if(S12Constantes.IDIOMA_FR.equals(idioma)){
			idioma = "4";
		}else if(S12Constantes.IDIOMA_DE.equals(idioma)){
			idioma = "5";
		}
		params.put(S12Constantes.IDIOMA_PHP_LIST, idioma);

		newsletter.setNombe((String)formNewsletter.get("nombre"));
		newsletter.setApellido((String)formNewsletter.get("apellido"));
		newsletter.setEmail((String)formNewsletter.get("email"));
		newsletter.setProvincia((String)formNewsletter.get("provincia"));
		newsletter.setPais((String)formNewsletter.get("pais"));
		newsletter.setIdioma((String)formNewsletter.get("idioma"));
		newsletter.setSexo((String)formNewsletter.get("sexo"));
		newsletter.setBorrado(false);

		String result = "";
		String accesibility = (String)formNewsletter.get("accesibility");

		if("on".equals(accesibility)){
			transport.setIdSubBackAction(1);
//			result = S12ConexionProxy.getStream(url, params);//Solo hay que aadir el usuario a las listas de php cuando se hallan rellenado todos los campos.
//			if(Q70Factoria.getTraza().isTraceActive()){
//				Q70Factoria.getTraza().trace(S12NewsletterAction.COMPONENTE,Q70TraceLevel.INFO , "S12NewsletterAction::processS41OP: Resultado de la llamada a travs del proxy a las listas de php = " + result);
//			}
		}else{
			transport.setIdSubBackAction(4);//'4' es para forzar el error y que pida la confirmacin.
		}
		newsletter.setErrorPhpList(result);

		transport.addParameter("result",result);
		transport.addParameter("newsletter",newsletter);
		transport.setIdBackAction("NewsletterAction");
		this.addTransport(transport);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12NewsletterAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12NewsletterAction::processS41OP: FIN");
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12NewsletterAction.COMPONENTE, Q70TraceLevel.DEBUG, "S12NewsletterAction::processS41OP: FIN");
		}
	}

}
