/*
 * Created on 28/04/2011
 *
 */
package s12.operacionespresentacion.newsletter;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import s12.constantes.S12Constantes;
import s12.operacionespresentacion.S12BaseAction;
import s12.util.S12ConexionProxy;
import s12.valueObjects.newsletter.S12Newsletter;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class S12BajaNewsletterAction.
 *
 *  
 */
public class S12BajaNewsletterAction extends S12BaseAction {

	/** The Constant COMPONENTE. */
	private static final String COMPONENTE = "NEWSLETTER";

	/** The Constant CINCO. */
	private static final int CINCO = 5;

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		if(errors.size()>0){
			return mapping.findForward("error");
		}
		return mapping.findForward("bussiness");
	}

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		Q70OPValidatorForm formNewsletter = (Q70OPValidatorForm)form;

		//if((String)formNewsletter.get("email")!=null && !"".equals((String)formNewsletter.get("email"))){
			HashMap params = new HashMap();
			String url = Q70ListenerUtils.getApplicationProperty("newsletter.baja.url");
			BTransport transport = new BTransport();
			S12Newsletter newsletter=new S12Newsletter();
			newsletter.setEmail((String)formNewsletter.get("email"));

			params.put(S12Constantes.EMAIL, (String)formNewsletter.get(S12Constantes.EMAIL));

			String result = S12ConexionProxy.getStream(url, params);
			newsletter.setErrorPhpList(result);

			transport.setIdSubBackAction(S12BajaNewsletterAction.CINCO);
			transport.addParameter("result",result);
			transport.addParameter("newsletter",newsletter);
			transport.setIdBackAction("NewsletterAction");
			this.addTransport(transport);
			if(Q70Factoria.getTraza().isTraceActive()){
				Q70Factoria.getTraza().trace(S12BajaNewsletterAction.COMPONENTE,Q70TraceLevel.INFO , "Resultado de la llamada a travs del proxy = " + result);
			}
//		}else{
//			errors.add("NEWSLETTER", new ActionError("error.newsletter.necesario"));
//		}

	}

}
