/*
 * Created on 06-sep-2005
 *
 */
package s12.operacionespresentacion.comun;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import s12.operacionespresentacion.S12BaseAction;
import s12.valueObjects.comun.S12Idioma;
import s12.valueObjects.usuarios.S12Usuario;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class S12BaseAppInitAction.
 *
 *  
 */
public abstract class  S12BaseAppInitAction extends S12BaseAction {

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12OP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processS12OP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		if (this.getSessionValueObjectFromContext("usuario")==null){

			HttpSession session = (HttpSession) request.getSession();
			String idSession = session.getId();
			S12Usuario usuario = new S12Usuario();
			usuario.setIdSession(idSession);
			this.setSessionValueObjectInContext(usuario,"usuario");
		}


			String language = request.getParameter("lang");
			if (language != null)
			{
				S12Idioma idioma = new S12Idioma();
				idioma.setIdIdioma(language);
				this.setSessionValueObjectInContext(idioma,"idioma");

				Q70ListenerUtils.updateLanguage(request,language);
			}

			this.processS12InitOP(contextoEjie,errors,mapping,form,request,response);
	}

	/**
	 * Process s12 init op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 */
	protected abstract void processS12InitOP(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception;

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see s12.operacionespresentacion.S12BaseAction#processS12Forward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected abstract ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) throws Exception;

}
