/*
 * Created on 08-jul-2005
 *
 */
package s12.operacionespresentacion;

import java.util.HashMap;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import bilbofrmk.search.BBaseQuery;
import bilbofrmk.trasport.BBackError;
import bilbofrmk.trasport.BBussinessPack;
import bilbofrmk.trasport.BTransport;
import bilbofrmk.valueObjects.BBaseValueObject;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class S12BaseDisplayAction.
 *
 *  
 *
 */
public abstract class S12BaseDisplayAction extends Q70ActionPasoOP {

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */

	private BBussinessPack bPack;
	private HashMap valueObjects;
	private HashMap sessionValueObjects;

	/**
	 * Gets the transport.
	 *
	 * @param i the i
	 *
	 * @return the transport
	 */
	public BTransport getTransport(int i){
		if(this.bPack!=null){
			return this.bPack.getTransport(i);
		}
		else{
			return null;
		}
	}

	/**
	 * Gets the transport.
	 *
	 * @param id the id
	 *
	 * @return the transport
	 */
	public BTransport getTransport(String id){ // NO_UCD
		if(this.bPack!=null){
			return this.bPack.getTransport(id);
		}else{
			return null;
		}
	}

	/**
	 * Gets the pack size.
	 *
	 * @return the pack size
	 */
	public int getPackSize(){
		if(this.bPack!=null){
			return this.bPack.getPackSize();
		}else{
			return 0;
		}
	}

	/**
	 * Are bussiness errors.
	 *
	 * @return true, if successful
	 */
	public boolean areBussinessErrors(){
		if(this.bPack!=null){
			return this.bPack.areErrors();
		}else{
			return false;
		}
	}

	/**
	 * Sets the value object in context.
	 *
	 * @param valueObject the value object
	 * @param name the name
	 */
	public void setValueObjectInContext(BBaseValueObject valueObject, String name){ // NO_UCD
		this.valueObjects.put(name,valueObject);
	}

	/**
	 * Gets the value object from context.
	 *
	 * @param name the name
	 *
	 * @return the value object from context
	 */
	public BBaseValueObject getValueObjectFromContext(String name){ // NO_UCD
		return (BBaseValueObject) this.valueObjects.get(name);
	}

	/**
	 * Sets the session value object in context.
	 *
	 * @param valueObject the value object
	 * @param name the name
	 */
	public void setSessionValueObjectInContext(BBaseValueObject valueObject, String name){ // NO_UCD
		this.sessionValueObjects.put(name,valueObject);
	}

	/**
	 * Gets the session value object from context.
	 *
	 * @param name the name
	 *
	 * @return the session value object from context
	 */
	public BBaseValueObject getSessionValueObjectFromContext(String name){
		return (BBaseValueObject) this.sessionValueObjects.get(name);
	}

	/**
	 * Sets the query in context.
	 *
	 * @param query the query
	 * @param name the name
	 */
	public void setQueryInContext(BBaseQuery query, String name){
		this.valueObjects.put(name,query);
	}

	/**
	 * Gets the query from context.
	 *
	 * @param name the name
	 *
	 * @return the query from context
	 */
	public BBaseQuery getQueryFromContext(String name){ // NO_UCD
		return (BBaseQuery) this.valueObjects.get(name);
	}


	/**
	 * Process bussiness errors.
	 *
	 * @param errors the errors
	 */
	public void processBussinessErrors(ActionErrors errors){
		for(int i=0; i < this.bPack.getErrors().size();i++){
			BBackError bError = (BBackError)this.bPack.getErrors().get(i);
			ActionError error = new ActionError("BackError." + bError.getIdError(),bError.getLiteralData());
			errors.add("backError",error);
		}
	}


	/**
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 *
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contextoEjie, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		this.valueObjects = (HashMap) contextoEjie.get("valueObjects");
		this.sessionValueObjects = (HashMap) contextoEjie.get("sessionValueObjects");
		if(this.valueObjects==null){
			this.valueObjects = new HashMap();
		}
		if(this.sessionValueObjects==null){
			this.sessionValueObjects = new HashMap();
		}
		this.bPack = null;

		HashMap facadeBackDataPack = (HashMap) contextoEjie.get("facadeBackDataPack");
		if(facadeBackDataPack!=null){
			this.bPack = (BBussinessPack) facadeBackDataPack.get("BBackBussinessPack");
		}
		this.processS12OP(contextoEjie,errors,mapping,form,request,response);

		contextoEjie.set("facadeBackDataPack",null);
		contextoEjie.set("valueObjects",this.valueObjects);
		contextoEjie.set("sessionValueObjects",this.sessionValueObjects);

	}

	/**
	 * @param request the request
	 *
	 * @return the locale
	 *
	 * @see org.apache.struts.action.Action#getLocale(javax.servlet.http.HttpServletRequest)
	 */
	protected Locale getLocale(HttpServletRequest request){
		return (Locale) request.getSession().getAttribute(Globals.LOCALE_KEY);
	}

	/**
	 * Process s12 op.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @throws Exception the exception
	 */
	abstract protected void processS12OP(Q70ContextoEJIE contextoEjie,ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception;

	/**
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 *
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contextoEjie, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		return this.processS12Forward(contextoEjie, errors, mapping, form, request, response);
	}

	/**
	 * Process s12 forward.
	 *
	 * @param contextoEjie the contexto ejie
	 * @param errors the errors
	 * @param mapping the mapping
	 * @param form the form
	 * @param request the request
	 * @param response the response
	 *
	 * @return the action forward
	 *
	 * @throws Exception the exception
	 */
	abstract protected ActionForward processS12Forward(Q70ContextoEJIE contextoEjie,
			ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception;

	/**
	 * Gets the b pack.
	 *
	 * @return the b pack
	 */
	public BBussinessPack getBPack() {
		return this.bPack;
	}

	/**
	 * Sets the b pack.
	 *
	 * @param pack the new b pack
	 */
	public void setBPack(BBussinessPack pack) {
		this.bPack = pack;
	}

	/**
	 * Gets the value objects.
	 *
	 * @return the value objects
	 */
	public HashMap getValueObjects() {
		return this.valueObjects;
	}

	/**
	 * Sets the value objects.
	 *
	 * @param valueObjects the new value objects
	 */
	public void setValueObjects(HashMap valueObjects) {
		this.valueObjects = valueObjects;
	}

	/**
	 * Gets the session value objects.
	 *
	 * @return the session value objects
	 */
	public HashMap getSessionValueObjects() {
		return this.sessionValueObjects;
	}

	/**
	 * Sets the session value objects.
	 *
	 * @param sessionValueObjects the new session value objects
	 */
	public void setSessionValueObjects(HashMap sessionValueObjects) {
		this.sessionValueObjects = sessionValueObjects;
	}
}