package s12.buscadores.formatters;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.lang.StringEscapeUtils;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.util.URLEncoder;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideElement;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchNavBar;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResults;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterURLHelpper;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchGuideFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchQueryFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultsNavBarFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchedRepositoriesResumeFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchGuideFormatterPreferences;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.portal.R01MPortalConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;

/**
 * <pre>
 * Clase que se encarga del formateo en html de la respuesta del buscador
 *
 * FUNCIONAMIENTO:
 *      A esta clase se llamad desde el manager general de la request (clase {@link com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebRequestProcessor})
 *      En la clase {@link com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebRequestProcessor} se PRE-CALCULAN ciertas partes de cdigo generado llamando
 *      a mtodos de esta clase:
 *          - Query                 : formatQuery
 *          - Caja de Bsqueda      : formatSearchBox
 *          - Cabecera              : formatHeader
 *          - Guia                  : formatSearchGuide
 *          - Resultados            : formatSearchResults
 *      Es posible que la clase {@link com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebRequestProcessor} guarde ciertas partes
 *      de codigo generado en SESSION (query, caja de bsqueda, cabecera, guia) para evitar
 *      su re-calculo.
 *
 *      Finalmente se componen todas las partes juntas llamando al metodo format de esta clase
 *      al cual se pasa el cdigo pre-generado.
 * </pre>
 *
 *  
 */
public class S12SearchSessionHtmlFormatter implements R01MSearchSessionFormatter, // NO_UCD
                                                          Serializable {
    private static final long serialVersionUID = -5286844506799110678L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////

    /** The Constant SIZE_STRINGBUFFER_SMALL. */
  	private static final int SIZE_STRINGBUFFER_SMALL = 200;

  	/** The Constant SIZE_STRINGBUFFER_MEDIUM. */
  	private static final int SIZE_STRINGBUFFER_MEDIUM = 500;

  	/** The Constant SIZE_STRINGBUFFER_LARGE. */
  	private static final int SIZE_STRINGBUFFER_LARGE = 5000;

///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public S12SearchSessionHtmlFormatter() {
        super();
    }

///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS HEREDADOS DE LA CLASE R01MSearchSessionFormatter
///////////////////////////////////////////////////////////////////////////////////////////
    /**
		 * Format search session.
		 *
		 * @param lang the lang
		 * @param prefs the prefs
		 * @param session the session
		 *
		 * @return the string buffer
		 *
		 * @see com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatSearchSession(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, com.ejie.r01m.objects.searchengine.session.R01MSearchSession)
		 */
    public StringBuffer formatSearchSession(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSession session) {
        return null; //Este formateador formatea seccin por seccin
    }

    /**
     * Format section by section.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param searchResultsFormatted the search results formatted
     * @param preGeneratedCode the pre generated code
     *
     * @return the string buffer
     *
     * @see com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatSectionBySection(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, java.lang.StringBuffer, java.util.Map)
     */
    public StringBuffer formatSectionBySection(String lang, R01MSearchSessionFormatterPreferences prefs, StringBuffer searchResultsFormatted, Map preGeneratedCode) {
        return S12SearchSessionHtmlFormatter._format(searchResultsFormatted,preGeneratedCode);
    }

    /**
     * Format.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param searchResultsFormatted the search results formatted
     * @param preGeneratedCode the pre generated code
     *
     * @return the string buffer
     *
     * @link com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#format(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, java.lang.StringBuffer, java.util.Map)
     */
    public StringBuffer format(String lang,R01MSearchSessionFormatterPreferences prefs,
                                           StringBuffer searchResultsFormatted,
                                           Map preGeneratedCode) {
        return this.formatSectionBySection(lang,prefs,searchResultsFormatted,preGeneratedCode);
    }

    /**
     * Format search box.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param qry the qry
     * @param preGeneratedCode the pre generated code
     *
     * @return the string buffer
     *
     * @link com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatSearchBox(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, com.ejie.r01m.objects.searchengine.query.R01MQueryObject, java.util.Map)
     */
    public StringBuffer formatSearchBox(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                    R01MQueryObject qry,
                                                    Map preGeneratedCode) {
        return S12SearchSessionHtmlFormatter._formatSearchBox(lang,qry,preGeneratedCode, prefs);
    }

    /**
     * Format header.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param query the query
     * @param sessionResults the session results
     * @param preGeneratedCode the pre generated code
     *
     * @return the string buffer
     *
     * @link com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatHeader(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, com.ejie.r01m.objects.searchengine.query.R01MQueryObject, com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults, java.util.Map)
     */
    public StringBuffer formatHeader(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                 R01MQueryObject query,
                                                 R01MSearchSessionResults sessionResults,
                                                 Map preGeneratedCode) {
        StringBuffer header = S12SearchSessionHtmlFormatter._formatHeader(lang,prefs,
                                                 query,sessionResults,
                                                 preGeneratedCode);
        return header;
    }

    /**
     * Format query.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param qry the qry
     * @param preGeneratedCode the pre generated code
     *
     * @return the string buffer
     *
     * @link com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatQuery(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, com.ejie.r01m.objects.searchengine.query.R01MQueryObject, java.util.Map)
     */
    public StringBuffer formatQuery(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                R01MQueryObject qry,
                                                Map preGeneratedCode) {
        StringBuffer query = S12SearchSessionHtmlFormatter._formatQuery(lang,prefs,
                                               qry,
                                               preGeneratedCode);
        return query;
    }

    /**
     * Format rss feed link.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param qry the qry
     * @param preGeneratedCode the pre generated code
     *
     * @return the string buffer
     *
     * @link com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatRssFeedLink(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, com.ejie.r01m.objects.searchengine.query.R01MQueryObject, java.util.Map)
     */
    public StringBuffer formatRssFeedLink(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                      R01MQueryObject qry,
                                                      Map preGeneratedCode) {
        StringBuffer rss = S12SearchSessionHtmlFormatter._formatRssFeedLink(lang,prefs,
                                                   qry,
                                                   preGeneratedCode,
                                                   false);
        return rss;
    }

    /**
     * Format risp link.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param qry the qry
     * @param preGeneratedCode the pre generated code
     *
     * @return the string buffer
     *
     * @link com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatXMLLink(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, com.ejie.r01m.objects.searchengine.query.R01MQueryObject, java.util.Map)
     */
    public StringBuffer formatRispLink(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                      R01MQueryObject qry,
                                                      Map preGeneratedCode) {
        StringBuffer rss = S12SearchSessionHtmlFormatter._formatRispLink(lang, prefs, qry,
                                                   preGeneratedCode,
                                                   false);
        return rss;
    }

    /**
     * Format search results.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param sessionResults the session results
     * @param preGeneratedCode the pre generated code
     * @param qry the qry
     *
     * @return the string buffer
     *
     * @link com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatSearchResults(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults, java.util.Map)
     */
    public StringBuffer formatSearchResults(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                        R01MSearchSessionResults sessionResults,
                                                        Map preGeneratedCode,R01MQueryObject qry) {
        StringBuffer results = S12SearchSessionHtmlFormatter._formatResults(lang,prefs,
                                                   sessionResults.getSearchResultsBySource(),
                                                   preGeneratedCode,qry);
        return results;
    }

    /**
     * Format search results items.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param items the items
     * @param preGeneratedCode the pre generated code
     *
     * @return the string buffer
     *
     * @link com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatSearchResultsItems(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem[], java.util.Map)
     */
    public StringBuffer formatSearchResultsItems(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                             R01MSearchResultItem[] items,
                                                             Map preGeneratedCode) {
        return S12SearchSessionHtmlFormatter._formatResultItems(lang,prefs,
                                       items,
                                       preGeneratedCode);
    }

    /**
     * Format search guide.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param guide the guide
     * @param preGeneratedCode the pre generated code
     *
     * @return the string buffer
     *
     * @link com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter#formatSearchGuide(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences, com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide, java.util.Map)
     */
    public StringBuffer formatSearchGuide(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                      R01MSearchGuide guide,
                                                      Map preGeneratedCode) {

        if (!prefs.showGuide) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer g;
        if (guide != null) {
            // OJO! si el nodo actual es null... se est en la raz de la guia..
            R01MSearchGuideElement[] guidePastElements = guide.getCurrentGuideNode() == null ? null : guide.getCurrentGuideNode().getPastElementsArray();
            R01MSearchGuideElement guideCurrentElement = guide.getCurrentGuideNode() == null ? null : guide.getCurrentGuideNode().getNodeElement();
            R01MSearchGuideElement[] guideFutureElements = guide.getCurrentGuideNode() == null ? guide.getFirstLevelNodesElements() : guide.getCurrentGuideNode().getFutureElementsArray();
            g = this._formatSearchGuide(lang,prefs,
                                   guidePastElements,guideCurrentElement,guideFutureElements,
                                   preGeneratedCode);
        } else {
            g = new StringBuffer("");
        }
        // "NO se utiliza guia de navegacin!
        return g;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS PRIVADOS ESTTICOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
		 * Formatea una sesin de bsqueda.
		 * IMPORTANTE:
		 * En la clase {@link com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebRequestProcessor} se han PRE-GENERADO partes
		 * llamando a mtodos concretos de esta clase
		 * - Query                 : formatQuery
		 * - Caja de Bsqueda      : formatSearchBox
		 * - Cabecera              : formatHeader
		 * - Guia                  : formatSearchGuide
		 * - Resultados            : formatSearchResults
		 * este mtodo lo nico que hace es "componer/juntar" todas las partes
		 *
		 * @param preGeneratedCode el codigo pre-formateado
		 * @param searchResultsFormatted the search results formatted
		 *
		 * @return la sesion formateada
		 */
    private static StringBuffer _format(StringBuffer searchResultsFormatted,Map preGeneratedCode) {
        StringBuffer sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_MEDIUM);
        sb.append("\r\n\r\n" +
                  "<div class=\"r01SearchSession\">\r\n");
        if (preGeneratedCode != null) {
            StringBuffer searchBoxFormatted = (StringBuffer)preGeneratedCode.get(R01MSearchSession.GENERATED_SEARCHBOX_ID);
            StringBuffer headerFormatted = (StringBuffer)preGeneratedCode.get(R01MSearchSession.GENERATED_HEADER_ID);
            StringBuffer guideFormatted = (StringBuffer)preGeneratedCode.get(R01MSearchSession.GENERATED_GUIDE_ID);
            StringBuffer rssFeedLinkFormatted = (StringBuffer)preGeneratedCode.get(R01MSearchSession.GENERATED_RSSLINK_ID);
//          StringBuffer theSearchResultsFormatted = searchResultsFormatted != null ? searchResultsFormatted
//                                                                                    : (StringBuffer)preGeneratedCode.get(R01MSearchSession.GENERATED_RESULTS_ID);

            if (searchBoxFormatted != null) {
                sb.append(searchBoxFormatted);
            }
            sb.append("<!--[if !IE]> oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo <![endif]-->\r\n" +
                      "<!--[if !IE]> oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo <![endif]-->\r\n" +
                      "<div class=\"r01SearchSessionResults\">\r\n");
            if (headerFormatted != null) {
            	sb.append(headerFormatted);
            }
            if (guideFormatted != null) {
            	sb.append(guideFormatted);
            }
            if (rssFeedLinkFormatted != null) {
            	sb.append(rssFeedLinkFormatted);
            }
            if (searchResultsFormatted != null) {
            	sb.append(searchResultsFormatted);
            }
            sb.append("</div>\r\n" +
                      "<!--[if !IE]> oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo <![endif]-->\r\n" +
                      "<!--[if !IE]> oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo <![endif]-->\r\n");
        } else {
            sb.append("<h1>ERROR: Pre-Generated code was not received from R01MSearchEngineWebRequestProcessor!!!</h1>");
        }
        sb.append("</div>\r\n");
        return sb;
    }

    /**
     * Formatea la caja de bsqueda.
     *
     * @param lang el lenguaje
     * @param qry la query de bsqeuda
     * @param preGeneratedCode codigo ya generado anteriormente
     * @param prefs the prefs
     *
     * @return html de la caja de bsqueda
     */
    private static StringBuffer _formatSearchBox(String lang,R01MQueryObject qry,
                                                             Map preGeneratedCode,
                                                             R01MSearchSessionFormatterPreferences prefs) {
        // Filtrar los tags HTML para evitar cross-scripting:
        //      Ej: introducir <script>alert("hola")</script> en la caja de texto
        String fullTextValue = (qry != null && qry.getFullText() != null) ?  R01MSearchEngineUtils.sanitizeParam(qry.getFullText())
                                                                          : "";
        String vaName = prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_VALUE_NAME);
        // Lenguaje
        String effLang = ("es".equals(lang) || "eu".equals(lang) || "fr".equals(lang) || "en".equals(lang) || "de".equals(lang)) ? lang : "en";

        // Componer la caja
        StringBuffer sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_SMALL);
        String servletRelativePath = R01MSearchFormatterURLHelpper.BASE_URL;
        sb.append("<!--[if !IE]> Se submite a esta misma pgina <![endif]-->\r\n");
        sb.append("<div class=\"r01searchBox r01clearfix\">\r\n");
        sb.append("<fieldset>\r\n");
        // Formulario
        sb.append("\t<form name=\"r01searchForm\" action=\"");
        sb.append(servletRelativePath);
        sb.append("\" onsubmit=\"if (window.r01gBtnSearchResult_Submit) window.r01gBtnSearchResult_Submit(event,'");
        sb.append(vaName);
        sb.append("');\">\r\n");
        sb.append("\t\t<label class=\"r01gLabelInputText\" for=\"r01searchFormText_");
        sb.append(vaName);
        sb.append("\" >Campo de la Busqueda</label>");
        sb.append("\t\t<input type=\"text\" name=\"");
        sb.append(R01MSearchEngineWebConstants.PARAM_SEARCH_QUERY_TEXT);
        sb.append("\" id=\"");
        sb.append("r01searchFormText_");
        sb.append(vaName);
        sb.append("\" value=\"");
        sb.append(StringEscapeUtils.escapeHtml(fullTextValue));
        StringBuffer iptClass = new StringBuffer("r01searchFormText");
        //Evento  keyup par bsquedas sugeridas
        if (prefs.showSuggestedSearchBox) {
            sb.append("\" onkeyup=\"if (window.r01gSearchBoxKeypress) r01gSearchBoxKeypress('");
            sb.append(vaName);
            sb.append("','");
            sb.append(prefs.resultsFormatterPreferences.itemUrlPrefix);
            iptClass.append(" iptAutocomplete");
            sb.append("');");
        }
        sb.append("\" class=\"");
        sb.append(iptClass);
        sb.append("\" />\r\n");
        sb.append("\t\t<input type=\"hidden\" name=\"");
        sb.append(R01MSearchEngineWebConstants.PARAM_SEARCHLANG );
        sb.append("\" value=\"");
        sb.append(lang);
        sb.append("\"/>\r\n");
        sb.append("\t\t<input type=\"hidden\" name=\"resultsSource\" value=\"fullText\"/>\r\n");      // compatibilidad con la V1
        sb.append("\t\t<input type=\"submit\" class=\"r01searchFormButton\" value=\"");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",effLang,"searchbox.button"));
        sb.append("\"/>\r\n");
        sb.append("\t</form>\r\n");
        sb.append("\t</fieldset>\r\n");

        // Ayudas
        String helpPage = XMLProperties.get(R01MConstants.API_APPCODE,"searchEngine/searchHelpPage/" + effLang);
        sb.append("\t<div class=\"r01searchBoxHelp\">\r\n");
        sb.append("\t\t<p><a href=\"");
        sb.append(StringEscapeUtils.escapeHtml(R01MSearchFormatterURLHelpper.BASE_URL + "?resultsSource=fullText&" + R01MQueryObject.METADATA_FULLTEXT));
        sb.append("=\">");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"query.nueva"));
        sb.append("</a></p>\r\n");
        sb.append("\t\t<p><a href=\"");
        sb.append(StringEscapeUtils.escapeHtml(helpPage));
        sb.append("\">");
        sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",effLang,"query.ayuda"));
        sb.append("</a></p>\r\n");
        sb.append("\t</div>\r\n");

        //Caja para bsquedas sugeridas
        if (prefs.showSuggestedSearchBox) {
            sb.append("\t<div id=\"r01searchBoxSuggested_" + prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_VALUE_NAME) + "\" class=\"r01searchBoxSuggested\"></div>");
        }

        sb.append("</div>\r\n");

        return sb;
    }
    /**
     * Formatea la query de bsqueda
     * @param lang el lenguaje
     * @param prefs las preferencias de formateo
     * @param qry la query de bsqueda
     * @param preGeneratedCode codigo ya generado anteriormente
     * @return el html con la query formateada
     */
    private static StringBuffer _formatQuery(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                         R01MQueryObject qry,
                                                         Map preGeneratedCode) {
        // Asegurarse de que siempre hay preferencias
        R01MSearchSessionFormatterPreferences appliedPrefs = (prefs == null ? new R01MSearchSessionFormatterPreferences():prefs);
        // Formatear
        StringBuffer sb;
        // *** Criterios de bsqueda
        if (appliedPrefs.formatterImpls.searchQueryFormatterClassName != null) {
            sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_SMALL);
            try {
                R01MSearchQueryFormatter qryFormatter = (R01MSearchQueryFormatter)ReflectionUtils.getObjectInstance(appliedPrefs.formatterImpls.searchQueryFormatterClassName);
                sb.append( qryFormatter.doFormatQuery(lang,appliedPrefs.queryFormatterPreferences,
                                                           qry) );
            } catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
                // Sacar el error por la salida....
                sb.append("Error al formatear la cabecera de bsqueda. No se ha podido instanciar el formateador: ");
                sb.append(refEx.getMessage());
            }
        } else {
            sb = new StringBuffer();
        }
        if (sb.length() > 0) {
            sb.insert(0,"\r\n\r\n<!--[if !IE]> oooooooooo CABECERA: CONDICIONES DE BUSQUEDA oooooooooo <![endif]-->\r\n<span class=\"r01Query\">\r\n");
            sb.append("</span>\r\n");    // Cabecera r01SearchSessionResultsHeader
        }
        return sb;
    }
    /**
     * Formatea la cabecera de una sesion de bsqueda
     * Probablemente la cabecera pueda ser cacheada, ya que de no variarse los parmetros de bsqueda, no es necesario
     * volverla a componer.
     *      Habra que volver a componer la cabecera si se pincha en un elemento de una guia de navegacin,
     *      pero NO si se pagina en cualquier origen de resultados.
     * @param lang El lenguaje
     * @param prefs las preferencias de formateo
     * @param query La query que ha dado lugar a los resultados
     * @param sessionResults Los resultados de la sesin de bsqueda
     * @param preGeneratedCode codigo ya generado anteriormente
     * @return El html con la cabecera formateada
     */
    private static StringBuffer _formatHeader(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                          R01MQueryObject query,
                                                          R01MSearchSessionResults sessionResults,
                                                          Map preGeneratedCode) {
        // Asegurarse de que siempre hay preferencias
        R01MSearchSessionFormatterPreferences appliedPrefs = (prefs == null ? new R01MSearchSessionFormatterPreferences():prefs);

        // Formatear
        StringBuffer sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_SMALL);
        sb.append("\r\n\r\n<!--[if !IE]>oooooooooo CABECERA: CONDICIONES DE BUSQUEDA oooooooooo <![endif]-->\r\n");

        // *** Numero de resultados total y por origen
        if (appliedPrefs.queryFormatterPreferences.showRepositoriesResume
         && appliedPrefs.formatterImpls.searchedRepositoriesFormatterClassName != null) {
            try {
                sb.append("<div class=\"r01SearchSessionResultsHeader\">\r\n");
                R01MSearchedRepositoriesResumeFormatter repoFormatter = (R01MSearchedRepositoriesResumeFormatter)ReflectionUtils.getObjectInstance(appliedPrefs.formatterImpls.searchedRepositoriesFormatterClassName);
                sb.append( repoFormatter.doFormatRepositoriesResume(lang,appliedPrefs.queryFormatterPreferences,
                                                                         sessionResults) );

                sb.append("</div>\r\n");    // Cabecera r01SearchSessionResultsHeader
            } catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
                // Sacar el error por la salida....
                sb.append("Error al formatear la cabecera de bsqueda. No se ha podido instanciar el formateador: ");
                sb.append(refEx.getMessage());
            }
        }

        return sb;
    }
    /**
     * Formatea la guia de navegacin
     * @param lang El lenguaje
     * @param prefs las preferencias de formateo
     * @param guidePastElements elementos pasados en la guia
     * @param guideCurrentElement elemento actual de la guia
     * @param guideFutureElements elementos futuros de la guia
     * @param preGeneratedCode codigo ya generado anteriormente
     * @return El html con la guia de navegacin formateada
     */
    private StringBuffer _formatSearchGuide(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                               R01MSearchGuideElement[] guidePastElements,
                                                               R01MSearchGuideElement guideCurrentElement,
                                                               R01MSearchGuideElement[] guideFutureElements,
                                                               Map preGeneratedCode) {
        // Asegurarse de que siempre hay preferencias
        R01MSearchSessionFormatterPreferences appliedPrefs = (prefs == null ? new R01MSearchSessionFormatterPreferences():prefs);

        // Formatear
        StringBuffer sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_SMALL);
        try {
            // *** Guia de Navegacion: puede ser una combo o una lista
            if (appliedPrefs.formatterImpls.searchGuideFormatterClassName != null) {
                R01MSearchGuideFormatter guideFormatter = (R01MSearchGuideFormatter)ReflectionUtils.getObjectInstance(appliedPrefs.formatterImpls.searchGuideFormatterClassName);
                if (appliedPrefs.guideFormatterPreferences.guideType == R01MSearchGuideFormatterPreferences.GUIDE_COMBO) {
                    sb.append( guideFormatter.doFormatGuideAsCombo(lang,appliedPrefs.guideFormatterPreferences,
                                                                        guidePastElements,
                                                                        guideCurrentElement,
                                                                        guideFutureElements) );
                } else if (appliedPrefs.guideFormatterPreferences.guideType == R01MSearchGuideFormatterPreferences.GUIDE_LIST) {
                    sb.append( guideFormatter.doFormatGuideAsList(lang,appliedPrefs.guideFormatterPreferences,
                                                                       guidePastElements,
                                                                       guideCurrentElement,
                                                                       guideFutureElements,
                                                                       appliedPrefs.guideFormatterPreferences.guideColumnsNum) );
                } else if (appliedPrefs.guideFormatterPreferences.guideType == R01MSearchGuideFormatterPreferences.GUIDE_TREE) {
                    // TODO Terminar cuando est ms definido
                }
            }
        } catch (ReflectionException refEx) {
            refEx.printStackTrace(System.out);
            // Sacar el error por la salida....
            sb.append("Error al formatear la guia de navegacin. No se ha podido instanciar el formateador: ");
            sb.append(refEx.getMessage());
        }
        return sb;
    }

    /**
     * Formatea la sindicacin de contenidos.
     *
     * @param lang El lenguaje
     * @param prefs las preferencias de formateo
     * @param query objeto con la query
     * @param preGeneratedCode cdigo pregenerado
     * @param rispAndRss the risp and rss
     *
     * @return El html con la sindicacin de contenidos formateada
     */
    private static StringBuffer _formatRssFeedLink(String lang,
                                                   R01MSearchSessionFormatterPreferences prefs,
                                                   R01MQueryObject query,
                                                   Map preGeneratedCode,
                                                   boolean rispAndRss) {
        // Asegurarse de que siempre hay preferencias
        R01MSearchSessionFormatterPreferences appliedPrefs = (prefs == null ? new R01MSearchSessionFormatterPreferences():prefs);

        String subscripcionRSS = R01MUtils.getLiteral("r01m", "searchEngineResources", lang, "portal.rss.subscription");
        String queEsRSS = R01MUtils.getLiteral("r01m", "searchEngineResources", lang, "portal.rss.queRSS");

        StringBuffer sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_SMALL);
        sb.append("\r\n\r\n<!--[if !IE]> oooooooooo SINDICACION DE CONTENIDOS oooooooooo <![endif]-->\r\n" +
                  "<div class=\"r01SearchSessionRssFeed");
        if (rispAndRss) {
            sb.append(" r01RssRispFloat");
        }
        sb.append("\">\r\n");

        String rssTitle =  "";
        if(prefs!=null) {
        	rssTitle = prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_RSS_TITLE);
        }
        String encodedTitleRSS = "";
        if(!StringUtils.isEmptyString(rssTitle)) {
            // /////////////////////////////////////////////////////////////////////////////////////////
            // IMPORTANTE: el ttulo se codifica en UTF-8
            // /////////////////////////////////////////////////////////////////////////////////////////
            try {
                encodedTitleRSS = URLEncoder.encode(rssTitle,R01MSearchEngineUtils.URL_ENCODING_UTF);
            } catch (UnsupportedEncodingException ex) {
                /* Ignorar */
                encodedTitleRSS = rssTitle;
            }
        }

        Properties propsRSS = new Properties();
        if (rssTitle != null) {
        	propsRSS.put("rssTitle", encodedTitleRSS);
        }
        if (subscripcionRSS != null) {
        	propsRSS.put("subscripcionRSS", subscripcionRSS);
        }
        if (queEsRSS != null) {
        	propsRSS.put("whatIsRSS", queEsRSS);
        }
        if (lang != null) {
        	propsRSS.put("lang", lang);
        }
        propsRSS.put("typeVA","SearchResult");
        if (appliedPrefs.resultsFormatterPreferences.itemUrlPrefix != null) {
        	propsRSS.put("presentationPage", appliedPrefs.resultsFormatterPreferences.itemUrlPrefix);
        }

        sb.append( R01MSearchEngineUtils.decorateRSSFeedLink("rssid", R01MSearchEngineWebConstants.PARAM_SEARCH_QUERY + "=" + R01MSearchEngineUtils.encodeQueryObjectInURL(query), true,propsRSS ));
        sb.append("</div>\r\n");

        return sb;
    }

    /**
     * Formatea el enlace para la generacin del XML para RISP.
     *
     * @param lang El lenguaje
     * @param prefs las preferencias de formateo
     * @param query objeto con la query
     * @param preGeneratedCode cdigo pregenerado
     * @param rispAndRss the risp and rss
     *
     * @return El html con la sindicacin de contenidos formateada
     */
    private static StringBuffer _formatRispLink(String lang,
                                                   R01MSearchSessionFormatterPreferences prefs,
                                                   R01MQueryObject query,
                                                   Map preGeneratedCode,
                                                   boolean rispAndRss) {
        StringBuffer sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_SMALL);

        // Hay que tener en cuenta que el objeto query se usa para pintar las cabeceras de la bsqueda
        // Hay que evitar que el objeto query sea alterado
        // Para ello clonamos el objeto ya que lo modificamos para generar la query de los enlaces RISP
        R01MQueryObject rispQuery = (R01MQueryObject) CloneUtils.cloneByReflection(query);

        sb.append("\r\n\r\n<!--[if !IE]> oooooooooo FORMATO RISP oooooooooo <![endif]-->\r\n" +
        		  "<div class=\"r01SearchSessionRispGlobal");
        if (rispAndRss) {
            sb.append(" r01RssRispFloat");
        }
        sb.append("\">\r\n");
        rispQuery.setPresentationProperty(R01MQueryObject.PRESENTATION_PAGE_SIZE, String.valueOf(R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE));
        //Quitamos parmetros de presentacin no necesarios en la query
        rispQuery.getPresentationProperties().remove(R01MQueryObject.PRESENTATION_NAVBAR_BLOCK_SIZE);

        S12SearchSessionHtmlFormatter._formatXMLRispLink(lang,prefs,rispQuery,preGeneratedCode, sb);
        S12SearchSessionHtmlFormatter._formatRDFRispLink(lang,prefs,rispQuery,preGeneratedCode, sb);

        sb.append("</div>\r\n");
        return sb;
    }

    /**
     * Formatea el enlace para la generacin del XML para RISP.
     *
     * @param lang El lenguaje
     * @param prefs las preferencias de formateo
     * @param query objeto con la query
     * @param preGeneratedCode cdigo pregenerado
     * @param sbRisp the sb risp
     *
     */
    private static void _formatXMLRispLink(String lang,
                                                   R01MSearchSessionFormatterPreferences prefs,
                                                   R01MQueryObject query,
                                                   Map preGeneratedCode,
                                                   StringBuffer sbRisp) {
        // Asegurarse de que siempre hay preferencias
        R01MSearchSessionFormatterPreferences appliedPrefs = (prefs == null ? new R01MSearchSessionFormatterPreferences():prefs);

        String xmlRispLabel = R01MUtils.getLiteral("r01m", "searchEngineResources", lang, "risp.xml.label");
        String queXMLRisp = R01MUtils.getLiteral("r01m", "searchEngineResources", lang, "risp.xml.queXMLRisp");
        String queXMLRispTitle = "risp XML";

        sbRisp.append("\r\n\r\n<!--[if !IE]> oooooooooo FORMATO RISP XML oooooooooo <![endif]-->\r\n" +
                  "<div class=\"r01SearchSessionRisp\">\r\n");

        Properties propsRisp = new Properties();
        propsRisp.put("rispUrl", "/r01hSearchResultWar/r01hPresentationXML.jsp");
        propsRisp.put("rispImage", "/AVComun/r01gSearchResultVA/images/r01gRispXML.gif");
        propsRisp.put("typeVA","SearchResult");
        propsRisp.put("rispPageInfo",R01MSearchEngineWebConstants.XML_PAGE_INFO);

        if (xmlRispLabel != null) {
        	propsRisp.put("labelRisp", xmlRispLabel);
        }
        if (queXMLRisp != null) {
        	propsRisp.put("whatIsRisp", queXMLRisp);
        }
        if (queXMLRispTitle != null) {
        	propsRisp.put("whatIsRispTitle",queXMLRispTitle);
        }
        if (lang != null) {
        	propsRisp.put("lang", lang);
        }

        //La pgina de presentacin de contenidos es necesaria para los enlaces 'Qu es ...?'
        if (appliedPrefs.resultsFormatterPreferences.itemUrlPrefix != null) {
        	propsRisp.put("presentationPage", appliedPrefs.resultsFormatterPreferences.itemUrlPrefix);
        }

        sbRisp.append( R01MSearchEngineUtils.decorateRispLink("r01RispXML", R01MSearchEngineWebConstants.PARAM_SEARCH_QUERY + "=" + R01MSearchEngineUtils.encodeQueryObjectInURL(query), true,propsRisp));
        sbRisp.append("</div>\r\n");


    }

    /**
     * Formatea el enlace para la generacin del RDF para RISP.
     *
     * @param lang El lenguaje
     * @param prefs las preferencias de formateo
     * @param query objeto con la query
     * @param preGeneratedCode cdigo pregenerado
     * @param sbRisp the sb risp
     *
     */
    private static void _formatRDFRispLink(String lang,
                                                   R01MSearchSessionFormatterPreferences prefs,
                                                   R01MQueryObject query,
                                                   Map preGeneratedCode,
                                                   StringBuffer sbRisp) {
        // Asegurarse de que siempre hay preferencias
        R01MSearchSessionFormatterPreferences appliedPrefs = (prefs == null ? new R01MSearchSessionFormatterPreferences():prefs);

        String rdfRispLabel = R01MUtils.getLiteral("r01m", "searchEngineResources", lang, "risp.rdf.label");
        String queRDFRisp = R01MUtils.getLiteral("r01m", "searchEngineResources", lang, "risp.rdf.queRDFRisp");
        String queRDFRispTitle = "risp RDF";

        sbRisp.append("\r\n\r\n<!--[if !IE]> oooooooooo FORMATO RISP RDF oooooooooo <![endif]-->\r\n" +
                  "<div class=\"r01SearchSessionRisp\">\r\n");

        Properties propsRisp = new Properties();
        propsRisp.put("rispUrl", "/r01hSearchResultWar/r01hPresentationRDF.jsp");
        propsRisp.put("rispImage", "/AVComun/r01gSearchResultVA/images/r01gRispRDF.gif");
        propsRisp.put("typeVA","SearchResult");
        propsRisp.put("rispPageInfo",R01MSearchEngineWebConstants.RDF_PAGE_INFO);
        if (rdfRispLabel != null) {
        	propsRisp.put("labelRisp", rdfRispLabel);
        }
        if (queRDFRisp != null) {
        	propsRisp.put("whatIsRisp", queRDFRisp);
        }
        if (queRDFRispTitle != null) {
        	propsRisp.put("whatIsRispTitle",queRDFRispTitle);
        }
        if (lang != null) {
        	propsRisp.put("lang", lang);
        }

        //La pgina de presentacin de contenidos es necesaria para los enlaces 'Qu es ...?'
        if (appliedPrefs.resultsFormatterPreferences.itemUrlPrefix != null) {
        	propsRisp.put("presentationPage", appliedPrefs.resultsFormatterPreferences.itemUrlPrefix);
        }


        sbRisp.append(R01MSearchEngineUtils.decorateRispLink("r01RispRDF", R01MSearchEngineWebConstants.PARAM_SEARCH_QUERY + "=" + R01MSearchEngineUtils.encodeQueryObjectInURL(query), true,propsRisp));
        sbRisp.append("</div>\r\n");
    }


    /**
     * Formatea en HTML los resultados de cada uno de los orgenes
     * @param lang El idioma
     * @param prefs las preferencias de presentacion
     * @param searchResultsBySource Los resultados de cada uno de los orgenes
     * @param preGeneratedCode codigo ya generado anteriormente
     * @param qry QueryObject para la generacin del RSS
     * @return El html con los resultados formateados
     */
    private static StringBuffer _formatResults(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                           Map searchResultsBySource,
                                                           Map preGeneratedCode, R01MQueryObject qry) {
        // Asegurarse de que siempre hay preferencias
        R01MSearchSessionFormatterPreferences appliedPrefs = (prefs == null ? new R01MSearchSessionFormatterPreferences():prefs);

        // Formatear cada uno de los orgenes de resultados
        StringBuffer sb;
        if (searchResultsBySource != null) {
            sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_LARGE);
            sb.append("\r\n\r\n<!--[if !IE]> oooooooooo RESULTADOS POR ORIGEN oooooooooo <![endif]-->\r\n" +
                      "<div class=\"r01SearchResultsBySource\">\r\n");
            // Recorrer cada uno de los orgenes de resultados...
            R01MSearchSourceResults currSrcResults = null;
            for(Iterator it=searchResultsBySource.values().iterator(); it.hasNext(); ) {
                currSrcResults = (R01MSearchSourceResults)it.next();

                if (currSrcResults.getResults() == null || currSrcResults.getResults().length == 0) {
                    sb.append( S12SearchSessionHtmlFormatter._composeNoResultsMessage(lang,preGeneratedCode) );
                    continue;
                }
                // Componer los textos de la barra de navegacin
                StringBuffer navBarText = null;     // Texto
                StringBuffer navBar = null;         // paginacion   <<    < 1 2 3 3 >    >>
                try {
                    if (appliedPrefs.navBarFormatterPreferences.showSourceResultsNavBars
                     && appliedPrefs.formatterImpls.searchResultsNavBarFormatterClassName != null) {
                        R01MSearchResultsNavBarFormatter navFormatter = (R01MSearchResultsNavBarFormatter)ReflectionUtils.getObjectInstance(appliedPrefs.formatterImpls.searchResultsNavBarFormatterClassName);
                        // Componer el texto de la barra
                        navBarText = navFormatter.doFormatNavBarText(lang,appliedPrefs.navBarFormatterPreferences,
                                                                          it.hasNext(),
                                                                          currSrcResults.getSourceOid(),currSrcResults.getSourceDetails().getSourceName(),
                                                                          currSrcResults.getNumberOfResults(),currSrcResults.getNumberOfPages(),
                                                                          currSrcResults.getNavBar());
                        // Componer la barra de navegacin
                        navBar = navFormatter.doFormatNavBar(lang,appliedPrefs.navBarFormatterPreferences,
                                                                  it.hasNext(),   // es el nico origen de resultados?
                                                                  currSrcResults.getSourceOid(),currSrcResults.getSourceDetails().getSourceName(),
                                                                  currSrcResults.getNumberOfResults(),currSrcResults.getNumberOfPages(),
                                                                  currSrcResults.getNavBar());
                    }
                } catch (ReflectionException refEx) {
                    refEx.printStackTrace(System.out);
                    sb.append("Error al formatear la guia. No se ha podido instanciar el formateador: ");
                    sb.append(refEx.getDetailedMessage());
                }


                // ------------ Componer el HTML -----------------
                sb.append("\r\n\r\n\t<!--[if !IE]> :::: RESULTADOS DEL ORIGEN ");
                sb.append(currSrcResults.getSourceDetails().getSourceName());
                sb.append(" <![endif]-->\r\n");

                sb.append("\t<div class=\"r01SearchResultsSource \">\r\n" +
                          // Anchor invisible para que al pulsar en el totalizador de resultados del origen se llegue aqui...
                          "\t<a name=\"");
                sb.append(currSrcResults.getSourceOid());
                sb.append("\" class=\"r01Invisible\">");
                sb.append(currSrcResults.getSourceDetails().getSourceName());
                sb.append('(');
                sb.append(currSrcResults.getSourceOid());
                sb.append(")</a>\r\n");

                // ------> Pestaas para las ordenaciones
                if (prefs != null && prefs.resultsFormatterPreferences.showOrderByTabs) {
                    sb.append("\t<div class=\"r01TabsContainer r01clearfix\"><!-- Tabs Ordenacion -->\r\n");
                    sb.append("\t\t<span class=\"r01OrderByTxt\">");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"pestanas.ordenar"));
                    sb.append("</span>\r\n");
                    sb.append("\t\t<div class=\"r01topTabs r01topTabsRight r01OrderByTabs\">\r\n");
                    sb.append("\t\t\t<ul>\r\n");
                    sb.append("\t\t\t\t<li><a href=\"#\"><span>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"pestanas.fecha"));
                    sb.append("</span></a></li>\r\n");
                    sb.append("\t\t\t\t<li><a href=\"#\"><span>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"pestanas.relevancia"));
                    sb.append("</span></a></li>\r\n");
                    sb.append("\t\t\t\t<li><a href=\"#\"><span>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"pestanas.ordeAlfab"));
                    sb.append("</span></a></li>\r\n");
                    sb.append("\t\t\t\t<li><a href=\"#\"><span>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"pestanas.vigencia"));
                    sb.append("</span></a></li>\r\n");
                    sb.append("\t\t\t</ul>\r\n");
                    sb.append("\t\t</div>\r\n");
                    sb.append("\t</div><!--[if !IE]> Tabs de ordenacion <![endif]-->\r\n");
                }

                // ===== PAGINACION +  RESULTADOS
                sb.append("\t<div class=\"r01SourceNavBarAndResults\">\r\n");

                // ------> Barra superior de navegacion
                // Resumen de la query
                StringBuffer queryFormatted = preGeneratedCode != null && preGeneratedCode.get(R01MSearchSession.GENERATED_QUERY_ID) != null
                                                    ? (StringBuffer)preGeneratedCode.get(R01MSearchSession.GENERATED_QUERY_ID)
                                                    : null;

                if(prefs != null) {
	                ///////////////////////////////////////////////////////////////////////////////////////////
	                //  SI EXISTE RSS Y RISP A LA VEZ
	                ///////////////////////////////////////////////////////////////////////////////////////////
	                if (prefs.showRSSFeedLink && prefs.showRisp) {
	                    sb.append("<div class=\"r01clearfix r01SearchSessionRSSRisp\">");
	                }

	                ///////////////////////////////////////////////////////////////////////////////////////////
	                //  Incorporar el RSS
	                ///////////////////////////////////////////////////////////////////////////////////////////
	                if (prefs.showRSSFeedLink) {
	                    sb.append( S12SearchSessionHtmlFormatter._formatRssFeedLink(lang,prefs,
	                                                       qry,
	                                                       preGeneratedCode, prefs.showRisp));
	                }
	                ///////////////////////////////////////////////////////////////////////////////////////////
	                //  Incorporar los enlaces RISP
	                ///////////////////////////////////////////////////////////////////////////////////////////
	                if (prefs.showRisp) {
	                    sb.append( S12SearchSessionHtmlFormatter._formatRispLink(lang,prefs,qry,preGeneratedCode,prefs.showRSSFeedLink));
	                    if (!prefs.showRSSFeedLink) {
	                        //Si hay RISP pero no RSS se escribe aqu
	                        sb.append("<!--#include virtual='/AVComun/r01gSearchResultVA/html/risp_leyend_");
	                        sb.append(lang);
	                        sb.append(".html'-->");
	                    }
	                }
	                ///////////////////////////////////////////////////////////////////////////////////////////
	                //  FIN SI EXISTE RSS Y RISP A LA VEZ
	                ///////////////////////////////////////////////////////////////////////////////////////////
	                if (prefs.showRSSFeedLink && prefs.showRisp) {
	                    //Si hay RISP y RSS se escribe aqu
	                    sb.append("<!--#include virtual='/AVComun/r01gSearchResultVA/html/risp_leyend_");
	                    sb.append(lang);
	                    sb.append(".html'--></div>");
	                }


	                StringBuffer supNavBarText = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_SMALL);
	                supNavBarText.append(navBarText);
	                // El resumen de la bsqueda vara dependiendo del idioma
	                // XXX resultados sobre YYY o XXX YYYY sobre (euskera)
	                if (lang != null && lang.equalsIgnoreCase(R01MConstants.LANG_EUSKERA)) {        // Caso especial euskera
	                    supNavBarText.append( (preGeneratedCode != null && queryFormatted != null && queryFormatted.length() > 0
	                                                                       ? " " + queryFormatted + " " + R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"item.sobre")
	                                                                       : "") );
	                } else {
	                    supNavBarText.append( (preGeneratedCode != null && queryFormatted != null && queryFormatted.length() > 0
	                                                                        ? " " + R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"item.sobre") + " " + queryFormatted
	                                                                        : "") );
	                }
                  /* En Turismo no se necesita barra superior
                  sb.append( _formatNavBar(supNavBarText,navBar,
                                           it.hasNext(),
                                           currSrcResults.getSourceOid(),currSrcResults.getSourceDetails().getSourceName(),
                                           currSrcResults.getNumberOfResults(),currSrcResults.getNumberOfPages(),
                                           currSrcResults.getNavBar(), prefs.showResultsHeader) );
                  */

	                // ------> Capa para banner y destacados
	                if (prefs.showBanner || !"0".equals(prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_MAXNUMHIGHLIGHT))) {
	                    sb.append("\t<div id=\"r01SourceHighLights_");
	                    sb.append(prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_VALUE_NAME));
	                    sb.append("\" class=\"r01SourceSearchResults\">\r\n");

	                    ///////////////////////////////////////////////////////////////////////////////////////////
	                    //  NO JAVASCRIPT - ENLACES DESTACADOS
	                    ///////////////////////////////////////////////////////////////////////////////////////////
	                    sb.append("\t<!-- en caso de que el navegador no soporte javascript mostrar una pgina con todas los destacados -->\r\n");
	                    if (qry.getFullText() != null) {
	                        sb.append("\t<noscript>\r\n");
	                        String highLightNoScriptText = prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_HIGHLIGHT_NOSCRIPT_TEXT);
	                        if ((highLightNoScriptText == null) || (StringUtils.isEmptyString(highLightNoScriptText))) {
	                            highLightNoScriptText = "Enlaces Destacados";
	                        }
	                        String highLightNoScriptTitle = prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_HIGHLIGHT_NOSCRIPT_TITLE);
	                        if ((highLightNoScriptTitle == null) || (StringUtils.isEmptyString(highLightNoScriptTitle))) {
	                            highLightNoScriptTitle = "";
	                        }

	                        sb.append("\t\t<a href=\"http://euskadi.colbenson.es/highlightedSearchResults?jsoncallback=?&r01FullText=");
	                        sb.append(qry.getFullText());
	                        sb.append("&r01IncludeBanner=");
	                        sb.append(prefs.showBanner);
	                        sb.append("&r01MaxNumHighLights=");
	                        sb.append(prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_MAXNUMHIGHLIGHT));
	                        sb.append("&t=html&r01SearchResultsPresentation=");
	                        sb.append(prefs.getFormatterProperty(R01MPortalConstants.REQ_PARAM_PORTAL_CODE));
	                        sb.append('-');
	                        sb.append(prefs.getFormatterProperty(R01MPortalConstants.REQ_PARAM_PORTAL_PAGECODE));
	                        sb.append('/');
	                        sb.append(prefs.getFormatterProperty(R01MPortalConstants.REQ_PARAM_PORTAL_PAGE_LANG));
	                        sb.append("&r01ContentsPresentation=\" title=\"");
	                        sb.append(highLightNoScriptTitle);
	                        sb.append("\">[");
	                        sb.append(highLightNoScriptText);
	                        sb.append("]</a>\t</noscript>\r\n");
	                    }
	                    sb.append("\t</div>\r\n");
	                }

	                // ------> Capa para bsquedas semnticas
	                if (prefs.showSemanticSearch) {
	                    sb.append("\t<div id=\"r01SemanticSearchResults_");
	                    sb.append(prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_VALUE_NAME));
	                    sb.append("\" class=\"r01SemanticSearchResults\">\r\n");

	                    ///////////////////////////////////////////////////////////////////////////////////////////
	                    //  NO JAVASCRIPT - ENLACES DESTACADOS (BSQUEDA SEMNTICA)
	                    ///////////////////////////////////////////////////////////////////////////////////////////
	                    sb.append("\t<!-- en caso de que el navegador no soporte javascript mostrar una pgina con todas los destacados -->\r\n");
	                    if (!StringUtils.isEmptyString(qry.getFullText())) {
	                        sb.append("\t<noscript>\r\n");
	                        String highLightNoScriptText = prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_HIGHLIGHT_NOSCRIPT_TEXT);
	                        if ((highLightNoScriptText == null) || (StringUtils.isEmptyString(highLightNoScriptText))) {
	                            highLightNoScriptText = "Enlaces Destacados";
	                        }
	                        String highLightNoScriptTitle = prefs.getFormatterProperty(R01MSearchEngineConstants.PRESENTATION_PROPERTY_HIGHLIGHT_NOSCRIPT_TITLE);
	                        if ((highLightNoScriptTitle == null) || (StringUtils.isEmptyString(highLightNoScriptTitle))) {
	                            highLightNoScriptTitle = "";
	                        }

	                        sb.append("\t\t<a href=\"http://ws07.inbenta.com/euskadinet?jsoncallback=?&r01FullText=");
	                        sb.append(qry.getFullText());
	                        sb.append("&t=html&r01SearchResultsPresentation=");
	                        sb.append(prefs.getFormatterProperty(R01MPortalConstants.REQ_PARAM_PORTAL_CODE));
	                        sb.append('-');
	                        sb.append(prefs.getFormatterProperty(R01MPortalConstants.REQ_PARAM_PORTAL_PAGECODE));
	                        sb.append('/');
	                        sb.append(prefs.getFormatterProperty(R01MPortalConstants.REQ_PARAM_PORTAL_PAGE_LANG));
	                        sb.append("&r01ContentsPresentation=\" title=\"");
	                        sb.append(highLightNoScriptTitle);
	                        sb.append("\">[");
	                        sb.append(highLightNoScriptText);
	                        sb.append("]</a>\t</noscript>\r\n");
	                    }
	                    sb.append("\t</div>\r\n");
	                }
	                // ------> Elementos de resultado
	                sb.append(S12SearchSessionHtmlFormatter._formatResultItems(lang,appliedPrefs,
	                                                  currSrcResults.getResults(),
	                                                  preGeneratedCode));

	                // ------> Barra inferior de navegacin
	                sb.append( S12SearchSessionHtmlFormatter._formatNavBar(navBarText,navBar,
	                                         false,                 // NO pintar el origen de resultados...
	                                         currSrcResults.getSourceOid(),currSrcResults.getSourceDetails().getSourceName(),
	                                         currSrcResults.getNumberOfResults(),currSrcResults.getNumberOfPages(),
	                                         currSrcResults.getNavBar(), prefs.showResultsHeader) );
                }


                sb.append("\t</div>\r\n" +  // ===== PAGINACION +  RESULTADOS
                          "\t</div>\r\n" +  // ... tabs + paginacion + resultados
                          "\t<!--[if !IE]> FIN RESULTADOS DEL ORIGEN ");
                sb.append(currSrcResults.getSourceDetails().getSourceName());
                sb.append(" <![endif]-->\r\n\r\n\r\n");

                // ------> Tooltip
                /*
                sb.append("\t<!-- Informacin sobre la agrupacin de resultados -->\r\n");
                sb.append("\t<div id=\"r01srToolTipBalloon\" class=\"r01toolTipBalloon\">\r\n");
                sb.append("\t\t" + R01MSearchEngineUtils.getLiteral(lang,"toolTip.agrupacionResultados") + "\r\n");
                sb.append("\t</div>\r\n");
                */
            }
        } else {
            sb = new StringBuffer();
            sb.append("\r\n\r\n<!--[if !IE]> oooooooooo RESULTADOS POR ORIGEN oooooooooo <![endif]-->\r\n" +
                      "<div class=\"r01SearchResultsBySource\">\r\n");
            sb.append( S12SearchSessionHtmlFormatter._composeNoResultsMessage(lang,preGeneratedCode) );
        }
        sb.append("</div>\r\n" +
                  "<!--[if !IE]> oooooooooo FIN RESULTADOS POR ORIGEN oooooooooo <![endif]-->\r\n");
        return sb;
    }
    /**
     * Formatea los elementos de resultado de bsqueda (elementos {@link R01MSearchResultItem})
     * @param lang el lenguaje
     * @param prefs las preferencias de formateo
     * @param items los items de resultado
     * @param preGeneratedCode codigo ya generado anteriormente
     * @return el html formateado
     */
    private static StringBuffer _formatResultItems(String lang,R01MSearchSessionFormatterPreferences prefs,
                                                               R01MSearchResultItem[] items,
                                                               Map preGeneratedCode) {
        // Asegurarse de que siempre hay preferencias y establecer las implementaciones de formateo
        // dependientes del tipo de contenido
        R01MSearchSessionFormatterPreferences appliedPrefs = (prefs == null ? new R01MSearchSessionFormatterPreferences():prefs);




        StringBuffer sb;
        // Elementos de resultado
        if (appliedPrefs.formatterImpls.searchResultItemFormatterClassName != null) {
            sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_LARGE);
            try {
                R01MSearchResultItemsFormatter resultsFormatter = (R01MSearchResultItemsFormatter)ReflectionUtils.getObjectInstance(appliedPrefs.formatterImpls.searchResultItemFormatterClassName);
                sb.append( resultsFormatter.doFormatResultItems(lang,appliedPrefs.resultsFormatterPreferences,
                                                                     items) );
            } catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
                sb.append("Error al formatear los resultados. No se ha podido instanciar el formateador: ");
                sb.append(refEx.getDetailedMessage());
            }
        } else {
            sb = new StringBuffer();
        }
        return sb;
    }

    /**
     * Formateo de la barra de navegacin.
     *
     * @param navBarText the nav bar text
     * @param navBarFormatted the nav bar formatted
     * @param areThereMoreSources the are there more sources
     * @param sourceOid the source oid
     * @param sourceName the source name
     * @param numResults the num results
     * @param numPages the num pages
     * @param navBar the nav bar
     * @param showHeader the show header
     *
     * @return the string buffer
     */
    private static StringBuffer _formatNavBar(StringBuffer navBarText,StringBuffer navBarFormatted,
                                              boolean areThereMoreSources,
                                              String sourceOid,String sourceName,
                                              int numResults,int numPages,
                                              R01MSearchNavBar navBar, boolean showHeader) {
        StringBuffer sb = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_MEDIUM);
        sb.append("\t<!--[if !IE]> BARRA DE NAVEGACIN EN EL ORIGEN <![endif]-->\r\n" +
                  "\t<div class=\"r01SearchResultsNavBar r01clearfix\">\r\n");

        // Estructura de capas:
        //      r01SearchResultsNavBar
        //          - r01SearchSourceName
        //          - r01SearchSourcePagCtx
        //          - r01SearchResultsNavBarItems
        String colsClassName = "r01SearchResultsNavBar" + (areThereMoreSources ? "3":"2") + "cols";

        // Nombre del origen (no mostrarlo si se trata de un nico origen de resultados)
        if (areThereMoreSources) {
            sb.append("\t\t<div class=\"r01SearchSourceName ");
            sb.append(colsClassName);
            sb.append("_1\">");
            sb.append(sourceName);
            sb.append("</div>\r\n");
        }

        // Contexto de paginacin>> Ejemplo: 250 resultados, pgina 1 de 12 resultados del 1 al 10
        /* En turismo no se necesita texto de navegacin
        sb.append("\t\t<div class=\"r01SearchSourcePagCtx ");
        sb.append(colsClassName);
        sb.append("_2\">");
        if(showHeader) {
            sb.append(navBarText);
        }// Texto de la barra
        sb.append("\t\t</div>\r\n");
        */

        // Los elementos de la paginacion
        if (numPages > 0) {
            if (navBar.getNavBarItems() != null && navBar.getNavBarItems().size() >= 4) {
                sb.append("\t\t<div class=\"r01SearchResultsNavBarItems ");
                sb.append(colsClassName);
                sb.append("_32\">\r\n");
                sb.append(navBarFormatted);
                sb.append("\t\t</div>\r\n");
            }
        } // numPages < 0


        sb.append("\t</div>\r\n" +
                  "\t<!--[if !IE]> FIN BARRA DE NAVEGACIN EN EL ORIGEN <![endif]-->\r\n");
        return sb;
    }
    /**
     * Compone el mensaje de NO hay resultados
     * @param lang el lenguaje del mensaje
     * @param preGeneratedCode codigo ya generado anteriormente
     * @return el mensaje
     */
    private static StringBuffer _composeNoResultsMessage(String lang,Map preGeneratedCode) {
        StringBuffer msg = new StringBuffer(S12SearchSessionHtmlFormatter.SIZE_STRINGBUFFER_MEDIUM);

//        StringBuffer queryFormatted = preGeneratedCode != null && preGeneratedCode.get(R01MSearchSession.GENERATED_QUERY_ID) != null ? (StringBuffer)preGeneratedCode.get(R01MSearchSession.GENERATED_QUERY_ID)
//                                                                                                                                     : new StringBuffer("");
        String line1 = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"noResults.line1") + "&nbsp;";
        //String line1_2 = queryFormatted.toString() != null && !StringUtils.isEmptyString(queryFormatted.toString()) > 0 ? (R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"noResults.buscando") + queryFormatted.toString())
        //                                                                                                    : "";
        String line1_2 = "";

        String line2 = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"noResults.line2");
        String sug1 = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"noResults.sugerencia1");
        String sug2 = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"noResults.sugerencia2");
        String sug3 = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"noResults.sugerencia3");

        msg.append("<div class=\"r01noResults\">");
        msg.append("<p class=\"r01noResultsLine1\">");
        msg.append(line1 != null && line1_2 != null ? (line1+line1_2) : "[NO Results]");
        msg.append("</p>");
        if (line2 != null) {
            msg.append("<p class=\"r01noResultsLine2\">");
            msg.append(line2);
            msg.append("</p>");
        }
        if (sug1 != null || sug2 != null || sug3 != null) {
            msg.append("<ul>");
            if (sug1 != null) {
            	msg.append("<li>");msg.append(sug1);msg.append("</li>");
            }
            if (sug2 != null) {
            	msg.append("<li>");msg.append(sug2);msg.append("</li>");
            }
            if (sug3 != null) {
            	msg.append("<li>");msg.append(sug3);msg.append("</li>");
            }
            msg.append("</ul>");
        }
        msg.append("</div>");
        return msg;
    }
    
    /**
     * Formatea la query de bsqueda.
     *
     * @param lang el lenguaje
     * @param prefs las preferencias de formateo
     * @param qry la query de bsqueda
     * @param preGeneratedCode codigo ya generado anteriormente
     * @param showAllMetadataDescription the show all metadata description
     * 
     * @return el html con la query formateada
     */
	@Override
	public StringBuffer formatQuery(String lang, R01MSearchSessionFormatterPreferences prefs,
            R01MQueryObject qry, Map preGeneratedCode, boolean showAllMetadataDescription) {
		
		return formatQuery(lang, prefs, qry, preGeneratedCode);
	}

}
