package s12.buscadores.formatters;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringEscapeUtils;

import com.ejie.r01m.objects.searchengine.results.R01MSearchNavBar;
import com.ejie.r01m.objects.searchengine.results.R01MSearchNavBarItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterURLHelpper;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultsNavBarFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsNavBarFormatterPreferences;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;

/**
 * Formateador por defecto en HTML de la barra de navegacin de un
 * origen resultados.
 *
 *  
 */
public class S12SearchResultsNavBarHtmlFormatter implements R01MSearchResultsNavBarFormatter, // NO_UCD
                                                                Serializable {
    private static final long serialVersionUID = -7493222398944421761L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////

  	/** The Constant SIZE_STRINGBUFFER_MEDIUM. */
  	private static final int SIZE_STRINGBUFFER_MEDIUM = 500;

  	/** The Constant SIZE_STRINGBUFFER_LARGE. */
  	private static final int SIZE_STRINGBUFFER_LARGE = 2000;

///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public S12SearchResultsNavBarHtmlFormatter() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
		 * Do format nav bar text.
		 *
		 * @param lang the lang
		 * @param prefs the prefs
		 * @param areThereMoreSources the are there more sources
		 * @param sourceOid the source oid
		 * @param sourceName the source name
		 * @param numResults the num results
		 * @param numPages the num pages
		 * @param navBar the nav bar
		 *
		 * @return the string buffer
		 *
		 * @see com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultsNavBarFormatter#doFormatNavBarText(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsNavBarFormatterPreferences, boolean, java.lang.String, java.lang.String, int, int, com.ejie.r01m.objects.searchengine.results.R01MSearchNavBar)
		 */
    public StringBuffer doFormatNavBarText(String lang,R01MSearchResultsNavBarFormatterPreferences prefs,
                                                       boolean areThereMoreSources,
                                                       String sourceOid,String sourceName,
                                                       int numResults,int numPages,
                                                       R01MSearchNavBar navBar) {

        if (numResults <= 0) {
        	return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }

        StringBuffer outPaggingTxt = new StringBuffer(S12SearchResultsNavBarHtmlFormatter.SIZE_STRINGBUFFER_LARGE);
        StringBuffer paggingSB = new StringBuffer(S12SearchResultsNavBarHtmlFormatter.SIZE_STRINGBUFFER_MEDIUM);
        paggingSB.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.numResultados"));   // numResults
        if (numPages > 0) {
            paggingSB.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.resultados"));
            //if (navBar.getCurrentPage() > 0 && navBar.getCurrentPageFirstElementNumber() > 0 && navBar.getCurrentPageLastElementNumber() > 0) {
            //    paggingSB.append(R01MSearchEngineUtils.getLiteral(lang,"navegaBarra.pagging"));
            //}
        }

        // Utilizar el customizador de propiedades
        Properties props = new Properties();
        try {
            // Utilizar un formateador de numeros
            NumberFormat nf = NumberFormat.getInstance();   // Toma el locale por defecto para el pais...

            props.setProperty("numResultados",nf.format(numResults));
            props.setProperty("currPage",nf.format(navBar.getCurrentPage()));
            props.setProperty("totalPages",nf.format(numPages));
            props.setProperty("currPageFirstEl",nf.format(navBar.getCurrentPageFirstElementNumber()));
            props.setProperty("currPageLastEl",nf.format(navBar.getCurrentPageLastElementNumber()));
        } catch(NumberFormatException nfEx) {
            nfEx.printStackTrace(System.out);
            // Ha fallado el formateo.. dejar sin formatear al menos
            props.setProperty("numResultados",Integer.toString(numResults));
            props.setProperty("currPage",Integer.toString(navBar.getCurrentPage()));
            props.setProperty("totalPages",Integer.toString(numPages));
            props.setProperty("currPageFirstEl",Integer.toString(navBar.getCurrentPageFirstElementNumber()));
            props.setProperty("currPageLastEl",Integer.toString(navBar.getCurrentPageLastElementNumber()));
        }

        try {
            // Leer todo el resultado y utilizar expresiones regulares para lanzar eventos
            Pattern p = Pattern.compile("(\\$\\[[^]$]+\\]\\$)");
            Matcher m = p.matcher(paggingSB);
            boolean directiveValid = m.find();
            String foundDirective = null;
            String propValue = null;
            while (directiveValid) {
                foundDirective = paggingSB.substring(m.start(),m.end());
                propValue = props.getProperty(foundDirective.substring(2,foundDirective.length()-2));
                m.appendReplacement(outPaggingTxt,propValue != null ? propValue:"");
                // Volver a buscar
                directiveValid = m.find();
            }
            m.appendTail(outPaggingTxt);

            /*
            TextCustomizer txtCust = new TextCustomizer();
            outPaggingTxt = new StringBuffer( txtCust.customize( new StringReader(paggingSB.toString()),props ) );
            */
        } catch(Exception ex) {
            ex.printStackTrace(System.out);
        }

        return outPaggingTxt;
    }

    /**
     * Do format nav bar.
     *
     * @param lang the lang
     * @param prefs the prefs
     * @param areThereMoreSources the are there more sources
     * @param sourceOid the source oid
     * @param sourceName the source name
     * @param numResults the num results
     * @param numPages the num pages
     * @param navBar the nav bar
     *
     * @return the string buffer
     *
     * @see com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultsNavBarFormatter#doFormatNavBar(java.lang.String, com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsNavBarFormatterPreferences, boolean, java.lang.String, java.lang.String, int, int, com.ejie.r01m.objects.searchengine.results.R01MSearchNavBar)
     */
    public StringBuffer doFormatNavBar(String lang,R01MSearchResultsNavBarFormatterPreferences prefs,
                                                   boolean areThereMoreSources,
                                                   String sourceOid,String sourceName,
                                                   int numResults,int numPages,
                                                   R01MSearchNavBar navBar) {

        if (navBar.getNavBarItems().size() < 4) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }

        // Si solo hay 4 elementos, son los elementos de control de primera pgina, pgina anterior, ultima pgina y pgina siguiente
        StringBuffer sb = new StringBuffer(S12SearchResultsNavBarHtmlFormatter.SIZE_STRINGBUFFER_MEDIUM);
        sb.append("\t\t\t<ul class=\"r01NavBarItems\">\r\n");
        Iterator it = navBar.getNavBarItems().iterator();
        R01MSearchNavBarItem currItem = null;
        StringBuffer itemStyleClass = null;
        String itemText = null;
        String itemAlt = null;
        StringBuffer itemURL = null;
        R01MSearchNavBarItem firstPageItem = navBar.findFirstPageItem();
        R01MSearchNavBarItem lastPageItem = navBar.findLastPageItem();
        boolean prevPagesBlockMarkIncluded = false;     // Se ha incluido la marca ... indicando que hay un bloque de pginas previo ?
        boolean nextPagesBlockMarkIncluded = false;     // Se ha incluido la marca ... indicando que hay un bloque de pginas posterior ?
        do {
            currItem = (R01MSearchNavBarItem)it.next();

            itemURL = new StringBuffer();
            if (currItem.getItemType().equals(R01MSearchNavBarItem.ITEM_FIRST_PAGE)) {
                continue;   // No pintar el enlace al primer resultado
                /*
                itemStyleClass = "r01NavBarCtrlItem r01NavBarFirst";
                //itemText = "<<";
                itemText = "&nbsp;&nbsp;&nbsp;&nbsp;";
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.primera"); //"Primera Pgina"
                itemURL += R01MSearchFormatterURLHelpper.composeFirstPageURL(sourceOid,currItem.getPageNum());
                */
            } else if (currItem.getItemType().equals(R01MSearchNavBarItem.ITEM_PREV_BLOCK)) {
                itemStyleClass = new StringBuffer("r01NavBarCtrlItem r01NavBarPrevBlock");
                //itemText = "<<";
                itemText = "&nbsp;&nbsp;&nbsp;&nbsp;";
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.bloqueanterior"); //"Bloque anterior"
                itemURL.append(R01MSearchFormatterURLHelpper.composePrevBlockURL(sourceOid,currItem.getPageNum()));
            } else if (currItem.getItemType().equals(R01MSearchNavBarItem.ITEM_PREV_PAGE)) {
                continue;
            		//itemStyleClass = "r01NavBarCtrlItem";
                //itemText = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.anterior");//"Anterior";
                //itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.paganterior");//"Pgina Anterior";
                //itemURL += R01MSearchFormatterURLHelpper.composePrevPageURL(sourceOid,currItem.getPageNum());
            } else if (currItem.getItemType().equals(R01MSearchNavBarItem.ITEM_PAGE)) {
                itemStyleClass = new StringBuffer("r01NavBarItem");
                if (currItem != lastPageItem) {
                	itemStyleClass.append(" r01NavBarIntermediateItem");   // Para incluir el separador | con la CSS
                }
                itemText = Integer.toString(currItem.getPageNum());
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.pagina") + itemText; //Pgina
                itemURL.append(R01MSearchFormatterURLHelpper.composePageURL(sourceOid,currItem.getPageNum()));
            } else if (currItem.getItemType().equals(R01MSearchNavBarItem.ITEM_NEXT_PAGE)) {
                continue;
            		//itemStyleClass = "r01NavBarCtrlItem";
                //itemText = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.siguiente");//"Siguiente";
                //itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.pagsiguiente");//"Siguiente Pgina";
                //itemURL += R01MSearchFormatterURLHelpper.composeNextPageURL(sourceOid,currItem.getPageNum());
            } else if (currItem.getItemType().equals(R01MSearchNavBarItem.ITEM_NEXT_BLOCK)) {
                itemStyleClass = new StringBuffer("r01NavBarCtrlItem r01NavBarNextBlock");
                //itemText = ">>";
                itemText = "&nbsp;&nbsp;&nbsp;&nbsp;";
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.bloquesiguiente"); //"Bloque siguiente"
                itemURL.append(R01MSearchFormatterURLHelpper.composeNextBlockURL(sourceOid,currItem.getPageNum()));
            } else if (currItem.getItemType().equals(R01MSearchNavBarItem.ITEM_LAST_PAGE)) {
                continue;       // No pintar el enlace al ltimo resultado
                /*
                itemStyleClass = "r01NavBarCtrlItem r01NavBarLast";
                //itemText = ">>";
                itemText = "&nbsp;&nbsp;&nbsp;&nbsp;";
                itemAlt = R01MUtils.getLiteral(R01MConstants.API_APPCODE,"searchEngineResources",lang,"navegaBarra.ultima");//"ltima Pgina";
                itemURL += R01MSearchFormatterURLHelpper.composeLastPageURL(sourceOid,currItem.getPageNum());
                */
            }

            // ---> Ver si hay que incluir los ... que dan acceso al bloque anterior de la barra
            if (!prevPagesBlockMarkIncluded && currItem == firstPageItem
             && currItem.getPageNum() > navBar.getNavBarBlockSize()) {
                //sb.append("\t\t\t\t<li class=\"r01NavBarItem\">...</li>\r\n");
                prevPagesBlockMarkIncluded = true;
            }

            // ---> Elemento de la barra
            itemURL.append("#");
            itemURL.append(sourceOid); // Poner un anchor para que se haga scroll automticamente
            sb.append("\t\t\t\t<li class=\"");sb.append(itemStyleClass);sb.append("\">");
            if (currItem.getPageNum() != navBar.getCurrentPage()) {
                sb.append("<a href=\"");
                sb.append(StringEscapeUtils.escapeHtml(itemURL.toString()));
                sb.append("\" title=\"");
                sb.append(itemAlt);
                //el atributo rel="nofollow" permite que el boot de Google no contine explorando los enlaces, de momento no se pone
                //sb.append("\" rel=\"nofollow\">");
                sb.append("\">");
                sb.append(itemText);
                sb.append("</a>");
            } else {
                sb.append("<b>");sb.append(itemText);sb.append("</b>");    // Es la pgina actual (no lleva enlace a ningun sitio)
            }
            sb.append("</li>\r\n");

            // ---> Ver si hay que incluir los ... que dan acceso al bloque posterior de la barra
            if (!nextPagesBlockMarkIncluded && currItem == lastPageItem
             && currItem.getPageNum() < navBar.getTotalNumberOfPages()) {
                //sb.append("\t\t\t\t<li class=\"r01NavBarItem\">...</li>\r\n");
                nextPagesBlockMarkIncluded = true;
            }
        } while(it.hasNext());

        sb.append("\t\t\t</ul>\r\n");

        return sb;
    }
}
