<%@ page language="java" import="java.util.ResourceBundle" pageEncoding="ISO-8859-1"%>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/tld/struts-logic.tld" prefix="logic" %>
<%@ taglib uri="/WEB-INF/tld/struts-bean.tld" prefix="bean" %>
<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="s12.util.S12Utils" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%@ page import="s12.util.S12AppConfig" %>

<%
//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
String language = S12Utils.idiomaValido(request.getParameter("lang"));
if ( language == null ) {
	language = S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
}
if ( language == null ) {
	language = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
}
if ( language == null ) {
	language = "es"; // Castellano por defecto cuando no se ha obtenido valor
}

ResourceBundle bundle;
bundle = S12Utils.obtenerBundle(request.getParameter("lang"), "s12ProgrExperienciales");

Q70ListenerUtils.updateLanguage(request,language); // Fija el idioma para los html:message
String staticImages = Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO");

String action = "";
if(!S12AppConfig.getInstance().getValue("cssIncluded").equals("OK")){
	action = "/aa30-11112/" + StringEscapeUtils.escapeHtml(language) + "/s12PortalWar/s12ProgramasExperienciales";
}else{
	action = "/s12PortalWar/s12ProgramasExperienciales";
}

String capitalSelect = request.getParameter("capital");
String diasSelect = request.getParameter("dias");
String viajarConSelect = request.getParameter("viajarCon");
String interesSelect = request.getParameter("interes");

String original = "";
if (request.getParameter("original")!=null){
	original = request.getParameter("original");
}

boolean noResultados = false;
if (request.getAttribute("noResultados")!=null){
	noResultados = true;
}
%>


<form name="formLogin" id="formLogin" action="<%=action%>" method="get">
	<div id="s12CuadroBuscadorPex" class="s12CuadroBuscador s12CuadroBuscadorProgExperienciales">
		<input type="hidden" name="lang" id="lang" value="<%=StringEscapeUtils.escapeHtml(language) %>">
		<input type="hidden" name="paginaFrom" id="paginaFrom" value="subHomeCapitalesMedida">
		<input type="hidden" name="portal" id="portal" value="aa30">
        <fieldset class="s12Tabla">
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.capital"/></label>
				<select name="capital" id="capital" class="s12Combo">
					<option value="4800200001"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.capital_48"/></option>
					<option value="2000690005"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.capital_20"/></option>
					<option value="0100590063"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.capital_01"/></option>
				</select>
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.dias"/></label>
				<select name="dias" id="dias" class="s12Combo">
					<option value="4"><html:message i18nKey="s12ProgrExperienciales" key="dias.cuatro"/></option>
					<option value="3"><html:message i18nKey="s12ProgrExperienciales" key="dias.tres"/></option>
					<option value="2"><html:message i18nKey="s12ProgrExperienciales" key="dias.dos"/></option>
					<option value="1"><html:message i18nKey="s12ProgrExperienciales" key="dias.uno"/></option>
				</select>
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.viajarCon"/></label>
				<select name="viajarCon" id="viajarCon" class="s12Combo">
					<option value="0"></option>
					<option value="1"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.viajarCon_1"/></option>
					<option value="2"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.viajarCon_2"/></option>
					<option value="3"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.viajarCon_3"/></option>
				</select>
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.intereses"/></label>
				<select name="interes" id="interes" class="s12Combo">
					<option value="0"></option>
					<option value="1"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.intereses_1"/></option>
					<option value="2"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.intereses_2"/></option>
					<option value="3"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.intereses_3"/></option>
					<option value="4"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.intereses_4"/></option>
					<option value="5"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.intereses_5"/></option>
					<option value="6"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.intereses_6"/></option>
				</select>
			</div>
			<div class="s12_checkgroup">
				<div class="s12_check">
					<input type="checkbox" class="s12Checkbox" name="original" id="original">
					<label for="original"><html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.original"/></label>
				</div>
			</div>
			<div class="s12_Boton">
				<input type="submit" value="<html:message i18nKey="s12ProgrExperienciales" key="progrExperienciales.buscar"/>" />
			</div>
		</fieldset>
	</div>
</form>

<script>
	for (var i=1; i<document.formLogin.capital.length; i++) {
		if ('<%=StringEscapeUtils.escapeJavaScript(capitalSelect) %>' == document.formLogin.capital.options[i].value){
			document.formLogin.capital.options[i].selected = 'true';
		}
	}

	for (var i=1; i<document.formLogin.dias.length; i++) {
		if ('<%=StringEscapeUtils.escapeJavaScript(diasSelect) %>' == document.formLogin.dias.options[i].value){
			document.formLogin.dias.options[i].selected = 'true';
		}
	}

	for (var i=1; i<document.formLogin.viajarCon.length; i++) {
		if ('<%=StringEscapeUtils.escapeJavaScript(viajarConSelect) %>' == document.formLogin.viajarCon.options[i].value){
			document.formLogin.viajarCon.options[i].selected = 'true';
		}
	}

	for (var i=1; i<document.formLogin.interes.length; i++) {
		if ('<%=StringEscapeUtils.escapeJavaScript(interesSelect) %>' == document.formLogin.interes.options[i].value){
			document.formLogin.interes.options[i].selected = 'true';
		}
	}

	if ('<%=StringEscapeUtils.escapeJavaScript(original) %>'){
		document.formLogin.original.checked = 'checked';
	}


	if(<%=noResultados%>){
		alert('<%=bundle.getString("progrExperienciales.noResultados")%>');
	}
</script>