<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MQueryObject" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData" %>
<%@ page import="com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences" %>
<%@ page import="com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants" %>
<%@ page import="com.ejie.r01m.objects.searchengine.session.R01MSearchSession" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants" %>
<%@ page import="s12.constantes.S12Constantes" %>
<%@ page import="s12.util.S12Utils"%>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>

<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n"%>

<%@ taglib uri="/WEB-INF/tld/r01mSearchEngineTags.tld" prefix="r01mTags" %>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>

<%
	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String language = S12Utils.idiomaValido(request.getParameter("r01kLang"));
	if ( language == null ) {
		language = S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( language == null ) {
		language = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	if ( language == null ) {
		language = "es"; // Castellano por defecto cuando no se ha obtenido valor
	}

	Q70ListenerUtils.updateLanguage(request,language); // Fija el idioma para los html:message
	String staticPath = Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO");

	String tituloOferta = Q70GestorMensajesi18n.getSingleton().getMessage("s12Buscadores","m1.ofertas",StringEscapeUtils.escapeHtml(language),null);
	String rssPath = Q70ListenerUtils.getApplicationProperty("RSS_PATH");
	rssPath = rssPath.replaceAll("XX##XX",StringEscapeUtils.escapeHtml(language)).replaceFirst("XX!!XX",tituloOferta);

	String s12CalendarioImg = staticPath + "/images/aa30-calendar-azul.png";
	String s12CalendarIdiomaJS = staticPath+"/scripts/lang/aa30Calendar-"+StringEscapeUtils.escapeHtml(language)+".js";
	
  //tipo recurso
  	String eventType = request.getParameter(S12Constantes.SF_EVENT_TYPE) != null ? request.getParameter(S12Constantes.SF_EVENT_TYPE) : "";
  	// Se obtiene la fechaDesde de la request
  	String fechaDesde = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1) != null ? request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1) : "";
  	// Se obtiene la fechaHasta de la request
  	String fechaHasta = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2) != null ? request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2) : "";
  	
  //coordenadas de posicin
    String distanciaMetros = "";
    String distanciaKm = "";
    String latitud = "";
   	String longitud = "";
   	
  //coordenadas de posicin
    if (request.getParameter(S12Constantes.SF_DISTANCIA_KM) != null) distanciaKm = request.getParameter(S12Constantes.SF_DISTANCIA_KM);
    if (request.getParameter(S12Constantes.SF_DISTANCIA_METROS) != null) distanciaMetros = request.getParameter(S12Constantes.SF_DISTANCIA_METROS);
    if (request.getParameter(S12Constantes.SF_LATITUD) != null) latitud = request.getParameter(S12Constantes.SF_LATITUD);
    if (request.getParameter(S12Constantes.SF_LONGITUD) != null) longitud = request.getParameter(S12Constantes.SF_LONGITUD);
    //Tipo de oferta (hotel o resto)
    if (request.getParameter(S12Constantes.SF_EVENT_TYPE) != null) eventType = request.getParameter(S12Constantes.SF_EVENT_TYPE);

%>



		


<form name="busqueda" id="busqueda" method="post" action="buscadorM2.jsp<%= S12Constantes.ANCLA_BUSCADOR %>">
	<div class="s12CuadroBuscador s12CuadroBuscadorM2">
		<input type="hidden" name="r01kLang" id="r01kLang" value="<%=StringEscapeUtils.escapeHtml(language) %>" />
		<input type="hidden" name="metodo" id="metodoBuscador"  value="buscadorM2_ofertas" />
		<input type="hidden" name="tipoRecurso" id="tipoRec" value="M2" />
		<input type="hidden" name="u_latitude" id="coordenadaLatitud" />
		<input type="hidden" name="u_longitude" id="coordenadaLongitud" />
		<input type="hidden" name="distancia_max" id="distanciaMetros" />
		<fieldset class="s12Tabla">
			<div class="s12_campo">
				<label><html:message i18nKey="s12Buscadores" key="m1.fechaEventoIni"/></label>
				<input type="text" name="eventSearchDate1" id="eventSearchDate1" class="s12CampoFechaM1"/>
				<img src="<%=s12CalendarioImg%>" id="cal1" title="<html:message i18nKey="s12Buscadores" key="m1.titleCalendar"/>"
			     onmouseover="this.style.background='#d4d9b9';"   onmouseout="this.style.background=''"/>
			</div>
			<div class="s12_campo">
				<label><html:message i18nKey="s12Buscadores" key="m1.fechaEventoFin"/></label>
				<input type="text" name="eventSearchDate2" id="eventSearchDate2" class="s12CampoFechaM1"/>
				<img src="<%=s12CalendarioImg%>" id="cal2"  title="<html:message i18nKey="s12Buscadores" key="m1.titleCalendar"/>"
			     onmouseover="this.style.background='#d4d9b9';" onmouseout="this.style.background=''" />
			</div>
			<div class="s12_campo" id="divCampoDistancia">
				<label><html:message i18nKey="s12Buscadores" key="general.distancia"></html:message></label>
				<input type="range" name="distanciaKm" id="distanciaKm" min="0" max="200" value="0" disabled="disabled" />
				<div class="divValorDistancia ocultar" id="divValorDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.kmDeMi"></html:message></div>
				<div class="divValorDistancia ocultar" id="divCualquierDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.cualquier"></html:message></div>
				<div class="divValorDistancia" id="divActiveGeolocalizacion"><html:message i18nKey="s12Buscadores" key="general.distancia.activeGeolocalizacion"></html:message></div>
			</div>
			<div class="s12_campo s12_select s12_clase_oferta">
				<label><html:message i18nKey="s12Buscadores" key="m2.tituloCombo"/></label>
				<select name="eventType" id="eventType"	class="s12Combo">
					<option value=""></option>
					<option value="0100"><html:message i18nKey="s12Buscadores" key="m2.alojamientos"/></option>
					<option value="9999"><html:message i18nKey="s12Buscadores" key="m1.otros"/></option>
				</select>
			</div>
			<div class="s12_Boton">				
				<input type="button" id="btnBuscarMapa" onclick="verMapa()" value="<html:message i18nKey="s12Buscadores" key="general.mapa"/>" />
				<input type="button" id="btnAjax" value="<html:message i18nKey="s12Buscadores" key="general.buscar"/>" data-onclick="validarFormulario();" />				
			</div>
		</fieldset>
	</div>
</form>

<script type="text/javascript" src="<%=staticPath%>/scripts/validaciones.js"></script>
<script type="text/javascript" src="<%=s12CalendarIdiomaJS%>"></script>

<div class="s12_BotonesMapa">
	<form name="mapa" id="mapa" method="get" action="/aa30-15820/<%=StringEscapeUtils.escapeHtml(language)%>/s12GoogleMapsWar/gMapsJSP/VisorGeoEuskadi.jsp" target="ifrMapa">
		<input type="hidden" name="lang" id="lang" value="<%=StringEscapeUtils.escapeHtml(language) %>" />
		<input type="hidden" name="query" id="query" />
	</form>
	
	<a href="javascript:verListado()" id="verListado" style="display: none"><span><html:message i18nKey="s12Buscadores" key="general.listado"/></span></a>
</div>

<!-- Recomendacin: Pasar el objeto query UNICAMENTE en la primera llamada,
     en el resto (paginaciones) no enviarlo (enviar null)
     #tampoco pasa nada si se enva# -->
<div id="s12_CapaResultados">     
	<div class="s12_titulo_resultado"><html:message i18nKey="s12Buscadores" key="general.resultadoBusqueda"/></div>
	<iframe name="ifrMapa" id="ifrMapa" frameborder="0" class="s12IfrMapa"></iframe>
	
</div>

<div class="s12_BotonesMapa botonRSS">
	<a href="<%=rssPath%>" target="_blank" id="rssOfertas" class="s12_ofertas_rss"><span><html:message i18nKey="s12Buscadores" key="ofertas.rss"/></span></a>
</div>

<script>
	// Precarga de datos del filtro
	$("#eventSearchDate1").attr("value", "<%= StringEscapeUtils.escapeJavaScript(fechaDesde) %>" || "");
	$("#eventSearchDate2").attr("value", "<%= StringEscapeUtils.escapeJavaScript(fechaHasta) %>" || "");
	$("#eventType").attr("value", "<%= StringEscapeUtils.escapeJavaScript(eventType) %>" || "");
	
	$("#distanciaMetros").val("<%=StringEscapeUtils.escapeJavaScript(distanciaMetros)%>");
	var distanciakilo = "<%=StringEscapeUtils.escapeJavaScript(distanciaKm)%>";
	if (distanciakilo != "") $("#distanciaKm").val(distanciakilo);
	$("#coordenadaLatitud").val("<%=StringEscapeUtils.escapeJavaScript(latitud)%>");
	$("#coordenadaLongitud").val("<%=StringEscapeUtils.escapeJavaScript(longitud)%>");
  

	function validarFormulario(){
		if ((document.busqueda.eventSearchDate1.value && document.busqueda.eventSearchDate2.value == '')
				|| (document.busqueda.eventSearchDate1.value == '' && document.busqueda.eventSearchDate2.value)){
			alert('<html:message i18nKey="s12Buscadores" key="agenda.obligatorioFechas"/>');
			return false;
		}else{
			//cuando las 2 fechas tienen valor
			if (document.busqueda.eventSearchDate1.value && document.busqueda.eventSearchDate2.value){
				//obtenemos el valor y el formato de las fechas
				var fechaDesde = document.busqueda.eventSearchDate1.value;
				var fechaHasta = document.busqueda.eventSearchDate2.value;
				var formatoFecha = fncGetFormatoFecha('<%=StringEscapeUtils.escapeJavaScript(language)%>');

				//comprobamos si las fechas tienen el formato incorrecto(segn el idioma)
				if (fncValidarFecha(fechaDesde,formatoFecha)
					&& fncValidarFecha(fechaHasta,formatoFecha)){
					alert('<html:message i18nKey="s12Buscadores" key="agenda.fechasFormatoIncorrecto"/>');
					return false;
				}else if (fncValidarFecha(fechaDesde,formatoFecha)){
					alert('<html:message i18nKey="s12Buscadores" key="agenda.fechaDesdeIncorrecto"/>');
					return false;
				}else if (fncValidarFecha(fechaHasta,formatoFecha)){
					alert('<html:message i18nKey="s12Buscadores" key="agenda.fechaHastaIncorrecto"/>');
					return false;
				}else{
					//si estan bien los formatos, comprobamos que sean fechas coherentes
					var dateDesde = getObjetoDate(fechaDesde,formatoFecha);
					var dateHasta = getObjetoDate(fechaHasta,formatoFecha);

					//si las fechas son coherentes, buscamos
					if (dateDesde > dateHasta){
						alert('<html:message i18nKey="s12Buscadores" key="agenda.fechasMal"/>');
						return false;
					}else{
						//document.busqueda.submit();
						return true;												
					}
				}

			//para cuando no estan rellenas ninguna de las 2 fechas, buscamos
			}else{
				//document.busqueda.submit();
				return true;
			}
		}
	}

</script>
<script type="text/javascript" src="<%=s12CalendarIdiomaJS%>"></script>
