<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MQueryObject" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData" %>
<%@ page import="com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants" %>

<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="s12.constantes.S12Constantes"%>
<%@ page import="s12.util.S12Utils"%>
<%@page import="org.apache.commons.lang.StringEscapeUtils"%>

<%@ taglib uri="/WEB-INF/tld/r01mSearchEngineTags.tld" prefix="r01mTags" %>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>

<%
	
	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String language = S12Utils.idiomaValido(request.getParameter("r01kLang"));
	if ( language == null ) {
		language = S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( language == null ) {
		language = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	if ( language == null ) {
		language = "es"; // Castellano por defecto cuando no se ha obtenido valor
	}

	Q70ListenerUtils.updateLanguage(request,language); // Fija el idioma para los html:message
	String staticPath = Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO");

	String s12CalendarioImg = staticPath + "/images/aa30-calendar.png";
	String s12CalendarIdiomaJS = staticPath+"/scripts/lang/aa30Calendar-"+StringEscapeUtils.escapeHtml(language)+".js";
	
	//Fechas para la query inicial, se buscan los eventos comprendidos dentro del da en el que estamos y los 15 siguientes

	//Obtengo la fecha actual para que haga de Fecha Inicio
	Calendar ahoraCal = Calendar.getInstance();
	String fechaInicioBusqueda = S12Utils.fechaFormatoYYYYMMDD(ahoraCal);

	//Obtengo la fecha de fin (sumo 15 das)
	Calendar quincena = Calendar.getInstance();
	quincena.add(Calendar.DATE, 15);
	String fechaFinBusqueda  = S12Utils.fechaFormatoYYYYMMDD(quincena);

	String actionForm = "buscadorM1.jsp" + S12Constantes.ANCLA_BUSCADOR;
	
	String listaResultados=request.getParameter("listaResultados");
	
	// Se obtiene el nombre del documento de la request
    String documentName = "";
    // Se obtiene la zona de la request
    String zona = "";
    // Se obtiene el eventType de la request
    String eventType = "";
		// Se obtiene el eventTown de la request
    String eventTownCode = "";
    String eventTownName = "";
	// Se obtiene la fechaDesde de la request
	String fechaDesde = "";
    // Se obtiene la fechaHasta de la request
    String fechaHasta = "";
    // Se obtiene el localityCode de la request
	// Viene de una ficha de recurso con localidad mltiple
    String localityCodeMultiple = "";
    String localityCode = "";
    String locality = "";
    String municipalitylocality = "";
    
  //coordenadas de posicin
    String distanciaMetros = "";
    String distanciaKm = "";
    String latitud = "";
   	String longitud = "";
	
	if (listaResultados == null || listaResultados.equals("S")){
		// Se obtiene el nombre del documento de la request
	    documentName = request.getParameter(S12Constantes.SF_DOCUMENT_NAME) != null ? request.getParameter(S12Constantes.SF_DOCUMENT_NAME) : "";
	    // Se obtiene la zona de la request
	    zona = request.getParameter(S12Constantes.SF_MARKS) != null ? request.getParameter(S12Constantes.SF_MARKS) : "";
	    // Se obtiene el eventType de la request
	    eventType = request.getParameter(S12Constantes.SF_EVENT_TYPE) != null ? request.getParameter(S12Constantes.SF_EVENT_TYPE) : "";
 		// Se obtiene el eventTown de la request
	    eventTownCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE) != null ? request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE) : "";
	    eventTownName = request.getParameter(S12Constantes.SF_MUNICIPALITY) != null ? request.getParameter(S12Constantes.SF_MUNICIPALITY) : "";
		// Se obtiene la fechaDesde de la request
		fechaDesde = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1) != null ? request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1) : "";
	    // Se obtiene la fechaHasta de la request
	    fechaHasta = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2) != null ? request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2) : "";
	    // Se obtiene el localityCode de la request
    	// Viene de una ficha de recurso con localidad mltiple
	    localityCodeMultiple = request.getParameter(S12Constantes.SF_LOCALITY_CODE_MULTIPLE) != null ? request.getParameter(S12Constantes.SF_LOCALITY_CODE_MULTIPLE) : "";
	    localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE) != null ? request.getParameter(S12Constantes.SF_LOCALITY_CODE) : "";
	    locality = request.getParameter(S12Constantes.SF_LOCALITY) != null ? request.getParameter(S12Constantes.SF_LOCALITY) : "";
	    municipalitylocality = request.getParameter(S12Constantes.SF_LOCALITYMUNICIPALITY) != null ? request.getParameter(S12Constantes.SF_LOCALITYMUNICIPALITY) : "";
	    
	  //coordenadas de posicin
	    if (request.getParameter(S12Constantes.SF_DISTANCIA_KM) != null) distanciaKm = request.getParameter(S12Constantes.SF_DISTANCIA_KM);
	    if (request.getParameter(S12Constantes.SF_DISTANCIA_METROS) != null) distanciaMetros = request.getParameter(S12Constantes.SF_DISTANCIA_METROS);
	    if (request.getParameter(S12Constantes.SF_LATITUD) != null) latitud = request.getParameter(S12Constantes.SF_LATITUD);
	    if (request.getParameter(S12Constantes.SF_LONGITUD) != null) longitud = request.getParameter(S12Constantes.SF_LONGITUD);
	}else{
		actionForm = "/aa30-20178x/" + StringEscapeUtils.escapeHtml(language) + "/s12PortalWar/buscadoresJSP/buscadorM1.jsp" + S12Constantes.ANCLA_BUSCADOR;
	}
	
%>


<form name="busqueda" id="busqueda" method="post" action="<%= actionForm %>">
	<div class="s12CuadroBuscador s12CuadroBuscadorM1">
		<input type="hidden" name="r01kLang" id="r01kLang" value="<%=StringEscapeUtils.escapeHtml(language) %>" />
		<input type="hidden" name="municipalityCode" id="municipalityCode" />
		<input type="hidden" name="templateType" id="templateType" value="M1"/>
		<input type="hidden" name="localityCodeMultiple" id="localityCodeMultiple" />
		<input type="hidden" name="localityCode" id="localityCode" />
		<input type="hidden" name="metodo" id="metodoBuscador" value="buscadorM1_agenda" />
		<input type="hidden" name="tipoRecurso" id="tipoRec" value="M1" />
		<input type="hidden" name="u_latitude" id="coordenadaLatitud" />
		<input type="hidden" name="u_longitude" id="coordenadaLongitud" />
		<input type="hidden" name="distancia_max" id="distanciaMetros" />
		<fieldset class="s12Tabla">
			<div class="s12_campo">
				<label><html:message i18nKey="s12Buscadores" key="general.nombre"/></label>
				<input type="text" name="documentName" id="documentName" class="s12CampoTexto"/>
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="general.zona"/></label>
				<select name="marks" id="marks" class="s12Combo">
						<option value=""></option>
						<option value="1"><html:message i18nKey="s12Buscadores" key="zona.costaVasca"/></option>
						<option value="2"><html:message i18nKey="s12Buscadores" key="zona.verdeNatural"/></option>
						<option value="3"><html:message i18nKey="s12Buscadores" key="zona.riojaAlavesa"/></option>
						<option value="4"><html:message i18nKey="s12Buscadores" key="zona.bilbao"/></option>
						<option value="5"><html:message i18nKey="s12Buscadores" key="zona.donosti"/></option>
						<option value="6"><html:message i18nKey="s12Buscadores" key="zona.gasteiz"/></option>
				</select>
			</div>
			<div class="s12_campo">
				<label><html:message i18nKey="s12Buscadores" key="general.localidad"/> (<html:message i18nKey="s12Buscadores" key="general.municipio"/>)</label>
				<input type="text" name="municipalitylocality" id="municipalitylocality" class="s12CampoTexto"/>
				<input type="hidden" name="municipality" id="municipality" />
				<input type="hidden" name="locality" id="locality" />
			</div>
			<div class="s12_campo">
				<label><html:message i18nKey="s12Buscadores" key="m1.fechaEventoIni"/></label>
				<input type="text" name="eventSearchDate1" id="eventSearchDate1" class="s12CampoFechaM1"/>
				<img src="<%=s12CalendarioImg%>" id="cal1" title="<html:message i18nKey="s12Buscadores" key="m1.titleCalendar"/>"/>
			</div>
			<div class="s12_campo">
				<label><html:message i18nKey="s12Buscadores" key="m1.fechaEventoFin"/></label>
				<input type="text" name="eventSearchDate2" id="eventSearchDate2" class="s12CampoFechaM1"/>
				<img src="<%=s12CalendarioImg%>" id="cal2"  title="<html:message i18nKey="s12Buscadores" key="m1.titleCalendar"/>"/>
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="general.tipo"/></label>
				<select name="eventType" id="eventType" class="s12Select s12Combo">
					<option value="">&nbsp;</option>
					<%if (language.equals(S12Constantes.IDIOMA_ES)){ %>
						<option value="0007"><html:message i18nKey="s12Buscadores" key="m1.familiares"/></option>
						<option value="0010"><html:message i18nKey="s12Buscadores" key="m1.conciertos"/></option>
						<option value="0003"><html:message i18nKey="s12Buscadores" key="m1.danza"/></option>
						<option value="0006"><html:message i18nKey="s12Buscadores" key="m1.deportes"/></option>
						<option value="0011"><html:message i18nKey="s12Buscadores" key="m1.eventosGastronomicos"/></option>
						<option value="0002"><html:message i18nKey="s12Buscadores" key="m1.exposiciones"/></option>
						<option value="0008"><html:message i18nKey="s12Buscadores" key="m1.festivales"/></option>
						<option value="0004"><html:message i18nKey="s12Buscadores" key="m1.fiestas"/></option>
						<option value="0005"><html:message i18nKey="s12Buscadores" key="m1.congresos"/></option>
						<option value="0009"><html:message i18nKey="s12Buscadores" key="m1.visitasGuiadas"/></option>
					<%}else if (language.equals(S12Constantes.IDIOMA_EU)){ %>
						<option value="0009"><html:message i18nKey="s12Buscadores" key="m1.visitasGuiadas"/></option>
						<option value="0003"><html:message i18nKey="s12Buscadores" key="m1.danza"/></option>
						<option value="0011"><html:message i18nKey="s12Buscadores" key="m1.eventosGastronomicos"/></option>
						<option value="0002"><html:message i18nKey="s12Buscadores" key="m1.exposiciones"/></option>
						<option value="0007"><html:message i18nKey="s12Buscadores" key="m1.familiares"/></option>
						<option value="0004"><html:message i18nKey="s12Buscadores" key="m1.fiestas"/></option>
						<option value="0008"><html:message i18nKey="s12Buscadores" key="m1.festivales"/></option>
						<option value="0005"><html:message i18nKey="s12Buscadores" key="m1.congresos"/></option>
						<option value="0006"><html:message i18nKey="s12Buscadores" key="m1.deportes"/></option>
						<option value="0010"><html:message i18nKey="s12Buscadores" key="m1.conciertos"/></option>
					<%}else if (language.equals(S12Constantes.IDIOMA_EN)){ %>
						<option value="0010"><html:message i18nKey="s12Buscadores" key="m1.conciertos"/></option>
						<option value="0005"><html:message i18nKey="s12Buscadores" key="m1.congresos"/></option>
						<option value="0011"><html:message i18nKey="s12Buscadores" key="m1.eventosGastronomicos"/></option>
						<option value="0003"><html:message i18nKey="s12Buscadores" key="m1.danza"/></option>
						<option value="0002"><html:message i18nKey="s12Buscadores" key="m1.exposiciones"/></option>
						<option value="0007"><html:message i18nKey="s12Buscadores" key="m1.familiares"/></option>
						<option value="0004"><html:message i18nKey="s12Buscadores" key="m1.fiestas"/></option>
						<option value="0008"><html:message i18nKey="s12Buscadores" key="m1.festivales"/></option>
						<option value="0006"><html:message i18nKey="s12Buscadores" key="m1.deportes"/></option>
						<option value="0009"><html:message i18nKey="s12Buscadores" key="m1.visitasGuiadas"/></option>
					<%}else if (language.equals(S12Constantes.IDIOMA_FR)){ %>
						<option value="0007"><html:message i18nKey="s12Buscadores" key="m1.familiares"/></option>
						<option value="0010"><html:message i18nKey="s12Buscadores" key="m1.conciertos"/></option>
						<option value="0003"><html:message i18nKey="s12Buscadores" key="m1.danza"/></option>
						<option value="0011"><html:message i18nKey="s12Buscadores" key="m1.eventosGastronomicos"/></option>
						<option value="0002"><html:message i18nKey="s12Buscadores" key="m1.exposiciones"/></option>
						<option value="0008"><html:message i18nKey="s12Buscadores" key="m1.festivales"/></option>
						<option value="0004"><html:message i18nKey="s12Buscadores" key="m1.fiestas"/></option>
						<option value="0005"><html:message i18nKey="s12Buscadores" key="m1.congresos"/></option>
						<option value="0006"><html:message i18nKey="s12Buscadores" key="m1.deportes"/></option>
						<option value="0009"><html:message i18nKey="s12Buscadores" key="m1.visitasGuiadas"/></option>
					<%}else if (language.equals(S12Constantes.IDIOMA_DE)){ %>
						<option value="0002"><html:message i18nKey="s12Buscadores" key="m1.exposiciones"/></option>
						<option value="0009"><html:message i18nKey="s12Buscadores" key="m1.visitasGuiadas"/></option>
						<option value="0007"><html:message i18nKey="s12Buscadores" key="m1.familiares"/></option>
						<option value="0004"><html:message i18nKey="s12Buscadores" key="m1.fiestas"/></option>
						<option value="0008"><html:message i18nKey="s12Buscadores" key="m1.festivales"/></option>
						<option value="0010"><html:message i18nKey="s12Buscadores" key="m1.conciertos"/></option>
						<option value="0011"><html:message i18nKey="s12Buscadores" key="m1.eventosGastronomicos"/></option>
						<option value="0006"><html:message i18nKey="s12Buscadores" key="m1.deportes"/></option>
						<option value="0005"><html:message i18nKey="s12Buscadores" key="m1.congresos"/></option>
						<option value="0003"><html:message i18nKey="s12Buscadores" key="m1.danza"/></option>
					<%}%>
					<option  value="0012"><html:message i18nKey="s12Buscadores" key="m1.otros"/></option>
				</select>
			</div>
			<div class="s12_campo" id="divCampoDistancia">
				<label><html:message i18nKey="s12Buscadores" key="general.distancia"></html:message></label>
				<input type="range" name="distanciaKm" id="distanciaKm" min="0" max="200" value="0" disabled="disabled" />
				<div class="divValorDistancia ocultar" id="divValorDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.kmDeMi"></html:message></div>
				<div class="divValorDistancia ocultar" id="divCualquierDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.cualquier"></html:message></div>
				<div class="divValorDistancia" id="divActiveGeolocalizacion"><html:message i18nKey="s12Buscadores" key="general.distancia.activeGeolocalizacion"></html:message></div>
			</div>
			<div class="s12_Boton">
				<%
					if (listaResultados == null || listaResultados.equals("S")){
				%>
					<input type="button" id="btnAjax" value="<html:message i18nKey="s12Buscadores" key="general.buscar"/>" data-onclick="validarFormulario(false);" />
				<%
					}else{
				%>
					<input type="button" value="<html:message i18nKey="s12Buscadores" key="general.buscar" />" onclick="validarFormulario(true);" />
				<%
					}
				%>
			</div>
		</fieldset>
	</div>
</form>


<%
	if (listaResultados == null || listaResultados.equals("S")){
%>
<div id="s12_CapaResultados">
	<div class="s12_titulo_resultado"><html:message i18nKey="s12Buscadores" key="general.resultadoBusqueda"/></div>	
</div>
<%
	}
%>

<!-- librera para cargar las validaciones -->
<script type="text/javascript" src="<%=staticPath%>/scripts/validaciones.js"></script>

<script>
	// Precarga de datos del filtro
	$("#documentName").attr("value", "<%=StringEscapeUtils.escapeJavaScript(documentName) %>");
	$("#marks").attr("value", "<%=StringEscapeUtils.escapeJavaScript(zona)%>");
	$("#municipalityCode").attr("value", "<%=StringEscapeUtils.escapeJavaScript(eventTownCode) %>");
	$("#municipality").attr("value", "<%=StringEscapeUtils.escapeJavaScript(eventTownName) %>");
	$("#eventType").attr("value", "<%=StringEscapeUtils.escapeJavaScript(eventType)%>");
	$("#eventSearchDate1").attr("value", "<%=StringEscapeUtils.escapeJavaScript(fechaDesde)%>");
	$("#eventSearchDate2").attr("value", "<%=StringEscapeUtils.escapeJavaScript(fechaHasta)%>");
	<%if(localityCodeMultiple != null){%>
		$("#localityCodeMultiple").attr("value", "<%=StringEscapeUtils.escapeJavaScript(localityCodeMultiple) %>");
	<%}else{%>
		$("#localityCodeMultiple").attr("value", "");
	<%}%>
	$("#localityCode").attr("value", "<%=StringEscapeUtils.escapeJavaScript(localityCode) %>");
	$("#locality").attr("value", "<%=StringEscapeUtils.escapeJavaScript(locality) %>");
	$("#municipalitylocality").val("<%=StringEscapeUtils.escapeJavaScript(request.getParameter("municipalitylocality") != null ? request.getParameter("municipalitylocality") : "" )%>");
	
	$("#distanciaMetros").val("<%=StringEscapeUtils.escapeJavaScript(distanciaMetros)%>");
	var distanciakilo = "<%=StringEscapeUtils.escapeJavaScript(distanciaKm)%>";
	if (distanciakilo != "") $("#distanciaKm").val(distanciakilo);
	$("#coordenadaLatitud").val("<%=StringEscapeUtils.escapeJavaScript(latitud)%>");
	$("#coordenadaLongitud").val("<%=StringEscapeUtils.escapeJavaScript(longitud)%>");

	function validarFormulario(hacerSubmit){
		//para cuando solo esta rellena una de las dos fechas
		if ((document.busqueda.eventSearchDate1.value && document.busqueda.eventSearchDate2.value == '')
					|| (document.busqueda.eventSearchDate1.value == '' && document.busqueda.eventSearchDate2.value)){
				alert('<html:message i18nKey="s12Buscadores" key="agenda.obligatorioFechas"/>');
				return false;
		}else{
			//cuando las 2 fechas tienen valor
			if (document.busqueda.eventSearchDate1.value && document.busqueda.eventSearchDate2.value){
				//obtenemos el valor y el formato de las fechas
				var fechaDesde = document.busqueda.eventSearchDate1.value;
				var fechaHasta = document.busqueda.eventSearchDate2.value;
				var formatoFecha = fncGetFormatoFecha('<%=StringEscapeUtils.escapeJavaScript(language)%>');

				//comprobamos si las fechas tienen el formato incorrecto(segn el idioma)
				if (fncValidarFecha(fechaDesde,formatoFecha)
					&& fncValidarFecha(fechaHasta,formatoFecha)){
					alert('<html:message i18nKey="s12Buscadores" key="agenda.fechasFormatoIncorrecto"/>');
					return false;
				}else if (fncValidarFecha(fechaDesde,formatoFecha)){
					alert('<html:message i18nKey="s12Buscadores" key="agenda.fechaDesdeIncorrecto"/>');
					return false;
				}else if (fncValidarFecha(fechaHasta,formatoFecha)){
					alert('<html:message i18nKey="s12Buscadores" key="agenda.fechaHastaIncorrecto"/>');
					return false;
				}else{
					//si estan bien los formatos, comprobamos que sean fechas coherentes
					var dateDesde = getObjetoDate(fechaDesde,formatoFecha);
					var dateHasta = getObjetoDate(fechaHasta,formatoFecha);

					//si las fechas son coherentes, buscamos
					if (dateDesde > dateHasta){
						alert('<html:message i18nKey="s12Buscadores" key="agenda.fechasMal"/>');
						return false;
					}else{
						if (hacerSubmit){
							document.busqueda.submit();
						}else{
							return true;
						}
					}
				}

			//para cuando no estan rellanas ninguna de las 2 fechas, buscamos
			}else{
				if (hacerSubmit){
					document.busqueda.submit();
				}else{
					return true;
				}
			}
		}
	}
	<%	
	  if (listaResultados != null && listaResultados.equals("N")){
	%>	  
		    
		    
			//Cogemos la fecha actual en el primer campo de la fecha
			var mydate=new Date();
			var year=mydate.getYear();
			if (year < 1000){
				year+=1900;
			}
			var month=mydate.getMonth()+1;
			if(month<10){
				month= '0'+month;
			}
			var day=mydate.getDate();
			if (day<10){
				day='0'+day;
			}


			//Cogemos la fecha quince das despues de la actual
		  	var milisegundos=parseInt(15*24*60*60*1000);
			var tiempo=mydate.getTime();
			var total=mydate.setTime(parseInt(tiempo+milisegundos));
			var dia=mydate.getDate();
			if (dia<10){
				dia='0'+dia;
			}
			var mes=mydate.getMonth()+1;
			if(mes<10){
				mes='0'+mes;
			}
			var anio=mydate.getYear();
			if (anio < 1000){
				anio+=1900;
			}

			//formato de las fechas, segn el idioma
			var fechaActual = '';
			var fechaQuinceDias = '';
			//han cambiado los formatos de fechas segn idioma, para el nuevo portal.
			if('<%=StringEscapeUtils.escapeJavaScript(language)%>' == '<%=S12Constantes.IDIOMA_ES%>' || 
				'<%=StringEscapeUtils.escapeJavaScript(language)%>' == '<%=S12Constantes.IDIOMA_FR%>'||
				'<%=StringEscapeUtils.escapeJavaScript(language)%>' == '<%=S12Constantes.IDIOMA_EN%>' ||
				'<%=StringEscapeUtils.escapeJavaScript(language)%>' == '<%=S12Constantes.IDIOMA_DE%>'){
				fechaActual = day+'/'+month+'/'+year;
				fechaQuinceDias = dia+'/'+mes+'/'+anio;
			}else if('<%=StringEscapeUtils.escapeJavaScript(language)%>' == '<%=S12Constantes.IDIOMA_EU%>'){
				fechaActual = year+'/'+month+'/'+day;
				fechaQuinceDias = anio+'/'+mes+'/'+dia;
			}

			document.getElementById('eventSearchDate1').value = fechaActual;
			document.getElementById('eventSearchDate2').value = fechaQuinceDias;
		    
	<%	    
	  }
	%>  

</script>
<script type="text/javascript" src="<%=s12CalendarIdiomaJS%>"></script>