<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MQueryObject" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData" %>
<%@ page import="com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences" %>
<%@ page import="com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants" %>
<%@ page import="com.ejie.r01m.objects.searchengine.session.R01MSearchSession" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants" %>
<%@ page import="s12.constantes.S12Constantes" %>
<%@ page import="s12.util.S12Utils" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>

<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>

<%@ taglib uri="/WEB-INF/tld/r01mSearchEngineTags.tld" prefix="r01mTags" %>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%
	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String language = S12Utils.idiomaValido(request.getParameter("r01kLang"));
	if ( language == null ) {
		language = S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( language == null ) {
		language = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	if ( language == null ) {
		language = "es"; // Castellano por defecto cuando no se ha obtenido valor
	}

	Q70ListenerUtils.updateLanguage(request,language); // Fija el idioma para los html:message
	String staticPath = Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO");

	// Se obtiene el sportType de la request
    String sportType = request.getParameter(S12Constantes.SF_SPORT_TYPE) != null ? request.getParameter(S12Constantes.SF_SPORT_TYPE) : "";
 	// Se obtiene el marks de la request
    String zona = request.getParameter(S12Constantes.SF_MARKS) != null ? request.getParameter(S12Constantes.SF_MARKS) : "";
    
  //coordenadas de posicin
    String distanciaMetros = "";
    String distanciaKm = "";
    String latitud = "";
   	String longitud = "";
   	
  //coordenadas de posicin
    if (request.getParameter(S12Constantes.SF_DISTANCIA_KM) != null) distanciaKm = request.getParameter(S12Constantes.SF_DISTANCIA_KM);
    if (request.getParameter(S12Constantes.SF_DISTANCIA_METROS) != null) distanciaMetros = request.getParameter(S12Constantes.SF_DISTANCIA_METROS);
    if (request.getParameter(S12Constantes.SF_LATITUD) != null) latitud = request.getParameter(S12Constantes.SF_LATITUD);
    if (request.getParameter(S12Constantes.SF_LONGITUD) != null) longitud = request.getParameter(S12Constantes.SF_LONGITUD);
%>


<div class="s12CuadroBuscador s12CuadroBuscadorI2">
	<form name="busqueda" id="busqueda" method="post" action="buscadorI2.jsp<%= S12Constantes.ANCLA_BUSCADOR %>">
		<input type="hidden" name="r01kLang" id="r01kLang" value="<%=StringEscapeUtils.escapeHtml(language) %>" />		
		<input type="hidden" name="metodo" id="metodoBuscador" value="buscadorI2_deportes" />
		<input type="hidden" name="tipoRecurso" id="tipoRec" value="I2" />
		<input type="hidden" name="u_latitude" id="coordenadaLatitud" />
		<input type="hidden" name="u_longitude" id="coordenadaLongitud" />
		<input type="hidden" name="distancia_max" id="distanciaMetros" />
		<fieldset class="s12Tabla">
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="general.zona"/></label>
				<select name="marks" id="marks" class="s12Combo">
					<option value="">&nbsp;</option>
					<option value="1"><html:message i18nKey="s12Buscadores" key="zona.costaVasca"/></option>
					<option value="2"><html:message i18nKey="s12Buscadores" key="zona.verdeNatural"/></option>
					<option value="3"><html:message i18nKey="s12Buscadores" key="zona.riojaAlavesa"/></option>
					<option value="4"><html:message i18nKey="s12Buscadores" key="zona.bilbao"/></option>
					<option value="5"><html:message i18nKey="s12Buscadores" key="zona.donosti"/></option>
					<option value="6"><html:message i18nKey="s12Buscadores" key="zona.gasteiz"/></option>
				</select>
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="general.tipo"/></label>
				<select name="sportType" id="sportType" class="s12Combo">
					<option value="">&nbsp;</option>
					<option value="1001"><html:message i18nKey="s12Buscador" key="instalciones.polideportivo"/></option>
					<option value="1002"><html:message i18nKey="s12Buscador" key="instalciones.piscinas"/></option>
					<option value="1003"><html:message i18nKey="s12Buscador" key="instalciones.campoGolf"/></option>
					<option value="1004"><html:message i18nKey="s12Buscador" key="instalciones.puertoDeportivo"/></option>
					<option value="1005"><html:message i18nKey="s12Buscador" key="instalciones.fronton"/></option>
					<option value="1006"><html:message i18nKey="s12Buscador" key="instalciones.pistaHielo"/></option>
					<option value="1007"><html:message i18nKey="s12Buscador" key="instalciones.clubNautico"/></option>
					<option value="1008"><html:message i18nKey="s12Buscador" key="instalciones.hipodromo"/></option>
					<option value="1009"><html:message i18nKey="s12Buscador" key="instalciones.estadio"/></option>
					<option value="1010"><html:message i18nKey="s12Buscador" key="instalciones.centrosBTT"/></option>
					<option value="1011"><html:message i18nKey="s12Buscador" key="instalciones.trailStation"/></option>
				</select>
			</div>
			<div class="s12_campo" id="divCampoDistancia">
				<label><html:message i18nKey="s12Buscadores" key="general.distancia"></html:message></label>
				<input type="range" name="distanciaKm" id="distanciaKm" min="0" max="200" value="0" disabled="disabled" />
				<div class="divValorDistancia ocultar" id="divValorDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.kmDeMi"></html:message></div>
				<div class="divValorDistancia ocultar" id="divCualquierDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.cualquier"></html:message></div>
				<div class="divValorDistancia" id="divActiveGeolocalizacion"><html:message i18nKey="s12Buscadores" key="general.distancia.activeGeolocalizacion"></html:message></div>
			</div>
			<div class="s12_Boton">
				<input type="button" id="btnBuscarMapa" onclick="verMapa()" value="<html:message i18nKey="s12Buscadores" key="general.mapa"/>" />
				<input type="button" id="btnAjax" value="<html:message i18nKey="s12Buscadores" key="general.buscar"/>" />
			</div>
		</fieldset>
	</form>
</div>

<div class="s12_BotonesMapa">
	<form name="mapa" id="mapa" method="get" action="/aa30-15820/<%=StringEscapeUtils.escapeHtml(language)%>/s12GoogleMapsWar/gMapsJSP/VisorGeoEuskadi.jsp" target="ifrMapa">
		<input type="hidden" name="lang" id="lang" value="<%=StringEscapeUtils.escapeHtml(language) %>" />
		<input type="hidden" name="query" id="query" />
	</form>
	
	<a href="javascript:verListado()" id="verListado" style="display: none"><span><html:message i18nKey="s12Buscadores" key="general.listado"/></span></a>
</div>

<div id="s12_CapaResultados">
	<div class="s12_titulo_resultado"><html:message i18nKey="s12Buscadores" key="general.resultadoBusqueda"/></div>
	<iframe name="ifrMapa" id="ifrMapa" frameborder="0" class="s12IfrMapa"></iframe>
</div>

<script>
	// Precarga de datos del filtro
	$("#marks").attr("value", "<%=StringEscapeUtils.escapeJavaScript(zona)%>");
	$("#sportType").attr("value", "<%=StringEscapeUtils.escapeJavaScript(sportType)%>");
	
	$("#distanciaMetros").val("<%=StringEscapeUtils.escapeJavaScript(distanciaMetros)%>");
	var distanciakilo = "<%=StringEscapeUtils.escapeJavaScript(distanciaKm)%>";
	if (distanciakilo != "") $("#distanciaKm").val(distanciakilo);
	$("#coordenadaLatitud").val("<%=StringEscapeUtils.escapeJavaScript(latitud)%>");
	$("#coordenadaLongitud").val("<%=StringEscapeUtils.escapeJavaScript(longitud)%>");
	
</script>
