<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MQueryObject" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData" %>
<%@ page import="com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences" %>
<%@ page import="com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants" %>
<%@ page import="com.ejie.r01m.objects.searchengine.session.R01MSearchSession" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants" %>
<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="s12.constantes.S12Constantes" %>
<%@ page import="s12.util.S12Utils" %>
<%@page import="org.apache.commons.lang.StringEscapeUtils"%>

<%@taglib uri="/WEB-INF/tld/r01mSearchEngineTags.tld" prefix="r01mTags" %>
<%@taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%

	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String language = S12Utils.idiomaValido(request.getParameter("r01kLang"));
	if ( language == null ) {
		language = S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( language == null ) {
		language = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	if ( language == null ) {
		language = "es"; // Castellano por defecto cuando no se ha obtenido valor
	}

	Q70ListenerUtils.updateLanguage(request,language); // Fija el idioma para los html:message
	String staticPath = Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO");
	
	// Se obtienen los datos de la request y se aaden a la lista de metadatos de la query
	String zona = request.getParameter(S12Constantes.SF_MARKS) != null ? request.getParameter(S12Constantes.SF_MARKS) : "";
	String tipo = request.getParameter(S12Constantes.SF_CULTURE_TYPE) != null ? request.getParameter(S12Constantes.SF_CULTURE_TYPE) : "";
	String subtipo = request.getParameter(S12Constantes.SF_SUB_TYPE) != null ? request.getParameter(S12Constantes.SF_SUB_TYPE) : "";
    // Se obtiene el municipalityCode de la request
    // Viene de una ficha de recurso con municipio mltiple
    String municipalityCodeMultiple = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE_MULTIPLE) != null ? request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE_MULTIPLE) : "";
    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE) != null ? request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE) : "";
    String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY) != null ? request.getParameter(S12Constantes.SF_MUNICIPALITY) : "";
    String territorioHistorico = request.getParameter (S12Constantes.SF_HISTORIC_TERRITORY_CODE) != null ? request.getParameter (S12Constantes.SF_HISTORIC_TERRITORY_CODE) : "";
 	// Se obtiene el localityCode de la request
   	// Viene de una ficha de recurso con localidad mltiple
    String localityCodeMultiple = request.getParameter(S12Constantes.SF_LOCALITY_CODE_MULTIPLE) != null ? request.getParameter(S12Constantes.SF_LOCALITY_CODE_MULTIPLE) : "";
    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE) != null ? request.getParameter(S12Constantes.SF_LOCALITY_CODE) : "";
    String locality = request.getParameter(S12Constantes.SF_LOCALITY) != null ? request.getParameter(S12Constantes.SF_LOCALITY) : "";
    String municipalitylocality = request.getParameter(S12Constantes.SF_LOCALITYMUNICIPALITY) != null ? request.getParameter(S12Constantes.SF_LOCALITYMUNICIPALITY) : "";
    
    // Se obtiene el accesibility de la request
    String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY) != null ? request.getParameter(S12Constantes.SF_ACCESIBILITY) : "";
  //gastronomico
	String gastronomico = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO) != null  ?request.getParameter(S12Constantes.SF_CLUB_PRODUCTO) : "";
	
	//coordenadas de posicin
    String distanciaMetros = "";
    String distanciaKm = "";
    String latitud = "";
   	String longitud = "";
   	
  //coordenadas de posicin
    if (request.getParameter(S12Constantes.SF_DISTANCIA_KM) != null) distanciaKm = request.getParameter(S12Constantes.SF_DISTANCIA_KM);
    if (request.getParameter(S12Constantes.SF_DISTANCIA_METROS) != null) distanciaMetros = request.getParameter(S12Constantes.SF_DISTANCIA_METROS);
    if (request.getParameter(S12Constantes.SF_LATITUD) != null) latitud = request.getParameter(S12Constantes.SF_LATITUD);
    if (request.getParameter(S12Constantes.SF_LONGITUD) != null) longitud = request.getParameter(S12Constantes.SF_LONGITUD);
%>


<div class="s12CuadroBuscador s12CuadroBuscadorH4">
	<form name="busqueda" id="busqueda" method="post" action="buscadorH4.jsp<%= S12Constantes.ANCLA_BUSCADOR %>">
		<input type="hidden" name="r01kLang" id="r01kLang" value="<%= StringEscapeUtils.escapeHtml(language) %>" />
		<input type="hidden" name="municipalityCodeMultiple" id="municipalityCodeMultiple" />
		<input type="hidden" name="municipalityCode" id="municipalityCode" />
		<input type="hidden" name="localityCodeMultiple" id="localityCodeMultiple" />
		<input type="hidden" name="localityCode" id="localityCode" />
		<input type="hidden" name="historicTerritoryCode" id="historicTerritoryCode" />
		<input type="hidden" name="metodo" id="metodoBuscador" value="buscadorH4_museos" />
		<input type="hidden" name="tipoRecurso" id="tipoRec" value="H4" />
		<input type="hidden" name="u_latitude" id="coordenadaLatitud" />
		<input type="hidden" name="u_longitude" id="coordenadaLongitud" />
		<input type="hidden" name="distancia_max" id="distanciaMetros" />
		<fieldset class="s12Tabla">
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="general.zona"/></label>
				<select name="marks" id="marks" class="s12Combo">
					<option value="">&nbsp;</option>
					<option value="1"><html:message i18nKey="s12Buscadores" key="zona.costaVasca"/></option>
					<option value="2"><html:message i18nKey="s12Buscadores" key="zona.verdeNatural"/></option>
					<option value="3"><html:message i18nKey="s12Buscadores" key="zona.riojaAlavesa"/></option>
					<option value="4"><html:message i18nKey="s12Buscadores" key="zona.bilbao"/></option>
					<option value="5"><html:message i18nKey="s12Buscadores" key="zona.donosti"/></option>
					<option value="6"><html:message i18nKey="s12Buscadores" key="zona.gasteiz"/></option>
				</select>
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="general.tipo"/></label>
				<select name="subtype" id="subtype" class="s12Combo">
					<option value="">&nbsp;</option>
					<option value="0000"><html:message i18nKey="s12Buscadores" key="h4.museos"/></option>
					<option value="0002"><html:message i18nKey="s12Buscadores" key="h4.Auditorios"/></option>
					<option value="0004"><html:message i18nKey="s12Buscadores" key="h4.centrosInterpretacion"/></option>
					<option value="0005"><html:message i18nKey="s12Buscadores" key="h4.equipSocioCulturales"/></option>
				</select>
			</div>
			
			<div class="s12_campo">
				<label><html:message i18nKey="s12Buscadores" key="general.localidad"/> (<html:message i18nKey="s12Buscadores" key="general.municipio"/>)</label>
				<input type="text" name="municipalitylocality" id="municipalitylocality" class="s12CampoTexto ui-autocomplete-input" autocomplete="on" role="textbox" aria-autocomplete="list" aria-haspopup="true"/>
				<input type="hidden" name="municipality" id="municipality" />
				<input type="hidden" name="locality" id="locality" />
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="general.subtipo"/></label>
				<select name="cultureType" id="cultureType" class="s12Combo subtipoComer">
					<option value="">&nbsp;</option>
					<option value="0005"><html:message i18nKey="s12Buscadores" key="h4.arte"/></option>
					<option value="0006"><html:message i18nKey="s12Buscadores" key="h4.historia"/></option>
					<option value="0007"><html:message i18nKey="s12Buscadores" key="h4.etnografia"/></option>
					<option value="0008"><html:message i18nKey="s12Buscadores" key="h4.religion"/></option>
					<option value="0009"><html:message i18nKey="s12Buscadores" key="h4.artesania"/></option>
					<option value="0010"><html:message i18nKey="s12Buscadores" key="h4.maritimo"/></option>
					<option value="0011"><html:message i18nKey="s12Buscadores" key="h4.cienciasNaturales"/></option>
					<option value="0012"><html:message i18nKey="s12Buscadores" key="h4.gastronomia"/></option>
					<option value="0013"><html:message i18nKey="s12Buscadores" key="h4.otros"/></option>
				</select>
			</div>
			<div class="s12_campo" id="divCampoDistancia">
				<label><html:message i18nKey="s12Buscadores" key="general.distancia"></html:message></label>
				<input type="range" name="distanciaKm" id="distanciaKm" min="0" max="200" value="0" disabled="disabled" />
				<div class="divValorDistancia ocultar" id="divValorDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.kmDeMi"></html:message></div>
				<div class="divValorDistancia ocultar" id="divCualquierDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.cualquier"></html:message></div>
				<div class="divValorDistancia" id="divActiveGeolocalizacion"><html:message i18nKey="s12Buscadores" key="general.distancia.activeGeolocalizacion"></html:message></div>
			</div>
			<div class="s12_checkgroup">
				<div class="s12_check">
					<input type="checkbox" name="productClub" id="productClub" class="s12Checkbox" value="A"/>
					<label for="productClub"><html:message i18nKey="s12Buscadores" key="general.gastronomika"/></label>
				</div>
				<div class="s12_check">
					<input type="checkbox" class="s12Checkbox" name="accesibility" id="accesibility">
					<label for="accesibility"><html:message i18nKey="s12Buscadores" key="a1.accesible"/></label>
				</div>
			</div>
			<div class="s12_Boton">
				<input type="button" id="btnBuscarMapa" onclick="verMapa()" value="<html:message i18nKey="s12Buscadores" key="general.mapa"/>" />
				<input type="button" id="btnAjax" value="<html:message i18nKey="s12Buscadores" key="general.buscar"/>" />
			</div>
		</fieldset>
	</form>
</div>
<div class="s12_BotonesMapa">
	<form name="mapa" id="mapa" method="get" action="/aa30-15820/<%=StringEscapeUtils.escapeHtml(language)%>/s12GoogleMapsWar/gMapsJSP/VisorGeoEuskadi.jsp" target="ifrMapa">
		<input type="hidden" name="lang" id="lang" value="<%=StringEscapeUtils.escapeHtml(language) %>" />
		<input type="hidden" name="query" id="query" />
	</form>
	
	<a href="javascript:verListado()" id="verListado" style="display: none"><span><html:message i18nKey="s12Buscadores" key="general.listado"/></span></a>
</div>

<div id="s12_CapaResultados">
	<div class="s12_titulo_resultado"><html:message i18nKey="s12Buscadores" key="general.resultadoBusqueda"/></div>
	<iframe name="ifrMapa" id="ifrMapa" frameborder="0" class="s12IfrMapa"></iframe>
</div>

<script>
	// Precarga de datos del filtro
	$("#marks").attr("value", "<%=StringEscapeUtils.escapeJavaScript(zona)%>");
	$("#cultureType").attr("value", "<%=StringEscapeUtils.escapeJavaScript(tipo)%>");
	$("#subtype").attr("value", "<%=StringEscapeUtils.escapeJavaScript(subtipo)%>");
	<%if(gastronomico != null && !"".equals(gastronomico)){%>
		$("#productClub").attr("checked", "checked");
	<%}%>
	<%if(accesible != null && !"".equals(accesible)){%>
	$("#accesibility").attr("checked", "checked");
	<%}%>
	<%if(municipalityCodeMultiple != null){%>
	$("#municipalityCodeMultiple").attr("value", "<%=StringEscapeUtils.escapeJavaScript(municipalityCodeMultiple) %>");
	<%}else{%>
		$("#municipalityCodeMultiple").attr("value", "");
	<%}%>
	$("#municipalityCode").attr("value", "<%=StringEscapeUtils.escapeJavaScript(municipalityCode) %>");
	$("#municipality").attr("value", "<%=StringEscapeUtils.escapeJavaScript(municipality) %>");
	
	<%if(localityCodeMultiple != null){%>
	$("#localityCodeMultiple").attr("value", "<%=StringEscapeUtils.escapeJavaScript(localityCodeMultiple) %>");
	<%}else{%>
		$("#localityCodeMultiple").attr("value", "");
	<%}%>
	$("#localityCode").attr("value", "<%=StringEscapeUtils.escapeJavaScript(localityCode) %>");
	$("#locality").attr("value", "<%=StringEscapeUtils.escapeJavaScript(locality) %>");
	$("#municipalitylocality").val("<%=StringEscapeUtils.escapeJavaScript(request.getParameter("municipalitylocality") != null ? request.getParameter("municipalitylocality") : "" )%>");

	<%if(territorioHistorico != null){%>
		$("#historicTerritoryCode").attr("value", "<%=StringEscapeUtils.escapeJavaScript(territorioHistorico) %>");
	<%}else{%>
		$("#historicTerritoryCode").attr("value", "");
	<%}%>
	
	$("#distanciaMetros").val("<%=StringEscapeUtils.escapeJavaScript(distanciaMetros)%>");
	var distanciakilo = "<%=StringEscapeUtils.escapeJavaScript(distanciaKm)%>";
	if (distanciakilo != "") $("#distanciaKm").val(distanciakilo);
	$("#coordenadaLatitud").val("<%=StringEscapeUtils.escapeJavaScript(latitud)%>");
	$("#coordenadaLongitud").val("<%=StringEscapeUtils.escapeJavaScript(longitud)%>");
</script>
