<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MQueryObject" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData" %>
<%@ page import="com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences" %>
<%@ page import="com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants" %>
<%@ page import="com.ejie.r01m.objects.searchengine.session.R01MSearchSession" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants" %>
<%@ page import="s12.constantes.S12Constantes" %>
<%@ page import="s12.util.S12Utils" %>
<%@page import="org.apache.commons.lang.StringEscapeUtils"%>

<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>

<%@ taglib uri="/WEB-INF/tld/r01mSearchEngineTags.tld" prefix="r01mTags" %>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%
	
	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String language = S12Utils.idiomaValido(request.getParameter("r01kLang"));
	if ( language == null ) {
		language = S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( language == null ) {
		language = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	if ( language == null ) {
		language = "es"; // Castellano por defecto cuando no se ha obtenido valor
	}

	Q70ListenerUtils.updateLanguage(request,language); // Fija el idioma para los html:message
	String staticPath = Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO_PORTAL");
	
	//coordenadas de posicin
    String distanciaMetros = "";
    String distanciaKm = "";
    String latitud = "";
   	String longitud = "";
   	String municipalitylocality = "";
   	
    //coordenadas de posicin
    if (request.getParameter(S12Constantes.SF_DISTANCIA_KM) != null) distanciaKm = request.getParameter(S12Constantes.SF_DISTANCIA_KM);
    if (request.getParameter(S12Constantes.SF_DISTANCIA_METROS) != null) distanciaMetros = request.getParameter(S12Constantes.SF_DISTANCIA_METROS);
    if (request.getParameter(S12Constantes.SF_LATITUD) != null) latitud = request.getParameter(S12Constantes.SF_LATITUD);
    if (request.getParameter(S12Constantes.SF_LONGITUD) != null) longitud = request.getParameter(S12Constantes.SF_LONGITUD);
    if (request.getParameter(S12Constantes.SF_LOCALITYMUNICIPALITY) != null) municipalitylocality = request.getParameter(S12Constantes.SF_LOCALITYMUNICIPALITY);
%>
<script type="text/javascript" src="<%=staticPath%>/scripts/buscadores/x65-buscadores.js"></script>

<div class="s12CuadroBuscador s12CuadroBuscadorD3">
	<form name="busqueda" id="busqueda" method="post" action="buscadorD3.jsp<%= S12Constantes.ANCLA_BUSCADOR %>">
		<input type="hidden" name="r01kLang" id="r01kLang" value="<%=StringEscapeUtils.escapeHtml(language) %>" />
		<input type="hidden" name="municipalityCode" id="municipalityCode" />
		<input type="hidden" name="localityCodeMultiple" id="localityCodeMultiple" />
		<input type="hidden" name="localityCode" id="localityCode" />
		<input type="hidden" name="u_latitude" id="coordenadaLatitud" />
		<input type="hidden" name="u_longitude" id="coordenadaLongitud" />
		<input type="hidden" name="distancia_max" id="distanciaMetros" />
		<fieldset class="s12Tabla">
			<div class="s12_campo">
				<label><html:message i18nKey="s12Buscadores" key="general.localidad"/> (<html:message i18nKey="s12Buscadores" key="general.municipio"/>)</label>
				<input type="text" name="municipalitylocality" id="municipalitylocality" class="s12CampoTexto"/>
				<input type="hidden" name="municipality" id="municipality" />
				<input type="hidden" name="locality" id="locality" />
			</div>
			<div class="s12_campo">
				<label><html:message i18nKey="s12Buscadores" key="general.zona"/></label>				
				<select name="marks" id="marks" class="s12Combo">
					<option value="">&nbsp;</option>
					<option value="1"><html:message i18nKey="s12Buscadores" key="zona.costaVasca"/></option>
					<option value="2"><html:message i18nKey="s12Buscadores" key="zona.verdeNatural"/></option>
					<option value="3"><html:message i18nKey="s12Buscadores" key="zona.riojaAlavesa"/></option>
					<option value="4"><html:message i18nKey="s12Buscadores" key="zona.bilbao"/></option>
					<option value="5"><html:message i18nKey="s12Buscadores" key="zona.donosti"/></option>
					<option value="6"><html:message i18nKey="s12Buscadores" key="zona.gasteiz"/></option>
				</select>
			</div>
			<div class="s12_campo" id="divCampoDistancia">
				<label><html:message i18nKey="s12Buscadores" key="general.distancia"></html:message></label>
				<input type="range" name="distanciaKm" id="distanciaKm" min="0" max="200" value="0" disabled="disabled" />
				<div class="divValorDistancia ocultar" id="divValorDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.kmDeMi"></html:message></div>
				<div class="divValorDistancia ocultar" id="divCualquierDistancia"><html:message i18nKey="s12Buscadores" key="general.distancia.cualquier"></html:message></div>
				<div class="divValorDistancia" id="divActiveGeolocalizacion"><html:message i18nKey="s12Buscadores" key="general.distancia.activeGeolocalizacion"></html:message></div>
			</div>			
			<div class="s12_Boton">
				<input type="submit" value="<html:message i18nKey="s12Buscadores" key="general.buscar"/>" class="s12Boton"/>
			</div>
		</fieldset>
	</form>
</div>
<%
	// Comprobar si en la sesin hay una query ejecutndose, si no es as, crear una a huevo...
	// (el buscador utiliza una variable en sesin donde deja la sesin de bsqueda que es
	//  la madre del cordero...)
	R01MSearchSession srchSession = (R01MSearchSession)request.getSession(false).getAttribute(R01MSearchEngineWebConstants.SESSIONVAR_SRCHSESSION);
	R01MQueryObject qry = null;

	//if (srchSession == null || srchSession.getQuery() == null) {
			qry = new R01MQueryObject();

	    // Objetos de tipologia
	    List<R01MSearchedCluster> clusters = new ArrayList<R01MSearchedCluster>();
	    clusters.add( new R01MSearchedCluster("euskadi") );
	    List<R01MSearchedFamily> families = new ArrayList<R01MSearchedFamily>();
	    families.add( new R01MSearchedFamily("turismo","turismo") );
	    List<R01MSearchedContentType> types = new ArrayList<R01MSearchedContentType>();
	    types.add( new R01MSearchedContentType("d_destinos_turisticos","d_destinos_turisticos") );

	    qry.setContentClusters(clusters);
	    qry.setContentFamilies(families);
	    qry.setContentTypes(types);

	    // MetaDatos
	    List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		 	 // Se establece el templateType
	    metaData.add( new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE,R01MSearchEngineConstants.EQUALS_OPERATOR,"D3") );

	    // Almacenamiento de los criterios de bsqueda en la sesin
	    // Necesario para mantenerlos en la paginacin
	    HashMap<String, HashMap<String, String>> criteriosBusqueda = (HashMap<String, HashMap<String, String>>) session.getAttribute("criteriosBusqueda");
	    HashMap<String, String> hmD3 = null;
	    HashMap<String, String> hmD3Aux = new HashMap<String, String>(); // Necesaria nueva instancia
	    String zonaSesion = "";
	    String municipalityCodeSesion = "";
	    String municipalitySesion = "";
	    String localityCodeSesion = "";
		  String localityCodeMultipleSesion = "";
		  String localitySesion = "";

	    // Comprobamos si estamos en paginacin
	    boolean bPaginacion = (request.getParameter("r01kQry") != null);

	    // Comprobamos si existen los datos en la sesin si no se crearn nuevos
	    if (criteriosBusqueda == null) {
	    	criteriosBusqueda = new HashMap<String, HashMap<String, String>>();
	    	hmD3 = new HashMap<String, String>();
	    	criteriosBusqueda.put("D3", hmD3);
	    } else { // Ya existe criteriosBusqueda en la sesin
	    	hmD3 = criteriosBusqueda.get("D3");

	    	if (hmD3 == null) { // No existe criteriosBusqueda para D3
	    		criteriosBusqueda = new HashMap<String, HashMap<String, String>>(); // Se resetean los criterios (slo habr uno activo para un buscador)
	    		hmD3 = new HashMap<String, String>();
	    		criteriosBusqueda.put("D3", hmD3);
	    	} else {
	    		// Datos de sesin, vlidos en paginacin
	  	    zonaSesion = hmD3.get(S12Constantes.SF_MARKS);
	  	    municipalityCodeSesion = hmD3.get(S12Constantes.SF_MUNICIPALITY_CODE);
	  	    municipalitySesion = hmD3.get(S12Constantes.SF_MUNICIPALITY);
	  	  	localityCodeMultipleSesion = hmD3.get(S12Constantes.SF_LOCALITY_CODE_MULTIPLE);
	  	    localityCodeSesion = hmD3.get(S12Constantes.SF_LOCALITY_CODE);
	  	    localitySesion = hmD3.get(S12Constantes.SF_LOCALITY);
	    	}
	    }

	    // Se obtiene la zona de la request
	    String zona = request.getParameter(S12Constantes.SF_MARKS);

	    if(zona != null && !"".equals(zona)){
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));

	    	// Se aade el parmetro a la sesin
	    	hmD3Aux.put(S12Constantes.SF_MARKS, zona);
	    } else {
	   		// Se aade el parmetro a la sesin
	    	hmD3Aux.put(S12Constantes.SF_MARKS, "");
	    }

	    // Se obtiene el municipalityCode de la request
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE);
	    String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);

	    if (municipalityCode != null && municipality != null && !"".equals(municipalityCode) &&
	    		!"".equals(municipality)) {
	    	metaData.add( new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY,R01MSearchEngineConstants.LIKE_OPERATOR,municipality.toUpperCase(new Locale("es","es"))) );

	    	// Se aade el parmetro a la sesin
	    	hmD3Aux.put(S12Constantes.SF_MUNICIPALITY_CODE, municipalityCode);
	    	hmD3Aux.put(S12Constantes.SF_MUNICIPALITY, municipality);
	    } else if (municipalityCode != null && municipality != null && "".equals(municipalityCode) &&
	    		!"".equals(municipality)) {
	    	metaData.add( new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY, R01MSearchEngineConstants.LIKE_OPERATOR,municipality.toUpperCase(new Locale("es","es"))) );

	   		// Se aade el parmetro a la sesin
	   		hmD3Aux.put(S12Constantes.SF_MUNICIPALITY_CODE, "");
	   		hmD3Aux.put(S12Constantes.SF_MUNICIPALITY, municipality);
	    }

	    if (municipalityCode == null ) {
	    	municipalityCode = "";
	    	hmD3Aux.put(S12Constantes.SF_MUNICIPALITY_CODE, "");
	    }

	    if (municipality == null || "".equals(municipality)) {
	    	municipality = "";
	    	hmD3Aux.put(S12Constantes.SF_MUNICIPALITY, "");
	    }
	    
	 		// Se obtiene el localityCode de la request
    	// Viene de una ficha de recurso con localidad mltiple
	    String localityCodeMultiple = request.getParameter(S12Constantes.SF_LOCALITY_CODE_MULTIPLE);
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE);
	    String locality = request.getParameter(S12Constantes.SF_LOCALITY);
	
	    if (localityCode != null && locality != null && !"".equals(localityCode) &&
	    		!"".equals(locality)) {
	    	metaData.add( new R01MSearchedMetaData(S12Constantes.SF_LOCALITY,R01MSearchEngineConstants.LIKE_OPERATOR,locality.toUpperCase(new Locale("es","es"))) );
	
	    	// Se aade el parmetro a la sesin
	    	hmD3Aux.put(S12Constantes.SF_LOCALITY_CODE_MULTIPLE, "");
	    	hmD3Aux.put(S12Constantes.SF_LOCALITY_CODE, localityCode);
	    	hmD3Aux.put(S12Constantes.SF_LOCALITY, locality);
	    } else if (localityCode != null && locality != null && "".equals(localityCode) &&
	    		!"".equals(locality)) {
	    	metaData.add( new R01MSearchedMetaData(S12Constantes.SF_LOCALITY,R01MSearchEngineConstants.LIKE_OPERATOR,locality.toUpperCase(new Locale("es","es"))) );
	
	   		// Se aade el parmetro a la sesin
	   		hmD3Aux.put(S12Constantes.SF_LOCALITY_CODE_MULTIPLE, "");
	   		hmD3Aux.put(S12Constantes.SF_LOCALITY_CODE, "");
	   		hmD3Aux.put(S12Constantes.SF_LOCALITY, locality);
	    } else if (localityCodeMultiple != null && !"".equals(localityCodeMultiple)) {
	    	metaData.add( new R01MSearchedMetaData(S12Constantes.SF_LOCALITY_CODE, R01MSearchEngineConstants.IN_OPERATOR, localityCodeMultiple) );
	
	    	// Se aade el parmetro a la sesin
	    	hmD3Aux.put(S12Constantes.SF_LOCALITY_CODE_MULTIPLE, localityCodeMultiple);
	    	hmD3Aux.put(S12Constantes.SF_LOCALITY_CODE, "");
	    	hmD3Aux.put(S12Constantes.SF_LOCALITY, "");
	    }
	
	    if (localityCodeMultiple == null ) {
	    	localityCodeMultiple = "";
	    	hmD3Aux.put(S12Constantes.SF_LOCALITY_CODE_MULTIPLE, "");
	    }
	
	    if (localityCode == null ) {
	    	localityCode = "";
	    	hmD3Aux.put(S12Constantes.SF_LOCALITY_CODE, "");
	    }
	
	    if (locality == null || "".equals(locality)) {
	    	locality = "";
	    	hmD3Aux.put(S12Constantes.SF_LOCALITY, "");
	    }

	  	//Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));

	    // Si venimos de una bsqueda volvemos a leer
	    // los valores de la sesin ya que se han actualizado
	    if (!bPaginacion) {
		    zonaSesion = hmD3Aux.get(S12Constantes.SF_MARKS);
		    municipalityCodeSesion = hmD3Aux.get(S12Constantes.SF_MUNICIPALITY_CODE);
		    municipalitySesion = hmD3Aux.get(S12Constantes.SF_MUNICIPALITY);
		    localityCodeMultipleSesion = hmD3Aux.get(S12Constantes.SF_LOCALITY_CODE_MULTIPLE);
		    localityCodeSesion = hmD3Aux.get(S12Constantes.SF_LOCALITY_CODE);
		    localitySesion = hmD3Aux.get(S12Constantes.SF_LOCALITY);

		 		// Comprobamos los null
		    if (zonaSesion == null) {
		    	zonaSesion = "";
		    }
		    if (municipalityCodeSesion == null) {
		    	municipalityCodeSesion = "";
		    }
		    if (municipalitySesion == null) {
		    	municipalitySesion = "";
		    }
		    if (localityCodeMultipleSesion == null) {
		    	localityCodeMultipleSesion = "";
		    }
		    if (localityCodeSesion == null) {
		    	localityCodeSesion = "";
		    }
		    if (localitySesion == null) {
		    	localitySesion = "";
		    }

		 		// Se guardan los nuevos criterios en la sesin
		 		criteriosBusqueda.put("D3",hmD3Aux);
		    session.setAttribute("criteriosBusqueda", criteriosBusqueda);
	    }

	    qry.setMetaData(metaData);

	 		// MetaDatos ordenacin
	    List<R01MSearchedOrderByMetaData> metaDataOrder = new ArrayList<R01MSearchedOrderByMetaData>();
	    metaDataOrder.add( new R01MSearchedOrderByMetaData(S12Constantes.SF_DOCUMENT_NAME,"ASC") );

	    qry.setOrderBy(metaDataOrder);

	    // Propiedades de presentacion

	    // Obtener la query string para el mapa
	    qry.setPresentationProperty(R01MQueryObject.PRESENTATION_PAGE_SIZE,"1000");
	    String queryString = R01MSearchEngineUtils.encodeQueryObjectInURL(qry);
	    /////////////

	 		// Establecer el nmero de resultados por pgina
	    qry.setPresentationProperty("r01NavBarBlockSize","5");
	    qry.setPresentationProperty(R01MQueryObject.PRESENTATION_PAGE_SIZE,"20");

	//}

	// Establecer las preferencias de formateo
	// Al crear el objeto R01MSearchSessionFormatterPreferences se obtiene la clase de formateo por defecto
	// desde el fichero r01m.properties.xml
	// Se puede cambiar la clase de formateo por defecto estableciendo el miembro sessionFormatterClassName
	//		Adicionalmente se puede "afinar" un poco ms y manteniendo la clase de formateo por
	//	        defecto cambiar alguna de las clases de formateo de cada uno de los bloques:
	//			- searchedRepositoriesFormatterClassName: Formateador del resumen de repositorios
	//			  en los que se ha buscado
	//			- searchQueryFormatterClassName: Formateador de la query (resumen de los criterios
	//			  de bsqueda)
	//			- searchGuideFormatterClassName: Formateador de las guas de navegacin
	//			- searchResultsFormatterClassName: Formateador de los resultados de bsqueda
	// 			- searchResultsNavBarFormatterClassName: Formateador de la barra de navegacin por
	//			  los resultados
	// 		Tambin es posible indicar en las preferencias de formateo si se quiere mostrar o no
	//		alguna de las	secciones anteriores:
	//			- Mostrar o no alguna de las condiciones de bsqueda
	//			- Mostrar o no las guas de navegacin y cmo mostrarlas (en forma de combo, lista
	//         o rbol)
	//			- Qu datos mostrar de cada elemento de resultados

  R01MSearchSessionFormatterPreferences prefs = new R01MSearchSessionFormatterPreferences();
  // NOTA: Lo siguiente NO es necesario si se utiliza el formateador por defecto.
  //		Normalmente lo nico que se cambia es el formateador de resultados y el resto se deja "tal
  //		cual"

  // #################### ESTO NO ES NECESARIO pero vale para ver como funciona
  // Formateador por defecto (al incializarse las preferencias ya se inicializa el formateador por
  // defecto con todos los valores que se vuelven a establecer aqu, pero se repite con fines didcticos)
	prefs.formatterImpls.sessionFormatterClassName = "s12.buscadores.formatters.S12SearchSessionHtmlFormatter";
  // La clase de formateo html por defecto utiliza a su vez formateadores para cada uno de los bloques
  // (este puede NO ser el caso de otras clases de formateo que pueden formatear todo "de una tacada",
	// como por ejemplo un formateador basado en XSL)
  prefs.formatterImpls.searchedRepositoriesFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchedRepositoriesResumeHtmlFormatter";
  prefs.formatterImpls.searchQueryFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchQueryHtmlFormatter";
  prefs.formatterImpls.searchGuideFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchGuideHtmlFormatter";
  prefs.formatterImpls.searchResultItemFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MSearchResultItemsThumbNailFormatter";
  //prefs.formatterImpls.searchResultsNavBarFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchResultsNavBarHtmlFormatter";
	prefs.formatterImpls.searchResultsNavBarFormatterClassName = "s12.buscadores.formatters.S12SearchResultsNavBarHtmlFormatter";

	// Mostrar o no alguna de las secciones de la query
	prefs.queryFormatterPreferences.showRepositoriesResume = false;	// Mostrar el resumen de
																																	// repositorios sobre los que se ha
																																	// buscado
  prefs.queryFormatterPreferences.showStorageConditionsResume = false;	// Mostrar informacin sobre
																																			// almacenamiento
  prefs.queryFormatterPreferences.showTypoConditionsResume = false;		// Mostrar informacin sobre
																																			// tipologa
  prefs.queryFormatterPreferences.showMetaDataConditionsResume = false;	// Mostrar informacin sobre
																																				// meta-datos
  prefs.queryFormatterPreferences.showStructureLabelsConditionsResume = false;	// Mostrar informacin
																																								// catalogacin en ejes
  prefs.queryFormatterPreferences.showGeoLabelsConditionsResume = false; // Mostrar informacin sobre
   																																				// catalogacin geogrficas
  prefs.queryFormatterPreferences.showOrderByResume = false; // Mostrar informacin sobre meta-datos de
																															// ordenacin

	// Guas de navegacin
	prefs.guideFormatterPreferences.showGuideElementsSubTotals = false;	// Mostrar el nmero de resultados
																																			// total para cada elemento de la gua
  //prefs.guideFormatterPreferences.guideType = R01MSearchGuideFormatterPreferences.GUIDE_COMBO;		// Mostrar la gua de navegacin como un combo
  //prefs.guideFormatterPreferences.guideColumnsNum = 3;// Nmero de columnas de la gua de navegacin
  // Barras de navegacin/paginacin por los resultados de un repositorio
  prefs.navBarFormatterPreferences.showSourceResultsNavBars = true;	// Mostrar las barras de
																																		// paginacin por resultados
																									  								// Resultados
  prefs.resultsFormatterPreferences.showContentInfoInResultItem = true;	// Mostrar informacin sobre el
																																				// contenido en cada item
  prefs.resultsFormatterPreferences.showDocumentInfoInResultItem = true;	// Mostrar informacin sobre el
																																					// documento en cada item
  prefs.resultsFormatterPreferences.showDataFileInfoInResultItem = true;	// Mostrar informacin sobre el
																																					// dataFile en cada item
  prefs.resultsFormatterPreferences.showCatalogInfoInResultItem = true;	// Mostrar informacin de
																																				// catalogacin en cada item

	// Establecer la url base para los items
	//prefs.resultsFormatterPreferences.itemUrlBase = R01MConstants.URL_INTERNET;

	// Establecer la pgina en la que se muestran los resultados
	// Portal y pgina que contiene el rea visual donde se muestran el contenido cuando se pincha en un hit
	// Pasar el prefijo de las urls de los elementos resultado de la bsqueda
	// El prefijo es el portal-pag/idioma con el portal, la pgina y el idioma donde hay un rea visual
	// que contiene un contenedor de resultados de bsqueda
	prefs.resultsFormatterPreferences.itemUrlPrefix = "x65-12375/" + StringEscapeUtils.escapeHtml(language);

	prefs.resultsFormatterPreferences.formatterAtributtes = new HashMap();
	//prefs.resultsFormatterPreferences.formatterAtributtes.put(R01MSearchEngineConstants.PRESENTATION_PROPERTY_THUMBNAILTYPE,"miniatura-1");
	prefs.resultsFormatterPreferences.formatterAtributtes.put(R01MSearchEngineConstants.PRESENTATION_PROPERTY_THUMBNAILTYPE,"miniatura-25");

  // #################### ESTO NO ES NECESARIO pero vale para ver como funciona

  request.setCharacterEncoding("UTF-8");
%>


<script>
	// Precarga de datos del filtro
	$("#marks").attr("value", "<%= StringEscapeUtils.escapeJavaScript( zonaSesion )%>" || "");
	$("#municipalityCode").attr("value", "<%= StringEscapeUtils.escapeJavaScript( municipalityCodeSesion )%>" || "");
	$("#municipality").attr("value", "<%= StringEscapeUtils.escapeJavaScript( municipalitySesion )%>" || "");
	<%if(localityCodeMultipleSesion != null){%>
		$("#localityCodeMultiple").attr("value", "<%= StringEscapeUtils.escapeJavaScript( localityCodeMultipleSesion )%>");
	<%}else{%>
		$("#localityCodeMultiple").attr("value", "");
	<%}%>
	$("#localityCode").attr("value", "<%=StringEscapeUtils.escapeJavaScript( localityCodeSesion )%>" || "");
	$("#locality").attr("value", "<%=StringEscapeUtils.escapeJavaScript( localitySesion )%>" || "");
	$("#municipalitylocality").val("<%=StringEscapeUtils.escapeJavaScript( request.getParameter("municipalitylocality") != null ? request.getParameter("municipalitylocality") : "" )%>");
	
	// Almacena la query en el campo hidden para utilizarlo el el mapa de Google Maps
  	$("#query").attr("value", "<%= queryString %>" || "");
	
	$("#distanciaMetros").val("<%=StringEscapeUtils.escapeJavaScript(distanciaMetros)%>");
	var distanciakilo = "<%=StringEscapeUtils.escapeJavaScript(distanciaKm)%>";
	if (distanciakilo != "") $("#distanciaKm").val(distanciakilo);
	$("#coordenadaLatitud").val("<%=StringEscapeUtils.escapeJavaScript(latitud)%>");
	$("#coordenadaLongitud").val("<%=StringEscapeUtils.escapeJavaScript(longitud)%>");
</script>

<!-- Recomendacin: Pasar el objeto query UNICAMENTE en la primera llamada,
     en el resto (paginaciones) no enviarlo (enviar null)
     #tampoco pasa nada si se enva# -->
<r01mTags:searchEngineSession query='<%=qry%>'
			    sessionFormatterPrefs='<%=prefs%>'
			    numberOfResultItemsPerPage="10"
			    returnAttachments="true"
			    cacheSearchSession="false"
			    serviceBaseURL="s12PortalWar/buscadoresJSP/buscadorD3.jsp" />

