<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MQueryObject" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData" %>
<%@ page import="com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences" %>
<%@ page import="com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants" %>
<%@ page import="com.ejie.r01m.objects.searchengine.session.R01MSearchSession" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils" %>
<%@ page import="com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedWorkArea" %>
<%@ page import="com.ejie.r01m.objects.searchengine.query.R01MSearchedDataRepository"%>

<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="s12.constantes.S12Constantes" %>
<%@ page import="s12.util.S12Utils" %>
<%@page import="org.apache.commons.lang.StringEscapeUtils"%>

<%@ taglib uri="/WEB-INF/tld/r01mSearchEngineTags.tld" prefix="r01mTags" %>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%
	
	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String language = S12Utils.idiomaValido(request.getParameter("r01kLang"));
	if ( language == null ) {
		language = S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( language == null ) {
		language = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	if ( language == null ) {
		language = "es"; // Castellano por defecto cuando no se ha obtenido valor
	}

	Q70ListenerUtils.updateLanguage(request,language); // Fija el idioma para los html:message
	String staticPath = Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO"); //"ejld003"
	String server = Q70ListenerUtils.getApplicationProperty("iw.storeLocation.server"); //"euskadi"
	String dataRepository = Q70ListenerUtils.getApplicationProperty("iw.storeLocation.dataRepository");
	String area = Q70ListenerUtils.getApplicationProperty("iw.storeLocation.area"); //"turismo"
	String workArea = Q70ListenerUtils.getApplicationProperty("iw.storeLocation.workArea"); //ws11_comun
	
	String keyEjeBTT = "r01etpd14fef0237bd1a5727adf784291f53bd3327";
	String keyRamaTipoArchivo 			= "r01etpd14fef04579a1a5727add31d4d8076be3df4";
	String keyTipoFichas 						= "r01etpd14fef05265a1a5727ad1d9a23f410e6d236";
//	String keyTipoRutas 						= "r01etpd14fef0589731a5727adb0fe6066d970669e";
//	String keyTipoFolletos 					= "r01etpd14fef0792381a5727ada13f19b4c5bf29b1";
	String keyTipoTracks 						= "r01etpd14fef0833251a5727adf0c4b9820d88cb44";
	String keyRamaSeccion 					= "r01etpd14fef093a631a5727ad375098d9e47a1b5a";
//	String keySeccionCentros 				= "r01etpd14fef0b06141a5727adb6a5b8c8686fa53a";
	String keySeccionBusturialdea 	= "r01etpd14fef0b9f3d1a5727ad4b8ceb275cf21b61";
	String keySeccionIzki 					= "r01etpd14fef0c6a8e1a5727ad9f1c5e6bcd12800f";
	String keySeccionDebabarrena 		= "r01etpd014fef0cbae21a5727adf4b0a5744fce005";
	String keySeccionValderejo 			= "r01etpd14fef0d03391a5727adf82cb34e4bee6315";
	String keySeccionTolosaldea 		= "r01etpd14fef0d9fc91a5727ad4520b46130ce63af";
	String keyRamaDificultad				= "r01etpd152f342fbea19d1dd7897a1d5d30d719b88";
	String keyDificultadMuyFacil 		= "r01etpd152f348630419d1dd783454931db782b266";
	String keyDificultadFacil 			= "r01etpd152f34a384a19d1dd789e6114cbc37cc961";
	String keyDificultadDificil 		= "r01etpd152f34af19b19d1dd78e0f9c4a7a34d5352";
	String keyDificultadMuyDificil 	= "r01etpd152f34b3c1419d1dd784660a5c9827e2711";

%>
<script type="text/javascript" src="<%=staticPath%>/scripts/buscadores/aa30-buscadores.js"></script>

<div class="s12CuadroBuscador s12CuadroBuscadorBTT">
	<form name="busqueda" id="busqueda" method="post" action="buscadorBTT.jsp<%= S12Constantes.ANCLA_BUSCADOR %>">
		<input type="hidden" name="r01kLang" id="r01kLang" value="<%= StringEscapeUtils.escapeHtml(language) %>" />
		<input type="hidden" name="query" id="query" />
		<fieldset class="s12Tabla">
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="btt.tipoArchivo"/></label>
				<select name="tipoarchivo" id="tipoarchivo" class="s12Combo">
					<option value="">&nbsp;</option>
					<option value="<%=keyTipoFichas%>"		><html:message i18nKey="s12Buscadores" key="archivo.fichas"/></option>
					<option value="<%=keyTipoTracks%>"		><html:message i18nKey="s12Buscadores" key="archivo.tracks"/></option>
				</select>
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="btt.centroBTT"/></label>
				<select name="seccion" id="seccion" class="s12Combo">
					<option value="">&nbsp;</option>
					<option value="<%=keySeccionBusturialdea%>"><html:message i18nKey="s12Buscadores" key="seccion.busturialdea"/></option>
					<option value="<%=keySeccionIzki%>"		><html:message i18nKey="s12Buscadores" key="seccion.izki"/></option>
					<option value="<%=keySeccionDebabarrena%>"	><html:message i18nKey="s12Buscadores" key="seccion.debabarrena"/></option>
					<option value="<%=keySeccionValderejo%>"	><html:message i18nKey="s12Buscadores" key="seccion.valderejo"/></option>
					<option value="<%=keySeccionTolosaldea%>"	><html:message i18nKey="s12Buscadores" key="seccion.tolosaldea"/></option>
				</select>
			</div>
			<div class="s12_campo s12_select">
				<label><html:message i18nKey="s12Buscadores" key="btt.dificultad"/></label>
				<select name="dificultad" id="dificultad" class="s12Combo">
					<option value="">&nbsp;</option>
					<option value="<%=keyDificultadMuyFacil%>"><html:message i18nKey="s12Buscadores" key="dificultad.muyfacil"/></option>
					<option value="<%=keyDificultadFacil%>"		><html:message i18nKey="s12Buscadores" key="dificultad.facil"/></option>
					<option value="<%=keyDificultadDificil%>"	><html:message i18nKey="s12Buscadores" key="dificultad.dificil"/></option>
					<option value="<%=keyDificultadMuyDificil%>"	><html:message i18nKey="s12Buscadores" key="dificultad.muydificil"/></option>
				</select>
			</div>
			<div class="s12_Boton">
				<input type="submit" value="<html:message i18nKey="s12Buscadores" key="general.buscar"/>" />
			</div>
		</fieldset>
	</form>
</div>

<%
	// Comprobar si en la sesin hay una query ejecutndose, si no es as, crear una a huevo...
	// (el buscador utiliza una variable en sesin donde deja la sesin de bsqueda que es
	//  la madre del cordero...)
	R01MSearchSession srchSession = (R01MSearchSession)request.getSession(false).getAttribute(R01MSearchEngineWebConstants.SESSIONVAR_SRCHSESSION);
	R01MQueryObject qry = null;

	//if (srchSession == null || srchSession.getQuery() == null) {
		qry = new R01MQueryObject();

	    // Objetos de tipologia
	    List<R01MSearchedCluster> clusters = new ArrayList<R01MSearchedCluster>();
	    clusters.add( new R01MSearchedCluster("euskadi") );
	    List<R01MSearchedFamily> families = new ArrayList<R01MSearchedFamily>();
	    families.add( new R01MSearchedFamily("enlaces","enlaces") );
	    List<R01MSearchedContentType> types = new ArrayList<R01MSearchedContentType>();
	    types.add( new R01MSearchedContentType("enlace","enlace") );

	    qry.setContentClusters(clusters);
	    qry.setContentFamilies(families);
	    qry.setContentTypes(types);

		// Almacenamiento de los criterios de bsqueda en la sesin
		// Necesario para mantenerlos en la paginacin
		HashMap<String, HashMap<String, String>> criteriosBusqueda = (HashMap<String, HashMap<String, String>>) session.getAttribute("criteriosBusqueda");
		HashMap<String, String> hmBTT = null;
		HashMap<String, String> hmBTTAux = new HashMap<String, String>(); // Necesaria nueva instancia
		String tipoArchivoSesion = "";
		String seccionSesion = "";
		String dificultadSesion = "";
		String queryStringSesion = "";
		
		// Comprobamos si estamos en paginacin
		boolean bPaginacion = (request.getParameter("r01kQry") != null);
		
		// Comprobamos si existen los datos en la sesin si no se crearn nuevos
		if (criteriosBusqueda == null) {
			criteriosBusqueda = new HashMap<String, HashMap<String, String>>();
			hmBTT = new HashMap<String, String>();
			criteriosBusqueda.put("BTT", hmBTT);
		} else { // Ya existe criteriosBusqueda en la sesin
			hmBTT = criteriosBusqueda.get("BTT");
		
	  	if (hmBTT == null) { // No existe criteriosBusqueda para BTT
	    	criteriosBusqueda = new HashMap<String, HashMap<String, String>>(); // Se resetean los criterios (slo habr uno activo para un buscador)
	    	hmBTT = new HashMap<String, String>();
	    	criteriosBusqueda.put("BTT", hmBTT);
	  	} else {
				// Datos de sesin, vlidos en paginacin
				tipoArchivoSesion = hmBTT.get(S12Constantes.SF_TIPO_ARCHIVO);
				seccionSesion = hmBTT.get(S12Constantes.SF_SECCION);
				dificultadSesion = hmBTT.get(S12Constantes.SF_DIFICULTAD);
		  		queryStringSesion = hmBTT.get("queryString");
			}
		}

	  //Se aade el filtro del eje de catalogacin: 
		
	  //Se obtienen los datos de la request y se aaden a la lista de metadatos o filtro de catalogacin de la query
		String tipo = StringEscapeUtils.escapeJava(request.getParameter(S12Constantes.SF_TIPO_ARCHIVO));			
		String seccion = request.getParameter(S12Constantes.SF_SECCION);
		String dificultad = request.getParameter(S12Constantes.SF_DIFICULTAD);

		//por ubicacin en el catlogo: SIRVE PARA OBTENER TODOS SIN FILTRAR, PERO ROMPE LA PAGINACIN.
// 	    List<R01MSearchedWorkArea> workAreas = new ArrayList<R01MSearchedWorkArea>();
// 	    workAreas.add(new R01MSearchedWorkArea(server, dataRepository, area, workArea));
// 	    qry.setWorkAreas(workAreas);
		
		//Bsqueda sin ningun valor de filtro:
		if ((tipo==null || "".equals(tipo)) && 
				(seccion==null || "".equals(seccion)) &&
				(dificultad==null || "".equals(dificultad))){
			qry.addORStructureCatalogFromKey(keyTipoFichas);
			qry.addORStructureCatalogFromKey(keyTipoTracks);
			qry.addORStructureCatalogFromKey(keySeccionBusturialdea);
			qry.addORStructureCatalogFromKey(keySeccionDebabarrena);
			qry.addORStructureCatalogFromKey(keySeccionIzki);
			qry.addORStructureCatalogFromKey(keySeccionTolosaldea);
			qry.addORStructureCatalogFromKey(keySeccionValderejo);
			qry.addORStructureCatalogFromKey(keyDificultadMuyFacil);
			qry.addORStructureCatalogFromKey(keyDificultadFacil);
			qry.addORStructureCatalogFromKey(keyDificultadDificil);
			qry.addORStructureCatalogFromKey(keyDificultadMuyDificil);
		}
		if(tipo != null && !"".equals(tipo)){
			//establecemos los filtros a aplicar en funcion de la seleccin del combo de Tipo de Archivo.
			qry.addANDStructureCatalog(tipo);
	    // Se aade el parmetro a la sesin
	    hmBTTAux.put(S12Constantes.SF_TIPO_ARCHIVO, tipo);
		} else {
			// Se aade el parmetro a la sesin
			hmBTTAux.put(S12Constantes.SF_TIPO_ARCHIVO, "");
		}

		if(seccion != null && !"".equals(seccion)){
			//establecemos los filtros a aplicar en funcion de la seleccin del combo de Seccin
			qry.addANDStructureCatalog(seccion);
	    // Se aade el parmetro a la sesin
	    hmBTTAux.put(S12Constantes.SF_SECCION, seccion);
		} else {
			// Se aade el parmetro a la sesin
			hmBTTAux.put(S12Constantes.SF_SECCION, "");
		}
	    
		if(dificultad != null && !"".equals(dificultad)){
			//establecemos los filtros a aplicar en funcion de la seleccin del combo de Dificultad
			qry.addANDStructureCatalog(dificultad);
	    // Se aade el parmetro a la sesin
	    hmBTTAux.put(S12Constantes.SF_DIFICULTAD, dificultad);
		} else {
			// Se aade el parmetro a la sesin
			hmBTTAux.put(S12Constantes.SF_DIFICULTAD, "");
		}
	    
	 	// Si venimos de una bsqueda volvemos a leer
	  // los valores de la sesin ya que se han actualizado
	  if (!bPaginacion) {
	    tipoArchivoSesion = hmBTTAux.get(S12Constantes.SF_TIPO_ARCHIVO);
	    seccionSesion = hmBTTAux.get(S12Constantes.SF_SECCION);
	    dificultadSesion = hmBTTAux.get(S12Constantes.SF_DIFICULTAD);
	    queryStringSesion = hmBTTAux.get("queryString");

	 		// Comprobamos los null
	    if (tipoArchivoSesion == null) {
	    	tipoArchivoSesion = "";
	    }
	    if (seccionSesion == null) {
	    	seccionSesion = "";
	    }
	    if (dificultadSesion == null) {
	    	dificultadSesion = "";
	    }
	    if (queryStringSesion == null) {
	    	queryStringSesion = "";
	    }

		 	// Se guardan los nuevos criterios en la sesin
		 	criteriosBusqueda.put("BTT",hmBTTAux);
		  session.setAttribute("criteriosBusqueda", criteriosBusqueda);
	  }
	
	 	// MetaDatos ordenacin
    List<R01MSearchedOrderByMetaData> metaDataOrder = new ArrayList<R01MSearchedOrderByMetaData>();
    metaDataOrder.add( new R01MSearchedOrderByMetaData(S12Constantes.SF_DOCUMENT_NAME,"ASC") );

	  qry.setOrderBy(metaDataOrder);

    // Obtener la query string (aunque no tenemos mapa, para depurar viene bien)
    qry.setPresentationProperty(R01MQueryObject.PRESENTATION_PAGE_SIZE,"1000");
    String queryString = R01MSearchEngineUtils.encodeQueryObjectInURL(qry);
    hmBTTAux.put("queryString", queryString);
	    
	 	// Establecer el nmero de resultados por pgina
    qry.setPresentationProperty("r01NavBarBlockSize","5");
    qry.setPresentationProperty(R01MQueryObject.PRESENTATION_PAGE_SIZE,"20");
	    
		//}

		// Establecer las preferencias de formateo
		// Al crear el objeto R01MSearchSessionFormatterPreferences se obtiene la clase de formateo por defecto
		// desde el fichero r01m.properties.xml
		// Se puede cambiar la clase de formateo por defecto estableciendo el miembro sessionFormatterClassName
		//		Adicionalmente se puede "afinar" un poco ms y manteniendo la clase de formateo por
		//	        defecto cambiar alguna de las clases de formateo de cada uno de los bloques:
		//			- searchedRepositoriesFormatterClassName: Formateador del resumen de repositorios
		//			  en los que se ha buscado
		//			- searchQueryFormatterClassName: Formateador de la query (resumen de los criterios
		//			  de bsqueda)
		//			- searchGuideFormatterClassName: Formateador de las guas de navegacin
		//			- searchResultsFormatterClassName: Formateador de los resultados de bsqueda
		// 			- searchResultsNavBarFormatterClassName: Formateador de la barra de navegacin por
		//			  los resultados
		// 		Tambin es posible indicar en las preferencias de formateo si se quiere mostrar o no
		//		alguna de las	secciones anteriores:
		//			- Mostrar o no alguna de las condiciones de bsqueda
		//			- Mostrar o no las guas de navegacin y cmo mostrarlas (en forma de combo, lista
		//         o rbol)
		//			- Qu datos mostrar de cada elemento de resultados

		R01MSearchSessionFormatterPreferences prefs = new R01MSearchSessionFormatterPreferences();
		// NOTA: Lo siguiente NO es necesario si se utiliza el formateador por defecto.
		//		Normalmente lo nico que se cambia es el formateador de resultados y el resto se deja "tal
		//		cual"
		
		// #################### ESTO NO ES NECESARIO pero vale para ver como funciona
		// Formateador por defecto (al incializarse las preferencias ya se inicializa el formateador por
		// defecto con todos los valores que se vuelven a establecer aqu, pero se repite con fines didcticos)
		prefs.formatterImpls.sessionFormatterClassName = "s12.buscadores.formatters.S12SearchSessionHtmlFormatter";
		// La clase de formateo html por defecto utiliza a su vez formateadores para cada uno de los bloques
		// (este puede NO ser el caso de otras clases de formateo que pueden formatear todo "de una tacada",
		// como por ejemplo un formateador basado en XSL)
		prefs.formatterImpls.searchedRepositoriesFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchedRepositoriesResumeHtmlFormatter";
		prefs.formatterImpls.searchQueryFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchQueryHtmlFormatter";
		prefs.formatterImpls.searchGuideFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchGuideHtmlFormatter";
		prefs.formatterImpls.searchResultItemFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MSearchResultItemsThumbNailFormatter";
		//prefs.formatterImpls.searchResultsNavBarFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchResultsNavBarHtmlFormatter";
		prefs.formatterImpls.searchResultsNavBarFormatterClassName = "s12.buscadores.formatters.S12SearchResultsNavBarHtmlFormatter";

		// Mostrar o no alguna de las secciones de la query
		prefs.queryFormatterPreferences.showRepositoriesResume = false;			// Mostrar el resumen de repositorios sobre los que se ha buscado
  	prefs.queryFormatterPreferences.showStorageConditionsResume = false;	// Mostrar informacin sobre almacenamiento
		prefs.queryFormatterPreferences.showTypoConditionsResume = false;		// Mostrar informacin sobre tipologa
  	prefs.queryFormatterPreferences.showMetaDataConditionsResume = false;	// Mostrar informacin sobre meta-datos
		prefs.queryFormatterPreferences.showStructureLabelsConditionsResume = false;	// Mostrar informacin catalogacin en ejes
		prefs.queryFormatterPreferences.showGeoLabelsConditionsResume = false; 	// Mostrar informacin sobre catalogacin geogrficas
  	prefs.queryFormatterPreferences.showOrderByResume = false; 				// Mostrar informacin sobre meta-datos de ordenacin

		// Guas de navegacin
		prefs.guideFormatterPreferences.showGuideElementsSubTotals = false;	// Mostrar el nmero de resultados total para cada elemento de la gua
		//prefs.guideFormatterPreferences.guideType = R01MSearchGuideFormatterPreferences.GUIDE_COMBO;		// Mostrar la gua de navegacin como un combo
		//prefs.guideFormatterPreferences.guideColumnsNum = 3;// Nmero de columnas de la gua de navegacin
		// Barras de navegacin/paginacin por los resultados de un repositorio
		prefs.navBarFormatterPreferences.showSourceResultsNavBars = true;	// Mostrar las barras de paginacin por resultados
		prefs.resultsFormatterPreferences.showContentInfoInResultItem = true;	// Mostrar informacin sobre el contenido en cada item
		prefs.resultsFormatterPreferences.showDocumentInfoInResultItem = true;	// Mostrar informacin sobre el documento en cada item
		prefs.resultsFormatterPreferences.showDataFileInfoInResultItem = true;	// Mostrar informacin sobre el dataFile en cada item
		prefs.resultsFormatterPreferences.showCatalogInfoInResultItem = true;	// Mostrar informacin de catalogacin en cada item

		// Establecer la url base para los items
		//prefs.resultsFormatterPreferences.itemUrlBase = R01MConstants.URL_INTERNET;

		// Establecer la pgina en la que se muestran los resultados
		// Portal y pgina que contiene el rea visual donde se muestran el contenido cuando se pincha en un hit
		// Pasar el prefijo de las urls de los elementos resultado de la bsqueda
		// El prefijo es el portal-pag/idioma con el portal, la pgina y el idioma donde hay un rea visual
		// que contiene un contenedor de resultados de bsqueda
		//prefs.resultsFormatterPreferences.itemUrlPrefix = "x65-12375/" + language;
 		prefs.resultsFormatterPreferences.itemUrlPrefix = "aa30-12375/" + StringEscapeUtils.escapeHtml(language);  //nuevo portal (aunque tienen regla en Apache para redirigirlo si pone x65)

//		prefs.resultsFormatterPreferences.formatterAtributtes = new HashMap();
//		prefs.resultsFormatterPreferences.formatterAtributtes.put(R01MSearchEngineConstants.PRESENTATION_PROPERTY_THUMBNAILTYPE,"miniatura-8");
//	  	// #################### ESTO NO ES NECESARIO pero vale para ver como funciona

	  	request.setCharacterEncoding("UTF-8");
%>

<script>
	// Precarga de datos del filtro
	$("#tipoarchivo").attr("value", "<%= StringEscapeUtils.escapeJavaScript(tipoArchivoSesion) %>" || "");
	$("#seccion").attr("value", "<%= StringEscapeUtils.escapeJavaScript(seccionSesion) %>" || "");
	$("#dificultad").attr("value", "<%= StringEscapeUtils.escapeJavaScript(dificultadSesion) %>" || "");
	// Almacena la query en el campo hidden (aunque no vamos a utilizarlo en ningun mapa de Google Maps, nos sirve para depurar)
	$("#query").attr("value", "<%= queryStringSesion %>" || "");
</script>

<!-- Recomendacin: Pasar el objeto query UNICAMENTE en la primera llamada,
     en el resto (paginaciones) no enviarlo (enviar null)
     #tampoco pasa nada si se enva# -->
<div id="s12_CapaResultados">
	<div class="s12_titulo_resultado"><html:message i18nKey="s12Buscadores" key="general.resultadoBusqueda"/></div>
	<r01mTags:searchEngineSession query='<%=qry%>'
			    sessionFormatterPrefs='<%=prefs%>'
			    numberOfResultItemsPerPage="6"
			    returnAttachments="true"
			    cacheSearchSession="false"
			    serviceBaseURL="s12PortalWar/buscadoresJSP/buscadorBTT.jsp" />
</div>	