package s12.portalMovil.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.portalMovil.valueObjects.S12Aeropuerto;
import s12.portalMovil.valueObjects.S12Agenda;
import s12.portalMovil.valueObjects.S12Alojamiento;
import s12.portalMovil.valueObjects.S12Aquariums;
import s12.portalMovil.valueObjects.S12Artesania;
import s12.portalMovil.valueObjects.S12Casinos;
import s12.portalMovil.valueObjects.S12CentrosComerciales;
import s12.portalMovil.valueObjects.S12CentrosFormacion;
import s12.portalMovil.valueObjects.S12Circuito;
import s12.portalMovil.valueObjects.S12CompaniasTransporte;
import s12.portalMovil.valueObjects.S12Deportes;
import s12.portalMovil.valueObjects.S12Destinos;
import s12.portalMovil.valueObjects.S12EmpresaAlquilerDeportivo;
import s12.portalMovil.valueObjects.S12EmpresaRelacionada;
import s12.portalMovil.valueObjects.S12EmpresaTurismoActivo;
import s12.portalMovil.valueObjects.S12EspaciosNaturales;
import s12.portalMovil.valueObjects.S12EstacionesTransporte;
import s12.portalMovil.valueObjects.S12Experiencia;
import s12.portalMovil.valueObjects.S12Localidades;
import s12.portalMovil.valueObjects.S12MasInformacion;
import s12.portalMovil.valueObjects.S12MercadosTradicionales;
import s12.portalMovil.valueObjects.S12Museos;
import s12.portalMovil.valueObjects.S12NoTeLoPierdas;
import s12.portalMovil.valueObjects.S12Novedad;
import s12.portalMovil.valueObjects.S12Ofertas;
import s12.portalMovil.valueObjects.S12OficinasTurismo;
import s12.portalMovil.valueObjects.S12PalacioCongreso;
import s12.portalMovil.valueObjects.S12Parking;
import s12.portalMovil.valueObjects.S12ParquesTematicosAtracciones;
import s12.portalMovil.valueObjects.S12PatrimonioCultural;
import s12.portalMovil.valueObjects.S12PlatosTipicos;
import s12.portalMovil.valueObjects.S12Playas;
import s12.portalMovil.valueObjects.S12Playground;
import s12.portalMovil.valueObjects.S12PlazasToros;
import s12.portalMovil.valueObjects.S12Poi;
import s12.portalMovil.valueObjects.S12ProductosTierra;
import s12.portalMovil.valueObjects.S12ProgramasExperienciales;
import s12.portalMovil.valueObjects.S12Puertos;
import s12.portalMovil.valueObjects.S12RecintoFerial;
import s12.portalMovil.valueObjects.S12Restauracion;
import s12.portalMovil.valueObjects.S12Ruta;
import s12.portalMovil.valueObjects.S12TeatrosCines;
import s12.portalMovil.valueObjects.S12Tiendas;
import s12.portalMovil.valueObjects.S12TurismoSalud;
import s12.portalMovil.valueObjects.S12ViaVerde;
import s12.portalMovil.valueObjects.S12ZonasBaresPintxos;
import s12.portalMovil.valueObjects.S12ZonasTiendas;
import s12.util.S12Utils;

import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MSearchEngineSessionAPI;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 *  
 * 
 */
public class S12PortalMovilServlet extends HttpServlet {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 2797926232057947332L;

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "PORTAL_MOVIL";

	private static final String ALOJAMIENTO_A1 = "buscadorA1_alojamiento";
	private static final String RESTAURACION_B1 = "buscadorB1_gastronomia";
	private static final String AEROPUERTOS_C1 = "buscadorC1_aeropuertos"; // deprecado
	private static final String COMPANIAS_TRANSPORTE_C2 = "buscadorC2_companiasDeTransporte";
	private static final String ESTACIONES_TRANSPORTE_C3 = "buscadorC3_estacion";
	private static final String APARCAMIENTOS_C6 = "buscadorC6_aparcamientos";
	private static final String LOCALIDADES_D2 = "buscadorD2_localidades";
	private static final String DESTINOS_D3 = "buscadorD3_destinos";
	private static final String RUTAS_D4 = "buscadorD4_rutas"; // unido con D6 en portal, independiente en servlet.
	private static final String CIRCUITOS_D4 = "buscadorD4_circuitos"; // deprecado
	private static final String EXPERIENCIAS_D6 = "buscadorD6_experiencias"; // unido con D4 en portal, independiente en
																				// servlet.
	private static final String VIAS_VERDES_D7 = "buscadorD7_viasVerde"; // deprecado??????????????
	private static final String OFICINAS_TURISMO_E1 = "buscadorE1_oficinasDeTurismo";
	private static final String NO_TE_LO_PIERDAS_F1 = "buscadorF1_noTeLoPierdas"; // deprecado
	private static final String PLAYAS_G1 = "buscadorG1_playasEmbalsesRios";
	private static final String ESPACIOS_NATURALES_G2 = "buscadorG2_espaciosNaturales";
	private static final String ARTESANIA_H10 = "buscadorH10_artesania"; // deprecado
	private static final String TEATROS_CINES_H1 = "buscadorH1_teatrosYCines";
	private static final String MUSEOS_H4 = "buscadorH4_museos";
	private static final String PATRIMONIO_CULTURAL_H5 = "buscadorH5_patrimonioCultural";
	private static final String PUERTOS_H6 = "buscadorH6_puertosDeportivosYPesqueros";
	private static final String DEPORTES_I2 = "buscadorI2_deportes";
	private static final String EMPRESAS_ALQUILER_DEPORTIVO_I31 = "buscadorI31_empresasAlquilerDeportivo";
	private static final String EMPRESA_TURISMO_ACTIVO_I32 = "buscadorI32_empresasTurismoActivo";
	private static final String PLATOS_TIPICOS_J1 = "buscadorJ1_platosTipicos";
	private static final String PRODUCTOS_TIERRA_J2 = "buscadorJ2_productosDeLaTierra";
	private static final String CENTROS_FORMACION_J4 = "buscadorJ4_centrosDeFormacion"; // deprecado
	private static final String PLAZAS_TOROS_K1 = "buscadorK1_plazasDeToros"; // deprecado
	private static final String PARQUES_TEMATICOS_K3 = "buscadorK3_parquesTematicosAtracciones"; // deprecado
	private static final String AQUARIUMS_K5 = "buscadorK5_aquariums"; // deprecado
	private static final String CASINOS_K7 = "buscadorK7_casinos"; // deprecado
	private static final String ZONAS_BARES_PINTXOS_K8 = "buscadorK8_zonasBaresPintxos";
	private static final String ZONAS_TIENDAS_L1 = "buscadorL1_zonasTiendas"; // deprecado
	private static final String TIENDAS_L2 = "buscadorL2_tiendas";
	private static final String CENTROS_COMERCIALES_L3 = "buscadorL3_centrosComerciales";
	private static final String MERCADOS_TRADICIONALES_L4 = "buscadorL4_mercadosTradicionales"; // deprecado
	private static final String AGENDA_M1 = "buscadorM1_agenda";
	private static final String OFERTAS_M2 = "buscadorM2_ofertas";
	private static final String PALACIOSCONGRESO_N1 = "buscadorN1_palaciosCongresos"; // deprecado
	private static final String RECINTOS_FERIALES_N2 = "buscadorN2_recintosFeriales"; // deprecado
	private static final String EMPRESASRELACIONADAS_N3 = "buscadorN3_empresasRelacionadas"; // recuperado en 2016
	private static final String TURISMO_SALUD_N5 = "buscadorN5_turismoSalud"; // deprecado???????
	private static final String NOVEDADES_O1 = "buscadorO1_novedades";

	private static final String ZONAS_DESTACADAS = "zonasDestacadas";
	private static final String GET_POIS_NEAR_LOCATION = "getPOIsNearLocation";
	private static final String PROGRAMAS_EXPERIENCIALES = "s12ProgramasExperienciales";

	private static final String IMPORTANCIA_RECURSOS_PLAYGROUND = "1,2";

	private static final int LETRA_OCHO = 8;
	private static final int LETRA_NUEVE = 9;

	/**
	 * Constructor
	 */
	public S12PortalMovilServlet() {
		super();
	}

	/**
	 * The doGet method of the servlet.
	 * 
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	@Override
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		this.doPost(request, response);
	}

	/**
	 * The doPost method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * 
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 * @throws SecurityException the security exception
	 */
	@Override
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException,
			SecurityException {

		response.setContentType("application/json");
		PrintWriter out = response.getWriter();

		try {

			long time_start, time_end;
			time_start = System.currentTimeMillis();

			ArrayList<String> arrRecursos = new ArrayList<String>();
			// Mtodo al que se quiere invocar. Obligatorio.
			String metodo = request.getParameter("metodo");
			String idioma = request.getParameter("language");

			// Indica que buscador vamos a usar BBDD = Base de datos, LOTE3 = Indexador de lote 3
			String tipoBuscador = Q70ListenerUtils.getApplicationProperty("portal.movil.buscador");

			int numero_resultados = -1;
			int ultimo_resultado = -1;
			double latitud = S12Constantes.LATITUD_SIN_VALOR;
			double longitud = S12Constantes.LONGITUD_SIN_VALOR;
			double distanciaMax = S12Constantes.DISTANCIA_SIN_VALOR;

			// parmetros de paginacin
			try {
				if (request.getParameter("number_results") != null) {
					numero_resultados = Integer.parseInt(request.getParameter("number_results"));
				}
				if (request.getParameter("last_result") != null) {
					ultimo_resultado = Integer.parseInt(request.getParameter("last_result"));
				}
			} catch (NumberFormatException nfEx) {
				// Cuando los valores no son vlidos, establecemos valores por defecto para NO paginar.
				numero_resultados = -1;
				ultimo_resultado = -1;
			}
			// parmetros de ubicacin
			try {
				if (request.getParameter("u_latitude") != null && !"".equals(request.getParameter("u_latitude"))) {
					latitud = Double.parseDouble(request.getParameter("u_latitude"));
				}
				if (request.getParameter("u_longitude") != null && !"".equals(request.getParameter("u_longitude"))) {
					longitud = Double.parseDouble(request.getParameter("u_longitude"));
				}
				if (request.getParameter("distancia_max") != null && !"".equals(request.getParameter("distancia_max"))) {
					distanciaMax = Integer.parseInt(request.getParameter("distancia_max"));
				}
			} catch (NumberFormatException nfEx) {
				// Cuando los valores no son vlidos, establecemos valores por defecto para NO aplicar.
				latitud = S12Constantes.LATITUD_SIN_VALOR;
				longitud = S12Constantes.LONGITUD_SIN_VALOR;
				distanciaMax = S12Constantes.DISTANCIA_SIN_VALOR;
			}
			// correccion de valores invlidos para paginacin, a valores por defecto.
			if (numero_resultados <= 0)
				numero_resultados = 1000;
			if (ultimo_resultado < 0)
				ultimo_resultado = 0;

			if (S12PortalMovilServlet.ZONAS_DESTACADAS.equals(metodo)) {
				String zonaDestacada = request.getParameter("zona_destacada"); // Obligatorio

				out.println(this.getPlayground(zonaDestacada, idioma, latitud, longitud));
			} else if (S12PortalMovilServlet.GET_POIS_NEAR_LOCATION.equals(metodo)) {
				String categorias = request.getParameter("categories"); // Obligatorio

				out.println(this.getPoisNearLocation(categorias, idioma, latitud, longitud));

			} else if (S12PortalMovilServlet.PROGRAMAS_EXPERIENCIALES.equals(metodo)) {
				String codCapital = request.getParameter("capital");
				int viajarCon = -1;
				if (request.getParameter("viajarCon") != null && !"".equals(request.getParameter("viajarCon"))) {
					viajarCon = Integer.parseInt(request.getParameter("viajarCon"));
				}
				int interes = -1;
				if (request.getParameter("interes") != null && !"".equals(request.getParameter("interes"))) {
					interes = Integer.parseInt(request.getParameter("interes"));
				}
				int dias = -1;
				if (request.getParameter("dias") != null && !"".equals(request.getParameter("dias"))) {
					dias = Integer.parseInt(request.getParameter("dias"));
				}
				String original = request.getParameter("original");

				out.println(this.getProgramasExperienciales(codCapital, viajarCon, interes, dias, original, idioma,
						latitud, longitud));

			} else { // Buscadores
				if ("BBDD".equals(tipoBuscador)) { // Consulta inicial a base de datos
					arrRecursos = this.buscarRecursosBasedatosDistancia(request, metodo, latitud, longitud,
							numero_resultados, ultimo_resultado, distanciaMax);
				} else { // Consulta inicial a Lote 3

					List<R01MSearchResultItem> results = this.buscarRecursosGestorContenidos(request, metodo);

					if (results != null && results.size() > 0) {

						Iterator<R01MSearchResultItem> itElementos = results.iterator();

						while (itElementos.hasNext()) {
							R01MSearchResultItem resultado = itElementos.next();

							if (Q70Factoria.getTraza().isTraceActive()) {
								Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
										"Encontrado el recurso: " + resultado.getDocumentInternalName());
							}
							arrRecursos.add(resultado.getDocumentInternalName());
						}
					}
				}

				time_end = System.currentTimeMillis();
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(
							S12PortalMovilServlet.COMPONENTE,
							Q70TraceLevel.DEBUG,
							"Tiempo tras obtener arrRecursos de la VM...... " + (time_end - time_start)
									+ " milisegundos");
				}

				if (arrRecursos != null && arrRecursos.size() > 0) {
					// Se pinta el resultado en pantalla
					if (S12PortalMovilServlet.ALOJAMIENTO_A1.equals(metodo)) {
						String resultado = S12Alojamiento.getAlojamientosA1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado, distanciaMax);
						out.println(resultado);
						// out.println(S12Alojamiento.getAlojamientosA1(arrRecursos, idioma, latitud, longitud,
						// numero_resultados, ultimo_resultado));

						// para el caso de B1 - 0002 (Zonas de Pintxos) y K8
					} else if ((S12PortalMovilServlet.ZONAS_BARES_PINTXOS_K8.equals(metodo))
							|| (S12PortalMovilServlet.RESTAURACION_B1.equals(metodo)
									&& request.getParameter(S12Constantes.SF_RESTORATION_TYPE) != null && request
									.getParameter(S12Constantes.SF_RESTORATION_TYPE).equals(S12Constantes.PINTXOS))) {
						out.println(S12ZonasBaresPintxos.getZonasBaresPintxosK8(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));

						// para el caso de B1 - 0004 (Bares de Pintxos) y L2
					} else if (S12PortalMovilServlet.TIENDAS_L2.equals(metodo)
							|| (S12PortalMovilServlet.RESTAURACION_B1.equals(metodo)
									&& request.getParameter(S12Constantes.SF_RESTORATION_TYPE) != null && request
									.getParameter(S12Constantes.SF_RESTORATION_TYPE)
									.equals(S12Constantes.BARES_PINTXOS))) {
						out.println(S12Tiendas.getTiendasL2(arrRecursos, idioma, latitud, longitud, numero_resultados,
								ultimo_resultado));

					} else if (S12PortalMovilServlet.RESTAURACION_B1.equals(metodo)) {
						out.println(S12Restauracion.getRestauracionB1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado, distanciaMax));
					} else if (S12PortalMovilServlet.AEROPUERTOS_C1.equals(metodo)) {
						out.println(S12Aeropuerto.getAeropuertosC1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.COMPANIAS_TRANSPORTE_C2.equals(metodo)) {
						out.println(S12CompaniasTransporte.getCompaniasTransporteC2(arrRecursos, idioma, latitud,
								longitud, numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.ESTACIONES_TRANSPORTE_C3.equals(metodo)) {
						out.println(S12EstacionesTransporte.getEstacionesTransporteC3(arrRecursos, idioma, latitud,
								longitud, numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.APARCAMIENTOS_C6.equals(metodo)) {
						out.println(S12Parking.getParkingsC6(arrRecursos, idioma, latitud, longitud, numero_resultados,
								ultimo_resultado));
					} else if (S12PortalMovilServlet.LOCALIDADES_D2.equals(metodo)) {
						out.println(S12Localidades.getLocalidadesD2(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.DESTINOS_D3.equals(metodo)) {
						out.println(S12Destinos.getDestinosD3(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.RUTAS_D4.equals(metodo)) {
						out.println(S12Ruta.getRutasD4(arrRecursos, idioma, latitud, longitud, numero_resultados,
								ultimo_resultado));
					} else if (S12PortalMovilServlet.CIRCUITOS_D4.equals(metodo)) {
						out.println(S12Circuito.getCircuitosD4(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.EXPERIENCIAS_D6.equals(metodo)) {
						out.println(S12Experiencia.getExperienciasD6(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.VIAS_VERDES_D7.equals(metodo)) {
						out.println(S12ViaVerde.getViasVerdesD7(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.OFICINAS_TURISMO_E1.equals(metodo)) {
						out.println(S12OficinasTurismo.getOficinasE1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.NO_TE_LO_PIERDAS_F1.equals(metodo)) {
						out.println(S12NoTeLoPierdas.getNoTeLoPierdasF1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.PLAYAS_G1.equals(metodo)) {
						out.println(S12Playas.getPlayasG1(arrRecursos, idioma, latitud, longitud, numero_resultados,
								ultimo_resultado));
					} else if (S12PortalMovilServlet.ESPACIOS_NATURALES_G2.equals(metodo)) {
						out.println(S12EspaciosNaturales.getEspaciosNaturalesG2(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.ARTESANIA_H10.equals(metodo)) {
						out.println(S12Artesania.getArtesaniaH10(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.TEATROS_CINES_H1.equals(metodo)) {
						out.println(S12TeatrosCines.getTeatrosCinesH1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.MUSEOS_H4.equals(metodo)) {
						out.println(S12Museos.getMuseosH4(arrRecursos, idioma, latitud, longitud, numero_resultados,
								ultimo_resultado));
					} else if (S12PortalMovilServlet.PATRIMONIO_CULTURAL_H5.equals(metodo)) {
						out.println(S12PatrimonioCultural.getPatrimoniosCulturalesH5(arrRecursos, idioma, latitud,
								longitud, numero_resultados, ultimo_resultado));

						// para el caso de H6 - 1004 (Puertos Deportivos) y I2
					} else if ((S12PortalMovilServlet.DEPORTES_I2.equals(metodo))
							|| S12PortalMovilServlet.PUERTOS_H6.equals(metodo)
							&& request.getParameter(S12Constantes.SF_TIPO) != null
							&& request.getParameter(S12Constantes.SF_TIPO).equals(S12Deportes.TIPO_RECURSO)) {
						out.println(S12Deportes.getDeportesI2(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));

					} else if (S12PortalMovilServlet.PUERTOS_H6.equals(metodo)) {
						out.println(S12Puertos.getPuertosH6(arrRecursos, idioma, latitud, longitud, numero_resultados,
								ultimo_resultado));
					} else if (S12PortalMovilServlet.EMPRESAS_ALQUILER_DEPORTIVO_I31.equals(metodo)) {
						out.println(S12EmpresaAlquilerDeportivo.getEmpresasAlquilerDeportivoI31(arrRecursos, idioma,
								latitud, longitud, numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.EMPRESA_TURISMO_ACTIVO_I32.equals(metodo)) {
						out.println(S12EmpresaTurismoActivo.getEmpresaTurismoActivoI32(arrRecursos, idioma, latitud,
								longitud, numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.PLATOS_TIPICOS_J1.equals(metodo)) {
						out.println(S12PlatosTipicos.getPlatosTipicosJ1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.PRODUCTOS_TIERRA_J2.equals(metodo)) {
						out.println(S12ProductosTierra.getProductosTierraJ2(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.CENTROS_FORMACION_J4.equals(metodo)) {
						out.println(S12CentrosFormacion.getCentrosFormacionJ4(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.PLAZAS_TOROS_K1.equals(metodo)) {
						out.println(S12PlazasToros.getPlazasTorosK1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.PARQUES_TEMATICOS_K3.equals(metodo)) {
						out.println(S12ParquesTematicosAtracciones.getParquesTematicosAtraccionesK3(arrRecursos,
								idioma, latitud, longitud, numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.AQUARIUMS_K5.equals(metodo)) {
						out.println(S12Aquariums.getAquariumsK5(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.CASINOS_K7.equals(metodo)) {
						out.println(S12Casinos.getCasinosK7(arrRecursos, idioma, latitud, longitud, numero_resultados,
								ultimo_resultado));
					} else if (S12PortalMovilServlet.ZONAS_TIENDAS_L1.equals(metodo)) {
						out.println(S12ZonasTiendas.getZonasTiendasL1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.CENTROS_COMERCIALES_L3.equals(metodo)) {
						out.println(S12CentrosComerciales.getCentrosComercialesL3(arrRecursos, idioma, latitud,
								longitud, numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.MERCADOS_TRADICIONALES_L4.equals(metodo)) {
						out.println(S12MercadosTradicionales.getMercadosTradicionalesL4(arrRecursos, idioma, latitud,
								longitud, numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.AGENDA_M1.equals(metodo)) {
						out.println(S12Agenda.getAgendaM1(arrRecursos, idioma, latitud, longitud, numero_resultados,
								ultimo_resultado, distanciaMax));
					} else if (S12PortalMovilServlet.OFERTAS_M2.equals(metodo)) {
						out.println(S12Ofertas.getOfertasM2(arrRecursos, idioma, latitud, longitud, numero_resultados,
								ultimo_resultado));
					} else if (S12PortalMovilServlet.PALACIOSCONGRESO_N1.equals(metodo)) {
						out.println(S12PalacioCongreso.getPalacioCongresoN1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.RECINTOS_FERIALES_N2.equals(metodo)) {
						out.println(S12RecintoFerial.getRecintoFerialN2(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.EMPRESASRELACIONADAS_N3.equals(metodo)) {
						out.println(S12EmpresaRelacionada.getEmpresaRelacionadaN3(arrRecursos, idioma, latitud,
								longitud, numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.TURISMO_SALUD_N5.equals(metodo)) {
						out.println(S12TurismoSalud.getTurismoSaludN5(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else if (S12PortalMovilServlet.NOVEDADES_O1.equals(metodo)) {
						out.println(S12Novedad.getNovedadesO1(arrRecursos, idioma, latitud, longitud,
								numero_resultados, ultimo_resultado));
					} else {
						out.println("[]");
						if (Q70Factoria.getTraza().isTraceActive()) {
							Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
									"El metodo recibido no esta reconocido: ... " + metodo);
						}
					}
				} else {
					out.println("[]");
				}
			}

			time_end = System.currentTimeMillis();
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(
						S12PortalMovilServlet.COMPONENTE,
						Q70TraceLevel.DEBUG,
						"Proceso TOTAL del servlet completado en .......... " + (time_end - time_start)
								+ " milisegundos");
			}

		} catch (SecurityException sEx) {
			sEx.printStackTrace();
			out.println("A la primera nunca va");
		} catch (Exception ex) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.ERROR,
						"Error al procesar los resultados ...........Error:" + ex.getMessage());
			}
			throw new ServletException("Error en S12PortalMovilServlet: doPost: ", ex);
		} finally {
			out.flush();
			out.close();
		}
	}

	/**
	 * Funcin para obtener los datos de un Playground.
	 * 
	 * @param playground nombre del playground
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * 
	 * @return datos del Playground
	 */
	private String getPlayground(String playground, String idioma, double latitud, double longitud) {
		// Se crea la zona destacada
		S12Playground aPlayground = new S12Playground();
		aPlayground.setCoordenadas(S12Constantes.getCoordenadasPlayGround(playground));

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();
		try {
			// Obtenemos todos los recursos que pueden aparecer en un playground. Importancia 1 y 2.
			ArrayList<S12Poi> recursosImportantes = portalMovilDAO.getRecursosImportantes(idioma,
					S12PortalMovilServlet.IMPORTANCIA_RECURSOS_PLAYGROUND, latitud, longitud);

			// Aadimos al playground solo aquellos recursos que estn dentro de los lmites del playground
			aPlayground.setPoisInPlayground(recursosImportantes);
		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.ERROR,
						"Error al buscar los recursos importantes en base de datos ...........Error:" + e.getMessage());
			}
		}

		return aPlayground.toJSONString();
	}

	/**
	 * Funcin para obtener los pois filtrados por tipo
	 * 
	 * @param categorias String Tipos de recursos a filtrar separados por ','. Formato:
	 *            tipoRecurso_subTipoRecurso_Categoria. Ejemplo: A1_H_1,B1_1,C2_
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * 
	 * @return listado de pois
	 */
	private String getPoisNearLocation(String categorias, String idioma, double latitud, double longitud) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			// Se obtiene todos los pois que cumplen los criterios de categoria
			ArrayList<S12Poi> poisList = portalMovilDAO.getPoisNearLocation(idioma, categorias, latitud, longitud);

			sRespuesta.append(new JSONArray(poisList).toString());
		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.ERROR,
						"Error al buscar los POIs en base de datos ...........Error:" + e.getMessage());
			}
			sRespuesta.append("[]");
		}

		return sRespuesta.toString();
	}

	/**
	 * Funcin para obtener los programas experienciales.
	 * 
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param viajarCon the viajar con
	 * @param interes the interes
	 * @param dias the dias
	 * @param original the original
	 * @param codCapital the cod capital
	 * 
	 * @return listado de programas experienciales
	 */
	private String getProgramasExperienciales(String codCapital, int viajarCon, int interes, int dias, String original,
			String idioma, double latitud, double longitud) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			String codigoProvincia = codCapital.substring(0, 2);
			String codigoCapital = codCapital.substring(0, 6);
			String nombreCapital = "";
			if ("01".equals(codigoProvincia)) {
				nombreCapital = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
						"progrExperienciales.capital_" + codigoProvincia + "_2", idioma);
			} else {
				nombreCapital = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
						"progrExperienciales.capital_" + codigoProvincia, idioma);
			}

			String mensaje = "";
			if (dias == 1) {
				mensaje = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
						"progrExperienciales.diaEn", idioma);
				if ("01".equals(codigoProvincia) && "eu".equals(idioma)) {
					mensaje = mensaje.replaceAll("##DIA##", String.valueOf(dias)).replaceAll("##CAPITAL##",
							nombreCapital + "e");
				} else {
					mensaje = mensaje.replaceAll("##DIA##", String.valueOf(dias)).replaceAll("##CAPITAL##",
							nombreCapital);
				}
			} else {
				mensaje = dias
						+ " "
						+ Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
								"progrExperienciales.variosDiasEn", idioma);
				if ("01".equals(codigoProvincia) && "eu".equals(idioma)) {
					mensaje = mensaje.replaceAll("##CAPITAL##", nombreCapital + "e");
				} else {
					mensaje = mensaje.replaceAll("##CAPITAL##", nombreCapital);
				}
			}

			S12ProgramasExperienciales programaExperiencial = new S12ProgramasExperienciales();
			programaExperiencial.setTitulo(mensaje);

			// se obtiene los enlaces segn la capital
			programaExperiencial.setEnlaces(portalMovilDAO.getEnlacesCapital(codCapital, idioma));

			// Se obtiene todos los Programas Experienciales que cumplen los criterios
			programaExperiencial.setDias(portalMovilDAO.getDiasProgrExperienciales(codCapital, viajarCon, interes,
					dias, original, idioma, latitud, longitud));

			// se obtienen Ms Informacin
			programaExperiencial.setMasInformacion(S12MasInformacion.getMasInformacion(codigoCapital, codigoProvincia,
					nombreCapital, idioma));

			sRespuesta.append(programaExperiencial.toJSONString());
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilServlet::getProgramasExperienciales: Exception: " + e.getMessage());
			}
		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(
						S12PortalMovilServlet.COMPONENTE,
						Q70TraceLevel.ERROR,
						"Error al buscar los Programas Experienciales en base de datos ...........Error:"
								+ e.getMessage());
			}
			sRespuesta.append("[]");
		} catch (NullPointerException e){
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(
						S12PortalMovilServlet.COMPONENTE,
						Q70TraceLevel.ERROR,
						"Error al buscar los Programas Experienciales en la llamada ...........Error:"
								+ e.getMessage());
			}
			sRespuesta.append("[]");
		}

		return sRespuesta.toString();
	}

	/**
	 * Buscar recursos de la base de datos.
	 * 
	 * @param request request
	 * @param metodo mtodo a ejecutar
	 * 
	 * @return resultados de bsqueda
	 */
	private ArrayList<String> buscarRecursosBasedatosDistancia(HttpServletRequest request, String metodo,
			double latOrigen, double longOrigen, int numero_resultados, int ultimo_resultado, double distanciaMax) {
		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();
		ArrayList<String> recursos = new ArrayList<String>();

		try {
//			if (ALOJAMIENTO_A1.equals(metodo)){
				ArrayList<Object> params = new ArrayList<Object>();
				ArrayList<Integer> tiposSQL = new ArrayList<Integer>();
				String sqlWhere = this.crearConsultaSqlConPrepare(request, params, tiposSQL);
				recursos = portalMovilDAO.getRecursosBaseDatosDistanciaConPrepare(sqlWhere, params, tiposSQL, 
						latOrigen, longOrigen, numero_resultados, ultimo_resultado, distanciaMax);
//			} else {
//				String sqlWhere = this.crearConsultaSql(request);
//				recursos = portalMovilDAO.getRecursosBaseDatosDistancia(sqlWhere, latOrigen, longOrigen, numero_resultados,
//						ultimo_resultado, distanciaMax);
//			}
		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.ERROR,
						"Error al buscar los recursos en base de datos ...........Error:" + e.getMessage());
			}
		}

		return recursos;
	}

	/**
	 * Buscar recursos gestor contenidos.
	 * 
	 * @param request request
	 * @param metodo mtodo a ejecutar
	 * 
	 * @return resultados de bsqueda
	 */
	private List<R01MSearchResultItem> buscarRecursosGestorContenidos(HttpServletRequest request, String metodo) {

		// Recogida de parmetros del mtodo
		String idioma = request.getParameter("language"); // Obligatorio

		/** CONFIGURACION GESTOR CONTENIDOS **/

		String server = "";
		List<R01MSearchResultItem> results = new ArrayList<R01MSearchResultItem>();
		try {
			// Parmetros del Gestor de Contenidos
			server = Q70ListenerUtils.getApplicationProperty("iw.storeLocation.server");
			String repository = Q70ListenerUtils.getApplicationProperty("iw.storeLocation.dataRepository");
			String area = Q70ListenerUtils.getApplicationProperty("iw.storeLocation.area");
			String workArea = Q70ListenerUtils.getApplicationProperty("iw.storeLocation.workArea");
			String cluster = Q70ListenerUtils.getApplicationProperty("iw.typology.cluster");
			String family = Q70ListenerUtils.getApplicationProperty("iw.typology.family");
			String familyAgenda = Q70ListenerUtils.getApplicationProperty("iw.typology.family.agenda");
			String familyNoticia = Q70ListenerUtils.getApplicationProperty("iw.typology.family.noticia");

			// Se crea la query que se va a aplicar
			R01MQueryObject qry = new R01MQueryObject();
			qry.addServer(server);
			qry.addDataRepository(server, repository);
			qry.addArea(server, repository, area);
			qry.addWorkArea(server, repository, area, workArea);
			qry.addContentCluster(cluster);

			// Variable que cambia segn el tipo de recurso a buscar
			if (metodo.equals(S12PortalMovilServlet.AGENDA_M1) || metodo.equals(S12PortalMovilServlet.OFERTAS_M2)) {
				qry.addContentFamily(familyAgenda);
			} else if (metodo.equals(S12PortalMovilServlet.NOVEDADES_O1)) {
				qry.addContentFamily(familyNoticia);
			} else {
				qry.addContentFamily(family);
			}

			// Mtodo que aade los metadatos de bsqueda a la query
			qry.setMetaData(this.crearMetaData(request));

			// Se aaden los metadatos de ordenacin a la query
			List<R01MSearchedOrderByMetaData> metaDataOrder = new ArrayList<R01MSearchedOrderByMetaData>();

			if (S12PortalMovilServlet.EXPERIENCIAS_D6.equals(metodo)) {
				metaDataOrder.add(new R01MSearchedOrderByMetaData("pubTargets_Inter", "DESC"));
			} else if (S12PortalMovilServlet.AGENDA_M1.equals(metodo)) {
				metaDataOrder.add(new R01MSearchedOrderByMetaData("importance", "ASC"));
				metaDataOrder.add(new R01MSearchedOrderByMetaData("eventSearchDate1", "DESC"));
			} else if (S12PortalMovilServlet.OFERTAS_M2.equals(metodo)) {
				metaDataOrder.add(new R01MSearchedOrderByMetaData("documentCreateDate", "DESC"));
			} else if (S12PortalMovilServlet.NOVEDADES_O1.equals(metodo)) {
				metaDataOrder.add(new R01MSearchedOrderByMetaData("commDate", "DESC"));
			} else {
				metaDataOrder.add(new R01MSearchedOrderByMetaData(S12Constantes.SF_DOCUMENT_NAME, "ASC"));
			}

			qry.setOrderBy(metaDataOrder);

			// Comprobamos si es B1, y como subTipo 0002(Zona Pintxos), cambiamos el valor de 'metodo'
			String letraFamilia = "";
			if (metodo.equals(S12PortalMovilServlet.RESTAURACION_B1)
					&& request.getParameter(S12Constantes.SF_RESTORATION_TYPE) != null
					&& request.getParameter(S12Constantes.SF_RESTORATION_TYPE).equals(S12Constantes.PINTXOS)) {

				metodo = S12PortalMovilServlet.ZONAS_BARES_PINTXOS_K8;
				letraFamilia = metodo.substring(S12PortalMovilServlet.LETRA_OCHO, S12PortalMovilServlet.LETRA_NUEVE);

			} else if (metodo.equals(S12PortalMovilServlet.RESTAURACION_B1)
					&& request.getParameter(S12Constantes.SF_RESTORATION_TYPE) != null
					&& request.getParameter(S12Constantes.SF_RESTORATION_TYPE).equals(S12Constantes.BARES_PINTXOS)) {
				// Comprobamos si es B1, y como subTipo 0004(Bares de Pintxos), cambiamos el valor de 'metodo'
				metodo = S12PortalMovilServlet.TIENDAS_L2;
				letraFamilia = metodo.substring(S12PortalMovilServlet.LETRA_OCHO, S12PortalMovilServlet.LETRA_NUEVE);
			} else if (metodo.equals(S12PortalMovilServlet.PUERTOS_H6)
					&& request.getParameter(S12Constantes.SF_TIPO) != null
					&& request.getParameter(S12Constantes.SF_TIPO).equals(S12Deportes.TIPO_RECURSO)) {

				metodo = S12PortalMovilServlet.DEPORTES_I2;
				letraFamilia = metodo.substring(S12PortalMovilServlet.LETRA_OCHO, S12PortalMovilServlet.LETRA_NUEVE);

			} else {
				letraFamilia = metodo.substring(S12PortalMovilServlet.LETRA_OCHO, S12PortalMovilServlet.LETRA_NUEVE);
			}

			qry.addContentType(S12Constantes.getContentType(letraFamilia));

			qry.setPublishedItemsOnly(true);
			qry.setReturnDocuments(false);
			qry.setReturnDataFiles(false);

			// Indica que no queremos paginar los resultados
			// qry.setAllResultsInAPage(true);

			// Esto indica que es una query nueva
			// Necesario incluirlo, si no siempre se ejecuta la query con el mismo idioma
			qry.setModified(true);
			// //////////

			// Crear la API de bsqueda.
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> Antes de obtener R01MSearchEngineSessionAPI <<<<<<<<<<<<<<<<<<<<");
			}

			R01MSearchEngineSessionAPI apiSesion = R01MClientFactory.getSearchEngineSessionAPI();

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> Despus de obtener R01MSearchEngineSessionAPI <<<<<<<<<<<<<<<<<<<<");
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> Antes de crear R01MSearchSession <<<<<<<<<<<<<<<<<<<<");
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> Parmetros del createSession <<<<<<<<<<<<<<<<<<<<");
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> sessionLang: " + idioma + " <<<<<<<<<<<<<<<<<<<<");
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> qry: " + qry.composeDebugInfo() + " <<<<<<<<<<<<<<<<<<<<");
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> lazyInit: false <<<<<<<<<<<<<<<<<<<<");
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> cacheResults: false <<<<<<<<<<<<<<<<<<<<");
				Q70Factoria.getTraza().trace(
						S12PortalMovilServlet.COMPONENTE,
						Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> qry string: " + R01MSearchEngineUtils.encodeQueryObjectInURL(qry)
								+ " <<<<<<<<<<<<<<<<<<<<");
			}

			R01MSearchSession sesion = apiSesion.createSession(idioma, qry, false, false);

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> Despus de crear R01MSearchSession <<<<<<<<<<<<<<<<<<<<");
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> Antes de obtener los resultados de bsqueda <<<<<<<<<<<<<<<<<<<<");
			}

			results = sesion.getTotalPagesAndSourcesSearchResultItems();

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						">>>>>>>>>>>>>>>>>>>>> Despus de obtener los resultados de bsqueda <<<<<<<<<<<<<<<<<<<<");
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						"Datos de la query " + qry.composeDebugInfo());
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
						"Se han obtenido " + (results != null ? results.size() : 0) + " resultados");
			}
		} catch (SecurityException sEx) {
			throw new SecurityException();
		} catch (Exception ex) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.ERROR,
						"Error al cargar el servidor " + server + "...........Error:" + ex.getMessage());
			}
			ex.printStackTrace();
		}

		/** FIN CONFIGURACION GESTOR CONTENIDOS **/

		return results;
	}

	/**
	 * Funcin que crea los metadatos para pasar a la query del lote 3.
	 * 
	 * @param request the request
	 * 
	 * @return lista de metadatos
	 */
	private List<R01MSearchedMetaData> crearMetaData(HttpServletRequest request) {
		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		String metodo = request.getParameter("metodo");

		if ((S12PortalMovilServlet.ALOJAMIENTO_A1.equals(metodo))) { // Alojamiento
			metaData = S12Alojamiento.crearMetaDataA1(request);
		} else if ((S12PortalMovilServlet.RESTAURACION_B1.equals(metodo))) { // Restauracin
			metaData = S12Restauracion.crearMetaDataB1(request);
		} else if ((S12PortalMovilServlet.AEROPUERTOS_C1.equals(metodo))) { // Aeropuertos
			metaData = S12Aeropuerto.crearMetaDataC1(request);
		} else if ((S12PortalMovilServlet.COMPANIAS_TRANSPORTE_C2.equals(metodo))) { // Compaias Transporte
			metaData = S12CompaniasTransporte.crearMetaDataC2(request);
		} else if ((S12PortalMovilServlet.ESTACIONES_TRANSPORTE_C3.equals(metodo))) { // Estaciones Transporte
			metaData = S12EstacionesTransporte.crearMetaDataC3(request);
		} else if ((S12PortalMovilServlet.APARCAMIENTOS_C6.equals(metodo))) { // Parkings
			metaData = S12Parking.crearMetaDataC6(request);
		} else if ((S12PortalMovilServlet.LOCALIDADES_D2.equals(metodo))) { // Localidades
			metaData = S12Localidades.crearMetaDataD2(request);
		} else if ((S12PortalMovilServlet.DESTINOS_D3.equals(metodo))) { // Destinos
			metaData = S12Destinos.crearMetaDataD3(request);
		} else if ((S12PortalMovilServlet.RUTAS_D4.equals(metodo))) { // Rutas
			metaData = S12Ruta.crearMetaDataD4(request);
		} else if ((S12PortalMovilServlet.CIRCUITOS_D4.equals(metodo))) { // Circuitos
			metaData = S12Circuito.crearMetaDataD4(request);
		} else if ((S12PortalMovilServlet.EXPERIENCIAS_D6.equals(metodo))) { // Experiencias Top
			metaData = S12Experiencia.crearMetaDataD6(request);
		} else if ((S12PortalMovilServlet.VIAS_VERDES_D7.equals(metodo))) { // Vas Verdes
			metaData = S12ViaVerde.crearMetaDataD7(request);
		} else if ((S12PortalMovilServlet.OFICINAS_TURISMO_E1.equals(metodo))) { // Oficinas de Turismo
			metaData = S12OficinasTurismo.crearMetaDataE1(request);
		} else if ((S12PortalMovilServlet.NO_TE_LO_PIERDAS_F1.equals(metodo))) { // No Te Lo Pierdas
			metaData = S12NoTeLoPierdas.crearMetaDataF1(request);
		} else if ((S12PortalMovilServlet.PLAYAS_G1.equals(metodo))) { // Playas, Embalses y Ros
			metaData = S12Playas.crearMetaDataG1(request);
		} else if ((S12PortalMovilServlet.ESPACIOS_NATURALES_G2.equals(metodo))) { // Espacios Naturales
			metaData = S12EspaciosNaturales.crearMetaDataG2(request);
		} else if ((S12PortalMovilServlet.ARTESANIA_H10.equals(metodo))) { // Artesana
			metaData = S12Artesania.crearMetaDataH10(request);
		} else if ((S12PortalMovilServlet.TEATROS_CINES_H1.equals(metodo))) { // Teatros y Cines
			metaData = S12TeatrosCines.crearMetaDataH1(request);
		} else if ((S12PortalMovilServlet.MUSEOS_H4.equals(metodo))) { // Museos
			metaData = S12Museos.crearMetaDataH4(request);
		} else if ((S12PortalMovilServlet.PATRIMONIO_CULTURAL_H5.equals(metodo))) { // Patrimonio Cultural
			metaData = S12PatrimonioCultural.crearMetaDataH5(request);
		} else if ((S12PortalMovilServlet.PUERTOS_H6.equals(metodo))) { // Puertos
			metaData = S12Puertos.crearMetaDataH6(request);
		} else if ((S12PortalMovilServlet.DEPORTES_I2.equals(metodo))) { // Deportes
			metaData = S12Deportes.crearMetaDataI2(request);
		} else if ((S12PortalMovilServlet.EMPRESAS_ALQUILER_DEPORTIVO_I31.equals(metodo))) { // Empresas de Alquiler
																								// Deportivo
			metaData = S12EmpresaAlquilerDeportivo.crearMetaDataI31(request);
		} else if ((S12PortalMovilServlet.EMPRESA_TURISMO_ACTIVO_I32.equals(metodo))) { // Deportes
			metaData = S12EmpresaTurismoActivo.crearMetaDataI32(request);
		} else if ((S12PortalMovilServlet.PLATOS_TIPICOS_J1.equals(metodo))) { // Platos Tpicos
			metaData = S12PlatosTipicos.crearMetaDataJ1(request);
		} else if ((S12PortalMovilServlet.PRODUCTOS_TIERRA_J2.equals(metodo))) { // Productos de la Tierra
			metaData = S12ProductosTierra.crearMetaDataJ2(request);
		} else if ((S12PortalMovilServlet.CENTROS_FORMACION_J4.equals(metodo))) { // Centros de Formacin
			metaData = S12CentrosFormacion.crearMetaDataJ4(request);
		} else if ((S12PortalMovilServlet.PLAZAS_TOROS_K1.equals(metodo))) { // Plazas de Toros
			metaData = S12PlazasToros.crearMetaDataK1(request);
		} else if ((S12PortalMovilServlet.PARQUES_TEMATICOS_K3.equals(metodo))) { // Parques Temticos o de Atracciones
			metaData = S12ParquesTematicosAtracciones.crearMetaDataK3(request);
		} else if ((S12PortalMovilServlet.AQUARIUMS_K5.equals(metodo))) { // Aquariums
			metaData = S12Aquariums.crearMetaDataK5(request);
		} else if ((S12PortalMovilServlet.CASINOS_K7.equals(metodo))) { // Casinos
			metaData = S12Casinos.crearMetaDataK7(request);
		} else if ((S12PortalMovilServlet.ZONAS_BARES_PINTXOS_K8.equals(metodo))) { // Zonas de Bares y Pintxos
			metaData = S12ZonasBaresPintxos.crearMetaDataK8(request);
		} else if ((S12PortalMovilServlet.ZONAS_TIENDAS_L1.equals(metodo))) { // Zonas de Tiendas
			metaData = S12ZonasTiendas.crearMetaDataL1(request);
		} else if ((S12PortalMovilServlet.CENTROS_COMERCIALES_L3.equals(metodo))) { // Centros Comerciales
			metaData = S12CentrosComerciales.crearMetaDataL3(request);
		} else if ((S12PortalMovilServlet.MERCADOS_TRADICIONALES_L4.equals(metodo))) { // Mercados Tradicionales
			metaData = S12MercadosTradicionales.crearMetaDataL4(request);
		} else if ((S12PortalMovilServlet.AGENDA_M1.equals(metodo))) { // Agenda
			metaData = S12Agenda.crearMetaDataM1(request);
		} else if ((S12PortalMovilServlet.OFERTAS_M2.equals(metodo))) { // Ofertas
			metaData = S12Ofertas.crearMetaDataM2(request);
		} else if ((S12PortalMovilServlet.PALACIOSCONGRESO_N1.equals(metodo))) { // Palacios de Congreso
			metaData = S12PalacioCongreso.crearMetaDataN1(request);
		} else if ((S12PortalMovilServlet.RECINTOS_FERIALES_N2.equals(metodo))) { // Recintos Feriales
			metaData = S12RecintoFerial.crearMetaDataN2(request);
		} else if ((S12PortalMovilServlet.EMPRESASRELACIONADAS_N3.equals(metodo))) { // Oficinas de Turismo
			metaData = S12EmpresaRelacionada.crearMetaDataN3(request);
		} else if ((S12PortalMovilServlet.TURISMO_SALUD_N5.equals(metodo))) { // Turismo Salud
			metaData = S12TurismoSalud.crearMetaDataN5(request);
		} else if ((S12PortalMovilServlet.NOVEDADES_O1.equals(metodo))) { // Novedades
			metaData = S12Novedad.crearMetaDataO1(request);
		} else if ((S12PortalMovilServlet.TIENDAS_L2.equals(metodo))) { // Tiendas
			metaData = S12Tiendas.crearMetaDataL2(request);
		}

		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_DOCUMENT_LANGUAGE,
				R01MSearchEngineConstants.EQUALS_OPERATOR, request.getParameter("language")));

		return metaData;

	}

	private String crearConsultaSqlConPrepare(HttpServletRequest request, ArrayList<Object> params, ArrayList<Integer> tiposSQL ) {
		StringBuffer sql = new StringBuffer();

		String metodo = request.getParameter("metodo");

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG,
					"crearConsultaSql. metodo = " + metodo);
		}

		if ((S12PortalMovilServlet.ALOJAMIENTO_A1.equals(metodo))) { // Alojamiento
			sql.append(S12Alojamiento.prepararSqlA1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.ZONAS_BARES_PINTXOS_K8.equals(metodo))) {
			sql.append(S12ZonasBaresPintxos.prepararSqlK8(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.RESTAURACION_B1.equals(metodo))) { // Restauracin
			sql.append(S12Restauracion.prepararSqlB1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.AEROPUERTOS_C1.equals(metodo))) { // Aeropuertos
			sql.append(S12Aeropuerto.prepararSqlC1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.COMPANIAS_TRANSPORTE_C2.equals(metodo))) { // Compaias Transporte
			sql.append(S12CompaniasTransporte.prepararSqlC2(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.ESTACIONES_TRANSPORTE_C3.equals(metodo))) { // Estaciones Transporte
			sql.append(S12EstacionesTransporte.prepararSqlC3(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.APARCAMIENTOS_C6.equals(metodo))) { // Parkings
			sql.append(S12Parking.prepararSqlC6(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.LOCALIDADES_D2.equals(metodo))) { // Localidades
			sql.append(S12Localidades.prepararSqlD2(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.DESTINOS_D3.equals(metodo))) { // Destinos
			sql.append(S12Destinos.prepararSqlD3(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.RUTAS_D4.equals(metodo))) { // Rutas
			sql.append(S12Ruta.prepararSqlD4(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.CIRCUITOS_D4.equals(metodo))) { // Circuitos
			sql.append(S12Circuito.prepararSqlD4(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.EXPERIENCIAS_D6.equals(metodo))) { // Experiencias Top
			sql.append(S12Experiencia.prepararSqlD6(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.VIAS_VERDES_D7.equals(metodo))) { // Vas Verdes
			sql.append(S12ViaVerde.prepararSqlD7(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.OFICINAS_TURISMO_E1.equals(metodo))) { // Oficinas de Turismo
			sql.append(S12OficinasTurismo.prepararSqlE1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.NO_TE_LO_PIERDAS_F1.equals(metodo))) { // No Te Lo Pierdas
			sql.append(S12NoTeLoPierdas.prepararSqlF1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.PLAYAS_G1.equals(metodo))) { // Playas, Embalses y Ros
			sql.append(S12Playas.prepararSqlG1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.ESPACIOS_NATURALES_G2.equals(metodo))) { // Espacios Naturales
			sql.append(S12EspaciosNaturales.prepararSqlG2(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.ARTESANIA_H10.equals(metodo))) { // Artesana
			sql.append(S12Artesania.prepararSqlH10(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.TEATROS_CINES_H1.equals(metodo))) { // Teatros y Cines
			sql.append(S12TeatrosCines.prepararSqlH1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.MUSEOS_H4.equals(metodo))) { // Museos
			sql.append(S12Museos.prepararSqlH4(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.PATRIMONIO_CULTURAL_H5.equals(metodo))) { // Patrimonio Cultural
			sql.append(S12PatrimonioCultural.prepararSqlH5(request,params,tiposSQL));
		} else if (S12PortalMovilServlet.DEPORTES_I2.equals(metodo)) {
			sql.append(S12Deportes.prepararSqlI2(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.EMPRESA_TURISMO_ACTIVO_I32.equals(metodo))) { // Puertos
			sql.append(S12EmpresaTurismoActivo.prepararSqlI32(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.PUERTOS_H6.equals(metodo))) { // Puertos
			sql.append(S12Puertos.prepararSqlH6(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.EMPRESAS_ALQUILER_DEPORTIVO_I31.equals(metodo))) { // Empresas de Alquiler Deportivo
			sql.append(S12EmpresaAlquilerDeportivo.prepararSqlI31(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.PLATOS_TIPICOS_J1.equals(metodo))) { // Platos Tpicos
			sql.append(S12PlatosTipicos.prepararSqlJ1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.PRODUCTOS_TIERRA_J2.equals(metodo))) { // Productos de la Tierra
			sql.append(S12ProductosTierra.prepararSqlJ2(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.CENTROS_FORMACION_J4.equals(metodo))) { // Centros de Formacin
			sql.append(S12CentrosFormacion.prepararSqlJ4(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.PLAZAS_TOROS_K1.equals(metodo))) { // Plazas de Toros
			sql.append(S12PlazasToros.prepararSqlK1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.PARQUES_TEMATICOS_K3.equals(metodo))) { // Parques Temticos o de Atracciones
			sql.append(S12ParquesTematicosAtracciones.prepararSqlK3(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.AQUARIUMS_K5.equals(metodo))) { // Aquariums
			sql.append(S12Aquariums.prepararSqlK5(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.CASINOS_K7.equals(metodo))) { // Casinos
			sql.append(S12Casinos.prepararSqlK7(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.ZONAS_TIENDAS_L1.equals(metodo))) { // Zonas de Tiendas
			sql.append(S12ZonasTiendas.prepararSqlL1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.CENTROS_COMERCIALES_L3.equals(metodo))) { // Centros Comerciales
			sql.append(S12CentrosComerciales.prepararSqlL3(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.MERCADOS_TRADICIONALES_L4.equals(metodo))) { // Mercados Tradicionales
			sql.append(S12MercadosTradicionales.prepararSqlL4(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.AGENDA_M1.equals(metodo))) { // Agenda
			sql.append(S12Agenda.prepararSqlM1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.OFERTAS_M2.equals(metodo))) { // Ofertas
			sql.append(S12Ofertas.prepararSqlM2(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.PALACIOSCONGRESO_N1.equals(metodo))) { // Palacios de Congreso
			sql.append(S12PalacioCongreso.prepararSqlN1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.RECINTOS_FERIALES_N2.equals(metodo))) { // Recintos Feriales
			sql.append(S12RecintoFerial.prepararSqlN2(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.EMPRESASRELACIONADAS_N3.equals(metodo))) { // Oficinas de Turismo
			sql.append(S12EmpresaRelacionada.prepararSqlN3(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.TURISMO_SALUD_N5.equals(metodo))) { // Turismo Salud
			sql.append(S12TurismoSalud.prepararSqlN5(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.NOVEDADES_O1.equals(metodo))) { // Novedades
			sql.append(S12Novedad.prepararSqlO1(request,params,tiposSQL));
		} else if ((S12PortalMovilServlet.TIENDAS_L2.equals(metodo))) { // Tiendas
			sql.append(S12Tiendas.prepararSqlL2(request,params,tiposSQL));
		}

		return sql.toString();

	}
	
	/**
	 * Utilidad para tracear toda la lista de parmetros recibidos en la request
	 * 
	 * @param request
	 */
	@SuppressWarnings({ "unchecked", "unused" })
	private void trazasRequest(HttpServletRequest request) {
		if (Q70Factoria.getTraza().isTraceActive()) {
			Enumeration<String> nombres = request.getParameterNames();
			while (nombres.hasMoreElements()) {
				String parametro = nombres.nextElement();
				String valor = request.getParameter(parametro);
				S12Utils.trazaLarga(S12PortalMovilServlet.COMPONENTE, Q70TraceLevel.DEBUG, parametro.concat(" = ")
						.concat(valor));
			}
		}
		return;
	}
}
