package s12.buscadorText.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;

import s12.buscadorText.dao.S12BuscadorTextDAO;
import s12.buscadorText.dao.S12BuscadorTextDaoException;
import s12.buscadorText.valueObjects.S12RecursoBuscadorText;
import s12.constantes.S12Constantes;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 *  
 * 
 */
public class S12BuscadorTextServlet extends HttpServlet {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 2797926232057947332L;

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "BUSCADOR_TEXT";

	
	/**
	 * Constructor
	 */
	public S12BuscadorTextServlet() {
		super();
	}

	/**
	 * The doGet method of the servlet.
	 * 
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	@Override
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		this.doPost(request, response);
	}

	/**
	 * The doPost method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * 
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 * @throws SecurityException the security exception
	 */
	@Override
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException,
			SecurityException {

		response.setContentType("application/json");
		PrintWriter out = response.getWriter();

		try {

			

			ArrayList<S12RecursoBuscadorText> arrRecursos = new ArrayList<S12RecursoBuscadorText>();
			// M�todo al que se quiere invocar. Obligatorio.
			String texto = request.getParameter("texto");
			String idioma = request.getParameter("language");

			

			int numero_resultados = -1;
			int ultimo_resultado = -1;
			

			// par�metros de paginaci�n
			try {
				if (request.getParameter("number_results") != null) {
					numero_resultados = Integer.parseInt(request.getParameter("number_results"));
				}
				if (request.getParameter("last_result") != null) {
					ultimo_resultado = Integer.parseInt(request.getParameter("last_result"));
				}
			} catch (NumberFormatException nfEx) {
				// Cuando los valores no son v�lidos, establecemos valores por defecto para NO paginar.
				numero_resultados = -1;
				ultimo_resultado = -1;
			}
			
			// correccion de valores inv�lidos para paginaci�n, a valores por defecto.
			if (numero_resultados <= 0)
				numero_resultados = 1000;
			if (ultimo_resultado < 0)
				ultimo_resultado = 0;

			
					arrRecursos = this.buscarRecursosOracleText( texto, idioma, 
							numero_resultados, ultimo_resultado);
				
				

				if (arrRecursos != null && arrRecursos.size() > 0) {					
						String resultado = this.devolverDatos( arrRecursos, texto, idioma);
						out.println(resultado);
				}else{
					StringBuffer sRespuesta = new StringBuffer();
					sRespuesta.append(new JSONArray(new ArrayList<S12RecursoBuscadorText>()).toString());
					out.println(sRespuesta.toString());
				}
				

		} catch (Exception ex) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscadorTextServlet.COMPONENTE, Q70TraceLevel.ERROR,
						"Error al procesar los resultados ...........Error:" + ex.getMessage());
			}
			throw new ServletException("Error en S12PortalMovilServlet: doPost: ", ex);
		} finally {
			out.flush();
			out.close();
		}
	}
	
	private String devolverDatos(ArrayList<S12RecursoBuscadorText> arrRecursos, String texto, String idioma) {
		StringBuffer sRespuesta = new StringBuffer();
		S12BuscadorTextDAO buscadorTextDAO = new S12BuscadorTextDAO();
		
		ArrayList<S12RecursoBuscadorText> arrRecursosDevolver = new ArrayList<S12RecursoBuscadorText>();
		
		try {
				
			for(S12RecursoBuscadorText recurso:arrRecursos){
				recurso = buscadorTextDAO.findDatosRecurso(recurso.getCodigoRecurso(), idioma);
				// buscar municipios con enlace
				recurso.setEnlacesMunicipio(buscadorTextDAO.findEnlacesMunicipio(recurso.getCodigoRecurso(), idioma));
				// devolver los textos de la tipologia
				recurso.setDescTipologia( Q70GestorMensajesi18n.getSingleton().getMessage("s12BuscadorText",
						"tipologia_" + recurso.getCodigoTipologia(), idioma));
				//devolver url amigable recurso, 
				//si es de tipo D5, devuelvo la url del primer D4 que encuentre
				if(recurso.getCodigoTipologia().equalsIgnoreCase(S12Constantes.ETAPAS)){
					Long sRecursoRuta = buscadorTextDAO.findRutaEtapa(recurso.getCodigoRecurso());
					recurso.setUrlAmigable(buscadorTextDAO.findUrlAmigable(sRecursoRuta, idioma));
				}else{					
					recurso.setUrlAmigable(buscadorTextDAO.findUrlAmigable(recurso.getCodigoRecurso(), idioma));
				}
				//devolver tipo plantilla para rutas y etapas
				if(recurso.getCodigoTipologia().equalsIgnoreCase(S12Constantes.RUTAS) ){
					recurso.setTipoPlantillaRuta(buscadorTextDAO.findTipoPlantillaRuta(recurso.getCodigoRecurso(), idioma));
				}else{
					if(recurso.getCodigoTipologia().equalsIgnoreCase(S12Constantes.ETAPAS)){
						recurso.setTipoPlantillaRuta(buscadorTextDAO.findTipoPlantillaEtapa(recurso.getCodigoRecurso(), idioma));						
					}else{
						recurso.setTipoPlantillaRuta("");
					}
				}
				arrRecursosDevolver.add(recurso);
	
			}

			sRespuesta.append(new JSONArray(arrRecursosDevolver).toString());
		} catch (Exception e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscadorTextServlet.COMPONENTE, Q70TraceLevel.ERROR,
						"Error al buscar los POIs en base de datos ...........Error:" + e.getMessage());
			}
			sRespuesta.append("[]");
		}

		return sRespuesta.toString();
	}
	private ArrayList<S12RecursoBuscadorText> buscarRecursosOracleText(String texto, String idioma, 
			int numero_resultados, int ultimo_resultado) {
		S12BuscadorTextDAO buscadorTextDAO = new S12BuscadorTextDAO();
		ArrayList<S12RecursoBuscadorText> recursos = new ArrayList<S12RecursoBuscadorText>();

		try {
				recursos = buscadorTextDAO.getRecursosOracleText(texto, idioma, numero_resultados,
					ultimo_resultado);
		} catch (S12BuscadorTextDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12BuscadorTextServlet.COMPONENTE, Q70TraceLevel.ERROR,
						"Error al buscar los recursos en base de datos ...........Error:" + e.getMessage());
			}
		}

		return recursos;
	}

	}
