 /* Created on 4-nov-2005
 *
 */
package s12.valueObjects.newsletter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

import s12.valueObjects.newsletter.S12Newsletter;
import bilbofrmk.exceptions.BPersistenceException;
import bilbofrmk.valueObjects.BBasePersistence;
import bilbofrmk.valueObjects.BBaseValueObject;

/**
 *  
 *
 */
public class S12NewsletterPersistence extends BBasePersistence { // NO_UCD

	private static final int SIZE_STRINGBUFFER = 120;

	/**
	 * Update object.
	 *
	 * @return null
	 *
	 * @throws BPersistenceException the b persistence exception
	 */
	protected BBaseValueObject updateObject() throws BPersistenceException {
		return null;
	}

	/**
	 * Creates the object.
	 *
	 * @return the b base value object
	 *
	 * @throws BPersistenceException the b persistence exception
	 */
	protected BBaseValueObject createObject() throws BPersistenceException {

		S12Newsletter newsletter =(S12Newsletter)objetoPesistible;

		StringBuffer strInsert = new StringBuffer(S12NewsletterPersistence.SIZE_STRINGBUFFER);
		strInsert.append("INSERT INTO S12_FORMULARIO");
		strInsert.append(" (NOMBRE, EMAIL, PROVINCIA, CREATION, APELLIDOS, PAIS, IDIOMA, TIPO, SEXO, PHP_LIST, BORRADO)");
		strInsert.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?)");

		ArrayList up0 = new ArrayList();
		ArrayList parameters = new ArrayList();


		parameters.add(newsletter.getNombre());
		parameters.add(newsletter.getEmail());
		parameters.add(newsletter.getProvincia());
		parameters.add(new Timestamp(new java.util.Date().getTime()));
		parameters.add(newsletter.getApellido());
		parameters.add(newsletter.getPais());
		parameters.add(newsletter.getIdioma());
		parameters.add(newsletter.getTipo());
		parameters.add(newsletter.getSexo());
		parameters.add(newsletter.getErrorPhpList());
		if(newsletter.isBorrado()){
			parameters.add("S");
		}else{
			parameters.add("N");
		}


		up0.add(parameters);
		super.doStatement(strInsert.toString(),up0);

		return newsletter;
	}

	/**
	 *
	 * @return the b base value object
	 *
	 * @throws BPersistenceException the b persistence exception
	 */
	protected BBaseValueObject deleteObject() throws BPersistenceException {
		S12Newsletter newsletter =(S12Newsletter)objetoPesistible;

		StringBuffer strDelete = new StringBuffer(S12NewsletterPersistence.SIZE_STRINGBUFFER);
		strDelete.append("UPDATE S12_FORMULARIO SET");
		strDelete.append(" BORRADO = 'S'");
		strDelete.append(" WHERE EMAIL = ?");

		ArrayList parameters = new ArrayList();
		ArrayList up0 = new ArrayList();
		up0.add(newsletter.getEmail());
		parameters.add(up0);

		super.doStatement(strDelete.toString(),parameters);

		return newsletter;
	}

	/**
	 *
	 * @return the object by id
	 *
	 * @throws BPersistenceException the b persistence exception
	 */
	protected BBaseValueObject getObjectById() throws BPersistenceException {
		S12Newsletter newsletter =(S12Newsletter)objetoPesistible;
		StringBuffer strSelect = new StringBuffer(S12NewsletterPersistence.SIZE_STRINGBUFFER);

		strSelect.append("Select DNI,NOMBRE,EMAIL,TFNO,DIRECCION,POBLACION,PROVINCIA,CREATION,APELLIDOS,PAIS,IDIOMA,TIPO,SEXO,PHP_LIST,BORRADO");
		strSelect.append(" FROM S12_FORMULARIO WHERE EMAIL = ? AND IDIOMA = ?");

		ArrayList parameters = new ArrayList();
		parameters.add(newsletter.getEmail());
		parameters.add(newsletter.getIdioma());

		super.doQuery(strSelect.toString(), parameters);
		return newsletter;
	}

	/**
	 *
	 * @param rs the rs
	 *
	 * @throws SQLException the SQL exception
	 * @throws BPersistenceException the b persistence exception
	 *
	 */
	protected void loadObject(ResultSet rs) throws SQLException,
			BPersistenceException {
			S12Newsletter newsletter =(S12Newsletter)objetoPesistible;
			if(rs.next()){
				newsletter.setNombe(rs.getString("NOMBRE"));
				newsletter.setEmail(rs.getString("EMAIL"));
				newsletter.setTelefono(rs.getString("TFNO"));
				newsletter.setDireccion(rs.getString("DIRECCION"));
				newsletter.setPoblacion(rs.getString("POBLACION"));
				newsletter.setProvincia(rs.getString("PROVINCIA"));
				newsletter.setCreation(rs.getDate("CREATION"));
				newsletter.setApellido(rs.getString("APELLIDOS"));
				newsletter.setPais(rs.getString("PAIS"));
				newsletter.setIdioma(rs.getString("IDIOMA"));
				newsletter.setTipo(rs.getString("TIPO"));
				newsletter.setSexo(rs.getString("SEXO"));
				newsletter.setErrorPhpList(rs.getString("PHP_LIST"));
				String borrado = rs.getString("BORRADO");
				if(!"S".equals(borrado)){
					newsletter.setBorrado(false);
				}else{
					newsletter.setBorrado(true);
				}
			}
			else{
				throw new BPersistenceException("Newsletter no encontrado");
			}
	}

}
