 /* Created on 4-nov-2005
 *
 */
package s12.valueObjects.logotipos;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

import bilbofrmk.exceptions.BObjectNotFoundException;
import bilbofrmk.exceptions.BPersistenceException;
import bilbofrmk.valueObjects.BBasePersistence;
import bilbofrmk.valueObjects.BBaseValueObject;

/**
 *  
 *
 */
public class S12SolicitudLogotipoPersistence extends BBasePersistence { // NO_UCD

	private static final int SIZE_STRINGBUFFER = 120;

	/**
	 * Update object.
	 *
	 * @return null
	 *
	 * @throws BPersistenceException the b persistence exception
	 */
	protected BBaseValueObject updateObject() throws BPersistenceException {
		return null;
	}

	/**
	 * @return the b base value object
	 *
	 * @throws BPersistenceException the b persistence exception
	 *
	 * @see bilbofrmk.valueObjects.BBasePersistence#createObject()
	 */
	protected BBaseValueObject createObject() throws BPersistenceException {
		S12SolicitudLogotipo solicitud  =(S12SolicitudLogotipo)objetoPesistible;

		StringBuffer strInsert = new StringBuffer(S12SolicitudLogotipoPersistence.SIZE_STRINGBUFFER);

		strInsert.append("INSERT INTO S12_SOLICITUD_LOGOTIPO");
		strInsert.append(" (CODSOLICITUD, FECHAENVIO, ENTIDAD, RESPONSABLE, TELEFONO, EMAIL, APLICACIONES, TAMANO, FONDO, IDIOMAS, SUGERENCIAS)");
		strInsert.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?)");

		ArrayList up0 = new ArrayList();
		ArrayList parameters = new ArrayList();

		Long codSolicitud = this.getNextVal("S1213Q00");
		solicitud.setId(codSolicitud.longValue());

		parameters.add(codSolicitud);
		parameters.add(new Timestamp(new java.util.Date().getTime()));
		parameters.add(solicitud.getEntidad());
		parameters.add(solicitud.getResponsable());
		parameters.add(solicitud.getTelefono());
		parameters.add(solicitud.getEmail());
		parameters.add(solicitud.getAplicaciones());
		parameters.add(solicitud.getTamano());
		parameters.add(solicitud.getFondo());
		parameters.add(solicitud.getIdiomas());
		parameters.add(solicitud.getSugerencias());
		up0.add(parameters);

		super.doStatement(strInsert.toString(),up0);

		return solicitud;
	}


	/**
	 *
	 * @return the b base value object
	 *
	 * @throws BPersistenceException the b persistence exception
	 */
	protected BBaseValueObject deleteObject() throws BPersistenceException {
		return null;
	}

	/**
	 *
	 * @return the object by id
	 *
	 * @throws BPersistenceException the b persistence exception
	 */
	protected BBaseValueObject getObjectById() throws BPersistenceException {
		S12SolicitudLogotipo solicitud  =(S12SolicitudLogotipo)objetoPesistible;

		StringBuffer strSelect = new StringBuffer(S12SolicitudLogotipoPersistence.SIZE_STRINGBUFFER);

		strSelect.append("SELECT CODSOLICITUD, FECHAENVIO, ENTIDAD, RESPONSABLE, TELEFONO, EMAIL, APLICACIONES, TAMANO, FONDO, IDIOMAS, SUGERENCIAS");
		strSelect.append(" FROM S12_SOLICITUD_LOGOTIPO");
		strSelect.append(" WHERE CODSOLICITUD = ?");

		ArrayList parameters = new ArrayList();
		parameters.add(new Long(solicitud.getId()));

		super.doQuery(strSelect.toString(),parameters);

		return solicitud;
	}

	/**
	 *
	 * @param rs the rs
	 *
	 * @throws SQLException the SQL exception
	 * @throws BPersistenceException the b persistence exception
	 *
	 */
	protected void loadObject(ResultSet rs) throws SQLException, BPersistenceException {
		S12SolicitudLogotipo solicitud =(S12SolicitudLogotipo)objetoPesistible;

		if(!rs.next()){
			throw new BObjectNotFoundException("No existe el objeto tema: " + solicitud.getId());
		}
		solicitud.setFechaEnvio(rs.getDate("FECHAENVIO"));
		solicitud.setEntidad(rs.getString("ENTIDAD"));
		solicitud.setResponsable(rs.getString("RESPONSABLE"));
		solicitud.setTelefono(rs.getString("TELEFONO"));
		solicitud.setEmail(rs.getString("EMAIL"));
		solicitud.setAplicaciones(rs.getString("APLICACIONES"));
		solicitud.setTamano(rs.getString("TAMANO"));
		solicitud.setFondo(rs.getString("FONDO"));
		solicitud.setIdiomas(rs.getString("IDIOMAS"));
		solicitud.setSugerencias(rs.getString("SUGERENCIAS"));
	}

}
