package s12.valueObjects;

import s12.s12PersistenceService.S12PersistenceServiceHome;
import s12.s12PersistenceService.S12PersistenceServiceObject;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import es.ejie.frmk.negocio.adaptadorinvocacion.Q70FactoriaEJBHome;
import bilbofrmk.context.BIContext;
import bilbofrmk.exceptions.BPersistenceException;
import bilbofrmk.valueObjects.BBaseValueObject;

/**
 *  
 *
 */
public class S12PersistenceSrv {

	public static final String GETOBJECTBYID = "0";
	public static final String CREATEOBJECT = "1";
	public static final String UPDATEOBJECT = "2";
	public static final String DELETEOBJECT = "3";

	/**
	 * Do persistence.
	 *
	 * @param appContex the app contex
	 * @param oPersist the o persist
	 * @param op the op
	 *
	 * @return the b base value object
	 *
	 * @throws BPersistenceException the b persistence exception
	 */
	public static BBaseValueObject doPersistence(BIContext appContex,BBaseValueObject oPersist, String op) throws BPersistenceException {
		try {
			S12PersistenceServiceHome serviceHome  = (S12PersistenceServiceHome)Q70FactoriaEJBHome.getSingleton().getHome("s12.S12PersistenceServiceEJB");
			S12PersistenceServiceObject service = serviceHome.create();
			BBaseValueObject valueObject = service.doPersist(appContex,oPersist,op);

			return valueObject;

		} catch (NamingException e) {
			throw new BPersistenceException("Error de nombrado del servicio de Peristencia",e);
		} catch (ClassCastException e) {
			return S12PersistenceSrv.classicCall(appContex,oPersist,op);
		} catch (CreateException e) {
			throw new BPersistenceException("Error creando del servicio de Peristencia",e);
		} catch (RemoteException e) {
			throw new BPersistenceException("Error del servicio de Peristencia",e.getCause());
		}
	}

	/**
	 * Classic call.
	 *
	 * @param appContex the app contex
	 * @param oPersist the o persist
	 * @param op the op
	 *
	 * @return the b base value object
	 *
	 * @throws BPersistenceException the b persistence exception
	 */
	private static BBaseValueObject classicCall(BIContext appContex,BBaseValueObject oPersist, String op) throws BPersistenceException {

		try {
			Context context = new InitialContext();
			S12PersistenceServiceHome serviceHome  = (S12PersistenceServiceHome)context.lookup("s12.S12PersistenceServiceEJB");
			S12PersistenceServiceObject service = serviceHome.create();

			return service.doPersist(appContex,oPersist,op);
		} catch (NamingException e) {
			throw new BPersistenceException("Error de nombrado del servicio de persistencia",e);
		} catch (ClassCastException e) {
			throw new BPersistenceException("Error de creacin del servicio de persistencia",e);
		} catch (CreateException e) {
			throw new BPersistenceException("Error creando del servicio de persistencia",e);
		} catch (RemoteException e) {
			throw new BPersistenceException("Error del servicio de persistencia",e.getCause());
		} catch (Throwable t) {
			throw new BPersistenceException("Error del servicio de persistencia",t.getCause());
		}
	}

	/**
	 * Instantiates a new s12 persistence srv.
	 */
	private S12PersistenceSrv() {

	}
}
