package s12.layar.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import s12.layar.dao.S12LayarDAO;
import s12.layar.valueObjects.S12LayarRaiz;
import bilbofrmk.util.BLogger;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 *
 *  
 *
 * Servlet que implementa el servicio REST para las llamadas GetPOIs desde Layar.
 *
 */
public class S12LayarServlet extends HttpServlet {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	private static final int SIZE_STRINGBUFFER = 400;
	private static final String COMPONENTE = "LAYAR";
	private final static String LAYER_NAME = Q70ListenerUtils.getApplicationProperty("LAYER_NAME");

	/**
	 * Constructor of the object.
	 */
	public S12LayarServlet() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
	}

	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 *
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {

		StringBuffer strMensaje = new StringBuffer(S12LayarServlet.SIZE_STRINGBUFFER);
		String resultado = "";
    	if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12LayarServlet.COMPONENTE, Q70TraceLevel.DEBUG,"S12LayarServlet::doGet: INICIO ");
		}

    	//trazas de parmetros recibidos
    	strMensaje.append("Valores recibidos:\n");
    	Map map = request.getParameterMap();
    	Iterator iter = map.entrySet().iterator();
    	while (iter.hasNext()){
    		Map.Entry entry = (Map.Entry)iter.next();
    		String name = (String)entry.getKey();
    		String[] values = (String[])entry.getValue();
    		strMensaje.append(name).append(" = [");
    		for ( int i = 0 ; i < values.length ; ++i ) {
    			if(i>0){
    				strMensaje.append(",");
    			}
    			strMensaje.append(values[i]);
    		}
    		strMensaje.append("]\n");
    	}
    	if (Q70Factoria.getTraza().isTraceActive()) {
        	Q70Factoria.getTraza().trace(S12LayarServlet.COMPONENTE, Q70TraceLevel.DEBUG,"S12LayarServlet::doGet: PARAMS ==== " + strMensaje.toString());
    	}
    	BLogger.blog(BLogger.DEBUG,"S12LayarServlet::doGet: PARAMS ==== " + strMensaje.toString());

		//recogida de valores de sesin
		String idioma = (String)request.getSession().getAttribute("language");
		String categoria = (String)request.getSession().getAttribute("category");

    	if (Q70Factoria.getTraza().isTraceActive()) {
			strMensaje = new StringBuffer(S12LayarServlet.SIZE_STRINGBUFFER);
			strMensaje.append("idioma = ").append(idioma);
			strMensaje.append(" , categoria = ").append(categoria);
			Q70Factoria.getTraza().trace(S12LayarServlet.COMPONENTE, Q70TraceLevel.DEBUG,"S12LayarServlet::doGet: SESION ==== " + strMensaje);
		}

		try {
			resultado = this.getPOIs(request);
			//Layar no soporta tags HTML para los textos, los eliminamos.
			resultado = this.eliminarHTML(resultado);
//			resultado = StringEscapeUtils.escapeJavaScript(resultado);

		} catch (Exception e) {
			/**
			 * NOTA SOBRE ERRORES:
			 * Cuando el servicio provoca ServletException, Layar recibe un error 500 y muestra al usuario el mensaje "No content available".
			 * Es una funcionalidad suficiente, salvo que queramos personalizar el mensaje al idioma en uso por ejemplo.
			 * En ese caso habra que implementar la gestin de errores devolviendo
			 * valores en las propiedades errorCode y errorString de la respuesta JSON.
			 */
			//TODO gestion de errores
	    	BLogger.blog(BLogger.DEBUG,"S12LayarServlet::doGet: ERROR ==== " + e.toString());

			throw new ServletException();
		}

		response.setContentType("application/json; charset=utf-8");
		PrintWriter out = response.getWriter();
		out.print(resultado);
		out.flush();
		out.close();
		response.setContentType("application/json; charset=utf-8");
    	if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12LayarServlet.COMPONENTE, Q70TraceLevel.DEBUG,"S12LayarServlet::doGet: FIN");
		}
	}

	/**
	 * Elimina los tags HTML de un String
	 * @param texto String de entrada
	 * @return String de salida sin tags HTML
	 */
	private String eliminarHTML(String texto) {
		String textoSinHTML = texto.replaceAll("\\<.*?\\>", "");
		return textoSinHTML;
	}

	/**
	 *
	 * @param request La request
	 * @return Respuesta JSON
	 * @throws Exception error
	 */
	private String getPOIs(HttpServletRequest request) throws Exception {
		S12LayarDAO layarDAO = new S12LayarDAO();
		S12LayarRaiz layarRaiz = null;

		String longitud = request.getParameter("lon");
		String latitud = request.getParameter("lat");
		String distancia = request.getParameter("radius");
		//para el idioma debe prevalecer el valor que est en sesin.
		String idioma = (String) request.getSession().getAttribute("language");
		if (idioma==null){
			idioma = request.getParameter("lang");
		}
		//para el filtro por categora prevalecer si viene valor para multicat, si no, el valor de sesion y si no, TODAS.
		String codCategoria = request.getParameter("multicat");
		if (codCategoria==null){
			codCategoria = (String) request.getSession().getAttribute("category");
		}
		if (codCategoria==null){
			codCategoria = "0";
		}

		//Condicion para tests:
		String layerName = request.getParameter("layerName");
		if (layerName != null && !layerName.equalsIgnoreCase(S12LayarServlet.LAYER_NAME)){
			//si el nombre de la capa no es el del properties, es un test:
			int resultados = 0;
			try {
				resultados = Integer.parseInt(request.getParameter("resultados"));
			} catch (NumberFormatException e) {
				resultados = 0;
			}
			layarRaiz = layarDAO.getPOIs(latitud, longitud, distancia, codCategoria, idioma, resultados);
			layarRaiz.setLayer(layerName);
		} else {
			layarRaiz = layarDAO.getPOIs(latitud, longitud, distancia, codCategoria, idioma, 0);
		}
    	if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12LayarServlet.COMPONENTE, Q70TraceLevel.DEBUG,"S12LayarServlet::getPOIs: SIN encodeUTF: " + layarRaiz.toJSONString());
		}
    	if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12LayarServlet.COMPONENTE, Q70TraceLevel.DEBUG,"S12LayarServlet::getPOIs: CON encodeUTF: " + com.ejie.r01f.util.StringUtils.encodeUTF(layarRaiz.toJSONString()));
		}

		return layarRaiz.toJSONString();
	}

	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 *
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {

		response.setContentType("text/html");
		PrintWriter out = response.getWriter();
		out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
		out.println("<HTML>");
		out.println("  <HEAD><TITLE>A Servlet</TITLE></HEAD>");
		out.println("  <BODY>");
		out.print("    This is ");
		out.print(this.getClass());
		out.println(", using the POST method");
		out.println("  </BODY>");
		out.println("</HTML>");
		out.flush();
		out.close();
	}

	/**
	 * Initialization of the servlet. <br>
	 *
	 * @throws ServletException if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
