package s12.layar.servlet;

import java.util.ArrayList;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import s12.constantes.S12Constantes;
import s12.layar.dao.S12LayarDAO;
import s12.layar.valueObjects.S12LayarDatos;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 *
 *  
 *
 */
public class S12LayarDatosServlet extends HttpServlet {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	private static final int DIEZ_CARACTERES = 10;
	private static final String COMPONENTE = "LAYAR";

	/**
	 * Constructor of the object.
	 */
	public S12LayarDatosServlet() {
		super();
	}



	/**
	 * The doGet method of the servlet.
	 *
	 * This method is called when a form has its tag value method equals to get.
	 *
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)	throws ServletException {
		this.doPost(request, response);
	}


	/**
	 * The doPost method of the servlet.
	 *
	 * This method is called when a form has its tag value method equals to post.
	 *
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {

		String pageForward = "";
		String codigoRecurso = "";

		if(request.getParameter("codRec")!=null){
			codigoRecurso = request.getParameter("codRec");
		}

		String idioma = "";
		if(request.getParameter("lang")!=null){
			idioma = request.getParameter("lang");
		}

		S12LayarDAO layarDAO = new S12LayarDAO();
		ArrayList arMultimedia = new ArrayList();
		ArrayList arMultimediaCas = new ArrayList();

		try{
			if (request.getParameter("galeria")!=null){
				pageForward = "/layarJSP/s12Galeria.jsp";

				String tipoRecurso = "";
				String nombreCompleto = "";
				S12LayarDatos datosLayar = new S12LayarDatos();

				//buscamos los datos del recurso
				datosLayar = layarDAO.getDatosLayar(codigoRecurso, idioma);

				if (datosLayar.getTitulo() != null && !datosLayar.getTitulo().equals("")){
					tipoRecurso = datosLayar.getTipoRecurso();
					request.setAttribute("datosLayar", datosLayar);

					//buscamos los multimedia del recurso(los del idioma de ejecucin y los de castellano)
					ArrayList arMultimediaCompleto = new ArrayList();
					arMultimedia = layarDAO.getMultimediaLayar(codigoRecurso, idioma);
					arMultimediaCas = layarDAO.getMultimediaLayar(codigoRecurso, S12Constantes.IDIOMA_ES);

					arMultimediaCompleto = this.generarRutaMultimedia(arMultimedia, arMultimediaCas, codigoRecurso, tipoRecurso, idioma);
					request.setAttribute("arMultimediaCompleto", arMultimediaCompleto);


					nombreCompleto = this.generarNombreCompleto(datosLayar, idioma);
					request.setAttribute("nombreCompleto", nombreCompleto.toString().toUpperCase());

				}else{
					//no existe informacin para ese recurso en el idioma seleccionado
					request.setAttribute("noInformacion", "true");
				}

			}else{
				pageForward = "/layarJSP/s12InformacionLayar.jsp";

				S12LayarDatos datosLayar = new S12LayarDatos();
				datosLayar = layarDAO.getDatosLayar(codigoRecurso, idioma);

				//comprobamos que tiene resultados(nombre) para mostrar en la pantalla
				if (datosLayar.getTitulo() != null && !"".equals(datosLayar.getTitulo())){
					//si tiene foto asociada, le generamos la ruta completa
					if (datosLayar.getFoto() != null && !"".equals(datosLayar.getFoto())){
						arMultimedia.add(datosLayar.getFoto());
						arMultimediaCas.add(datosLayar.getFoto());
						arMultimedia = this.generarRutaMultimedia(arMultimedia, arMultimediaCas, codigoRecurso, datosLayar.getTipoRecurso(), S12Constantes.IDIOMA_ES);
						datosLayar.setFoto((String)arMultimedia.get(0));
					}else{
						//buscamos los multimedia del recurso(los del idioma de ejecucin y los de castellano)
						arMultimedia = layarDAO.getMultimediaLayar(codigoRecurso, idioma);
						arMultimediaCas = layarDAO.getMultimediaLayar(codigoRecurso, S12Constantes.IDIOMA_ES);
						if (arMultimediaCas.size() > 0){
							arMultimedia = this.generarRutaMultimedia(arMultimedia, arMultimediaCas, codigoRecurso, datosLayar.getTipoRecurso(), idioma);
							datosLayar.setFoto((String)arMultimedia.get(0));
						}
					}

					request.setAttribute("datosLayar", datosLayar);
				}
			}

		} catch (Exception e) {
			throw new ServletException( "Error en S12LayarDatosServlet: doPost: ", e );
		}


		this.forwardJSP(request,response,pageForward);
	}


	/**
   * Forward jsp.
   *
   * @param request the request
   * @param response the response
   * @param page the page
   *
   * @throws ServletException the servlet exception
   */
  public void forwardJSP(HttpServletRequest request, HttpServletResponse response, String page) throws ServletException
  {
    try {
      ServletContext ctx = this.getServletContext();

      RequestDispatcher dispatcher = ctx.getRequestDispatcher( page );
      if (dispatcher == null) {
        throw new ServletException( "No dispatcher found for " + page );
      }
      dispatcher.forward( request, response );

      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12LayarDatosServlet.COMPONENTE, Q70TraceLevel.DEBUG, "S12LayarDatosServlet:: Fin");
      }
    }
    catch (Exception e) {
      e.printStackTrace();
      throw new ServletException( "Failed to process request", e );
    }

  }


  /**
   * Generar ruta multimedia.
   *
   * @param arMultimedia the ar multimedia
   * @param arMultimediaEs the ar multimedia es
   * @param codigo the codigo
   * @param tipoRecurso the tipo recurso
   * @param idioma the idioma
   * @return the array list
   * @throws ServletException the servlet exception
   */
  public ArrayList generarRutaMultimedia(ArrayList arMultimedia, ArrayList arMultimediaEs, String codigo, String tipoRecurso, String idioma) throws ServletException  {

  	ArrayList arMultimediaCompleto = new ArrayList();
    try {
    	if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12LayarDatosServlet.COMPONENTE, Q70TraceLevel.DEBUG, "S12LayarDatosServlet:: generarRutaMultimedia:: Inicio");
      }

    		//auto-rellenar el cdigo con ceros por la izquierda
			StringBuffer codigoCompleto = new StringBuffer(codigo);
			while (codigoCompleto.length() < S12LayarDatosServlet.DIEZ_CARACTERES){
				codigoCompleto.insert(0, "0");
			}

			//rellenamos la estructura completo de cada multimedia y lo metemos en un ArrayList
			StringBuffer estructura;
			for (int i=0; i<arMultimedia.size(); i++){
				estructura = new StringBuffer();
				estructura.append(Q70ListenerUtils.getApplicationProperty("URL_PORTAL"));
				estructura.append("/contenidos/").append(S12Constantes.getContentType(tipoRecurso.substring(0, 1))).append("/");
				estructura.append(codigoCompleto).append("_").append(tipoRecurso.toLowerCase()).append("_rec_turismo/");

				//si los nombres son iguales, que apunte a castellano en el Gestor de Contenidos, sino al idioma en ejecucin
				if (!arMultimedia.get(i).equals(arMultimediaEs.get(i))){
					estructura.append(idioma).append("_").append(codigo).append("/images/").append(arMultimedia.get(i));
				}else{
					estructura.append(S12Constantes.IDIOMA_ES).append("_").append(codigo).append("/images/").append(arMultimediaEs.get(i));
				}
				
				arMultimediaCompleto.add(estructura.toString());
			}


      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12LayarDatosServlet.COMPONENTE, Q70TraceLevel.DEBUG, "S12LayarDatosServlet:: generarRutaMultimedia:: Fin");
      }
      return arMultimediaCompleto;
    }catch (Exception e) {
      e.printStackTrace();
      throw new ServletException( "Error al generar las Rutas para los Multimedia", e );
    }

  }

  /**
   * Generar nombre completo.
   *
   * @param datosLayar the datos layar
   * @param idioma the idioma
   *
   * @return the string
   *
   * @throws ServletException the servlet exception
   */
  public String generarNombreCompleto(S12LayarDatos datosLayar, String idioma) throws ServletException  {

  	StringBuffer nombreCompleto = new StringBuffer();
  	String tipoRecurso = datosLayar.getTipoRecurso();
		String subTipoRecurso = datosLayar.getSubTipoRecurso();
  	String nombreSubTipo = "";
    try {
    	if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12LayarDatosServlet.COMPONENTE, Q70TraceLevel.DEBUG, "S12LayarDatosServlet:: generarNombreCompleto:: Inicio");
      }

    	//si el recurso es A1 o B1, auto-completamos el nombre segn el idioma
			if (tipoRecurso.equals("A1")){
				nombreSubTipo = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.a1."+subTipoRecurso,idioma);
				if (idioma.equals("es") || idioma.equals("fr") || idioma.equals("de")){
					nombreCompleto.append(nombreSubTipo).append(" ").append(datosLayar.getTitulo());
				}else{
					nombreCompleto.append(datosLayar.getTitulo()).append(" ").append(nombreSubTipo);
				}

			}else if (tipoRecurso.equals("B1")){
				nombreSubTipo = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.b1."+subTipoRecurso,idioma);
				if (idioma.equals("es") || idioma.equals("fr") || idioma.equals("de")){
					nombreCompleto.append(nombreSubTipo).append(" ").append(datosLayar.getTitulo());
				}else{
					nombreCompleto.append(datosLayar.getTitulo()).append(" ").append(nombreSubTipo);
				}

			}else{
				nombreCompleto.append(datosLayar.getTitulo());
			}


      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12LayarDatosServlet.COMPONENTE, Q70TraceLevel.DEBUG, "S12LayarDatosServlet:: generarNombreCompleto:: Fin");
      }
      return nombreCompleto.toString();

    }catch (Exception e) {
      e.printStackTrace();
      throw new ServletException( "Error al generar el nombre completo del recurso", e );
    }

  }

}
