<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="s12.layar.valueObjects.S12LayarDatos" %>

<%
	String language = request.getParameter("lang");

	if ( language == null ) {
		language = "es"; // Castellano por defecto
	}

	Q70ListenerUtils.updateLanguage(request,language); // Fija el idioma para los html:message
	String staticPathLayar = Q70ListenerUtils.getApplicationProperty("URL_LAYAR_ESTATICO");
%>


<html>
	<head>
		<script src="<%=staticPathLayar%>/scripts/jquery.js" type="text/javascript"></script>
		<script src="<%=staticPathLayar%>/scripts/x65-ficha.js" type="text/javascript"></script>
		<link rel="stylesheet" href="<%=staticPathLayar%>/styles/estiloFicha.css" />

		<%
			if (request.getAttribute("datosLayar")!=null){
				S12LayarDatos datosLayar = (S12LayarDatos)request.getAttribute("datosLayar");%>
				<meta name="viewport" content="initial-scale=1">
				<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
				<title><%=datosLayar.getTitulo()%></title>
	</head>
<body>

	<div id="content">
		<div id="poi_title"><strong><%=datosLayar.getTitulo()%></strong></div>
		<div id="share">
			<ul>
				<li>
					<% if (datosLayar.getTelefono() !=null){%>
						<a href="tel://<%=datosLayar.getTelefono()%>"><img src="<%=staticPathLayar%>/images/btnTelefonoGris.png"/></a>
					<%}else{%>
						<img class="layar_deshabilitado" src="<%=staticPathLayar%>/images/btnTelefonoGris.png"/>
					<%}%>
				</li>
				<li>
					<% if (datosLayar.getEmail() !=null){%>
						<a href="mailto:<%=datosLayar.getEmail()%>"><img src="<%=staticPathLayar%>/images/btnMailGris.png"/></a>
					<%}else{%>
						<img class="layar_deshabilitado" src="<%=staticPathLayar%>/images/btnMailGris.png"/>
					<%}%>
				</li>
				<li>
					<% if (datosLayar.getUrl() !=null){%>
						<a href="<%=datosLayar.getUrl()%>" target="_blank"><img src="<%=staticPathLayar%>/images/btnInternetGris.png"/></a>
					<%}else{%>
						<img class="layar_deshabilitado" src="<%=staticPathLayar%>/images/btnInternetGris.png"/>
					<%}%>
				</li>
				<li>
					<% if (datosLayar.getUrlAmigable() !=null){%>
						<a href="http://www.facebook.com/sharer.php?u=<%=datosLayar.getUrlAmigable()%>" target="_blank"><img src="<%=staticPathLayar%>/images/btn_facebook.png"/></a>
					<%}else{%>
						<img class="layar_deshabilitado" src="<%=staticPathLayar%>/images/btn_facebook.png"/>
					<%}%>
				</li>
				<li class="li_last">
					<% if (datosLayar.getUrlAmigable() !=null){%>
						<a href="http://twitter.com/share?url=<%=datosLayar.getUrlAmigable()%>" target="_blank"><img src="<%=staticPathLayar%>/images/btn_twitter.png"/></a>
					<%}else{%>
						<img class="layar_deshabilitado" src="<%=staticPathLayar%>/images/btn_twitter.png"/>
					<%}%>
				</li>
			</ul>

		</div>
		<% if (datosLayar.getFoto() !=null){%>
		<div class="imagen">
			<div class="poi_imagen">
				<img src="<%=datosLayar.getFoto()%>" alt="<%=datosLayar.getTitulo()%>" />
			</div>
		</div>
		<%}%>
		<% if (datosLayar.getDescripcion() !=null){%>
		<div id="info">
			<div class="poi_titulo"><%=datosLayar.getTitulo()%></div>
			<div id="poi_desc"><%=datosLayar.getDescripcion()%></div>

				<div id="poi_ver_mas">
				<% if (datosLayar.getUrlAmigable() !=null){%>
					<a href="<%=datosLayar.getUrlAmigable()%>"><html:message i18nKey="s12Layar" key="layar.boton.verMas"/></a>
				<%}else{%>

				<%}%>
				</div>
		</div>
		<%}%>
	</div>
<%}else{%>
	<html:message i18nKey="s12Layar" key="layar.noInformacion"/>
<%}%>

</body>
</html>



