<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="s12.util.S12Utils" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%

	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String lang = StringEscapeUtils.escapeJava(request.getParameter("lang"));
	lang = S12Utils.idiomaValido(lang);
	if ( lang == null ) {
		lang= S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( lang == null ) {
		lang = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	
	// Establece el idioma por defecto
	if (lang == null) {
		Q70ListenerUtils.updateLanguage(request,"es");
	}
	else {
		Q70ListenerUtils.updateLanguage(request,lang);
	}

	String UrlConexion = Q70ListenerUtils.getApplicationProperty("UrlConexion");
	String IdiomaDefecto = Q70ListenerUtils.getApplicationProperty("IdiomaDefecto");

	String UrlFichasMiniaturasRaiz = Q70ListenerUtils.getApplicationProperty("UrlFichasMiniaturasRaiz");

	String ALIAS_ESTATICO	= Q70ListenerUtils.getApplicationProperty("ALIAS_ESTATICO");
	
	lang = (lang == null ? IdiomaDefecto : lang);

	String queryString = "";

	if (request.getParameter("query") != null) {
		queryString = (String) request.getParameter("query");
	}

	String recursos = "";

	if (request.getParameter("recursos") != null) {
		recursos = (String) request.getParameter("recursos");
	}

	// Caso de tratarse de Programas Experienciales
	String pex = "";

	if (request.getParameter("pex") != null) {
		pex = (String) request.getParameter("pex");
	}
%>

<script>
	var ES_VISOR = true;

	var ALIAS_ESTATICO = "<%= ALIAS_ESTATICO %>";
	
	var G_URL_CONEXION = "<%= UrlConexion %>";
	var G_IDIOMA_ACTUAL = "<%= StringEscapeUtils.escapeJavaScript(lang) %>";

	var RECURSOS = "<%=StringEscapeUtils.escapeJavaScript(recursos)%>";

	var PEX = "<%=StringEscapeUtils.escapeJavaScript(pex)%>";

	var ONLOAD_QUERY = '<%=StringEscapeUtils.escapeJavaScript(queryString)%>';

	// OPCIONES
	var CONST_ENLACE_FICHAS_MINIATURAS_RAIZ = "<%= UrlFichasMiniaturasRaiz %>";

	// Textos idiomticos usados en la aplicacin
	var CONST_LABEL_DESCARGARPOI = "<html:message i18nKey="s12GoogleMaps" key="Acciones.DescripcionDescargarPOI" />";

</script>

<div id="s12_capaVisorGeoEuskadi">
	<div id="s12_VisorGeoEuskadi_mapa"></div>
	
	<div class="clear"></div>

	<div id="formatoarchivogps">
		<form name="formFormatoArchivoGps" id="formFormatoArchivoGps">
			<div id="formatoarchivogpscabecera">
				<div class="floatleft">
					<div><html:message i18nKey="s12GoogleMaps" key="Acciones.DescargarPOI" /></div>
				</div>
				<div class="floatright">
					<a href="javascript:cerrarVentanaFormatoArchivoGps()"><img src="<%= ALIAS_ESTATICO %>/images/gmaps/close.gif"></a>
				</div>
				<div class="clear"></div>
			</div>

			<div id="formatoarchivogpscontopciones">
				<div><html:message i18nKey="s12GoogleMaps" key="Acciones.SeleccioneGPS" />:</div>
				<div><input type="radio" id="ov2" name="formatoArchivoGps" value="OV2" checked>TomTom (.OV2)</div>
				<div><input type="radio" id="csv" name="formatoArchivoGps" value="CSV">Garmin, Navman (.CSV)</div>
			</div>

			<div id="formatoarchivogpsboton">
				<input type="button" class="inputbutton" value="<html:message i18nKey="s12GoogleMaps" key="Acciones.DescargarPOI" />" onClick="javascript:descargarPOI();">
				<input type="hidden" value="" name="codRecPOI">
				<input type="hidden" value="" name="nombreRecPOI">
				<input type="hidden" value="" name="latitudPOI">
				<input type="hidden" value="" name="longitudPOI">
			</div>
		</form>
	</div>
</div>


