<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="s12.util.S12Utils" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%
	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String lang = StringEscapeUtils.escapeJava(request.getParameter("lang"));
	lang = S12Utils.idiomaValido(lang);
	if ( lang == null ) {
		lang= S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( lang == null ) {
		lang = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	
	// Establece el idioma por defecto
	if (lang == null) {
		Q70ListenerUtils.updateLanguage(request,"es");
	}
	else {
		Q70ListenerUtils.updateLanguage(request,request.getParameter("lang"));
	}

	String UrlConexion = Q70ListenerUtils.getApplicationProperty("UrlConexion");
	String IdiomaDefecto = Q70ListenerUtils.getApplicationProperty("IdiomaDefecto");

	String UrlFichasMiniaturasRaiz = Q70ListenerUtils.getApplicationProperty("UrlFichasMiniaturasRaiz");

	String ALIAS_ESTATICO	= Q70ListenerUtils.getApplicationProperty("ALIAS_ESTATICO");

	lang = (lang == null ? IdiomaDefecto : lang);
%>

<script>
	var ALIAS_ESTATICO = "<%= ALIAS_ESTATICO %>";	
	
	var G_URL_CONEXION = "<%= UrlConexion %>";	
	var G_IDIOMA_ACTUAL = "<%= StringEscapeUtils.escapeJavaScript(lang) %>";

	// OPCIONES
	var CONST_ENLACE_FICHAS_MINIATURAS_RAIZ = "<%= UrlFichasMiniaturasRaiz %>";

	// Textos idiomticos usados en la aplicacin
	var CONST_LABEL_LUGARES = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.GoTo" />";
	var CONST_LABEL_LUGARES_BILBAO = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Bilbao" />";
	var CONST_LABEL_LUGARES_DONOSTI = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Donosti" />";
	var CONST_LABEL_LUGARES_VITORIA = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Vitoria" />";
	var CONST_LABEL_LUGARES_COSTA	= "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Costa" />";
	var CONST_LABEL_LUGARES_INTERIOR = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Interior" />";
	var CONST_LABEL_LUGARES_RIOJA = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Rioja" />";

	var CONST_LABEL_ACCIONES = "<html:message i18nKey="s12GoogleMaps" key="Acciones.Acciones" />";
	
	var CONST_LABEL_VERRECURSOS = "<html:message i18nKey="s12GoogleMaps" key="Bocadillo.VerRecursos" />";
	
	var CONST_LABEL_ACCTION_CLEAN = "<html:message i18nKey="s12GoogleMaps" key="Acciones.LimpiarTodo" />";

	var CONST_SCRIPTS_3RDPARTY = "<%= ALIAS_ESTATICO %>" + "/scripts/gastronomika/3rdparty/";
</script>

<script src="//maps.googleapis.com/maps/api/js?key=AIzaSyBFBIl-sOAYIFB-FTUyXUQQ7gfp6Lt2_7w&language=<%= StringEscapeUtils.escapeHtml(lang) %>&libraries=panoramio,geometry"></script>

<script>
	// Textos idiomticos usados en la aplicacin
	var CONST_TREE_TEXTO_DONDE_COMER = '<html:message i18nKey="s12GoogleMaps" key="Filtros.Gastronomica.dondeComer" />';
	var CONST_TREE_TEXTO_DONDE_COMPRAR = '<html:message i18nKey="s12GoogleMaps" key="Filtros.Gastronomica.dondeComprar" />';
	var CONST_TREE_TEXTO_QUE_VISITAR = '<html:message i18nKey="s12GoogleMaps" key="Filtros.Gastronomica.queVisitar" />';
	var CONST_TREE_TEXTO_EMPRESAS_ACTIVIDADES = '<html:message i18nKey="s12GoogleMaps" key="Filtros.Gastronomica.empresasActividades" />';
	var CONST_TREE_TEXTO_DONDE_DORMIR = '<html:message i18nKey="s12GoogleMaps" key="Filtros.Gastronomica.dondeDormir" />';
</script>

<div id="s12_capaVisorGMaps">
	<div id="s12_capaVisorGMaps_map">
		<div id="map"></div>
	</div>

	<div id="s12_capaVisorGMaps_menuHidden">
		<a href="javaScript:showHideMenu()">
			<img src="<%= ALIAS_ESTATICO %>/images/gmaps/menuarrowshow.gif" />
		</a>
	</div>

	<div id="s12_capaVisorGMaps_menu">
		<div class="cabeceracaja">
			<a href="javaScript:showHideMenu()">
				<img src="<%= ALIAS_ESTATICO %>/images/gmaps/menuarrowhide.gif" />
			</a>
			<div class="titulocabecera">
				<html:message i18nKey="s12GoogleMaps" key="Menu.titulo" />
			</div>
		</div>
		
		<div>
			<div id="ContTabul">
				<div id="div_tree">
			</div>
			<div id="div_tree_loading_filtros">
				<img src="<%= ALIAS_ESTATICO %>/images/gmaps/loading.gif" />
			</div>
		</div>
	</div>
</div>

