<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="s12.util.S12Utils" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%

	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String lang = StringEscapeUtils.escapeJava(request.getParameter("lang"));
	lang = S12Utils.idiomaValido(lang);
	if ( lang == null ) {
		lang= S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( lang == null ) {
		lang = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	
	// Establece el idioma por defecto
	if (lang == null) {
		Q70ListenerUtils.updateLanguage(request,"es");
	}
	else {
		Q70ListenerUtils.updateLanguage(request,lang);
	}

	String UrlConexion = Q70ListenerUtils.getApplicationProperty("UrlConexion");
	String IdiomaDefecto = Q70ListenerUtils.getApplicationProperty("IdiomaDefecto");
	String UrlFichasMiniaturasRaiz = Q70ListenerUtils.getApplicationProperty("UrlFichasMiniaturasRaiz");
	String ALIAS_ESTATICO	= Q70ListenerUtils.getApplicationProperty("ALIAS_ESTATICO");

	lang = (lang == null ? IdiomaDefecto : lang);
%>

<script>
	var ES_VISOR = false;
	var ALIAS_ESTATICO = "<%= ALIAS_ESTATICO %>";
	var G_URL_CONEXION = "<%= UrlConexion %>";
	var G_IDIOMA_ACTUAL = "<%= StringEscapeUtils.escapeJavaScript(lang) %>";

	var CONST_ENLACE_FICHAS_MINIATURAS_RAIZ = "<%= UrlFichasMiniaturasRaiz %>";

	// Parmetros de la URL
	var tipoRecursosImpresion = '<%=StringEscapeUtils.escapeJavaScript(request.getParameter("tipos_recursos"))%>';
	var latitudImpresion = '<%=StringEscapeUtils.escapeJavaScript(request.getParameter("lat"))%>';
	var longitudImpresion = '<%=StringEscapeUtils.escapeJavaScript(request.getParameter("lng"))%>';
	var zoomImpresion = '<%=StringEscapeUtils.escapeJavaScript(request.getParameter("zoom"))%>';
	var rutaImpresion = '<%=StringEscapeUtils.escapeJavaScript(request.getParameter("ruta"))%>';
</script>

<script charset="UTF-8" type="text/javascript" src="//maps.googleapis.com/maps/api/js?key=AIzaSyBFBIl-sOAYIFB-FTUyXUQQ7gfp6Lt2_7w&language=<%= StringEscapeUtils.escapeHtml(lang) %>"></script>

<jsp:include page="constantesRecursos.jsp"/>

<div id="s12_capaVisorGMapsPlantillaImpresion">
	<div id="loadingplantilla">
		<img src="<%= ALIAS_ESTATICO %>/images/gmaps/loading.gif" />
	</div>
	<div style="float:left; margin-top:3px; margin-bottom:3px;">
		<div id="box">
			<a href="javascript:window.print()">
				<img src="<%= ALIAS_ESTATICO %>/images/gmaps/printer.gif" class="iconoAlinearMedio" style="margin-right:3px;"><html:message i18nKey="s12GoogleMaps" key="Acciones.Imprimir" />
			</a>
		</div>
		<div style="clear:both"></div>
		<div style="float:right">
			<textarea id="notas" rows="3" style="color:silver;" onClick="javascript:if(this.value == '<html:message i18nKey="s12GoogleMaps" key="Acciones.PuedeEscribir" />') this.value = ''; this.style.color = '#000000'"/><html:message i18nKey="s12GoogleMaps" key="Acciones.PuedeEscribir" /></textarea>
		</div>
		<div style="float:right">
			<span id="titulonota"><html:message i18nKey="s12GoogleMaps" key="Acciones.Notas" />&nbsp;</span>
		</div>
		<div style="clear:both"></div>
	</div>
	<div style="clear:both"></div>
	<div id="s12_capaVisorGMaps_map">
		<div id="map"></div>
	</div>
</div>
