
<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>
<%@ taglib uri="/WEB-INF/tld/ejieFramework-html.tld" prefix="html" %>
<%@ page import="es.ejie.frmk.listeners.base.Q70ListenerUtils" %>
<%@ page import="s12.util.S12Utils" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils" %>
<%

	//Valor de idioma: se obtiene por parmetro, si no viene, se deduce de la URL y si eso falla, se intenta leer de cookie
	String lang = StringEscapeUtils.escapeJava(request.getParameter("lang"));
	lang = S12Utils.idiomaValido(lang);
	if ( lang == null ) {
		lang= S12Utils.getIdiomaFromRequestURL(request.getRequestURL().toString());
	}
	if ( lang == null ) {
		lang = S12Utils.getIdiomaFromR01euskadiCookie(request.getCookies());
	}
	
	// Establece el idioma por defecto
	if (lang == null) {
		Q70ListenerUtils.updateLanguage(request,"es");
	}
	else {
		Q70ListenerUtils.updateLanguage(request,lang);
	}

	String UrlConexion = Q70ListenerUtils.getApplicationProperty("UrlConexion");
	String UrlQueryAPI = Q70ListenerUtils.getApplicationProperty("UrlQueryAPI");
	String IdiomaDefecto = Q70ListenerUtils.getApplicationProperty("IdiomaDefecto");

	String ModoDebug = Q70ListenerUtils.getApplicationProperty("ModoDebug");

	String UrlFichasMiniaturasRaiz = Q70ListenerUtils.getApplicationProperty("UrlFichasMiniaturasRaiz");

	String UrlPlantillaImpresion = Q70ListenerUtils.getApplicationProperty("UrlPlantillaImpresion");

	String ALIAS_ESTATICO	= Q70ListenerUtils.getApplicationProperty("ALIAS_ESTATICO");
	String PLAYGROUNDS_ESTATICO	= Q70ListenerUtils.getApplicationProperty("PLAYGROUNDS_ESTATICO");

	lang = (lang == null ? IdiomaDefecto : lang);

	String queryString = "";

	if (request.getParameter("query") != null) {
		queryString = (String) request.getParameter("query");
	}

	String recursos = "";

	if (request.getParameter("recursos") != null) {
		recursos = (String) request.getParameter("recursos");
	}

	// Caso de tratarse de Programas Experienciales
	String pex = "";

	if (request.getParameter("pex") != null) {
		pex = (String) request.getParameter("pex");
	}
%>

<script>
	var ES_VISOR = true;

	var ALIAS_ESTATICO = "<%= ALIAS_ESTATICO %>";
	var PLAYGROUNDS_ESTATICO = "<%= PLAYGROUNDS_ESTATICO %>";

	var G_URL_CONEXION = "<%= UrlConexion %>";
	var G_URL_QUERY_API = "<%= UrlQueryAPI %>";
	var G_IDIOMA_ACTUAL = "<%= StringEscapeUtils.escapeJavaScript(lang) %>";

	var RECURSOS = "<%=StringEscapeUtils.escapeJavaScript(recursos)%>";

	var PEX = "<%=StringEscapeUtils.escapeJavaScript(pex)%>";

	var ONLOAD_QUERY = '<%=StringEscapeUtils.escapeJavaScript(queryString)%>';

	// OPCIONES
	var CONST_ENLACE_FICHAS_MINIATURAS_RAIZ = "<%= UrlFichasMiniaturasRaiz %>";

	var CONST_ENLACE_PLANTILLAIMPRESION = "<%= UrlPlantillaImpresion %>" + G_IDIOMA_ACTUAL + "/s12GoogleMapsWar/gMapsJSP/VisorGMapsPlantillaImpresionNP.jsp";

	<%if(ModoDebug.equals("1")) {%>
		CONST_ENLACE_PLANTILLAIMPRESION = "VisorGMapsPlantillaImpresion_EJIE.jsp";
	<%}%>

	// Textos idiomticos usados en la aplicacin
	var CONST_LABEL_LUGARES = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.GoTo" />";
	var CONST_LABEL_LUGARES_BILBAO = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Bilbao" />";
	var CONST_LABEL_LUGARES_DONOSTI = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Donosti" />";
	var CONST_LABEL_LUGARES_VITORIA = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Vitoria" />";
	var CONST_LABEL_LUGARES_COSTA	= "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Costa" />";
	var CONST_LABEL_LUGARES_INTERIOR = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Interior" />";
	var CONST_LABEL_LUGARES_RIOJA = "<html:message	i18nKey="s12GoogleMaps" key="Lugares.Rioja" />";

	var CONST_LABEL_ESTATICOS_RESULTADOBUSQUEDA = "<html:message	i18nKey="s12GoogleMaps" key="Estaticos.ResultadoBusqueda" />";

	var CONST_LABEL_ACCIONES = "<html:message i18nKey="s12GoogleMaps" key="Acciones.Acciones" />";
	var CONST_LABEL_PETICIONNOMBRERECURSOS = "<html:message i18nKey="s12GoogleMaps" key="Acciones.PeticionNombreRecurso" />";
	var CONST_LABEL_ERRORRECURSOS = "<html:message i18nKey="s12GoogleMaps" key="Acciones.ErrorRecursos" />";
	var CONST_LABEL_PETICIONNOMBRERUTA = "<html:message i18nKey="s12GoogleMaps" key="Acciones.PeticionNombreRuta" />";
	var CONST_LABEL_ERRORRUTA = "<html:message i18nKey="s12GoogleMaps" key="Acciones.ErrorRuta" />";

	var CONST_LABEL_ORIGEN = "<html:message i18nKey="s12GoogleMaps" key="Rutas.Origen" />";
	var CONST_LABEL_DESTINO = "<html:message i18nKey="s12GoogleMaps" key="Rutas.Destino" />";
	var CONST_LABEL_ERRORCAMPOSRUTA = "<html:message i18nKey="s12GoogleMaps" key="Rutas.ErrorCamposRuta" />";
	var CONST_LABEL_ERRORCALCULARRUTA = "<html:message i18nKey="s12GoogleMaps" key="Rutas.ErrorRuta" />";
	var CONST_LABEL_COMOLLEGAR = "<html:message i18nKey="s12GoogleMaps" key="Rutas.ComoLlegarJS" />";
	var CONST_LABEL_DESDEAQUI = "<html:message i18nKey="s12GoogleMaps" key="Rutas.DesdeAqui" />";
	var CONST_LABEL_HASTAAQUI = "<html:message i18nKey="s12GoogleMaps" key="Rutas.HastaAqui" />";

	var CONST_LABEL_VERRECURSOS = "<html:message i18nKey="s12GoogleMaps" key="Bocadillo.VerRecursos" />";
	var CONST_LABEL_DESCARGARPOI = "<html:message i18nKey="s12GoogleMaps" key="Acciones.DescripcionDescargarPOI" />";

	var CONST_LABEL_ACCTION_CLEAN = "<html:message i18nKey="s12GoogleMaps" key="Acciones.LimpiarTodo" />";
	var CONST_LABEL_ACCTION_PRINT = "<html:message i18nKey="s12GoogleMaps" key="Acciones.Imprimir" />";
	var CONST_LABEL_ACCTION_EXPORT_VIEW = "<html:message i18nKey="s12GoogleMaps" key="Acciones.ExportarRecursos" />" + "(" + "<html:message i18nKey="s12GoogleMaps" key="Acciones.VistaActual" />" + ")";
	var CONST_LABEL_ACCTION_EXPORT_ALL = "<html:message i18nKey="s12GoogleMaps" key="Acciones.ExportarRecursos" />" + "(" + "<html:message i18nKey="s12GoogleMaps" key="Acciones.Todo" />" + ")";
	var CONST_LABEL_ACCTION_EXPORT_RUTE = "<html:message i18nKey="s12GoogleMaps" key="Acciones.ExportarRuta" />";

	var CONST_LABEL_GRAN_BILBAO = "<html:message i18nKey="s12GoogleMaps" key="Playgrounds.GranBilbao" />";
	var CONST_LABEL_RESERVA_BIOSFERA_URDAIBAI = "<html:message i18nKey="s12GoogleMaps" key="Playgrounds.ReservaBiosferaUrdaibai" />";
	var CONST_LABEL_RIOJA_ALAVESA = "<html:message i18nKey="s12GoogleMaps" key="Playgrounds.RiojaAlavesa" />";
	var CONST_LABEL_AIZKORRI = "<html:message i18nKey="s12GoogleMaps" key="Playgrounds.Aizkorri" />";
	var CONST_LABEL_GEOPARQUE = "<html:message i18nKey="s12GoogleMaps" key="Playgrounds.Geoparque" />";
	var CONST_LABEL_COSTA_GETARIA = "<html:message i18nKey="s12GoogleMaps" key="Playgrounds.CostaGetaria" />";
	var CONST_LABEL_CORAZON_EUSKADI = "<html:message i18nKey="s12GoogleMaps" key="Playgrounds.CorazonEuskadi" />";
	var CONST_LABEL_GORBEIA = "<html:message i18nKey="s12GoogleMaps" key="Playgrounds.Gorbeia" />";

	var CONST_SCRIPTS_3RDPARTY = "<%= ALIAS_ESTATICO %>" + "/scripts/gmaps/3rdparty/";
</script>

<script src="//maps.googleapis.com/maps/api/js?key=AIzaSyBFBIl-sOAYIFB-FTUyXUQQ7gfp6Lt2_7w&language=<%= StringEscapeUtils.escapeHtml(lang) %>&libraries=panoramio,geometry"></script>
<script type="text/javascript" src="<%=ALIAS_ESTATICO%>/scripts/gmaps/3rdparty/maps.google.polygon.containsLatLng.js"></script>

<jsp:include page="constantesRecursos.jsp"/>

<div id="s12_capaVisorGMaps">
	<div id="s12_capaVisorGMaps_map">
		<div id="map"></div>
		<!--
		he puesto un form para pasar los puntos de la ruta por mtodo POST, ya q con el mtodo GET no acepta ms
		de unos 10000 caracteres (esto depende del navegador y del servidor)
		aqu lo explican http://www.hackingballz.com/blogs/5/XMLHttpRequest-enviando-datos-via-POST.html
		-->
		<form id="form" name="form" action="" method="POST" class="forminvisible">
			<input type="hidden" id="puntosRuta" name="puntosRuta" value="">
		</form>
	</div>

	<div id="s12_capaVisorGMaps_menuHidden">
		<a href="javaScript:showHideMenu()">
			<img src="<%= ALIAS_ESTATICO %>/images/gmaps/menuarrowshow.gif" />
		</a>
	</div>

	<div id="s12_capaVisorGMaps_menu">
		<div class="cabeceracaja">
			<a href="javaScript:showHideMenu()">
				<img src="<%= ALIAS_ESTATICO %>/images/gmaps/menuarrowhide.gif" />
			</a>
			<div class="titulocabecera">
				<html:message i18nKey="s12GoogleMaps" key="Menu.titulo" />
			</div>
		</div>

		<div>

			<!-- INI TABS -->
			<div class="conttabs">
				<ul id="tabnav">
					<li class="activo" id="mtabFiltros">
						<a href="javascript:cambiarTab('mtabFiltros');">
							<span class="nosubrayado">
								<html:message i18nKey="s12GoogleMaps" key="Menu.Tab.Filtros" />
							</span>
						</a>
					</li>
					<li class="inactivo" id="mtabRutas">
						<a href="javascript:cambiarTab('mtabRutas');">
							<span class="nosubrayado">
							 <html:message i18nKey="s12GoogleMaps" key="Menu.Tab.Rutas" />
							</span>
						</a>
					</li>
				</ul>
			</div>

			<div id="ContTabul">

				<!-- TAB filtros -->

				<div id="Tab_mtabFiltros" class="Tab_ContentsVisible">

					<div id="divRadarRangeHalo">
						<html:message i18nKey="s12GoogleMaps" key="Rutas.FiltrarRecursos" /> <input type="text" id="radarRangeHalo" class="inputtext textrange" size="1" maxlength="2" onChange="changeRadiusHalo()"> <html:message i18nKey="s12GoogleMaps" key="Rutas.km" />
						<hr class="lineaseparadoraruta" />
					</div>

					<div id="contsearch" style="display: none;">
						<input type="checkbox" id="searchvisiblecheck" onChange="javascript:cambioVisibilidadSearch(this)"><img
						src="<%= ALIAS_ESTATICO %>/images/gmaps/recursos/iconestatico.png" title=""><span id="searchtext"></span>
						<a href="javascript:borrarBusqueda()"><img src="<%= ALIAS_ESTATICO %>/images/gmaps/closesearch.gif"></a>
						<div class="clear"></div>
					</div>

					<div id="div_tree">

					</div>
					
					<div id="gastronomika">
						<a target="_top" href="<html:message i18nKey="s12GoogleMaps" key="Gastronomica.URL" />">
							<html:message i18nKey="s12GoogleMaps" key="Gastronomica.EuskadiGastronomika" />
						</a>
					</div>
					
					<div id="surfing">
						<a target="_top" href="<html:message i18nKey="s12GoogleMaps" key="Surfing.URL" />">
							<html:message i18nKey="s12GoogleMaps" key="Surfing.SurfingEuskadi" />
						</a>
					</div>

					<div id="div_tree_loading_filtros">
						<img src="<%= ALIAS_ESTATICO %>/images/gmaps/loading.gif" />
					</div>

				</div>

				<!-- FIN TAB filtros -->

				<!-- TAB rutas -->

				<div id="Tab_mtabRutas" class="Tab_ContentsInvisible">

					<div id="div_Rutas">

						<div class="contRutas" value="CALCULO_RUTA">

							<div class="contcomollegar">

								<div class="contorigendestino">
									<img src="<%= ALIAS_ESTATICO %>/images/gmaps/iconorigen.gif" class="iconoAlinearArriba"/>
									<input value="<html:message i18nKey="s12GoogleMaps" key="Rutas.Origen" />" onClick="javasript: if(this.value == '<html:message i18nKey="s12GoogleMaps" key="Rutas.Origen" />') this.value = '';" type="text" id="INPUT_RUTA_ORIGEN"
										name="INPUT_RUTA_ORIGEN" class="inputtext botonorigendestino" tabindex="1" />
								</div>

								<div>
									<img src="<%= ALIAS_ESTATICO %>/images/gmaps/icondestino.gif" class="iconoAlinearArriba"/>
									<input value="<html:message i18nKey="s12GoogleMaps" key="Rutas.Destino" />" onClick="javasript: if(this.value == '<html:message i18nKey="s12GoogleMaps" key="Rutas.Destino" />') this.value = '';" type="text" id="INPUT_RUTA_DESTINO"
										name="INPUT_RUTA_DESTINO" class="inputtext botonorigendestino" tabindex="2" />
								</div>

								<div class="botonesruta">

									<input value="<html:message i18nKey="s12GoogleMaps" key="Rutas.ComoLlegar" />" type="button"
										onclick="calculateRute()" name="RUTA_CALCULAR" class="inputbutton"/>

									<input value="<html:message i18nKey="s12GoogleMaps" key="Rutas.BorrarRuta" />" type="button"
										onclick="removeRute()" name="BORRAR_RUTAS" class="inputbutton"/>

								</div>

								<div>
									<div id="divFiltrarRecursos">
										<html:message i18nKey="s12GoogleMaps" key="Rutas.FiltrarRecursos" />
									</div>
									<div id="divRangoKm">
										<input type="text" id="radarRange" class="inputtext textrange" size="1" maxlength="2" onChange="changeRadius()"> <html:message i18nKey="s12GoogleMaps" key="Rutas.km" />
									</div>
									<div id="divCheckPosicion">
										<input id="checkPosicion" type="checkbox" onClick="startRadars()" value="radar"/>
										<html:message i18nKey="s12GoogleMaps" key="Rutas.Posicion" />
									</div>
									<div id="divCheckRuta">
										<input id="checkRuta" type="checkbox" onClick="startRadars()" value="radar" disabled/>
										<html:message i18nKey="s12GoogleMaps" key="Rutas.Ruta" />
									</div>
								</div>

							</div>

							<div id="div_tree_loading_rutas">
								<img src="<%= ALIAS_ESTATICO %>/images/gmaps/loading.gif" />
							</div>

							<div id="DIV_RUTA_INFORME" class="tipo">
								<span> </span>
							</div>

						</div>

					</div>

				</div>

				<!-- FIN TAB rutas -->

				<!-- FIN TABS -->

			</div>
		</div>

	</div>

	<div class="clear"></div>

	<div id="formatoarchivogps">
		<form name="formFormatoArchivoGps" id="formFormatoArchivoGps">
			<div id="formatoarchivogpscabecera">
				<div class="floatleft">
					<div><html:message i18nKey="s12GoogleMaps" key="Acciones.DescargarPOI" /></div>
				</div>
				<div class="floatright">
					<a href="javascript:cerrarVentanaFormatoArchivoGps()"><img src="<%= ALIAS_ESTATICO %>/images/gmaps/close.gif"></a>
				</div>
				<div class="clear"></div>
			</div>

			<div id="formatoarchivogpscontopciones">
				<div><html:message i18nKey="s12GoogleMaps" key="Acciones.SeleccioneGPS" />:</div>
				<div><input type="radio" id="ov2" name="formatoArchivoGps" value="OV2" checked>TomTom (.OV2)</div>
				<div><input type="radio" id="csv" name="formatoArchivoGps" value="CSV">Garmin, Navman (.CSV)</div>
			</div>

			<div id="formatoarchivogpsboton">
				<input type="button" class="inputbutton" value="<html:message i18nKey="s12GoogleMaps" key="Acciones.DescargarPOI" />" onClick="javascript:descargarPOI();">
				<input type="hidden" value="" name="codRecPOI">
				<input type="hidden" value="" name="nombreRecPOI">
				<input type="hidden" value="" name="latitudPOI">
				<input type="hidden" value="" name="longitudPOI">
			</div>
		</form>
	</div>

</div>
