package s12.accionesNegocio.newsletter;

import s12.accionesNegocio.S12FErrors;
import s12.search.S12NewsletterQuery;
import s12.search.S12PaisesTraduccionesQuery;
import s12.search.S12ProvinciasQuery;
import s12.search.S12SearchSrv;
import s12.valueObjects.S12PersistenceSrv;
import s12.valueObjects.newsletter.S12Newsletter;
import bilbofrmk.FacadeEJB.BFBaseAction;
import bilbofrmk.context.BIContext;
import bilbofrmk.exceptions.BFActionException;
import bilbofrmk.exceptions.BPersistenceException;
import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.trasport.BBackError;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 * Clase que representa las acciones de negocio para el mantenimiento d
 * los viajes que nos cuentan los usuarios
 *  
 */
public class S12FNewsletter extends BFBaseAction { // NO_UCD

	public static final int CONST_INSERTAR_FORM = 1;
	public static final int CONST_SELEC_MAILS = 2;
	public static final int CONST_SELEC_PROVINCIAS = 3;
	public static final int SUSCRIPCION_NO_CONFIRMADA = 4;
	public static final int ELIMINAR_SUSCRIPCION = 5;


	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "NEWSLETTER";

	/**
	 * Ejecuta la accin de negocio y la redireccion a la sub-accion
	 * que necesita dependiendo del identificativo del transporte.
	 *
	 * @param appContext Contexto de la aplicacin
	 * @param transport Transporte de negocio
	 *
	 * @return Transporte de negocio
	 *
	 * @throws BFActionException the BF action exception
	 */
	public BTransport doExecute(BIContext appContext, BTransport transport) throws BFActionException{
		BTransport backTransport = transport;

		switch(transport.getIdSubBackAction()){
			case S12FNewsletter.CONST_INSERTAR_FORM:
				backTransport = this.insertFormulario(appContext,(S12Newsletter)backTransport.getParameter("newsletter"));
				break;

			case S12FNewsletter.CONST_SELEC_MAILS:
				backTransport = this.selectEmails(appContext);
				break;

			case S12FNewsletter.CONST_SELEC_PROVINCIAS:
				backTransport = this.selectProvincias(appContext);
				break;

			case S12FNewsletter.SUSCRIPCION_NO_CONFIRMADA:
				backTransport.addError(new BBackError(S12FErrors.SUSCRIPCION_NO_CONFIRMADA));
				break;
			case S12FNewsletter.ELIMINAR_SUSCRIPCION:
				backTransport = this.eliminarSuscripcion(appContext,(S12Newsletter)backTransport.getParameter("newsletter"));
				break;
			default:
				break;
		}


		return backTransport;
	}



	/**
	 * Select provincias.
	 *
	 * @param context the context
	 *
	 * @return the b transport
	 *
	 * @throws BFActionException the BF action exception
	 */
	private BTransport selectProvincias(BIContext context) throws BFActionException {

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FNewsletter.COMPONENTE, Q70TraceLevel.DEBUG, "S12FNewsletter::selectProvincias: INICIO");
		}

		BTransport backTransport = new BTransport();
		S12ProvinciasQuery queryProvincias = new S12ProvinciasQuery();
		S12PaisesTraduccionesQuery queryPaises = new S12PaisesTraduccionesQuery();
		S12NewsletterQuery queryNewsletter = new S12NewsletterQuery();

		try {
			queryNewsletter = (S12NewsletterQuery)S12SearchSrv.doSearch(context,queryNewsletter);
		}catch (Exception e) {
			e.printStackTrace();
		}

		backTransport.addParameter("queryDestinatarios",queryNewsletter);
		//backTransport = this.selectEmails(context);

		try{

			queryProvincias.setTodas(true);
			queryProvincias = (S12ProvinciasQuery)S12SearchSrv.doSearch(context,queryProvincias);
			queryPaises = (S12PaisesTraduccionesQuery)S12SearchSrv.doSearch(context, queryPaises);
		}catch (Exception e) {
			e.printStackTrace();
		}

		backTransport.addParameter("provincias", queryProvincias);
		backTransport.addParameter("paises", queryPaises);

		//backTransport = this.selectEmails(context);
		//backTransport.addParameter("queryLstEmails",this.selectEmails(context));

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FNewsletter.COMPONENTE, Q70TraceLevel.DEBUG, "S12FNewsletter::selectProvincias: FIN");
		}
		return backTransport;
	}


	/**
	 * Insert formulario.
	 *
	 * @param context the context
	 * @param newsletter the newsletter
	 *
	 * @return the b transport
	 *
	 * @throws BFActionException the BF action exception
	 */
	public BTransport insertFormulario(BIContext context,S12Newsletter newsletter) throws BFActionException{
		BTransport backTransport = new BTransport();

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FNewsletter.COMPONENTE, Q70TraceLevel.DEBUG, "S12FNewsletter::insertFormulario: INICIO");
		}

//		if(!"OK".equals(newsletter.getErrorPhpList())){
//			throw new BFActionException("BPersistenceException", "Error al aadir la suscripcin a las listas de PHP. " + newsletter.getErrorPhpList());
//		}

		try {
			newsletter = (S12Newsletter)S12PersistenceSrv.doPersistence(context,newsletter,S12PersistenceSrv.GETOBJECTBYID);
		} catch (BPersistenceException e) {
			try {
				newsletter = (S12Newsletter)S12PersistenceSrv.doPersistence(context,newsletter,S12PersistenceSrv.CREATEOBJECT);
			} catch (BPersistenceException e1) {
				throw new BFActionException("BPersistenceException: Error al aadir la suscripcin de Newsletter EN BD", e1.getMessage());
			}
		}


		backTransport.addParameter("newsletter",newsletter);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FNewsletter.COMPONENTE, Q70TraceLevel.DEBUG, "S12FNewsletter::insertFormulario: FIN");
		}

		return backTransport;
	}


	/**
	 * Select emails.
	 *
	 * @param context the context
	 *
	 * @return the b transport
	 *
	 * @throws BFActionException the BF action exception
	 */
	private BTransport selectEmails(BIContext context) throws BFActionException{

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FNewsletter.COMPONENTE, Q70TraceLevel.DEBUG, "S12FNewsletter::selectEmails: INICIO");
		}

		BTransport backTransport = new BTransport();
		S12NewsletterQuery queryNewsletter = new S12NewsletterQuery();

		//esta es la busqueda para mostrar en la tabla todos los usuarios a los que se les va a mandar el Email
		try {
			queryNewsletter = (S12NewsletterQuery)S12SearchSrv.doSearch(context,queryNewsletter);
		}catch (Exception e) {
			e.printStackTrace();
		}

		backTransport.addParameter("queryDestinatarios",queryNewsletter);


		//generaremos las busquedas para conseguir los emails de los usuarios segun el idioma que hayan establecido
		String[] lstIdiomas = {"es","eu","en","fr","de"};
		//S12NewsletterQuery queryIdiomas = new S12NewsletterQuery();
		for (int i=0; i<lstIdiomas.length; i++){
			S12NewsletterQuery queryIdiomas = new S12NewsletterQuery();
			queryIdiomas.setIdioma(lstIdiomas[i]);
			try {
				queryIdiomas = (S12NewsletterQuery)S12SearchSrv.doSearch(context,queryIdiomas);
				backTransport.addParameter("queryIdiomas_"+lstIdiomas[i],queryIdiomas);
			} catch (BSearchException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FNewsletter.COMPONENTE, Q70TraceLevel.DEBUG, "S12FNewsletter::selectEmails: FIN");
		}

		return backTransport;
	}

	/**
	 * Eliminar suscripcin.
	 *
	 * @param context the context
	 * @param newsletter the newsletter
	 *
	 * @return the b transport
	 *
	 * @throws BFActionException the BF action exception
	 */
	private BTransport eliminarSuscripcion(BIContext context, S12Newsletter newsletter) throws BFActionException{
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FNewsletter.COMPONENTE, Q70TraceLevel.DEBUG, "S12FNewsletter::eliminarSuscripcion: INICIO");
		}

		BTransport backTransport = new BTransport();

		if(!"OK".equals(newsletter.getErrorPhpList())){
			throw new BFActionException("BPersistenceException", "Error al aadir la suscripcin a las listas de PHP. " + newsletter.getErrorPhpList());
		}

		try {
			S12PersistenceSrv.doPersistence(context, newsletter, S12PersistenceSrv.DELETEOBJECT);
		}catch (BPersistenceException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12FNewsletter.COMPONENTE, Q70TraceLevel.ERROR, "Error al eliminar la suscripcin del newsletter");
			}
			throw new BFActionException("BPersistenceException", "Error al eliminar la suscripcin del newsletter de las listas de PHP. " + newsletter.getErrorPhpList());
		}

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FNewsletter.COMPONENTE, Q70TraceLevel.DEBUG, "S12FNewsletter::eliminarSuscripcion: FIN");
		}
		return backTransport;
	}


}
