package s12.accionesNegocio.logotipos;

import s12.accionesNegocio.S12FErrors;
import s12.report.S12LogotiposReport;
import s12.report.S12ReportSrv;
import s12.valueObjects.S12PersistenceSrv;
import s12.valueObjects.comun.S12Idioma;
import s12.valueObjects.logotipos.S12LogotiposMail;
import s12.valueObjects.logotipos.S12SolicitudLogotipo;
import bilbofrmk.FacadeEJB.BFBaseAction;
import bilbofrmk.context.BIContext;
import bilbofrmk.email.BEMailMessage;
import bilbofrmk.email.BEMailSender;
import bilbofrmk.exceptions.BDuplicateKeyException;
import bilbofrmk.exceptions.BEMailSendingException;
import bilbofrmk.exceptions.BFActionException;
import bilbofrmk.exceptions.BPersistenceException;
import bilbofrmk.exceptions.BReportException;
import bilbofrmk.trasport.BBackError;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * Clase que representa la acciones de negocio necesarias para crear un
 * informe de Logotipos (en este caso sera el mail para enviar una solicitud)
 *  
 */
public class S12FLogotiposHTML extends BFBaseAction{ // NO_UCD

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "LOGOTIPOS";

	/**
	 * Ejecuta la accin de negocio y la redireccion a la sub-accin
	 * necesaria dependiendo del identificativo del transporte.
	 *
	 * @param appContext Contexto de la aplicacin
	 * @param transport Transporte de negocio
	 *
	 * @return Transporte de negocio
	 *
	 * @throws BFActionException the BF action exception
	 */
	public BTransport doExecute(BIContext appContext, BTransport transport) throws BFActionException {
		BTransport backTransport = null;

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FLogotiposHTML.COMPONENTE, Q70TraceLevel.DEBUG, "S12FLogotiposHTML::doExecute: Inicio");
		}

		switch(transport.getIdSubBackAction()){

		case 1:
			backTransport = transport;
			break;

		case 2:
			backTransport = this.enviarSolicitud(appContext, (S12SolicitudLogotipo) transport.getParameter("solicitud"), (S12Idioma) transport.getParameter("idioma"));
			break;

		default:
			backTransport = transport;
			break;
		}
		return backTransport;
		}

	/**
	 * Enviar Solicitud.
	 *
	 * @param context the context
	 * @param solicitud the solicitud
	 * @param idioma the idioma
	 *
	 * @return the b transport
	 *
	 * @throws BFActionException the BF action exception
	 */
	public BTransport enviarSolicitud(BIContext context, S12SolicitudLogotipo solicitud, S12Idioma idioma) throws BFActionException {
		BTransport backTransport = new BTransport();

			try{
					solicitud = (S12SolicitudLogotipo)S12PersistenceSrv.doPersistence(context,solicitud,S12PersistenceSrv.CREATEOBJECT);
					this.enviarEmail(solicitud, context, idioma);
					backTransport.addParameter("solicitud", solicitud);
			    return backTransport;
			}catch(BDuplicateKeyException e1){
				BBackError error =  new BBackError(S12FErrors.SOLICITUD_DUPLICADO);
				backTransport.addError(error);
				return backTransport;
			}catch(BPersistenceException e1){
				BBackError error =  new BBackError(S12FErrors.SOLICITUD_INTEGRIDADREFERENCIAL);
				backTransport.addError(error);
				return backTransport;
				//throw new BFActionException("S12FLogotiposHTML","insertSolicitud",e1);
			}
		/*}catch(BPersistenceException e){
			throw new BFActionException("S12FLogotiposHTML","insertSolicitud",e);
		}*/
	}


	/**
	 * enviarEmail
	 *
	 * @param solicitud the solicitud
	 * @param context the context
	 * @param idioma the idioma
	 *
	 * @throws BFActionException the BF action exception
	 */
	private void enviarEmail(S12SolicitudLogotipo solicitud, BIContext context, S12Idioma idioma) throws BFActionException {

		S12LogotiposReport logotiposReport=new S12LogotiposReport();
		S12LogotiposMail logotiposMail = new S12LogotiposMail();
		logotiposMail.setToSolicitud(solicitud.getEmail());
		logotiposMail.setFromSolicitud(Q70ListenerUtils.getApplicationProperty("LOGOTIPOS_EMAIL_FROM"));
		logotiposMail.setMensajeSolicitud("mensaje");

		logotiposReport.setLogotiposMail(logotiposMail);
		logotiposReport.setSolicitud(solicitud);
		String xslPath=Q70ListenerUtils.getApplicationProperty("XSL_FILE_PATH");
		logotiposReport.setXSLPath(xslPath);
		//logotiposReport.setIdioma((S12Idioma) this.getSessionValueObjectFromContext("idioma"));
		logotiposReport.setIdioma(idioma);

		String plantilla = logotiposMail.getPlantillaSolicitud();
		logotiposReport.setXSLTemplateFile(plantilla);
		try{
			logotiposReport=(S12LogotiposReport)S12ReportSrv.doReport(context,logotiposReport);
		}
		catch(BReportException e)
		{
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12FLogotiposHTML.COMPONENTE, Q70TraceLevel.DEBUG, "S12FLogotiposHTML::enviarEmail-Fin");
			}
		}

		String emailServer=Q70ListenerUtils.getApplicationProperty("email.smtp.server");
		String notDeliveryAddress=Q70ListenerUtils.getApplicationProperty("mailbox.notdelivery");
		BEMailMessage eMailMessage = new BEMailMessage();
		BEMailSender sendMessage = new BEMailSender();
		eMailMessage.setFrom(logotiposMail.getFromSolicitud());
		eMailMessage.setEmailServer(emailServer);
		String message ="";

		try {
			message = Q70GestorMensajesi18n.getSingleton().getMessage("s12Logotipos","solicitudLogotipo.asuntoMail",idioma.getIdIdioma(),null);
		}catch(Q70GestorMensajesException e){
    		//throw new JspException(e);
    }
		eMailMessage.setSubject(message);
		eMailMessage.setNotDeliveryAddress(notDeliveryAddress);
		eMailMessage.setMsgBodyText(logotiposReport.getTransformedXML().toString());
		eMailMessage.addTo(Q70ListenerUtils.getApplicationProperty("LOGOTIPOS_EMAIL_TO"));
		try{
			sendMessage.send(eMailMessage);
		}catch (BEMailSendingException e) {
			throw new BFActionException("S12FLogotiposHTML","enviarEmailSolicitud",e);
		}catch (Exception e){
    	if (Q70Factoria.getTraza().isTraceActive()) {
  			Q70Factoria.getTraza().trace(S12FLogotiposHTML.COMPONENTE, Q70TraceLevel.ERROR,"S12FLogotiposHTML::enviarEmail: Error al enviar el correo de notificacin");
  		}
    	throw new BFActionException("S12FLogotiposHTML","enviarEmailSolicitud",e);
    }
	}
}
