package s12.accionesNegocio.adminLogotipos;

import s12.accionesNegocio.S12FErrors;
import s12.search.S12LogotiposQuery;
import s12.search.S12SearchSrv;
import s12.valueObjects.S12PersistenceSrv;
import s12.valueObjects.logotipos.S12SolicitudLogotipo;
import bilbofrmk.FacadeEJB.BFBaseAction;
import bilbofrmk.context.BIContext;
import bilbofrmk.exceptions.BFActionException;
import bilbofrmk.exceptions.BObjectNotFoundException;
import bilbofrmk.exceptions.BPersistenceException;
import bilbofrmk.trasport.BBackError;
import bilbofrmk.trasport.BTransport;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 * Clase que representa la acciones de negocio necesarias para el mantenimiento
 * de Solicitudes de Logotipos
 *  
 */
public class S12FMantLogotipos extends BFBaseAction{ // NO_UCD

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "LOGOTIPOS";

	/** The Constant CONST_CARGA_INICIAL. */
	public static final int CONST_CARGA_INICIAL = 1;

	/** The Constant CONST_CARGA_INICIAL. */
	public static final int CONST_VER_SOLICITUD = 2;

	/**
	 * Ejecuta la accin de negocio y la redireccion a la sub-accin
	 * necesaria dependiendo del identificativo del transporte.
	 *
	 * @param appContext Contexto de la aplicacin
	 * @param transport Transporte de negocio
	 *
	 * @return Transporte de negocio
	 *
	 * @throws BFActionException the BF action exception
	 */
	public BTransport doExecute(BIContext appContext, BTransport transport) throws BFActionException {
		BTransport backTransport = null;

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FMantLogotipos.COMPONENTE, Q70TraceLevel.DEBUG, "S12FMantLogotipos::doExecute: Inicio");
		}

		switch(transport.getIdSubBackAction()){
			case S12FMantLogotipos.CONST_CARGA_INICIAL:
				backTransport = this.carga(appContext);
				break;

			case S12FMantLogotipos.CONST_VER_SOLICITUD:
				backTransport = this.loadSolicitud(appContext, (S12SolicitudLogotipo)transport.getParameter("solicitud"));
				break;

			default:
				break;
		}

		return backTransport;
		}

	/**
	 * Carga inicial.
	 *
	 * @param context the context
	 *
	 * @return the b transport
	 *
	 * @throws BFActionException the BF action exception
	 */
	private BTransport carga(BIContext context) throws BFActionException{

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FMantLogotipos.COMPONENTE, Q70TraceLevel.DEBUG, "S12FMantLogotipos(carga)::processS12InitOP: INICIO");
		}

		BTransport backTransport = new BTransport();
		S12LogotiposQuery queryLogotipos = new S12LogotiposQuery();

		try {
			queryLogotipos = (S12LogotiposQuery)S12SearchSrv.doSearch(context,queryLogotipos);
		}catch (Exception e) {
			e.printStackTrace();
		}

		backTransport.addParameter("queryLogotipos",queryLogotipos);

		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12FMantLogotipos.COMPONENTE, Q70TraceLevel.DEBUG, "S12FMantLogotipos(carga)::processS12InitOP: FIN");
		}

		return backTransport;
	}


	/**
	 * Carga los datos de una solicitud para ello realiza lo siguiente:
	 * - Comprueba si existe
	 * - Si existe lo devuelve en el transporte
	 * - Si no existe devuelve una excepcin que la guarda en los errores
	 * de negocio del transporte.
	 *
	 * @param context Contexto de la aplicacin
	 * @param solicitud Objeto solicitud
	 *
	 * @return Transporte donde devuelve los datos
	 *
	 * @throws BFActionException the BF action exception
	 */
	public BTransport loadSolicitud(BIContext context, S12SolicitudLogotipo solicitud)throws BFActionException {
		BTransport backTransport = new BTransport();
		try{
			S12SolicitudLogotipo solicitudTmp = (S12SolicitudLogotipo)S12PersistenceSrv.doPersistence(context,solicitud,S12PersistenceSrv.GETOBJECTBYID);
			backTransport.addParameter("solicitud",solicitudTmp);
			return backTransport;
		}catch(BObjectNotFoundException e){
			BBackError error = new BBackError(S12FErrors.TEMA_NOEXISTE);
			backTransport.addError(error);
			return backTransport;
		}catch(BPersistenceException e){
			throw new BFActionException("S12FMantLogotipos","loadSolicitud",e);
		}
	}
}
