/*
 * Created on 30-jun-2005
 *
 */
package s12.accionesNegocio;

import s12.search.S12SearchSrv;
import bilbofrmk.FacadeEJB.BFBaseAction;
import bilbofrmk.context.BIContext;
import bilbofrmk.exceptions.BFActionException;
import bilbofrmk.exceptions.BSearchException;
import bilbofrmk.search.BBaseQuery;
import bilbofrmk.trasport.BTransport;
/**
 * The Class S12FSearchAction.
 *
 *  
 */
public class S12FSearchAction extends BFBaseAction { // NO_UCD

	/**
	 * Do execute.
	 *
	 * @param appContex the app contex
	 * @param trasport the trasport
	 *
	 * @return the b transport
	 *
	 * @throws BFActionException the BF action exception
	 *
	 * @see bilbofrmk.FacadeEJB.BFBaseAction#doExecute(bilbofrmk.context.BIContext, bilbofrmk.trasport.BTransport)
	 */
	public BTransport doExecute(BIContext appContex, BTransport trasport)
			throws BFActionException {

		BBaseQuery query = (BBaseQuery) trasport.getParameter("query");
		query = this.doSearch(appContex,query);

		BTransport backTranport = new BTransport();
		backTranport.addParameter("query",query);

		return backTranport;
	}


	/**
	 * Do search.
	 *
	 * @param appContex the app contex
	 * @param query the query
	 *
	 * @return the b base query
	 *
	 * @throws BFActionException the BF action exception
	 */
	public BBaseQuery doSearch(BIContext appContex, BBaseQuery query)throws BFActionException {
		try{
			return S12SearchSrv.doSearch(appContex,query);
		}catch(BSearchException e){
			throw new BFActionException("S12FSearchAction","Error del servicio de bsquedas",e);
		}

	}

}
