package s12.valueObjects.usuarios;

import java.util.ArrayList;

import bilbofrmk.valueObjects.BBaseValueObject;

/**
 * Clase que representa un usuario y los mtodos para trabajar con el.
 * Un usuario puede tener una serie de perfiles.
 *  
 */
public class S12Usuario extends BBaseValueObject {

	/**
	 *
	 */
	private static final long serialVersionUID = 7438237567489905520L;
	/**
	 * Cdigo de la sesin
	 */
	private String idSession;
	/**
	 * Nombre del Usuario conectado
	 */
	private String nombre;
	/**
	 * Identificativo de Xlnet conectado
	 */
	private String idXlnet;
	/**
	 * Idioma del usuario conectado
	 */
	private String idioma;
	/**
	 * Lista de perfiles que tiene le usuario
	 */
	private ArrayList arrPerfilesXlnet;

	/**
	 * Devuelve el cdigo de la sesin
	 * @return Cdigo de la sesin
	 */
	public String getIdSession() {
		return this.idSession;
	}
	/**
	 * Fijar el cdigo de la sesin
	 * @param idSession Cdigo de la sesin a fijar
	 */
	public void setIdSession(String idSession) {
		this.idSession = idSession;
	}
	/**
	 * Devuelve el nombre del Usuario conectado
	 * @return Nombre del Usuario
	 */
	public String getNombre() {
		return this.nombre;
	}
	/**
	 * Fija el nombre del Usuario conectado
	 * @param nombre Nombre del Usuario conectado a fijar
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Devuelve la lista de perfiles que puede tener el Usuario conectado
	 * @return ArrayList de perfiles del Usuario
	 */
	public ArrayList getArrPerfilesXlnet() {
		return this.arrPerfilesXlnet;
	}
	/**
	 * Fija los perfiles que puede tener el Usuario conectado en una lista
	 * @param arrPerfilesXlnet Lista de perfiles a fijar
	 */
	public void setArrPerfilesXlnet(ArrayList arrPerfilesXlnet) {
		this.arrPerfilesXlnet = arrPerfilesXlnet;
	}

	/**
	 * Devuelve el idioma asociado al Usuario
	 * @return Idioma del Usuario
	 */
	public String getIdioma() {
		return this.idioma;
	}
	/**
	 * Fija el idioma del Usuario
	 * @param idioma Idioma a fijar
	 */
	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}
	/**
	 * Devuelve el cdigo XlNet del Usuario
	 * @return Cdigo XlNet
	 */
	public String getIdXlnet() {
		return this.idXlnet;
	}
	/**
	 * Fija el cdigo XlNet del Usuario
	 * @param idXlnet Cdigo XlNet del Usuario
	 */
	public void setIdXlnet(String idXlnet) {
		this.idXlnet = idXlnet;
	}
}
