package s12.valueObjects.newsletter;

import java.sql.Date;
import bilbofrmk.valueObjects.BBaseValueObject;

/**
  *
  *  
  */
public class S12Newsletter extends BBaseValueObject {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -360447522988809128L;

	/** The Constant NEWSLETTER. */
	private final static String NEWSLETTER = "N";

	/** The tipo. */
	private String tipo;

	/** Nombre del autor del formulario. */
	private String nombre;

	/** Apellido del autor del formulario. */
	private String apellido;

	/** Email del autor del formulario. */
	private String email;

	/** Fecha en la que se escribe el formulario. */
	private Date creation;

	/** Telefono del autor del formulario. */
	private String telefono;

	/** Direccion del autor del formulario. */
	private String direccion;

	/** Poblacion del autor del formulario. */
	private String poblacion;

	/** Provincia del autor del formulario. */
	private String provincia;

	/** Pais del autor del formulario. */
	private String pais;

	/** Idioma del autor del formulario. */
	private String idioma;

	/** The codigo html_es. */
	private StringBuffer codigoHtmles;

	/** The codigo html_eu. */
	private StringBuffer codigoHtmleu;

	/** The codigo html_en. */
	private StringBuffer codigoHtmlen;

	/** The codigo html_fr. */
	private StringBuffer codigoHtmlfr;

	/** The codigo html_de. */
	private StringBuffer codigoHtmlde;

	/** The sexo. */
	private String sexo;

	/** The error php list. */
	private String errorPhpList;

	/** The borrado. */
	private boolean borrado;

	/**
	 * Instantiates a new s12 newsletter.
	 */
	public S12Newsletter() {
		this.tipo = S12Newsletter.NEWSLETTER;
		this.nombre = null;
		this.apellido = null;
		this.creation = null;
		this.telefono = null;
		this.email = null;
		this.direccion = null;
		this.poblacion = null;
		this.provincia = null;
		this.pais = null;
		this.idioma = null;
		this.codigoHtmles = null;
		this.codigoHtmleu = null;
		this.codigoHtmlen = null;
		this.codigoHtmlfr = null;
		this.codigoHtmlde = null;
		this.sexo = null;
	}


	/**
	 * Gets the codigo html_es.
	 *
	 * @return the codigo html_es
	 */
	public StringBuffer getCodigoHtmles() {
		return this.codigoHtmles;
	}


	/**
	 * Sets the codigo html_es.
	 *
	 * @param codigoHtml_es the new codigo html_es
	 */
	public void setCodigoHtmles(StringBuffer codigoHtml_es) {
		this.codigoHtmles = codigoHtml_es;
	}

	/**
	 * Gets the codigo html_eu.
	 *
	 * @return the codigo html_eu
	 */
	public StringBuffer getCodigoHtmleu() {
		return this.codigoHtmleu;
	}


	/**
	 * Sets the codigo html_eu.
	 *
	 * @param codigoHtml_eu the new codigo html_eu
	 */
	public void setCodigoHtmleu(StringBuffer codigoHtml_eu) {
		this.codigoHtmleu = codigoHtml_eu;
	}


	/**
	 * Gets the codigo html_en.
	 *
	 * @return the codigo html_en
	 */
	public StringBuffer getCodigoHtmlen() {
		return this.codigoHtmlen;
	}


	/**
	 * Sets the codigo html_en.
	 *
	 * @param codigoHtml_en the new codigo html_en
	 */
	public void setCodigoHtmlen(StringBuffer codigoHtml_en) {
		this.codigoHtmlen = codigoHtml_en;
	}


	/**
	 * Gets the codigo html_fr.
	 *
	 * @return the codigo html_fr
	 */
	public StringBuffer getCodigoHtmlfr() {
		return this.codigoHtmlfr;
	}


	/**
	 * Sets the codigo html_fr.
	 *
	 * @param codigoHtml_fr the new codigo html_fr
	 */
	public void setCodigoHtmlfr(StringBuffer codigoHtml_fr) {
		this.codigoHtmlfr = codigoHtml_fr;
	}


	/**
	 * Gets the codigo html_de.
	 *
	 * @return the codigo html_de
	 */
	public StringBuffer getCodigoHtmlde() {
		return this.codigoHtmlde;
	}


	/**
	 * Sets the codigo html_de.
	 *
	 * @param codigoHtml_de the new codigo html_de
	 */
	public void setCodigoHtmlde(StringBuffer codigoHtml_de) {
		this.codigoHtmlde = codigoHtml_de;
	}


	/**
	 * Sets the tipo.
	 *
	 * @param tipo the new tipo
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * Sets the nombre.
	 *
	 * @param nombre the new nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Gets the tipo.
	 *
	 * @return the tipo
	 */
	public String getTipo() {
		return this.tipo;
	}

	/**
	 * Devuelve la fecha en la que se escribi el formulario.
	 *
	 * @return Fecha de escritura del formulario
	 */
	public Date getCreation() {
		return this.creation;
	}

	/**
	 * Fija la fecha en la que se escribe el formulario.
	 *
	 * @param creation the creation
	 */
	public void setCreation(Date creation) {
		this.creation = creation;
	}

	/**
	 * Devuelve la nombre del formulario.
	 *
	 * @return Descripcin del formulario
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Fija el nombre del formulario.
	 *
	 * @param nombre the nombre
	 */
	public void setNombe(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Devuelve el mail del formulario.
	 *
	 * @return mail del formulario
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * Fija el Email del formulario.
	 *
	 * @param email the email
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * Devuelve el telefono del formulario.
	 *
	 * @return telefono del formulario
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * Fija el Telefono del formulario.
	 *
	 * @param telefono the telefono
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * Devuelve el direccion del formulario.
	 *
	 * @return direccion del formulario
	 */
	public String getDireccion() {
		return this.direccion;
	}

	/**
	 * Fija el direccion del formulario.
	 *
	 * @param direccion del formulario a fijar
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}

	/**
	 * Devuelve el poblacion del formulario.
	 *
	 * @return poblacion del formulario
	 */
	public String getPoblacion() {
		return this.poblacion;
	}

	/**
	 * Fija el poblacion del formulario.
	 *
	 * @param poblacion del formulario a fijar
	 */
	public void setPoblacion(String poblacion) {
		this.poblacion = poblacion;
	}

	/**
	 * Devuelve el provincia del formulario.
	 *
	 * @return provincia del formulario
	 */
	public String getProvincia() {
		return this.provincia;
	}

	/**
	 * Fija el provincia del formulario.
	 *
	 * @param provincia del formulario a fijar
	 */
	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	/**
	 * Devuelve el apellido del formulario.
	 *
	 * @return apellido del formulario
	 */
	public String getApellido() {
		return this.apellido;
	}

	/**
	 * Fija el apellido del formulario.
	 *
	 * @param apellido del formulario a fijar
	 */
	public void setApellido(String apellido) {
		this.apellido = apellido;
	}

	/**
	 * Devuelve el pais del formulario.
	 *
	 * @return pais del formulario
	 */
	public String getPais() {
		return this.pais;
	}

	/**
	 * Fija el pais del formulario.
	 *
	 * @param pais del formulario a fijar
	 */
	public void setPais(String pais) {
		this.pais = pais;
	}

	/**
	 * Devuelve el idioma del formulario.
	 *
	 * @return idioma del formulario
	 */
	public String getIdioma() {
		return this.idioma;
	}

	/**
	 * Fija el idioma del formulario.
	 *
	 * @param idioma del formulario a fijar
	 */
	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}


	/**
	 * Gets the sexo.
	 *
	 * @return the sexo
	 */
	public String getSexo() {
		return this.sexo;
	}


	/**
	 * Sets the sexo.
	 *
	 * @param sexo the new sexo
	 */
	public void setSexo(String sexo) {
		this.sexo = sexo;
	}


	/**
	 * Gets the error php list.
	 *
	 * @return the error php list
	 */
	public String getErrorPhpList() {
		return this.errorPhpList;
	}


	/**
	 * Sets the error php list.
	 *
	 * @param errorPhpList the new error php list
	 */
	public void setErrorPhpList(String errorPhpList) {
		this.errorPhpList = errorPhpList;
	}


	/**
	 * Checks if is borrado.
	 *
	 * @return true, if is borrado
	 */
	public boolean isBorrado() {
		return this.borrado;
	}


	/**
	 * Sets the borrado.
	 *
	 * @param borrado the new borrado
	 */
	public void setBorrado(boolean borrado) {
		this.borrado = borrado;
	}
}
