package s12.valueObjects.logotipos;

import java.sql.Date;
import bilbofrmk.valueObjects.BBaseValueObject;

/**
  * Clase que representa la Solicitud para utilizar el Logotipo Euskadi.
  *
  *  
  */
public class S12SolicitudLogotipo extends BBaseValueObject {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -360447522988809128L;


	/** Identificativo interno autonumerico. */
	private long id;

	/** Fecha en la que se envia la solicitud. */
	private Date fechaEnvio;

	/** Entidad solicitante. */
	private String entidad;

	/** Responsable. */
	private String responsable;

	/** Telefono. */
	private String telefono;

	/** Email. */
	private String email;

	/** Aplicaciones de uso. */
	private String aplicaciones;

	/** Tamano del Logotipo. */
	private String tamano;

	/** Fondo del Logotipo. */
	private String fondo;

	/** Idiomas de uso del Logotipo. */
	private String idiomas;

	/** Sugerencias y comentarios. */
	private String sugerencias;

	/**
	 * Instantiates a new s12 solicitud logotipo.
	 */
	public S12SolicitudLogotipo() {
		this.id = -1;
		this.fechaEnvio = null;
		this.entidad = null;
		this.responsable = null;
		this.telefono = null;
		this.email = null;
		this.aplicaciones = null;
		this.tamano = null;
		this.fondo = null;
		this.idiomas = null;
		this.sugerencias = null;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public long getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(long id) {
		this.id = id;
	}

	/**
	 * Gets the fecha envio.
	 *
	 * @return the fecha envio
	 */
	public String getFechaEnvio() {
		return this.fechaEnvio.toString();
	}

	/**
	 * Sets the fecha envio.
	 *
	 * @param fechaEnvio the new fecha envio
	 */
	public void setFechaEnvio(Date fechaEnvio) {
		this.fechaEnvio = fechaEnvio;
	}

	/**
	 * Gets the entidad.
	 *
	 * @return the entidad
	 */
	public String getEntidad() {
		return this.entidad;
	}

	/**
	 * Sets the entidad.
	 *
	 * @param entidad the new entidad
	 */
	public void setEntidad(String entidad) {
		this.entidad = entidad;
	}

	/**
	 * Gets the responsable.
	 *
	 * @return the responsable
	 */
	public String getResponsable() {
		return this.responsable;
	}

	/**
	 * Sets the responsable.
	 *
	 * @param responsable the new responsable
	 */
	public void setResponsable(String responsable) {
		this.responsable = responsable;
	}

	/**
	 * Gets the telefono.
	 *
	 * @return the telefono
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * Sets the telefono.
	 *
	 * @param telefono the new telefono
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * Gets the email.
	 *
	 * @return the email
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * Sets the email.
	 *
	 * @param email the new email
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * Gets the aplicaciones.
	 *
	 * @return the aplicaciones
	 */
	public String getAplicaciones() {
		return this.aplicaciones;
	}

	/**
	 * Sets the aplicaciones.
	 *
	 * @param aplicaciones the new aplicaciones
	 */
	public void setAplicaciones(String aplicaciones) {
		this.aplicaciones = aplicaciones;
	}

	/**
	 * Gets the tamano.
	 *
	 * @return the tamano
	 */
	public String getTamano() {
		return this.tamano;
	}

	/**
	 * Sets the tamano.
	 *
	 * @param tamano the new tamano
	 */
	public void setTamano(String tamano) {
		this.tamano = tamano;
	}

	/**
	 * Gets the fondo.
	 *
	 * @return the fondo
	 */
	public String getFondo() {
		return this.fondo;
	}

	/**
	 * Sets the fondo.
	 *
	 * @param fondo the new fondo
	 */
	public void setFondo(String fondo) {
		this.fondo = fondo;
	}

	/**
	 * Gets the idiomas.
	 *
	 * @return the idiomas
	 */
	public String getIdiomas() {
		return this.idiomas;
	}

	/**
	 * Sets the idiomas.
	 *
	 * @param idiomas the new idiomas
	 */
	public void setIdiomas(String idiomas) {
		this.idiomas = idiomas;
	}

	/**
	 * Gets the sugerencias.
	 *
	 * @return the sugerencias
	 */
	public String getSugerencias() {
		return this.sugerencias;
	}

	/**
	 * Sets the sugerencias.
	 *
	 * @param sugerencias the new sugerencias
	 */
	public void setSugerencias(String sugerencias) {
		this.sugerencias = sugerencias;
	}

}
