package s12.valueObjects.logotipos;

import bilbofrmk.valueObjects.BBaseValueObject;

/**
 * Clase que representa una mensaje de correo de una solicitud y presenta los mtodos para trabajar con el.
 *  
 */
public class S12LogotiposMail extends BBaseValueObject{

	/**
	 *
	 */
	private static final long serialVersionUID = 2371334587058604163L;
	/**
	 * Cdigo de solicitud
	 */
	private long codSolicitud;
	/**
	 * Direccin del destinatario de la solicitud
	 */
	private String toSolicitud;
	/**
	 * Mensaje
	 */
	private String mensajeSolicitud;
	/**
	 * Direccin del remitente de la Solicitud
	 */
	private String fromSolicitud;
	/**
	 * Plantilla de la postal
	 */
	private static String plantillaSolicitud = "s12-Logotipos.xsl";



	/**
	 * Devuelve el cdigo de la Solicitud
	 * @return Cdigo de la Solicitud
	 */
	public long getCodSolicitud() {
		return this.codSolicitud;
	}
	/**
	 * Fija el cdigo de la solicitud
	 * @param codSolicitud Cdigo de la solicitud a fijar
	 */
	public void setCodSolicitud(long codSolicitud) {
		this.codSolicitud = codSolicitud;
	}
	/**
	 * Devuelve la direccin del remitente de la solicitud
	 * @return Direccin del remitente
	 */
	public String getFromSolicitud() {
		return this.fromSolicitud;
	}
	/**
	 * Fijar la direccin del remitente de la Solicitud
	 * @param fromSolicitud Direccin del remitente
	 */
	public void setFromSolicitud(String fromSolicitud) {
		this.fromSolicitud = fromSolicitud;
	}
	/**
	 * Devuelve el mensaje que se quiere enviar con la Solicitud
	 * @return Mensaje
	 */
	public String getMensajeSolicitud() {
		return this.mensajeSolicitud;
	}
	/**
	 * Fija el mensaje que se quiere enviar con la Solicitud
	 * @param mensajeSolicitud Mensaje a fijar
	 */
	public void setMensajeSolicitud(String mensajeSolicitud) {
		this.mensajeSolicitud = mensajeSolicitud;
	}
	/**
	 * Devuelve la direccin del destinatario a enviar la Solicitud
	 * @return Direccin del destinatario
	 */
	public String getToSolicitud() {
		return this.toSolicitud;
	}
	/**
	 * Fija la direccin del destinatario a enviar la Postal
	 * @param toSolicitud Direccin del destinatario
	 */
	public void setToSolicitud(String toSolicitud) {
		this.toSolicitud = toSolicitud;
	}

	/**
	 * Devuelve la plantilla que contiene el formato del mensaje
	 * de la Solicitud que se quiere enviar
	 * @return Plantilla de Solicitud
	 */
	public String getPlantillaSolicitud() {
		return S12LogotiposMail.plantillaSolicitud;
	}

}
