package s12.valueObjects.comun;

import bilbofrmk.valueObjects.BBaseValueObject;

/**
 * Clase que representa un idioma, contiene el nombre del idioma tanto en castellano como en euskera.
 * La clase presenta los mtodos necesarios para acceder a todos los atributos del idioma.
 *  
 */
public class S12Idioma extends BBaseValueObject {
	/**
	 *
	 */
	private static final long serialVersionUID = 5560586708930575317L;
	/**
	 * Cdigo del idioma
	 */
	private String idIdioma;
	/**
	 * Nombre del idioma en castellano
	 */
	private String nombreIdiomaCas;
	/**
	 * Nombre del idioma en euskera
	 */
	private String nombreIdiomaEus;

	/**
	 * Construye un objeto Idioma inicializando todos sus atributos
	 */
	public S12Idioma(){
		this.idIdioma=null;
		this.nombreIdiomaCas=null;
		this.nombreIdiomaEus=null;
	}

	/**
	 * Devuelve el id del idioma
	 * @return Cdigo de identificacin del idioma
	 */
	public String getIdIdioma() {
		return this.idIdioma;
	}

	/**
	 * Fija el cdigo del idioma.
	 *
	 * @param idIdioma the id idioma
	 */
	public void setIdIdioma(String idIdioma) {
		this.idIdioma = idIdioma;
	}
	/**
	 * Devuelve el nombre del idioma en castellano
	 * @return Nombre del idioma en castellano
	 */
	public String getNombreIdiomaCas() {
		return this.nombreIdiomaCas;
	}
	/**
	 * Fija el nombre del idioma en castellano
	 * @param nombreIdiomaCas Nombre del idioma en castellano
	 */
	public void setNombreIdiomaCas(String nombreIdiomaCas) {
		this.nombreIdiomaCas = nombreIdiomaCas;
	}
	/**
	 * Devuelve el nombre del idioma en euskera
	 * @return Nombre del idioma en euskera
	 */
	public String getNombreIdiomaEus() {
		return this.nombreIdiomaEus;
	}
	/**
	 * Fija el nombre del idioma en euskera
	 * @param nombreIdiomaEus Nombre del idioma en euskera
	 */
	public void setNombreIdiomaEus(String nombreIdiomaEus) {
		this.nombreIdiomaEus = nombreIdiomaEus;
	}
}
