/*
 * Created on 22-ago-2005
 *
 */
package s12.util;

import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.NamingException;

import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;

import bilbofrmk.context.BIlookupBConnection;

/**
 *  
 *
 */
public class S12JDBCConnector implements BIlookupBConnection {


	private static final long serialVersionUID = -9215831377143124718L;

	/**
	 * @param dataSourceName the data source name
	 *
	 * @return the connection
	 *
	 * @throws NamingException the naming exception
	 * @throws SQLException the SQL exception
	 *
	 * @see bilbofrmk.context.BIlookupBConnection#lookupBConnection(java.lang.String)
	 */
	public Connection lookupBConnection(String dataSourceName) throws NamingException,
			SQLException {
		return Q70ConectorJDBC.getSingleton().getConnection(dataSourceName);
	}

	/**
	 * Lookup b connection.
	 *
	 * @return the connection
	 *
	 * @throws NamingException the naming exception
	 * @throws SQLException the SQL exception
	 */
	public Connection lookupBConnection()throws NamingException,SQLException{
		return Q70ConectorJDBC.getSingleton().getConnection(S12AppConfig.getInstance().getValue("S41_JNDI_DATASOURCE"));
	}

}
