package s12.util;

import java.util.Iterator;

import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

//import weblogic.webservice.core.soap.SOAPBodyElementImpl;
//import weblogic.webservice.core.soap.SOAPFaultImpl;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 * Clase que realiza una invocacin al webService que se le pase como parmetro.
 *
 *  
 */
public class S12InvokerWS {

  /** Constante que indica el componente al que pertenece dicha clase. Es necesario para el uso del log de trazas. */
  private static final String COMPONENTE = "INTEGRACION";

  // prefix - String giving the prefix of the namespace.
  /** The Constant PREFIX. */
  private static final String PREFIX = "web";

  // uri - a String giving the URI of the namespace
  /** The Constant TARGET_NAMESPACE. */
  private static final String TARGET_NAMESPACE = "http://www.ejie.es/webService";

  /** The url. */
  private String url;

  /** The method. */
  private String method;

  /** The param names. */
  private String[] paramNames;

  /** The param values. */
  private String[] paramValues;

  /** The prefix. */
  private String prefix;

  /** The target namespace. */
  private String targetNamespace;

  private static final int SIZE_STRINGBUFFER = 45;

  /**
   * Constructor del S41InvokerWS.
   *
   * Define el prefix y el targetNamespace por defecto.
   *
   * @param url String
   * @param method String
   * @param paramNames String
   * @param paramValues String
   *
   *  
   */
  public S12InvokerWS(String url, String method, String[] paramNames, String[] paramValues) {
    this.url = url;
    this.method = method;
    this.paramNames = paramNames;
    this.paramValues = paramValues;
    this.prefix = S12InvokerWS.PREFIX;
    this.targetNamespace = S12InvokerWS.TARGET_NAMESPACE;
  }

  /**
   * Invoca al web service definido por this.
   *
   * @return el resultado de la invocacin soap
   *
   * @throws Exception the exception
   */
  public String invoke() throws Exception {
  	String rtdo = "";
    try {
      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.DEBUG, "S12InvokerWS::invoke: entrada");
      }
      // creamos el mensaje SOAP.
      MessageFactory mfactory = MessageFactory.newInstance();
      SOAPMessage message = mfactory.createMessage();
      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.DEBUG, "S12InvokerWS::invoke: mensaje SOAP creado");
      }

      // conseguimos la parte SOAP del mensaje
      SOAPPart soapPart = message.getSOAPPart();
      // conseguimos el envelope del soapPart
      SOAPEnvelope envelope = soapPart.getEnvelope();
      // conseguimos el body del envelope
      SOAPBody body = envelope.getBody();
      // conseguimos el tnsname del mtodo al que se va a llamar
      Name name = envelope.createName(this.method, this.prefix, this.targetNamespace);
      SOAPBodyElement element = body.addBodyElement(name);
      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.DEBUG, "S12InvokerWS::invoke: conseguidos todos los elementos para invocar al WS");
      }

      // aadimos al body los elementos con los parmetros. Hay que conocer
      // el nombre del parmetro. (Aunque se podra conseguir con el wsdl)
      for (int i=0; i < this.paramNames.length && i < this.paramValues.length; i++) {
          SOAPElement param = element.addChildElement(envelope.createName( this.paramNames[i]) );
          param.addTextNode( this.paramValues[i] );
      }
      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.DEBUG, "S12InvokerWS::invoke: parametros aadidos");
      }

      // conseguimos una conexin SOAP.
      SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
      SOAPConnection con = factory.createConnection();
      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.DEBUG, "S12InvokerWS::invoke: conexion con SOAP creada");
      }

      // hacemos la llamada SOAP y recuperamos la respuesta
      SOAPMessage response = con.call(message, this.url);
      // obtenemos el resultado en forma de String
      rtdo = S12InvokerWS.getResultado(response);
      if (Q70Factoria.getTraza().isTraceActive()) {
        Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.DEBUG, "S12InvokerWS::invoke: resultado de llamada a SOAP: " + rtdo);
      }
    } catch (SOAPFaultException e) {
  		if (Q70Factoria.getTraza().isTraceActive()) {
  			Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.ERROR, "S12InvokerWS::invoke: SOAPFaultException: " + e.getMessage());
  		}
  		//rtdo = "SOAPFaultException: " + e.getMessage();
  		throw new S12WSException(e.getMessage(), e);
    } catch (SOAPException e) {
  		if (Q70Factoria.getTraza().isTraceActive()) {
  			Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.ERROR, "S12InvokerWS::invoke: SOAPFaultException: " + e.getMessage());
  		}
  		//rtdo = "SOAPException: " + e.getMessage();
  		throw new S12WSException(e.getMessage(), e);
    } catch (Exception e) {
  		if (Q70Factoria.getTraza().isTraceActive()) {
  			Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.ERROR, "S12InvokerWS::invoke: Excepcion: " + e.getMessage());
  		}
  		//rtdo = "Exception: " + e.getMessage();
  		throw new S12WSException(e.getMessage(), e);
    }
    return rtdo;
  }

  /**
   * Invoca al web service definido por this.
   *
   * @param response SOAPMessage
   *
   * @return SOAPBodyElement el resultado de la invocacin soap
   *
   * @throws Exception the exception
   */
  private static SOAPBodyElement getSOAPBodyElement(SOAPMessage response) throws Exception {
		SOAPBodyElement rtdo = null;
    try {
      Iterator iterator = response.getSOAPPart().getEnvelope().getBody().getChildElements();
      while (iterator.hasNext()) {
        Object oUndefined = iterator.next();
        if (oUndefined instanceof SOAPBodyElement) {
          rtdo = (SOAPBodyElement) oUndefined;
          break;
        }
      }
    } catch (Exception e) {
  		if (Q70Factoria.getTraza().isTraceActive()) {
  			Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.ERROR, "S12InvokerWS::getSOAPBodyElement: Excepcion: " + e.getMessage());
  		}
      throw e;
    }
    return rtdo;
  }

  /**
   * Obtiene el resultado de la llamada al webservice.
   *
   * @param response SOAPMessage
   *
   * @return SOAPBodyElement el resultado de la invocacin soap
   *
   * @throws Exception the exception
   */
  private static String getResultado(SOAPMessage response) throws Exception {
    String rtdo = "";
    try {
      SOAPBodyElement soapBodyElement = S12InvokerWS.getSOAPBodyElement(response);

      if (soapBodyElement instanceof SOAPBodyElement) {
        // todo ha ido bien... recogemos el resultado.
        String responseElementName = soapBodyElement.getElementName().toString();
        String resultElementName = responseElementName.replaceAll("Response$", "Result");
        resultElementName = resultElementName.substring(2);

        Iterator iterator = soapBodyElement.getChildElements();
        while (iterator.hasNext()) {
        	SOAPElement element = (SOAPElement) iterator.next();
			rtdo = element.getValue();
			break;
        }
      }
      else if (soapBodyElement instanceof SOAPFault) {
        // ha ocurrido un error
        SOAPFault fault = (SOAPFault) soapBodyElement;

        // tratamos el SOAPFault
        // nota: este mtodo lanza una Exception
        S12InvokerWS.tratarSOAPFault(fault);
      } else {
        throw new Exception("El SOAPBodyElement no es una instancia de SOAPBodyElementImpl ni de SOAPFaulImpl");
      }
    } catch (Exception e) {
  		if (Q70Factoria.getTraza().isTraceActive()) {
  			Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.ERROR, "S12InvokerWS::getResultado: Excepcion: " + e.getMessage());
  		}
      throw e;
    }
    return rtdo;
  }

  /**
   * Tratamiento del SOAPFault.
   *
   * @param fault SOAPFault
   *
   * @throws Exception the exception
   */
  private static void tratarSOAPFault(SOAPFault fault) throws Exception {
    try {
      StringBuffer mensajeError = new StringBuffer(S12InvokerWS.SIZE_STRINGBUFFER);
      mensajeError.append("SOAPFault:\n");
      mensajeError.append(" faultCode: " + fault.getFaultCode() + "\n");
      mensajeError.append(" faultString: " + fault.getFaultString() + "\n");

      Detail detail = fault.getDetail();
      StringBuffer detailValue = new StringBuffer(S12InvokerWS.SIZE_STRINGBUFFER);
      Iterator it = detail.getDetailEntries();
      while (it.hasNext()) {
        DetailEntry detailEntry = (DetailEntry) it.next();
        detailValue.append(" detailEntry: " + detailEntry.getValue() + "\n");
      }
    } catch (Exception e) {
  		if (Q70Factoria.getTraza().isTraceActive()) {
  			Q70Factoria.getTraza().trace(S12InvokerWS.COMPONENTE, Q70TraceLevel.ERROR, "S12InvokerWS::tratarSOAPFault: Excepcion: " + e.getMessage());
  		}
      throw e;
    }
  }
}