package s12.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.NamingException;

/**
 * The Class S12ConnectionManager.
 *  tica
 */
public class S12ConnectionManager {

	/**
	 * Instantiates a new s12 connection manager.
	 */
	private S12ConnectionManager (){
		super();
	}

	/**
	 * Gets the connection.
	 *
	 * @return the connection
	 *
	 * @throws NamingException the naming exception
	 * @throws SQLException the SQL exception
	 */
	public static synchronized Connection getConnection() throws NamingException, SQLException
	{
		S12JDBCConnector connector = new S12JDBCConnector();
		Connection conn = connector.lookupBConnection();
		conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
		return conn;
	}


	/**
	 * Close.
	 *
	 * @param conn the conn
	 */
	public static void close(Connection conn) {
		try {
			if (conn != null){
				conn.close();
			}
		}catch (SQLException sqle){
			sqle.printStackTrace();
		}
	}

	/**
	 * Close.
	 *
	 * @param stmt the stmt
	 */
	public static void close(Statement stmt){
		try {
			if (stmt != null){
				stmt.close();
			}
		}catch (SQLException sqle){
			sqle.printStackTrace();
		}
	}

	/**
	 * Close.
	 *
	 * @param rs the rs
	 */
	public static void close(ResultSet rs){
		try {
			if (rs != null){
				rs.close();
			}
		}catch (SQLException sqle){
			sqle.printStackTrace();
		}
	}

	/**
	 * Begin trans.
	 *
	 * @param connection the connection
	 */
	public static void beginTrans(Connection connection){
		try{
//			if(connection.getTransactionIsolation()!=Connection.TRANSACTION_SERIALIZABLE){
//				connection.setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
				connection.setAutoCommit(false);

//			}
		}catch (SQLException sqle){
			sqle.printStackTrace();
		}
	}

	/**
	 * Commit.
	 *
	 * @param conn the conn
	 */
	public static void commit(Connection conn){
		try {
			if (conn != null){
				conn.commit();
			}

		}catch (SQLException sqle){
			sqle.printStackTrace();
		}
	}

	/**
	 * Rollback.
	 *
	 * @param conn the conn
	 */
	public static void rollback(Connection conn){
		try {
			if (conn != null){
				conn.rollback();
			}

		}catch (SQLException sqle){
			sqle.printStackTrace();
		}
	}

}
