/*
 * Created on Apr 14, 2010
 *
 */
package s12.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * The Class S12ConexionProxy.
 *
 *  
 */
public class S12ConexionProxy {

	private static final String user = Q70ListenerUtils.getApplicationProperty("proxy_user");
  private static final String password = Q70ListenerUtils.getApplicationProperty("proxy_password");
  private static final String proxy = Q70ListenerUtils.getApplicationProperty("proxy_host");
  private static final String port = Q70ListenerUtils.getApplicationProperty("proxy_port");

  /**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
  private static final String COMPONENTE = "PROXYSERVLET";

  /**
	 * Constructor.
	 */
	private S12ConexionProxy() {
	}

  /**
   * Realiza una conexin a travs del proxy a la url indicada como parmetro.
   *
   * @param url La url a la que nos queremos conectar.
   * @param params the params
   *
   * @return stream de datos recibidos desde la url indicada.
   */
  public static String getStream(String url, HashMap params) {
	  HttpURLConnection connection = null;
	  StringBuffer result = new StringBuffer();

	  try {
			URL server = new URL(null,url,new sun.net.www.protocol.http.Handler());

			Properties sysProps = System.getProperties();
		  Properties initialProps = (Properties) sysProps.clone();

			if(Q70Factoria.getTraza().isTraceActive()){
				Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.DEBUG, "S12ConexionProxy::getStream:Propiedades Iniciales:");
				Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.DEBUG, "S12ConexionProxy::getStream:http.proxyHost=" + initialProps.getProperty("http.proxyHost"));
				Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.DEBUG, "S12ConexionProxy::getStream:http.proxyPort=" + initialProps.getProperty("http.proxyPort"));
				Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.DEBUG, "S12ConexionProxy::getStream:http.proxyUser=" + initialProps.getProperty("http.proxyUser"));
				Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.DEBUG, "S12ConexionProxy::getStream:http.proxyPassword=" + initialProps.getProperty("http.proxyPassword"));
			}

		  sysProps.setProperty("http.proxyHost", S12ConexionProxy.proxy);
		  sysProps.setProperty("http.proxyPort", S12ConexionProxy.port);
	   	sysProps.setProperty("http.proxyUser", S12ConexionProxy.user);
	   	sysProps.setProperty("http.proxyPassword", S12ConexionProxy.password);

	   	if (Q70Factoria.getTraza().isTraceActive()) {
	   		Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.DEBUG, "S12ConexionProxy::getStream:Host: " + S12ConexionProxy.proxy + "Port: " + S12ConexionProxy.port);
	   		Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.DEBUG, "S12ConexionProxy::getStream:User: " + S12ConexionProxy.user + "Pass: " + S12ConexionProxy.password);
	   	}

	   	System.setProperties(sysProps);

		  Authenticator.setDefault(new S12MyAuthenticator());

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.DEBUG, "S12ConexionProxy::getStream:Abrir conexion");
			}
			connection = (HttpURLConnection) server.openConnection();
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.DEBUG, "S12ConexionProxy::getStream:Conexion abierta");
			}

	   	connection.setAllowUserInteraction(true);
	   	HttpURLConnection.setFollowRedirects(true);
	   	connection.setDoInput(true);
	   	connection.setDoOutput(true);
	   	connection.getPermission();

	   	//Si hay parmetros para aadir al POST.
	   	if(!params.isEmpty()){
	   		OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
	   		Set paramsNames = params.entrySet();
	   		Object[] entryArray = paramsNames.toArray();
	   		Map.Entry entry = (Map.Entry)entryArray[0];
	   		String name = (String)entry.getKey();
	   		String value = (String)entry.getValue();
	   		out.write(name + "=" + value);
	   		for(int i=1;i<entryArray.length;i++){
	   			entry = (Map.Entry)entryArray[i];
	   			name = (String)entry.getKey();
	   			value = (String)entry.getValue();
	   			out.write('&');
			   	out.write(name + "=" + value);
	   		}
		   	out.close();
	   	}


	   	BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
			String decodedString;
			while ((decodedString = in.readLine()) != null) {
				result.append(decodedString);
			}
			in.close();

		  System.setProperties(initialProps);

		} catch (Exception e) {
			connection.disconnect();
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12ConexionProxy.COMPONENTE, Q70TraceLevel.ERROR, "S12ConexionProxy::getStream: " + e.getClass() + ": " + e.getMessage());
			}
			result = new StringBuffer("ERROR");
	  }

		return result.toString();
  }
}
