package s12.search.record;

import bilbofrmk.search.records.BBaseRecord;

/**
 * Clase que representa un registro de tipo Provincia
 *  
 */
public class S12ProvinciaRecord extends BBaseRecord{

	/**
	 *
	 */
	private static final long serialVersionUID = -5074524759410045629L;
	/**
	 * Cdigo de la Provincia
	 */
	private long codProvincia;
	/**
	 * Nombre de la Provincia
	 */

	private String nomProvinciaCas;
	private String nomProvinciaEus;

	/**
	 * Construye el registro Provincia y lo inicializa
	 */
	public S12ProvinciaRecord(){
		this.codProvincia=-1;
		this.nomProvinciaCas=null;
		this.nomProvinciaEus=null;
	}

	/**
	 * Obtiene el identificativo nico del registro. En este caso el cdigo
	 * de Provincia (codProvincia)
	 *
	 * @return the id
	 */
	public String getId() {
		return this.getCodGeoCatalog();
	}
	/**
	 * Devuelve el cdigo de la Provincia
	 * @return Cdigo de la Provincia
	 */
	public String getCodProvincia() {
		return String.valueOf(this.codProvincia).toString();
	}
	/**
	 * Fija el cdigo de la Provincia
	 * @param codProvincia Cdigo de la Provincia a fijar
	 */
	public void setCodProvincia(long codProvincia) {
		this.codProvincia = codProvincia;
	}

	/**
	 * @return Returns the nomProvinciaCas.
	 */
	public String getNomProvinciaCas() {
		return this.nomProvinciaCas;
	}
	/**
	 * @param nomProvinciaCas The nomProvinciaCas to set.
	 */
	public void setNomProvinciaCas(String nomProvinciaCas) {
		this.nomProvinciaCas = nomProvinciaCas;
	}
	/**
	 * @return Returns the nomProvinciaEus.
	 */
	public String getNomProvinciaEus() {
		return this.nomProvinciaEus;
	}
	/**
	 * @param nomProvinciaEus The nomProvinciaEus to set.
	 */
	public void setNomProvinciaEus(String nomProvinciaEus) {
		this.nomProvinciaEus = nomProvinciaEus;
	}

	/**
	 * Gets the nom provincia.
	 *
	 * @return the nom provincia
	 */
	public String getNomProvincia(){
		if(this.loc.getLanguage().equals("eu")){
			return this.getNomProvinciaEus();
		}else{
			return this.getNomProvinciaCas();
		}
	}

	/**
	 * Devuelve el cgio nico de municipios para buscadores.
	 *
	 * @return Cdigo de localizacin
	 */
	public String getCodGeoCatalog(){
	 return (this.lPad(""+this.getCodProvincia(),2));
	}
	/**
	 * Mete ceros por la izquierda, al identificativo geogrfico.
	 * @param c1 Identificativo del elemento geogrfico
	 * @param tam tamao del identificativo
	 * @return El identificativo
	 */
	private String lPad(String c1,int tam) {
		char c2='0';
		int lStr = c1.length();
		StringBuffer resul = new StringBuffer("");
		if(tam>=lStr) {
			for(int i=0;i<tam-lStr;i++){
				resul.append(c2);
			}
			resul.append(c1);
			return resul.toString();
		}
		return c1;
	}
}
