package s12.search.record;

import bilbofrmk.search.records.BBaseRecord;

/**
 * Clase que representa un registro de tipo Municipio
 *  
 */

public class S12MunicipioRecord extends BBaseRecord {

	/**
	 *
	 */
	private static final long serialVersionUID = -3869962081167233616L;

	private long codMunicipio;
	private long codProvincia;
	private String nomMunicipioCas;
	private String nomMunicipioEus;

	private static final int LONGITUD_COD_MUNICIPIO = 4;

	/**
	 * Construye el registro Municipio y lo inicializa
	 */

	public S12MunicipioRecord(){

		this.codMunicipio = -1;
		this.codProvincia = -1;
		this.nomMunicipioCas=null;
		this.nomMunicipioEus=null;
	}

	/**
	 * Obtiene el identificativo nico del registro. En este caso el cdigo
	 * del Municipio
	 *
	 * @return the id
	 */

	public String getId() {

		return this.getCodGeoCatalog();

	}

	/**

	 * Devuelve el cdigo del Municipio

	 * @return Cdigo del Municipio

	 */

	public String getCodMunicipio() {

		return String.valueOf(this.codMunicipio).toString();

	}

	/**

	 * Fija el cdigo del Municipio

	 * @param codMunicipio Cdigo del Municipio a fijar

	 */

	public void setCodMunicipio(long codMunicipio) {

		this.codMunicipio = codMunicipio;

	}

	/**

	 * Devuelve el cdigo de la Provincia

	 * @return Cdigo de la Provincia

	 */

	public long getCodProvincia() {
		return this.codProvincia;
	}

	/**
	 * Fija el cdigo de la Provincia
	 * @param codProvincia Cdigo de la Provincia a fijar
	 */

	public void setCodProvincia(long codProvincia) {

		this.codProvincia = codProvincia;
	}

	/**
	* Devuelve el cgio nico de municipios para buscadores
	* @return Cdigo de localizacin
	*/

	public String getCodGeoCatalog(){
	 return (this.lPad(""+this.getCodProvincia(),2) + this.lPad(""+this.getCodMunicipio(),S12MunicipioRecord.LONGITUD_COD_MUNICIPIO));
	}

	/**

	 * Mete ceros por la izquierda, al identificativo geogrfico.

	 * @param c1 Identificativo del elemento geogrfico

	 * @param tam tamao del identificativo

	 * @return El identificativo

	 */

	private String lPad(String c1,int tam) {

		char c2='0';
		int lStr = c1.length();
		StringBuffer resul = new StringBuffer("");
		if(tam>=lStr) {
			for(int i=0;i<tam-lStr;i++){
				resul.append(c2);
			}
			resul.append(c1);
			return resul.toString();
		}
		return c1;
	}

	/**
	 * @return Returns the nomMunicipioCas.
	 */

	public String getNomMunicipioCas() {
		return this.nomMunicipioCas;
	}

	/**

	 * @param nomMunicipioCas The nomMunicipioCas to set.

	 */

	public void setNomMunicipioCas(String nomMunicipioCas) {

		this.nomMunicipioCas = nomMunicipioCas;
	}

	/**
	 * @return Returns the nomMunicipioEus.
	 */

	public String getNomMunicipioEus() {
		return this.nomMunicipioEus;
	}

	/**

	 * @param nomMunicipioEus The nomMunicipioEus to set.

	 */

	public void setNomMunicipioEus(String nomMunicipioEus) {

		this.nomMunicipioEus = nomMunicipioEus;

	}



	/**
	 * Gets the nom municipio.
	 *
	 * @return the nom municipio
	 */
	public String getNomMunicipio(){
		if(this.loc.getLanguage().equals("eu")){
			return this.getNomMunicipioEus();
		}else{
			return this.getNomMunicipioCas();
		}
	}

	/**
	 * @return the value
	 *
	 * @see bilbofrmk.search.records.BBaseRecord#getValue()
	 */
	public String getValue(){
		if(this.loc.getLanguage().equals("eu")){
			return this.getNomMunicipioEus();
		}else{
			return this.getNomMunicipioCas();
		}
	}
}