/*
 * Created on Aug 17, 2010
 *
 */

package s12.search.record;

import bilbofrmk.search.records.BBaseRecord;

/**
 * Clase que representa un registro la modalidad de alquiler de los agroturismos (k)
 *  
 */
public class S12ModalidadRecord extends BBaseRecord {

	/**
	 *
	 */
	private static final long serialVersionUID = 2226073232525861591L;
	/**
	 * Cdigo recurso
	 */
	private long codRecurso;
	/**
	 * id modalidad alquiler (0-las dos, 1-habitaciones, 2-casa entera)
	 *
	 */
	private String idModalidad;

	/**
	 * Construye un registro de Idioma y lo inicializa.
	 */
	public S12ModalidadRecord(){
		this.codRecurso=-1;
		this.idModalidad=null;
	}



	/**
	 * Gets the cod recurso.
	 *
	 * @return the cod recurso
	 */
	public long getCodRecurso() {
		return this.codRecurso;
	}



	/**
	 * Sets the cod recurso.
	 *
	 * @param codRecurso the new cod recurso
	 */
	public void setCodRecurso(long codRecurso) {
		this.codRecurso = codRecurso;
	}



	/**
	 * Gets the id modalidad.
	 *
	 * @return the id modalidad
	 */
	public String getIdModalidad() {
		return this.idModalidad;
	}



	/**
	 * Sets the id modalidad.
	 *
	 * @param idModalidad the new id modalidad
	 */
	public void setIdModalidad(String idModalidad) {
		this.idModalidad = idModalidad;
	}



	/**
	 * Obtiene el identificador nico del registro. En este caso el cdigo
	 * de la modalidad (idModalidad)
	 *
	 * @return the id
	 */
	public String getId() {
		return this.idModalidad;
	}

}
