package s12.search.record;

import bilbofrmk.search.records.BBaseRecord;

/**
 * Clase que representa un registro de tipo Municipio.
 *
 *  
public class S12LocalidadRecord extends BBaseRecord {

	private static final long serialVersionUID = -7092637184730641100L;
	private long codLocalidad;
	private long codMunicipio;
	private long codProvincia;
	private String nomLocalidadCas;
	private String nomLocalidadEus;

	private static final int LONGITUD_COD_MUNICIPIO = 4;
	private static final int LONGITUD_COD_LOCALIDAD = 4;

	/**
	 * * Construye el registro Localidad y lo inicializa.
	 */

	public S12LocalidadRecord(){
		this.codLocalidad = -1;
		this.codMunicipio = -1;
		this.codProvincia = -1;
		this.nomLocalidadCas=null;
		this.nomLocalidadEus=null;
	}

	/**
	 * * Obtiene el identificativo nico del registro. En este caso el cdigo
	 * *
	 * * del Localidad
	 * *
	 * * @return the id
	 */
	public String getId() {
		return this.getCodGeoCatalog();
	}

	/**
	 * Devuelve el cdigo de la Localidad.
	 *
	 * @return Cdigo de la Localidad
	 */

	public String getCodLocalidad() {

		return String.valueOf(this.codLocalidad).toString();

	}

	/**
	 * Fija el cdigo de la Localidad.
	 *
	 * @param codLocalidad Cdigo de la Localidad a fijar
	 */

	public void setCodLocalidad(long codLocalidad) {

		this.codLocalidad = codLocalidad;

	}

	/**
	 * Devuelve el cdigo del Municipio.
	 *
	 * @return Cdigo del Municipio
	 */

	public String getCodMunicipio() {

		return String.valueOf(this.codMunicipio).toString();

	}

	/**
	 * Fija el cdigo del Municipio.
	 *
	 * @param codMunicipio Cdigo del Municipio a fijar
	 */

	public void setCodMunicipio(long codMunicipio) {

		this.codMunicipio = codMunicipio;

	}

	/**
	 * Devuelve el cdigo de la Provincia.
	 *
	 * @return Cdigo de la Provincia
	 */

	public long getCodProvincia() {

		return this.codProvincia;

	}

	/**
	 * Fija el cdigo de la Provincia.
	 *
	 * @param codProvincia Cdigo de la Provincia a fijar
	 */

	public void setCodProvincia(long codProvincia) {
		this.codProvincia = codProvincia;
	}

	/**
	 * Devuelve el cgio nico de localizacion para buscadores.
	 *
	 * @return Cdigo de localizacin
	 */

	public String getCodGeoCatalog(){
	 return (this.lPad(""+this.getCodProvincia(),2) + this.lPad(""+this.getCodMunicipio(),S12LocalidadRecord.LONGITUD_COD_MUNICIPIO)
			 + this.lPad(""+this.getCodLocalidad(),S12LocalidadRecord.LONGITUD_COD_LOCALIDAD));
	}

	/**
	 * Mete ceros por la izquierda, al identificativo geogrfico.
	 *
	 * @param c1 Identificativo del elemento geogrfico
	 * @param tam tamao del identificativo
	 *
	 * @return El identificativo
	 */

	private String lPad(String c1,int tam) {
		char c2='0';
		int lStr = c1.length();
		StringBuffer resul= new StringBuffer("");
		if(tam>=lStr) {
			for(int i=0;i<tam-lStr;i++){
				resul.append(c2);
			}
			resul.append(c1);
			return resul.toString();
		}
		return c1;
	}

	/**
	 * Gets the nom localidad cas.
	 *
	 * @return Returns the nomLocalidadCas.
	 */

	public String getNomLocalidadCas() {

		return this.nomLocalidadCas;
	}

	/**
	 * Sets the nom localidad cas.
	 *
	 * @param nomLocalidadCas The nomLocalidadCas to set.
	 */

	public void setNomLocalidadCas(String nomLocalidadCas) {

		this.nomLocalidadCas = nomLocalidadCas;

	}

	/**
	 * Gets the nom localidad eus.
	 *
	 * @return Returns the nomLocalidadEus.
	 */

	public String getNomLocalidadEus() {

		return this.nomLocalidadEus;

	}

	/**
	 * Sets the nom localidad eus.
	 *
	 * @param nomLocalidadEus The nomLocalidadEus to set.
	 */

	public void setNomLocalidadEus(String nomLocalidadEus) {

		this.nomLocalidadEus = nomLocalidadEus;

	}



	/**
	 * * Gets the nom localidad.
	 * *
	 * * @return the nom localidad
	 *
	 */
	public String getNomLocalidad(){

		if(this.loc.getLanguage().equals("eu")){

			return this.getNomLocalidadEus();

		}else{

			return this.getNomLocalidadCas();
		}
	}

	/**
	 *
	 * @return the value
	 */
	public String getValue(){
		if(this.loc.getLanguage().equals("eu")){
			return this.getNomLocalidadEus();
		}else{
			return this.getNomLocalidadCas();
		}
	}
}