package s12.search;

import bilbofrmk.search.BBaseQuery;

/**
 * Clase que representa los criterios de bsqueda para los Municipios
 *  
 */
public class S12LocalidadesQuery extends BBaseQuery {

	/**
	 *
	 */
	private static final long serialVersionUID = 3104915454986111593L;
	/**
	 * Cdigo Municipio
	 */
	private long codMunicipio;
	/**
	 * Cdigo Provincia
	 */
	private long codProvincia;
	/**
	 * Construye los criterios de bsqueda para los Municipios y los
	 * inicializa
	 */
	public S12LocalidadesQuery(){

		this.codMunicipio = -1;
		this.codProvincia = -1;
	}

	/**
	 * @return the int
	 *
	 * @see bilbofrmk.search.BBaseQuery#validate()
	 */
	public int validate() {
		return 0;
	}
	/**
	 * Devuelve el criterio del cdigo de Municipio
	 * @return Cdigo de Municipio
	 */
	public long getCodMunicipio() {
		return this.codMunicipio;
	}
	/**
	 * Fija el cdigo de Municipio como criterio para buscar los
	 * municipios
	 * @param codMunicipio The codMunicipio to set.
	 */
	public void setCodMunicipio(long codMunicipio) {
		this.codMunicipio= codMunicipio;
	}
	/**
	 * Devuelve el criterio del cdigo de Provincia
	 * @return Cdigo de Provincia
	 */
	public long getCodProvincia() {
		return this.codProvincia;
	}
	/**
	 * Fija el cdigo de Provincia como criterio para buscar los
	 * municipios
	 * @param codProvincia The codProvincia to set.
	 */
	public void setCodProvincia(long codProvincia) {
		this.codProvincia = codProvincia;
	}
}
