package s12.report;

import s12.valueObjects.logotipos.S12SolicitudLogotipo;
import s12.valueObjects.logotipos.S12LogotiposMail;
import bilbofrmk.reports.BBaseReport;
import s12.valueObjects.comun.S12Idioma;

/**
 * Clase que representa un informe de Solicitud de Logotipos. Contiene los datos necesarios
 * para crear el informe
 *  
 */
public class S12LogotiposReport extends BBaseReport {

	/**
	 *
	 */
	private static final long serialVersionUID = 2873098310035821126L;
	/**
	 * Solicitud de Logotipos
	 */
	private S12SolicitudLogotipo solicitud;
	/**
	 * Objeto logotiposMail: Contiene los datos necesarios para mandar el
	 * mensaje
	 */
	private S12LogotiposMail logotiposMail;
	/**
	 * Indicador de si se quiere crear el informe directamente o no
	 */
	private boolean bOnFly = true;

	/**
	 * Idioma de la solicitud
	 */
	private S12Idioma idioma;

	/**
	 * Devuelve la plantilla XSL.
	 *
	 * @return the default xsl template file
	 */
	public String getDefaultXSLTemplateFile() {
		return "";
	}

	/**
	 * Devuelve el path donde se ubica la plantilla XSL.
	 *
	 * @return the default xsl path
	 */
	public String getDefaultXSLPath() {
		return "";
	}

	/**
	 * Comprueba si el informe se va a realizar diractamente o no
	 * @return true - Si se quiere realizar directamente;
	 * 		   false - En el caso contrario
	 */
	public boolean isBOnFly() {
		return this.bOnFly;
	}
	/**
	 * Fija el indicador para realizar el informe directamente o no
	 * @param onFly Indicador
	 */
	public void setBOnFly(boolean onFly) {
		this.bOnFly = onFly;
	}
	/**
	 * Devuelve el objeto SolicitudLogotipo que se quiere enviar
	 * @return Objeto SolicitudLogotipo
	 */
	public S12SolicitudLogotipo getSolicitud() {
		return this.solicitud;
	}
	/**
	 * Fija la S12SolicitudLogotipo que se quiere enviar
	 * @param solicitud SolicitudLogotipos a fijar.
	 */
	public void setSolicitud(S12SolicitudLogotipo solicitud) {
		this.solicitud = solicitud;
	}

	/**
	 * Devuelve el objeto que contiene los datos necesarios para enviar el
	 * mensaje (logotiposMail)
	 * @return Objeto logotiposMail
	 */
	public S12LogotiposMail getLogotiposMail() {
		return this.logotiposMail;
	}
	/**
	 * Fija el objeto S12LogotiposMail
	 * @param logotiposMail Objeto S12LogotiposMail a fijar
	 */
	public void setLogotiposMail(S12LogotiposMail logotiposMail) {
		this.logotiposMail = logotiposMail;
	}
	/**
	 * Devuelve el idioma
	 * @return s12Idioma Idioma
	 */
	public S12Idioma getIdioma() {
		return this.idioma;
	}

	/**
	 * Fija el objeto idioma
	 *
	 * @param idioma the idioma
	 */
	public void setIdioma(S12Idioma idioma) {
		this.idioma = idioma;
	}
}
