/*
 * Created on 08/08/2011
 *
 */
package s12.progrExperienciales.valueObjects;
import java.util.ArrayList;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;


/**
 * The Class S12EnlacesCapital.
 *  
 */
public class S12GaleriaXml implements JSONString {

	/** The imagen. */
	private ArrayList<S12ImagenXml> imagen;

	/**
	 * Constructor.
	 */
	public S12GaleriaXml() {
		this.imagen = new ArrayList<S12ImagenXml>();
	}

	/**
	 * @return Retorna el valor del campo imagen.
	 */
	public ArrayList<S12ImagenXml> getImagen() {
		return this.imagen;
	}

	/**
	 * @param imagen Establece el valor del campo imagen.
	 */
	public void setImagen(ArrayList<S12ImagenXml> imagen) {
		this.imagen = imagen;
	}


	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		JSONObject jObject2 = new JSONObject();
		try {
			jObject.put("galeria", jObject2.put("imagen", this.imagen));
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

}